/*	$NetBSD$	*/

/*
 * Copyright (c) 1994 Havard Eidnes.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Computer Systems
 *	Engineering Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _SYS_DEV_VAUDIO_IF_H_
#define _SYS_DEV_VAUDIO_IF_H_

#include <sys/types.h>
#include <sys/audioio.h>
#include <sys/mutex.h>

#include <dev/audio_if.h>
/* check we have an audio(4) configured into kernel */
#if defined(_KERNEL_OPT)
#include "audio.h"

#if (NAUDIO == 0) && (NMIDI == 0) && (NMIDIBUS == 0)
#error "No 'audio* at audiobus?' or 'midi* at midibus?' or similar configured"
#endif

#endif /* _KERNEL_OPT */

struct vaudio_attach_args {
	int	type;
	const void *hwif;	/* either audio_hw_if * or midi_hw_if * */
	void	*hdl;
	int	blksize;
};
/* Attach the MI driver(s) to the MD driver. */
device_t vaudio_attach_mi(int, device_t);
int	vaudioprint(void *, const char *);

/* Get the hw device from an audio softc */
device_t vaudio_get_device(struct audio_softc *);

#endif /* _SYS_DEV_VAUDIO_IF_H_ */
