/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.namespace.serial;

import com.sun.jmx.defaults.JmxProperties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JMXNamespaceContext {
    private static final Logger LOG = JmxProperties.NAMESPACE_LOGGER;
    public final String prefixToRemove;
    public final String prefixToAdd;
    private static final ThreadLocal<SerialContext> prefix = new ThreadLocal<SerialContext>(){

        @Override
        protected SerialContext initialValue() {
            return new SerialContext();
        }
    };

    private JMXNamespaceContext(String string, String string2) {
        this.prefixToRemove = string2 == null ? "" : string2;
        this.prefixToAdd = string == null ? "" : string;
    }

    public static JMXNamespaceContext getSerializationContext() {
        return prefix.get().serializationContext;
    }

    public static JMXNamespaceContext getDeserializationContext() {
        return prefix.get().deserializationContext;
    }

    private static String[] setSerializationContext(String string, String string2) {
        SerialContext serialContext = prefix.get();
        JMXNamespaceContext jMXNamespaceContext = serialContext.serializationContext;
        String[] stringArray = new String[]{jMXNamespaceContext.prefixToRemove, jMXNamespaceContext.prefixToAdd};
        serialContext.serializationContext = new JMXNamespaceContext(string2, string);
        return stringArray;
    }

    private static String[] setDeserializationContext(String string, String string2) {
        SerialContext serialContext = prefix.get();
        JMXNamespaceContext jMXNamespaceContext = serialContext.deserializationContext;
        String[] stringArray = new String[]{jMXNamespaceContext.prefixToRemove, jMXNamespaceContext.prefixToAdd};
        serialContext.deserializationContext = new JMXNamespaceContext(string2, string);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void serialize(ObjectOutputStream objectOutputStream, Object object, String string, String string2) throws IOException {
        String[] stringArray = JMXNamespaceContext.setSerializationContext(string, string2);
        try {
            objectOutputStream.writeObject(object);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                JMXNamespaceContext.setSerializationContext(stringArray[0], stringArray[1]);
            }
            catch (Exception exception) {
                LOG.log(Level.FINEST, "failed to restore serialization context", exception);
            }
            throw throwable;
        }
        try {
            JMXNamespaceContext.setSerializationContext(stringArray[0], stringArray[1]);
        }
        catch (Exception exception) {
            LOG.log(Level.FINEST, "failed to restore serialization context", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object deserialize(ObjectInputStream objectInputStream, String string, String string2) throws IOException, ClassNotFoundException {
        Object object;
        String[] stringArray = JMXNamespaceContext.setDeserializationContext(string, string2);
        try {
            object = objectInputStream.readObject();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                JMXNamespaceContext.setDeserializationContext(stringArray[0], stringArray[1]);
            }
            catch (Exception exception) {
                LOG.log(Level.FINEST, "failed to restore serialization context", exception);
            }
            throw throwable;
        }
        try {
            JMXNamespaceContext.setDeserializationContext(stringArray[0], stringArray[1]);
        }
        catch (Exception exception) {
            LOG.log(Level.FINEST, "failed to restore serialization context", exception);
        }
        return object;
    }

    private static final class SerialContext {
        private JMXNamespaceContext serializationContext = new JMXNamespaceContext("", "");
        private JMXNamespaceContext deserializationContext = new JMXNamespaceContext("", "");
    }
}

