/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.internalizer;

import com.sun.tools.internal.xjc.reader.internalizer.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class VersionChecker
extends XMLFilterImpl {
    private String version = null;
    private boolean seenRoot = false;
    private boolean seenBindings = false;
    private Locator locator;
    private Locator rootTagStart;

    public VersionChecker(XMLReader xMLReader) {
        this.setParent(xMLReader);
    }

    public VersionChecker(ContentHandler contentHandler, ErrorHandler errorHandler, EntityResolver entityResolver) {
        this.setContentHandler(contentHandler);
        if (errorHandler != null) {
            this.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            this.setEntityResolver(entityResolver);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (!this.seenRoot) {
            this.seenRoot = true;
            this.rootTagStart = new LocatorImpl(this.locator);
            this.version = attributes.getValue("http://java.sun.com/xml/ns/jaxb", "version");
            if (string.equals("http://java.sun.com/xml/ns/jaxb")) {
                String string4 = attributes.getValue("", "version");
                if (this.version != null && string4 != null) {
                    SAXParseException sAXParseException = new SAXParseException(Messages.format("Internalizer.TwoVersionAttributes", new Object[0]), this.locator);
                    this.getErrorHandler().error(sAXParseException);
                }
                if (this.version == null) {
                    this.version = string4;
                }
            }
        }
        if ("http://java.sun.com/xml/ns/jaxb".equals(string)) {
            this.seenBindings = true;
        }
    }

    public void endDocument() throws SAXException {
        SAXParseException sAXParseException;
        super.endDocument();
        if (this.seenBindings && this.version == null) {
            sAXParseException = new SAXParseException(Messages.format("Internalizer.VersionNotPresent", new Object[0]), this.rootTagStart);
            this.getErrorHandler().error(sAXParseException);
        }
        if (this.version != null && !this.version.equals("1.0") && !this.version.equals("2.0")) {
            sAXParseException = new SAXParseException(Messages.format("Internalizer.IncorrectVersion", new Object[0]), this.rootTagStart);
            this.getErrorHandler().error(sAXParseException);
        }
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }
}

