/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.annotation;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.SourcePosition;
import com.sun.tools.internal.ws.ToolVersion;
import com.sun.tools.internal.ws.processor.ProcessorNotificationListener;
import com.sun.tools.internal.ws.processor.generator.GeneratorUtil;
import com.sun.tools.internal.ws.processor.generator.Names;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.model.Operation;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBModel;
import com.sun.tools.internal.ws.processor.modeler.ModelerException;
import com.sun.tools.internal.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.internal.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.internal.ws.processor.modeler.annotation.TypeModeler;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceConstants;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceReferenceCollector;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceVisitor;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceWrapperGenerator;
import com.sun.tools.internal.ws.processor.util.ClientProcessorEnvironment;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.internal.ws.util.ToolBase;
import com.sun.tools.internal.xjc.api.JavaCompiler;
import com.sun.tools.internal.xjc.api.Reference;
import com.sun.tools.internal.xjc.api.XJC;
import com.sun.xml.internal.ws.util.localization.Localizable;
import com.sun.xml.internal.ws.util.localization.LocalizableMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceProvider;

public class WebServiceAP
extends ToolBase
implements AnnotationProcessor,
ModelBuilder,
WebServiceConstants,
ProcessorNotificationListener {
    protected AnnotationProcessorEnvironment apEnv;
    protected ProcessorEnvironment env;
    private File sourceDir;
    private Model model;
    private TypeDeclaration remoteDecl;
    private TypeDeclaration remoteExceptionDecl;
    private TypeDeclaration exceptionDecl;
    private TypeDeclaration defHolderDecl;
    private Service service;
    private Port port;
    protected AnnotationProcessorContext context;
    private Set<TypeDeclaration> processedTypeDecls = new HashSet<TypeDeclaration>();
    protected Messager messager;
    private ByteArrayOutputStream output;
    private ToolBase tool;
    private boolean doNotOverWrite = false;
    private boolean wrapperGenerated = false;
    private boolean isAPTInvocation = false;

    public void run() {
    }

    protected boolean parseArguments(String[] stringArray) {
        return true;
    }

    public WebServiceAP(ToolBase toolBase, ProcessorEnvironment processorEnvironment, Properties properties, AnnotationProcessorContext annotationProcessorContext) {
        super(System.out, "WebServiceAP");
        this.context = annotationProcessorContext;
        this.tool = toolBase;
        this.env = processorEnvironment;
        if (properties != null) {
            this.sourceDir = new File(properties.getProperty("sourceDirectory"));
            String string = "doNotOverWrite";
            this.doNotOverWrite = Boolean.valueOf(properties.getProperty(string));
        }
    }

    public void init(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        this.apEnv = annotationProcessorEnvironment;
        this.remoteDecl = this.apEnv.getTypeDeclaration(REMOTE_CLASSNAME);
        this.remoteExceptionDecl = this.apEnv.getTypeDeclaration(REMOTE_EXCEPTION_CLASSNAME);
        this.exceptionDecl = this.apEnv.getTypeDeclaration(EXCEPTION_CLASSNAME);
        this.defHolderDecl = this.apEnv.getTypeDeclaration(HOLDER_CLASSNAME);
        if (this.env == null) {
            Map<String, String> map = annotationProcessorEnvironment.getOptions();
            this.output = new ByteArrayOutputStream();
            String string = map.get("-d");
            if (string == null) {
                string = ".";
            }
            this.sourceDir = map.get("-s") != null ? new File(map.get("-s")) : new File(string);
            String string2 = map.get("-classpath");
            String string3 = string + File.pathSeparator + string2 + File.pathSeparator + System.getProperty("java.class.path");
            this.env = new ClientProcessorEnvironment(this.output, string3, this);
            ((ClientProcessorEnvironment)this.env).setNames(new Names());
            boolean bl = false;
            for (String string4 : map.keySet()) {
                if (!string4.equals("-verbose")) continue;
                bl = true;
            }
            if (bl) {
                this.env.setFlags(1);
            }
            this.messager = annotationProcessorEnvironment.getMessager();
            this.isAPTInvocation = true;
        }
        this.env.setFiler(annotationProcessorEnvironment.getFiler());
    }

    public AnnotationProcessorEnvironment getAPEnv() {
        return this.apEnv;
    }

    public ProcessorEnvironment getEnvironment() {
        return this.env;
    }

    public ProcessorEnvironment getProcessorEnvironment() {
        return this.env;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public void onError(String string) {
        this.onError((Localizable)new LocalizableMessage(this.getResourceBundleName(), string, new Object[0]));
    }

    public void onError(String string, Object[] objectArray) throws ModelerException {
        this.onError(null, string, objectArray);
    }

    public void onError(SourcePosition sourcePosition, String string, Object[] objectArray) throws ModelerException {
        this.onError(sourcePosition, (Localizable)new LocalizableMessage(this.getResourceBundleName(), string, objectArray));
    }

    public void onError(Localizable localizable) throws ModelerException {
        this.onError(null, localizable);
    }

    public void onError(SourcePosition sourcePosition, Localizable localizable) throws ModelerException {
        if (this.messager == null) {
            throw new ModelerException(localizable);
        }
        this.messager.printError(sourcePosition, this.localizer.localize(localizable));
    }

    public void onWarning(String string) {
        this.onWarning((Localizable)new LocalizableMessage(this.getResourceBundleName(), string, new Object[0]));
    }

    public void onWarning(Localizable localizable) {
        String string = this.localizer.localize(this.getMessage("webserviceap.warning", this.localizer.localize(localizable)));
        if (this.messager != null) {
            this.messager.printWarning(string);
        } else {
            this.report(string);
        }
    }

    public void onInfo(Localizable localizable) {
        if (this.messager != null) {
            String string = this.localizer.localize(localizable);
            this.messager.printNotice(string);
        } else {
            String string = this.localizer.localize(this.getMessage("webserviceap.info", this.localizer.localize(localizable)));
            this.report(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (this.context.getRound() == 1) {
            this.buildModel();
        }
        if (!this.wrapperGenerated || this.context.getRound() == 2 || this.context.allEncoded()) {
            if (!(this.context.getRound() != 2 && this.wrapperGenerated || this.context.isModelCompleted())) {
                this.completeModel();
                this.context.setModelCompleted(true);
            }
            try {
                for (AnnotationProcessorContext.SEIContext sEIContext : this.context.getSEIContexts()) {
                    if (sEIContext.getModelCompiled()) continue;
                    this.runProcessorActions(sEIContext.getModel());
                    sEIContext.setModelCompiled(true);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (this.messager != null && this.output != null && this.output.size() > 0) {
                    this.messager.printNotice(this.output.toString());
                }
            }
        }
        this.context.incrementRound();
    }

    public boolean checkAndSetProcessed(TypeDeclaration typeDeclaration) {
        if (!this.processedTypeDecls.contains(typeDeclaration)) {
            this.processedTypeDecls.add(typeDeclaration);
            return false;
        }
        return true;
    }

    public void clearProcessed() {
        this.processedTypeDecls.clear();
    }

    protected void runProcessorActions(Model model) throws Exception {
        if (this.tool != null) {
            this.tool.runProcessorActions();
        }
    }

    protected String getGenericErrorMessage() {
        return "webserviceap.error";
    }

    protected String getResourceBundleName() {
        return "com.sun.tools.internal.ws.resources.webserviceap";
    }

    public void createModel(TypeDeclaration typeDeclaration, QName qName, String string, String string2) {
        AnnotationProcessorContext.SEIContext sEIContext = this.context.getSEIContext(typeDeclaration);
        if (sEIContext.getModel() != null) {
            this.onError("webserviceap.model.already.exists");
            return;
        }
        this.log("creating model: " + qName);
        this.model = new Model(qName);
        this.model.setTargetNamespaceURI(string);
        this.model.setProperty("com.sun.xml.internal.ws.processor.model.ModelerName", string2);
        sEIContext.setModel(this.model);
    }

    public void setService(Service service) {
        this.service = service;
        this.model.addService(service);
    }

    public void setPort(Port port) {
        this.port = port;
        this.service.addPort(port);
    }

    public void addOperation(Operation operation) {
        this.port.addOperation(operation);
    }

    public void setWrapperGenerated(boolean bl) {
        this.wrapperGenerated = bl;
    }

    public TypeDeclaration getTypeDeclaration(String string) {
        return this.apEnv.getTypeDeclaration(string);
    }

    public String getSourceVersion() {
        return ToolVersion.VERSION.MAJOR_VERSION;
    }

    private void buildModel() {
        WebServiceProvider webServiceProvider = null;
        WebServiceVisitor webServiceVisitor = this.createWrapperGenerator();
        boolean bl = false;
        for (TypeDeclaration typeDeclaration : this.apEnv.getTypeDeclarations()) {
            if (!(typeDeclaration instanceof ClassDeclaration)) continue;
            webServiceProvider = typeDeclaration.getAnnotation(WebServiceProvider.class);
            WebService webService = typeDeclaration.getAnnotation(WebService.class);
            if (webServiceProvider != null) {
                if (webService != null) {
                    this.onError("webserviceap.webservice.and.webserviceprovider", new Object[]{typeDeclaration.getQualifiedName()});
                }
                bl = true;
            }
            if (!this.shouldProcessWebService(webService)) continue;
            typeDeclaration.accept(webServiceVisitor);
            bl = true;
        }
        if (!bl) {
            if (this.isAPTInvocation) {
                this.onWarning("webserviceap.no.webservice.endpoint.found");
            } else {
                this.onError("webserviceap.no.webservice.endpoint.found");
            }
        }
    }

    protected WebServiceVisitor createWrapperGenerator() {
        return new WebServiceWrapperGenerator(this, this.context);
    }

    protected WebServiceVisitor createReferenceCollector() {
        return new WebServiceReferenceCollector(this, this.context);
    }

    protected boolean shouldProcessWebService(WebService webService) {
        return webService != null;
    }

    private void completeModel() {
        TypeDeclaration typeDeclaration;
        this.clearProcessed();
        JavaCompiler javaCompiler = XJC.createJavaCompiler();
        WebServiceVisitor webServiceVisitor = this.createReferenceCollector();
        for (AnnotationProcessorContext.SEIContext sEIContext : this.context.getSEIContexts()) {
            this.log("completing model for endpoint: " + sEIContext.getSEIImplName());
            typeDeclaration = this.apEnv.getTypeDeclaration(sEIContext.getSEIImplName());
            if (typeDeclaration == null) {
                this.onError("webserviceap.could.not.find.typedecl", new Object[]{sEIContext.getSEIImplName(), this.context.getRound()});
            }
            typeDeclaration.accept(webServiceVisitor);
        }
        this.clearProcessed();
        for (AnnotationProcessorContext.SEIContext sEIContext : this.context.getSEIContexts()) {
            typeDeclaration = this.apEnv.getTypeDeclaration(sEIContext.getSEIName());
            Collection<Reference> collection = sEIContext.getSchemaReferences(this);
            JAXBModel jAXBModel = new JAXBModel(javaCompiler.bind(collection, sEIContext.getSchemaElementMap(this), sEIContext.getNamespaceURI(), this.apEnv));
            sEIContext.setJAXBModel(jAXBModel);
        }
    }

    public boolean isException(TypeDeclaration typeDeclaration) {
        return WebServiceAP.isSubtype(typeDeclaration, this.exceptionDecl);
    }

    public boolean isRemoteException(TypeDeclaration typeDeclaration) {
        return WebServiceAP.isSubtype(typeDeclaration, this.remoteExceptionDecl);
    }

    public boolean isRemote(TypeDeclaration typeDeclaration) {
        return WebServiceAP.isSubtype(typeDeclaration, this.remoteDecl);
    }

    public static boolean isSubtype(TypeDeclaration typeDeclaration, TypeDeclaration typeDeclaration2) {
        Object object;
        if (typeDeclaration.equals(typeDeclaration2)) {
            return true;
        }
        ClassDeclaration classDeclaration = null;
        if (typeDeclaration instanceof ClassDeclaration && (object = ((ClassDeclaration)typeDeclaration).getSuperclass()) != null && (classDeclaration = object.getDeclaration()).equals(typeDeclaration2)) {
            return true;
        }
        object = null;
        for (InterfaceType interfaceType : typeDeclaration.getSuperinterfaces()) {
            object = interfaceType.getDeclaration();
            if (!object.equals(typeDeclaration2)) continue;
            return true;
        }
        if (object != null && WebServiceAP.isSubtype((TypeDeclaration)object, typeDeclaration2)) {
            return true;
        }
        return classDeclaration != null && WebServiceAP.isSubtype(classDeclaration, typeDeclaration2);
    }

    public static String getMethodSig(MethodDeclaration methodDeclaration) {
        StringBuffer stringBuffer = new StringBuffer(methodDeclaration.getSimpleName() + "(");
        Iterator<TypeParameterDeclaration> iterator = methodDeclaration.getFormalTypeParameters().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            TypeParameterDeclaration typeParameterDeclaration = iterator.next();
            stringBuffer.append(typeParameterDeclaration.getSimpleName());
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getOperationName(String string) {
        return string;
    }

    public String getResponseName(String string) {
        return Names.getResponseName(string);
    }

    public TypeMirror getHolderValueType(TypeMirror typeMirror) {
        return TypeModeler.getHolderValueType(typeMirror, this.defHolderDecl, this.apEnv);
    }

    public boolean canOverWriteClass(String string) {
        return !this.doNotOverWrite || !GeneratorUtil.classExists(this.env, string);
    }

    public void log(String string) {
        if (this.env != null && this.env.verbose()) {
            String string2 = "[" + string + "]";
            if (this.messager != null) {
                this.messager.printNotice(string2);
            } else {
                System.out.println(string2);
            }
        }
    }

    public String getXMLName(String string) {
        return string;
    }
}

