/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.AbstractJavaHeapObjectVisitor;
import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.server.QueryHandler;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefsByTypeQuery
extends QueryHandler {
    @Override
    public void run() {
        JavaClass javaClass = this.snapshot.findClass(this.query);
        if (javaClass == null) {
            this.error("class not found: " + this.query);
        } else {
            HashMap<JavaClass, Long> hashMap = new HashMap<JavaClass, Long>();
            final HashMap<JavaClass, Long> hashMap2 = new HashMap<JavaClass, Long>();
            Enumeration enumeration = javaClass.getInstances(false);
            while (enumeration.hasMoreElements()) {
                JavaHeapObject javaHeapObject = (JavaHeapObject)enumeration.nextElement();
                if (javaHeapObject.getId() == -1L) continue;
                Enumeration enumeration2 = javaHeapObject.getReferers();
                while (enumeration2.hasMoreElements()) {
                    JavaHeapObject javaHeapObject2 = (JavaHeapObject)enumeration2.nextElement();
                    JavaClass javaClass2 = javaHeapObject2.getClazz();
                    if (javaClass2 == null) {
                        System.out.println("null class for " + javaHeapObject2);
                        continue;
                    }
                    Long l = (Long)hashMap.get(javaClass2);
                    l = l == null ? new Long(1L) : new Long(l + 1L);
                    hashMap.put(javaClass2, l);
                }
                javaHeapObject.visitReferencedObjects(new AbstractJavaHeapObjectVisitor(){

                    public void visit(JavaHeapObject javaHeapObject) {
                        JavaClass javaClass = javaHeapObject.getClazz();
                        Long l = (Long)hashMap2.get(javaClass);
                        l = l == null ? new Long(1L) : new Long(l + 1L);
                        hashMap2.put(javaClass, l);
                    }
                });
            }
            this.startHtml("References by Type");
            this.out.println("<p align='center'>");
            this.printClass(javaClass);
            if (javaClass.getId() != -1L) {
                this.out.println("[" + javaClass.getIdString() + "]");
            }
            this.out.println("</p>");
            if (hashMap.size() != 0) {
                this.out.println("<h3 align='center'>Referrers by Type</h3>");
                this.print(hashMap);
            }
            if (hashMap2.size() != 0) {
                this.out.println("<h3 align='center'>Referees by Type</h3>");
                this.print(hashMap2);
            }
            this.endHtml();
        }
    }

    private void print(final Map<JavaClass, Long> map) {
        this.out.println("<table border='1' align='center'>");
        Set<JavaClass> set = map.keySet();
        JavaClass[] javaClassArray = new JavaClass[set.size()];
        set.toArray(javaClassArray);
        Arrays.sort(javaClassArray, new Comparator<JavaClass>(){

            @Override
            public int compare(JavaClass javaClass, JavaClass javaClass2) {
                Long l = (Long)map.get(javaClass);
                Long l2 = (Long)map.get(javaClass2);
                return l2.compareTo(l);
            }
        });
        this.out.println("<tr><th>Class</th><th>Count</th></tr>");
        for (int i = 0; i < javaClassArray.length; ++i) {
            JavaClass javaClass = javaClassArray[i];
            this.out.println("<tr><td>");
            this.out.print("<a href='/refsByType/");
            this.out.print(javaClass.getIdString());
            this.out.print("'>");
            this.out.print(javaClass.getName());
            this.out.println("</a>");
            this.out.println("</td><td>");
            this.out.println(map.get(javaClass));
            this.out.println("</td></tr>");
        }
        this.out.println("</table>");
    }
}

