/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XAnyEvent;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XPropertyCache;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XRootWindow;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XBaseWindow {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XBaseWindow");
    private static final Logger insLog = Logger.getLogger("sun.awt.X11.insets.XBaseWindow");
    private static final Logger eventLog = Logger.getLogger("sun.awt.X11.event.XBaseWindow");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XBaseWindow");
    private static final Logger grabLog = Logger.getLogger("sun.awt.X11.grab.XBaseWindow");
    public static final String PARENT_WINDOW = "parent window";
    public static final String BOUNDS = "bounds";
    public static final String OVERRIDE_REDIRECT = "overrideRedirect";
    public static final String EVENT_MASK = "event mask";
    public static final String VALUE_MASK = "value mask";
    public static final String BORDER_PIXEL = "border pixel";
    public static final String COLORMAP = "color map";
    public static final String DEPTH = "visual depth";
    public static final String VISUAL_CLASS = "visual class";
    public static final String VISUAL = "visual";
    public static final String EMBEDDED = "embedded";
    public static final String DELAYED = "delayed";
    public static final String PARENT = "parent";
    public static final String BACKGROUND_PIXMAP = "pixmap";
    public static final String VISIBLE = "visible";
    public static final String SAVE_UNDER = "save under";
    public static final String BACKING_STORE = "backing store";
    public static final String BIT_GRAVITY = "bit gravity";
    private XCreateWindowParams delayedParams;
    Set<Long> children = new HashSet<Long>();
    long window;
    boolean visible;
    boolean mapped;
    boolean embedded;
    Rectangle maxBounds;
    volatile XBaseWindow parentWindow;
    private boolean disposed;
    private long screen;
    private XSizeHints hints;
    private XWMHints wmHints;
    static final int MIN_SIZE = 1;
    static final int DEF_LOCATION = 1;
    private static XAtom wm_client_leader;
    private InitialiseState initialising;
    int x;
    int y;
    int width;
    int height;
    protected StateLock state_lock;

    void awtLock() {
        XToolkit.awtLock();
    }

    void awtUnlock() {
        XToolkit.awtUnlock();
    }

    void awtLockNotifyAll() {
        XToolkit.awtLockNotifyAll();
    }

    void awtLockWait() throws InterruptedException {
        XToolkit.awtLockWait();
    }

    protected final void init(long l, Rectangle rectangle) {
    }

    protected final void preInit() {
    }

    protected final void postInit() {
    }

    void instantPreInit(XCreateWindowParams xCreateWindowParams) {
        this.state_lock = new StateLock();
        this.initialising = InitialiseState.NOT_INITIALISED;
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        Long l;
        this.state_lock = new StateLock();
        this.initialising = InitialiseState.NOT_INITIALISED;
        this.embedded = Boolean.TRUE.equals(xCreateWindowParams.get(EMBEDDED));
        this.visible = Boolean.TRUE.equals(xCreateWindowParams.get(VISIBLE));
        Object v = xCreateWindowParams.get(PARENT);
        if (v instanceof XBaseWindow) {
            this.parentWindow = (XBaseWindow)v;
        } else {
            l = (Long)xCreateWindowParams.get(PARENT_WINDOW);
            if (l != null) {
                this.parentWindow = XToolkit.windowToXWindow(l);
            }
        }
        l = (Long)xCreateWindowParams.get(EVENT_MASK);
        if (l != null) {
            long l2 = l;
            xCreateWindowParams.put(EVENT_MASK, l2 |= 0x80000L);
        }
        this.screen = -1L;
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("WM name is " + this.getWMName());
        }
        this.updateWMName();
        this.initClientLeader();
    }

    protected final void init(XCreateWindowParams xCreateWindowParams) {
        this.awtLock();
        this.initialising = InitialiseState.INITIALISING;
        this.awtUnlock();
        try {
            if (!Boolean.TRUE.equals(xCreateWindowParams.get(DELAYED))) {
                this.preInit(xCreateWindowParams);
                this.create(xCreateWindowParams);
                this.postInit(xCreateWindowParams);
            } else {
                this.instantPreInit(xCreateWindowParams);
                this.delayedParams = xCreateWindowParams;
            }
            this.awtLock();
            this.initialising = InitialiseState.INITIALISED;
            this.awtLockNotifyAll();
            this.awtUnlock();
        }
        catch (RuntimeException runtimeException) {
            this.awtLock();
            this.initialising = InitialiseState.FAILED_INITIALISATION;
            this.awtLockNotifyAll();
            this.awtUnlock();
            throw runtimeException;
        }
        catch (Throwable throwable) {
            log.log(Level.WARNING, "Exception during peer initialization", throwable);
            this.awtLock();
            this.initialising = InitialiseState.FAILED_INITIALISATION;
            this.awtLockNotifyAll();
            this.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkInitialised() {
        this.awtLock();
        try {
            switch (this.initialising) {
                case INITIALISED: {
                    boolean bl = true;
                    return bl;
                }
                case INITIALISING: {
                    try {
                        while (this.initialising != InitialiseState.INITIALISED) {
                            this.awtLockWait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        boolean bl = false;
                        this.awtUnlock();
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                case NOT_INITIALISED: 
                case FAILED_INITIALISATION: {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.awtUnlock();
        }
    }

    XBaseWindow() {
        this(new XCreateWindowParams());
    }

    XBaseWindow(long l, Rectangle rectangle) {
        this(new XCreateWindowParams(new Object[]{BOUNDS, rectangle, PARENT_WINDOW, l}));
    }

    XBaseWindow(Rectangle rectangle) {
        this(new XCreateWindowParams(new Object[]{BOUNDS, rectangle}));
    }

    public XBaseWindow(XCreateWindowParams xCreateWindowParams) {
        this.init(xCreateWindowParams);
    }

    XBaseWindow(long l) {
        this(new XCreateWindowParams(new Object[]{PARENT_WINDOW, l, EMBEDDED, Boolean.TRUE}));
    }

    protected void checkParams(XCreateWindowParams xCreateWindowParams) {
        if (xCreateWindowParams == null) {
            throw new IllegalArgumentException("Window creation parameters are null");
        }
        xCreateWindowParams.putIfNull((Object)PARENT_WINDOW, (Object)XToolkit.getDefaultRootWindow());
        xCreateWindowParams.putIfNull((Object)BOUNDS, new Rectangle(1, 1, 1, 1));
        xCreateWindowParams.putIfNull((Object)DEPTH, (Object)0);
        xCreateWindowParams.putIfNull((Object)VISUAL, (Object)0L);
        xCreateWindowParams.putIfNull((Object)VISUAL_CLASS, (Object)2);
        xCreateWindowParams.putIfNull((Object)VALUE_MASK, (Object)2048L);
        Rectangle rectangle = (Rectangle)xCreateWindowParams.get(BOUNDS);
        rectangle.width = Math.max(1, rectangle.width);
        rectangle.height = Math.max(1, rectangle.height);
        Long l = (Long)xCreateWindowParams.get(EVENT_MASK);
        long l2 = l != null ? l : 0L;
        xCreateWindowParams.put(EVENT_MASK, l2 |= 0x1400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void create(XCreateWindowParams xCreateWindowParams) {
        XToolkit.awtLock();
        try {
            XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
            try {
                Integer n;
                Integer n2;
                Boolean bl;
                Long l;
                Long l2;
                this.checkParams(xCreateWindowParams);
                long l3 = (Long)xCreateWindowParams.get(VALUE_MASK);
                Long l4 = (Long)xCreateWindowParams.get(EVENT_MASK);
                xSetWindowAttributes.set_event_mask(l4);
                l3 |= 0x800L;
                Long l5 = (Long)xCreateWindowParams.get(BORDER_PIXEL);
                if (l5 != null) {
                    xSetWindowAttributes.set_border_pixel(l5);
                    l3 |= 8L;
                }
                if ((l2 = (Long)xCreateWindowParams.get(COLORMAP)) != null) {
                    xSetWindowAttributes.set_colormap(l2);
                    l3 |= 0x2000L;
                }
                if ((l = (Long)xCreateWindowParams.get(BACKGROUND_PIXMAP)) != null) {
                    xSetWindowAttributes.set_background_pixmap(l);
                    l3 |= 1L;
                }
                Long l6 = (Long)xCreateWindowParams.get(PARENT_WINDOW);
                Rectangle rectangle = (Rectangle)xCreateWindowParams.get(BOUNDS);
                Integer n3 = (Integer)xCreateWindowParams.get(DEPTH);
                Integer n4 = (Integer)xCreateWindowParams.get(VISUAL_CLASS);
                Long l7 = (Long)xCreateWindowParams.get(VISUAL);
                Boolean bl2 = (Boolean)xCreateWindowParams.get(OVERRIDE_REDIRECT);
                if (bl2 != null) {
                    xSetWindowAttributes.set_override_redirect(bl2);
                    l3 |= 0x200L;
                }
                if ((bl = (Boolean)xCreateWindowParams.get(SAVE_UNDER)) != null) {
                    xSetWindowAttributes.set_save_under(bl);
                    l3 |= 0x400L;
                }
                if ((n2 = (Integer)xCreateWindowParams.get(BACKING_STORE)) != null) {
                    xSetWindowAttributes.set_backing_store(n2);
                    l3 |= 0x40L;
                }
                if ((n = (Integer)xCreateWindowParams.get(BIT_GRAVITY)) != null) {
                    xSetWindowAttributes.set_bit_gravity(n);
                    l3 |= 0x10L;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Creating window for " + this + " with the following attributes: \n" + xCreateWindowParams);
                }
                this.window = XlibWrapper.XCreateWindow(XToolkit.getDisplay(), l6, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, n3, n4.intValue(), l7, l3, xSetWindowAttributes.pData);
                if (this.window == 0L) {
                    throw new IllegalStateException("Couldn't create window because of wrong parameters. Run with NOISY_AWT to see details");
                }
                XToolkit.addToWinMap(this.window, this);
            }
            finally {
                xSetWindowAttributes.dispose();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public XCreateWindowParams getDelayedParams() {
        return this.delayedParams;
    }

    protected String getWMName() {
        return XToolkit.getCorrectXIDString(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initClientLeader() {
        XToolkit.awtLock();
        try {
            if (wm_client_leader == null) {
                wm_client_leader = XAtom.get("WM_CLIENT_LEADER");
            }
            wm_client_leader.setWindowProperty(this, XBaseWindow.getXAWTRootWindow());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static XRootWindow getXAWTRootWindow() {
        return XRootWindow.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        XToolkit.awtLock();
        try {
            if (this.hints != null) {
                XlibWrapper.XFree(this.hints.pData);
                this.hints = null;
            }
            XToolkit.removeFromWinMap(this.getWindow(), this);
            XlibWrapper.XDestroyWindow(XToolkit.getDisplay(), this.getWindow());
            if (XPropertyCache.isCachingSupported()) {
                XPropertyCache.clearCache(this.window);
            }
            this.window = -1L;
            if (!this.isDisposed()) {
                this.setDisposed(true);
            }
            XAwtState.getGrabWindow();
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWMHints(XWMHints xWMHints) {
        XToolkit.awtLock();
        try {
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public XWMHints getWMHints() {
        if (this.wmHints == null) {
            this.wmHints = new XWMHints(XlibWrapper.XAllocWMHints());
        }
        return this.wmHints;
    }

    public XSizeHints getHints() {
        if (this.hints == null) {
            long l = XlibWrapper.XAllocSizeHints();
            this.hints = new XSizeHints(l);
        }
        return this.hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeHints(long l, int n, int n2, int n3, int n4) {
        if (insLog.isLoggable(Level.FINER)) {
            insLog.finer("Setting hints, flags " + XlibWrapper.hintsToString(l));
        }
        XToolkit.awtLock();
        try {
            XSizeHints xSizeHints = this.getHints();
            if ((l & 4L) != 0L) {
                xSizeHints.set_x(n);
                xSizeHints.set_y(n2);
            }
            if ((l & 8L) != 0L) {
                xSizeHints.set_width(n3);
                xSizeHints.set_height(n4);
            } else if ((xSizeHints.get_flags() & 8L) != 0L) {
                l |= 8L;
            }
            if ((l & 0x10L) != 0L) {
                xSizeHints.set_min_width(n3);
                xSizeHints.set_min_height(n4);
            } else if ((xSizeHints.get_flags() & 0x10L) != 0L) {
                l |= 0x10L;
            }
            if ((l & 0x20L) != 0L) {
                if (this.maxBounds != null) {
                    if (this.maxBounds.width != Integer.MAX_VALUE) {
                        xSizeHints.set_max_width(this.maxBounds.width);
                    } else {
                        xSizeHints.set_max_width(XToolkit.getDefaultScreenWidth());
                    }
                    if (this.maxBounds.height != Integer.MAX_VALUE) {
                        xSizeHints.set_max_height(this.maxBounds.height);
                    } else {
                        xSizeHints.set_max_height(XToolkit.getDefaultScreenHeight());
                    }
                } else {
                    xSizeHints.set_max_width(n3);
                    xSizeHints.set_max_height(n4);
                }
            } else if ((xSizeHints.get_flags() & 0x20L) != 0L) {
                l |= 0x20L;
                if (this.maxBounds != null) {
                    if (this.maxBounds.width != Integer.MAX_VALUE) {
                        xSizeHints.set_max_width(this.maxBounds.width);
                    } else {
                        xSizeHints.set_max_width(XToolkit.getDefaultScreenWidth());
                    }
                    if (this.maxBounds.height != Integer.MAX_VALUE) {
                        xSizeHints.set_max_height(this.maxBounds.height);
                    } else {
                        xSizeHints.set_max_height(XToolkit.getDefaultScreenHeight());
                    }
                }
            }
            xSizeHints.set_flags(l |= 0x200L);
            xSizeHints.set_win_gravity(1);
            if (insLog.isLoggable(Level.FINER)) {
                insLog.finer("Setting hints, resulted flags " + XlibWrapper.hintsToString(l) + ", values " + xSizeHints);
            }
            XlibWrapper.XSetWMNormalHints(XToolkit.getDisplay(), this.getWindow(), xSizeHints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public boolean isMinSizeSet() {
        XSizeHints xSizeHints = this.getHints();
        long l = xSizeHints.get_flags();
        return (l & 0x10L) == 16L;
    }

    Object getStateLock() {
        return this.state_lock;
    }

    public long getWindow() {
        return this.window;
    }

    public long getContentWindow() {
        return this.window;
    }

    public XBaseWindow getContentXWindow() {
        return XToolkit.windowToXWindow(this.getContentWindow());
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFront() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XRaiseWindow(XToolkit.getDisplay(), this.getWindow());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xRequestFocus(long l) {
        XToolkit.awtLock();
        try {
            if (focusLog.isLoggable(Level.FINER)) {
                focusLog.finer("XSetInputFocus on " + Long.toHexString(this.getWindow()) + " with time " + l);
            }
            XlibWrapper.XSetInputFocus2(XToolkit.getDisplay(), this.getWindow(), l);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xRequestFocus() {
        XToolkit.awtLock();
        try {
            if (focusLog.isLoggable(Level.FINER)) {
                focusLog.finer("XSetInputFocus on " + Long.toHexString(this.getWindow()));
            }
            XlibWrapper.XSetInputFocus(XToolkit.getDisplay(), this.getWindow());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long xGetInputFocus() {
        XToolkit.awtLock();
        try {
            long l = XlibWrapper.XGetInputFocus(XToolkit.getDisplay());
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xSetVisible(boolean bl) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting visible on " + this + " to " + bl);
        }
        XToolkit.awtLock();
        try {
            this.visible = bl;
            if (bl) {
                XlibWrapper.XMapWindow(XToolkit.getDisplay(), this.getWindow());
            } else {
                XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.getWindow());
            }
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    boolean isMapped() {
        return this.mapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateWMName() {
        String string = this.getWMName();
        XToolkit.awtLock();
        try {
            if (string == null) {
                string = " ";
            }
            XAtom xAtom = XAtom.get(39L);
            xAtom.setProperty(this.getWindow(), string);
            XAtom xAtom2 = XAtom.get("_NET_WM_NAME");
            xAtom2.setPropertyUTF8(this.getWindow(), string);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWMClass(String[] stringArray) {
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("WM_CLASS_NAME consists of exactly two strings");
        }
        XToolkit.awtLock();
        try {
            XAtom xAtom = XAtom.get(67L);
            xAtom.setProperty8(this.getWindow(), stringArray[0] + '\u0000' + stringArray[1]);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    boolean isVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getScreenOfWindow(long l) {
        XToolkit.awtLock();
        try {
            long l2 = XlibWrapper.getScreenOfWindow(XToolkit.getDisplay(), l);
            return l2;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getScreenNumber() {
        XToolkit.awtLock();
        try {
            long l = XlibWrapper.XScreenNumberOfScreen(this.getScreen());
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    long getScreen() {
        if (this.screen == -1L) {
            this.screen = XBaseWindow.getScreenOfWindow(this.window);
        }
        return this.screen;
    }

    public void xSetBounds(Rectangle rectangle) {
        this.xSetBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xSetBounds(int n, int n2, int n3, int n4) {
        if (this.getWindow() == 0L) {
            insLog.warning("Attempt to resize uncreated window");
            throw new IllegalStateException("Attempt to resize uncreated window");
        }
        insLog.fine("Setting bounds on " + this + " to (" + n + ", " + n2 + "), " + n3 + "x" + n4);
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), this.getWindow(), n, n2, n3, n4);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static Point toOtherWindow(long l, long l2, int n, int n2) {
        Point point = new Point(0, 0);
        XBaseWindow xBaseWindow = XToolkit.windowToXWindow(l);
        XBaseWindow xBaseWindow2 = XToolkit.windowToXWindow(l2);
        if (xBaseWindow != null && xBaseWindow2 != null) {
            point.x = n + xBaseWindow.getAbsoluteX() - xBaseWindow2.getAbsoluteX();
            point.y = n2 + xBaseWindow.getAbsoluteY() - xBaseWindow2.getAbsoluteY();
        } else if (xBaseWindow2 != null && XlibUtil.isRoot(l, xBaseWindow2.getScreenNumber())) {
            point.x = n - xBaseWindow2.getAbsoluteX();
            point.y = n2 - xBaseWindow2.getAbsoluteY();
        } else if (xBaseWindow != null && XlibUtil.isRoot(l2, xBaseWindow.getScreenNumber())) {
            point.x = n + xBaseWindow.getAbsoluteX();
            point.y = n2 + xBaseWindow.getAbsoluteY();
        } else {
            point = XlibUtil.translateCoordinates(l, l2, new Point(n, n2));
        }
        return point;
    }

    Rectangle toGlobal(Rectangle rectangle) {
        Point point = this.toGlobal(rectangle.getLocation());
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (point != null) {
            rectangle2.setLocation(point);
        }
        return rectangle2;
    }

    Point toGlobal(Point point) {
        Point point2 = this.toGlobal(point.x, point.y);
        if (point2 != null) {
            return point2;
        }
        return new Point(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point toGlobal(int n, int n2) {
        long l;
        XToolkit.awtLock();
        try {
            l = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
        }
        finally {
            XToolkit.awtUnlock();
        }
        Point point = XBaseWindow.toOtherWindow(this.getContentWindow(), l, n, n2);
        if (point != null) {
            return point;
        }
        return new Point(n, n2);
    }

    Point toLocal(Point point) {
        Point point2 = this.toLocal(point.x, point.y);
        if (point2 != null) {
            return point2;
        }
        return new Point(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point toLocal(int n, int n2) {
        long l;
        XToolkit.awtLock();
        try {
            l = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
        }
        finally {
            XToolkit.awtUnlock();
        }
        Point point = XBaseWindow.toOtherWindow(l, this.getContentWindow(), n, n2);
        if (point != null) {
            return point;
        }
        return new Point(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean grabInput() {
        grabLog.log(Level.FINE, "Grab input on {0}", new Object[]{this});
        XToolkit.awtLock();
        try {
            if (XAwtState.getGrabWindow() == this && XAwtState.isManualGrab()) {
                grabLog.fine("    Already Grabbed");
                boolean bl = true;
                return bl;
            }
            XBaseWindow xBaseWindow = XAwtState.getGrabWindow();
            int n = XlibWrapper.XGrabPointer(XToolkit.getDisplay(), this.getContentWindow(), 1, 8316, 1, 1, 0L, XWM.isMotif() ? (long)XToolkit.arrowCursor : 0L, 0L);
            if (n != 0) {
                XlibWrapper.XUngrabPointer(XToolkit.getDisplay(), 0L);
                XAwtState.setGrabWindow(null);
                grabLog.fine("    Grab Failure - mouse");
                boolean bl = false;
                return bl;
            }
            int n2 = XlibWrapper.XGrabKeyboard(XToolkit.getDisplay(), this.getContentWindow(), 1, 1, 1, 0L);
            if (n2 != 0) {
                XlibWrapper.XUngrabPointer(XToolkit.getDisplay(), 0L);
                XlibWrapper.XUngrabKeyboard(XToolkit.getDisplay(), 0L);
                XAwtState.setGrabWindow(null);
                grabLog.fine("    Grab Failure - keyboard");
                boolean bl = false;
                return bl;
            }
            if (xBaseWindow != null) {
                xBaseWindow.ungrabInputImpl();
            }
            XAwtState.setGrabWindow(this);
            grabLog.fine("    Grab - success");
            boolean bl = true;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void ungrabInput() {
        XToolkit.awtLock();
        try {
            XBaseWindow xBaseWindow = XAwtState.getGrabWindow();
            grabLog.log(Level.FINE, "UnGrab input on {0}", new Object[]{xBaseWindow});
            if (xBaseWindow != null) {
                xBaseWindow.ungrabInputImpl();
                XlibWrapper.XUngrabPointer(XToolkit.getDisplay(), 0L);
                XlibWrapper.XUngrabKeyboard(XToolkit.getDisplay(), 0L);
                XAwtState.setGrabWindow(null);
                XlibWrapper.XFlush(XToolkit.getDisplay());
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void ungrabInputImpl() {
    }

    static void checkSecurity() {
        if (XToolkit.isSecurityWarningEnabled() && XToolkit.isToolkitThread()) {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            log.warning(stackTraceElementArray[1] + ": Security violation: calling user code on toolkit thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getChildren() {
        Object object = this.getStateLock();
        synchronized (object) {
            return new HashSet<Long>(this.children);
        }
    }

    public void handleMapNotifyEvent(XEvent xEvent) {
        this.mapped = true;
    }

    public void handleUnmapNotifyEvent(XEvent xEvent) {
        this.mapped = false;
    }

    public void handleReparentNotifyEvent(XEvent xEvent) {
        if (eventLog.isLoggable(Level.FINER)) {
            XReparentEvent xReparentEvent = xEvent.get_xreparent();
            eventLog.finer(xReparentEvent.toString());
        }
    }

    public void handlePropertyNotify(XEvent xEvent) {
        XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
        if (XPropertyCache.isCachingSupported()) {
            XPropertyCache.clearCache(this.window, XAtom.get(xPropertyEvent.get_atom()));
        }
        if (eventLog.isLoggable(Level.FINER)) {
            eventLog.log(Level.FINER, "{0}", new Object[]{xPropertyEvent});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDestroyNotify(XEvent xEvent) {
        XAnyEvent xAnyEvent = xEvent.get_xany();
        if (xAnyEvent.get_window() == this.getWindow()) {
            XToolkit.removeFromWinMap(this.getWindow(), this);
            if (XPropertyCache.isCachingSupported()) {
                XPropertyCache.clearCache(this.getWindow());
            }
        }
        if (xAnyEvent.get_window() != this.getWindow()) {
            Object object = this.getStateLock();
            synchronized (object) {
                this.children.remove(xAnyEvent.get_window());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCreateNotify(XEvent xEvent) {
        XAnyEvent xAnyEvent = xEvent.get_xany();
        if (xAnyEvent.get_window() != this.getWindow()) {
            Object object = this.getStateLock();
            synchronized (object) {
                this.children.add(xAnyEvent.get_window());
            }
        }
    }

    public void handleClientMessage(XEvent xEvent) {
        if (eventLog.isLoggable(Level.FINER)) {
            XClientMessageEvent xClientMessageEvent = xEvent.get_xclient();
            eventLog.finer(xClientMessageEvent.toString());
        }
    }

    public void handleVisibilityEvent(XEvent xEvent) {
    }

    public void handleKeyPress(XEvent xEvent) {
    }

    public void handleKeyRelease(XEvent xEvent) {
    }

    public void handleExposeEvent(XEvent xEvent) {
    }

    public void handleButtonPressRelease(XEvent xEvent) {
        XButtonEvent xButtonEvent = xEvent.get_xbutton();
        int n = 0;
        for (int i = 0; i < XToolkit.getNumMouseButtons(); ++i) {
            if (i == 4 || i == 5) continue;
            n |= xButtonEvent.get_state() & XConstants.buttonsMask[i];
        }
        switch (xEvent.get_type()) {
            case 4: {
                if (n != 0) break;
                XAwtState.setAutoGrabWindow(this);
                break;
            }
            case 5: {
                if (!XBaseWindow.isFullRelease(n, xButtonEvent.get_button())) break;
                XAwtState.setAutoGrabWindow(null);
            }
        }
    }

    public void handleMotionNotify(XEvent xEvent) {
    }

    public void handleXCrossingEvent(XEvent xEvent) {
    }

    public void handleConfigureNotifyEvent(XEvent xEvent) {
        XConfigureEvent xConfigureEvent = xEvent.get_xconfigure();
        insLog.log(Level.FINER, "Configure, {0}", new Object[]{xConfigureEvent});
        this.x = xConfigureEvent.get_x();
        this.y = xConfigureEvent.get_y();
        this.width = xConfigureEvent.get_width();
        this.height = xConfigureEvent.get_height();
    }

    static boolean isFullRelease(int n, int n2) {
        if (n2 < 0 || n2 > XToolkit.getNumMouseButtons()) {
            return n == 0;
        }
        return n == XConstants.buttonsMask[n2 - 1];
    }

    static boolean isGrabbedEvent(XEvent xEvent, XBaseWindow xBaseWindow) {
        switch (xEvent.get_type()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
            case 7: 
            case 8: {
                return xBaseWindow instanceof XWindowPeer;
            }
        }
        return false;
    }

    static void dispatchToWindow(XEvent xEvent) {
        XBaseWindow xBaseWindow = XAwtState.getGrabWindow();
        if (xBaseWindow == null || !XBaseWindow.isGrabbedEvent(xEvent, xBaseWindow)) {
            xBaseWindow = XToolkit.windowToXWindow(xEvent.get_xany().get_window());
        }
        if (xBaseWindow != null && xBaseWindow.checkInitialised()) {
            xBaseWindow.dispatchEvent(xEvent);
        }
    }

    public void dispatchEvent(XEvent xEvent) {
        if (eventLog.isLoggable(Level.FINEST)) {
            eventLog.finest(xEvent.toString());
        }
        int n = xEvent.get_type();
        if (this.isDisposed()) {
            return;
        }
        switch (n) {
            case 15: {
                this.handleVisibilityEvent(xEvent);
                break;
            }
            case 33: {
                this.handleClientMessage(xEvent);
                break;
            }
            case 12: 
            case 13: {
                this.handleExposeEvent(xEvent);
                break;
            }
            case 4: 
            case 5: {
                this.handleButtonPressRelease(xEvent);
                break;
            }
            case 6: {
                this.handleMotionNotify(xEvent);
                break;
            }
            case 2: {
                this.handleKeyPress(xEvent);
                break;
            }
            case 3: {
                this.handleKeyRelease(xEvent);
                break;
            }
            case 7: 
            case 8: {
                this.handleXCrossingEvent(xEvent);
                break;
            }
            case 22: {
                this.handleConfigureNotifyEvent(xEvent);
                break;
            }
            case 19: {
                this.handleMapNotifyEvent(xEvent);
                break;
            }
            case 18: {
                this.handleUnmapNotifyEvent(xEvent);
                break;
            }
            case 21: {
                this.handleReparentNotifyEvent(xEvent);
                break;
            }
            case 28: {
                this.handlePropertyNotify(xEvent);
                break;
            }
            case 17: {
                this.handleDestroyNotify(xEvent);
                break;
            }
            case 16: {
                this.handleCreateNotify(xEvent);
            }
        }
    }

    protected boolean isEventDisabled(XEvent xEvent) {
        return false;
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    public int getAbsoluteX() {
        XBaseWindow xBaseWindow = this.getParentWindow();
        if (xBaseWindow != null) {
            return xBaseWindow.getAbsoluteX() + this.getX();
        }
        return this.getX();
    }

    public int getAbsoluteY() {
        XBaseWindow xBaseWindow = this.getParentWindow();
        if (xBaseWindow != null) {
            return xBaseWindow.getAbsoluteY() + this.getY();
        }
        return this.getY();
    }

    public XBaseWindow getParentWindow() {
        return this.parentWindow;
    }

    public XWindowPeer getToplevelXWindow() {
        XBaseWindow xBaseWindow;
        for (xBaseWindow = this; xBaseWindow != null && !(xBaseWindow instanceof XWindowPeer); xBaseWindow = xBaseWindow.getParentWindow()) {
        }
        return (XWindowPeer)xBaseWindow;
    }

    public String toString() {
        return super.toString() + "(" + Long.toString(this.getWindow(), 16) + ")";
    }

    public boolean contains(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.getWidth() && n2 < this.getHeight();
    }

    public boolean containsGlobal(int n, int n2) {
        return n >= this.getAbsoluteX() && n2 >= this.getAbsoluteY() && n < this.getAbsoluteX() + this.getWidth() && n2 < this.getAbsoluteY() + this.getHeight();
    }

    static class StateLock {
        StateLock() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InitialiseState {
        INITIALISING,
        NOT_INITIALISED,
        INITIALISED,
        FAILED_INITIALISATION;

    }
}

