/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.lang.ref.SoftReference;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.StateInvariantError;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class WrappedPlainView
extends BoxView
implements TabExpander {
    FontMetrics metrics;
    Segment lineBuffer;
    boolean widthChanging;
    int tabBase;
    int tabSize;
    boolean wordWrap;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;

    public WrappedPlainView(Element element) {
        this(element, false);
    }

    public WrappedPlainView(Element element, boolean bl) {
        super(element, 1);
        this.wordWrap = bl;
    }

    protected int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 8;
        return n2;
    }

    protected void drawLine(int n, int n2, Graphics graphics, int n3, int n4) {
        Element element = this.getElement();
        Element element2 = element.getElement(element.getElementIndex(n));
        try {
            if (element2.isLeaf()) {
                this.drawText(element2, n, n2, graphics, n3, n4);
            } else {
                int n5 = element2.getElementIndex(n2);
                for (int i = element2.getElementIndex(n); i <= n5; ++i) {
                    Element element3 = element2.getElement(i);
                    int n6 = Math.max(element3.getStartOffset(), n);
                    int n7 = Math.min(element3.getEndOffset(), n2);
                    n3 = this.drawText(element3, n6, n7, graphics, n3, n4);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't render: " + n + "," + n2);
        }
    }

    private int drawText(Element element, int n, int n2, Graphics graphics, int n3, int n4) throws BadLocationException {
        n2 = Math.min(this.getDocument().getLength(), n2);
        AttributeSet attributeSet = element.getAttributes();
        if (Utilities.isComposedTextAttributeDefined(attributeSet)) {
            graphics.setColor(this.unselected);
            n3 = Utilities.drawComposedText(this, attributeSet, graphics, n3, n4, n - element.getStartOffset(), n2 - element.getStartOffset());
        } else if (this.sel0 == this.sel1 || this.selected == this.unselected) {
            n3 = this.drawUnselectedText(graphics, n3, n4, n, n2);
        } else if (n >= this.sel0 && n <= this.sel1 && n2 >= this.sel0 && n2 <= this.sel1) {
            n3 = this.drawSelectedText(graphics, n3, n4, n, n2);
        } else if (this.sel0 >= n && this.sel0 <= n2) {
            if (this.sel1 >= n && this.sel1 <= n2) {
                n3 = this.drawUnselectedText(graphics, n3, n4, n, this.sel0);
                n3 = this.drawSelectedText(graphics, n3, n4, this.sel0, this.sel1);
                n3 = this.drawUnselectedText(graphics, n3, n4, this.sel1, n2);
            } else {
                n3 = this.drawUnselectedText(graphics, n3, n4, n, this.sel0);
                n3 = this.drawSelectedText(graphics, n3, n4, this.sel0, n2);
            }
        } else if (this.sel1 >= n && this.sel1 <= n2) {
            n3 = this.drawSelectedText(graphics, n3, n4, n, this.sel1);
            n3 = this.drawUnselectedText(graphics, n3, n4, this.sel1, n2);
        } else {
            n3 = this.drawUnselectedText(graphics, n3, n4, n, n2);
        }
        return n3;
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.unselected);
        Document document = this.getDocument();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n3, n4 - n3, segment);
        int n5 = Utilities.drawTabbedText(this, segment, n, n2, graphics, this, n3);
        SegmentCache.releaseSharedSegment(segment);
        return n5;
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selected);
        Document document = this.getDocument();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n3, n4 - n3, segment);
        int n5 = Utilities.drawTabbedText(this, segment, n, n2, graphics, this, n3);
        SegmentCache.releaseSharedSegment(segment);
        return n5;
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    protected int calculateBreakPosition(int n, int n2) {
        Segment segment = SegmentCache.getSharedSegment();
        this.loadText(segment, n, n2);
        int n3 = this.getWidth();
        if (n3 == Integer.MAX_VALUE) {
            n3 = (int)this.getDefaultSpan(0);
        }
        int n4 = this.wordWrap ? n + Utilities.getBreakLocation(segment, this.metrics, this.tabBase, this.tabBase + n3, this, n) : n + Utilities.getTabbedTextOffset(segment, this.metrics, this.tabBase, this.tabBase + n3, this, n, false);
        SegmentCache.releaseSharedSegment(segment);
        return n4;
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            for (int i = 0; i < n; ++i) {
                viewArray[i] = new WrappedLine(element.getElement(i));
            }
            this.replace(0, 0, viewArray);
        }
    }

    void updateChildren(DocumentEvent documentEvent, Shape shape) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            View[] viewArray = new View[elementArray2.length];
            for (int i = 0; i < elementArray2.length; ++i) {
                viewArray[i] = new WrappedLine(elementArray2[i]);
            }
            this.replace(elementChange.getIndex(), elementArray.length, viewArray);
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    final void loadText(Segment segment, int n, int n2) {
        try {
            Document document = this.getDocument();
            document.getText(n, n2 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't get line text");
        }
    }

    final void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        this.metrics = container.getFontMetrics(font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    private float getDefaultSpan(int n) {
        switch (n) {
            case 0: {
                return 80 * this.metrics.getWidths()[77];
            }
            case 1: {
                return 24 * this.metrics.getHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float nextTabStop(float f, int n) {
        if (this.tabSize == 0) {
            return f;
        }
        int n2 = ((int)f - this.tabBase) / this.tabSize;
        return this.tabBase + (n2 + 1) * this.tabSize;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = (Rectangle)shape;
        this.tabBase = rectangle.x;
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        this.sel0 = jTextComponent.getSelectionStart();
        this.sel1 = jTextComponent.getSelectionEnd();
        this.unselected = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        Caret caret = jTextComponent.getCaret();
        this.selected = caret.isSelectionVisible() && jTextComponent.getHighlighter() != null ? jTextComponent.getSelectedTextColor() : this.unselected;
        graphics.setFont(jTextComponent.getFont());
        super.paint(graphics, shape);
    }

    public void setSize(float f, float f2) {
        this.updateMetrics();
        if ((int)f != this.getWidth()) {
            this.preferenceChanged(null, true, true);
            this.widthChanging = true;
        }
        super.setSize(f, f2);
        this.widthChanging = false;
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        return super.getPreferredSpan(n);
    }

    public float getMinimumSpan(int n) {
        this.updateMetrics();
        return super.getMinimumSpan(n);
    }

    public float getMaximumSpan(int n) {
        this.updateMetrics();
        return super.getMaximumSpan(n);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.insertUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.removeUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
    }

    class WrappedLine
    extends View {
        int lineCount;
        SoftReference<int[]> lineCache;

        WrappedLine(Element element) {
            super(element);
            this.lineCache = null;
            this.lineCount = -1;
        }

        public float getPreferredSpan(int n) {
            switch (n) {
                case 0: {
                    float f = WrappedPlainView.this.getWidth();
                    if (f == 2.1474836E9f) {
                        f = WrappedPlainView.this.getDefaultSpan(n);
                    }
                    return f;
                }
                case 1: {
                    if (this.getDocument().getLength() > 0) {
                        if (this.lineCount < 0 || WrappedPlainView.this.widthChanging) {
                            this.breakLines(this.getStartOffset());
                        }
                        return this.lineCount * WrappedPlainView.this.metrics.getHeight();
                    }
                    return WrappedPlainView.this.getDefaultSpan(n);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = (Rectangle)shape;
            int n = rectangle.y + WrappedPlainView.this.metrics.getAscent();
            int n2 = rectangle.x;
            JTextComponent jTextComponent = (JTextComponent)this.getContainer();
            Highlighter highlighter = jTextComponent.getHighlighter();
            LayeredHighlighter layeredHighlighter = highlighter instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
            int n3 = this.getStartOffset();
            int n4 = this.getEndOffset();
            int n5 = n3;
            int[] nArray = this.getLineEnds();
            for (int i = 0; i < this.lineCount; ++i) {
                int n6;
                int n7 = n6 = nArray == null ? n4 : n3 + nArray[i];
                if (layeredHighlighter != null) {
                    int n8 = n6 == n4 ? n6 - 1 : n6;
                    layeredHighlighter.paintLayeredHighlights(graphics, n5, n8, shape, jTextComponent, this);
                }
                WrappedPlainView.this.drawLine(n5, n6, graphics, n2, n);
                n5 = n6;
                n += WrappedPlainView.this.metrics.getHeight();
            }
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            Rectangle rectangle = shape.getBounds();
            rectangle.height = WrappedPlainView.this.metrics.getHeight();
            rectangle.width = 1;
            int n2 = this.getStartOffset();
            if (n < n2 || n > this.getEndOffset()) {
                throw new BadLocationException("Position out of range", n);
            }
            int n3 = bias == Position.Bias.Forward ? n : Math.max(n2, n - 1);
            int n4 = 0;
            int[] nArray = this.getLineEnds();
            if (nArray != null) {
                n4 = this.findLine(n3 - n2);
                if (n4 > 0) {
                    n2 += nArray[n4 - 1];
                }
                rectangle.y += rectangle.height * n4;
            }
            if (n > n2) {
                Segment segment = SegmentCache.getSharedSegment();
                WrappedPlainView.this.loadText(segment, n2, n);
                rectangle.x += Utilities.getTabbedTextWidth(segment, WrappedPlainView.this.metrics, rectangle.x, WrappedPlainView.this, n2);
                SegmentCache.releaseSharedSegment(segment);
            }
            return rectangle;
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            Object object;
            int n;
            int n2;
            biasArray[0] = Position.Bias.Forward;
            Rectangle rectangle = (Rectangle)shape;
            int n3 = (int)f;
            int n4 = (int)f2;
            if (n4 < rectangle.y) {
                return this.getStartOffset();
            }
            if (n4 > rectangle.y + rectangle.height) {
                return this.getEndOffset() - 1;
            }
            rectangle.height = WrappedPlainView.this.metrics.getHeight();
            int n5 = n2 = rectangle.height > 0 ? (n4 - rectangle.y) / rectangle.height : this.lineCount - 1;
            if (n2 >= this.lineCount) {
                return this.getEndOffset() - 1;
            }
            int n6 = this.getStartOffset();
            if (this.lineCount == 1) {
                n = this.getEndOffset();
            } else {
                object = this.getLineEnds();
                n = n6 + object[n2];
                if (n2 > 0) {
                    n6 += object[n2 - 1];
                }
            }
            if (n3 < rectangle.x) {
                return n6;
            }
            if (n3 > rectangle.x + rectangle.width) {
                return n - 1;
            }
            object = SegmentCache.getSharedSegment();
            WrappedPlainView.this.loadText((Segment)object, n6, n);
            int n7 = Utilities.getTabbedTextOffset((Segment)object, WrappedPlainView.this.metrics, rectangle.x, n3, WrappedPlainView.this, n6);
            SegmentCache.releaseSharedSegment((Segment)object);
            return Math.min(n6 + n7, n - 1);
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.update(documentEvent, shape);
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.update(documentEvent, shape);
        }

        private void update(DocumentEvent documentEvent, Shape shape) {
            int n = this.lineCount;
            this.breakLines(documentEvent.getOffset());
            if (n != this.lineCount) {
                WrappedPlainView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = (Rectangle)shape;
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        final int[] getLineEnds() {
            if (this.lineCache == null) {
                return null;
            }
            int[] nArray = this.lineCache.get();
            if (nArray == null) {
                return this.breakLines(this.getStartOffset());
            }
            return nArray;
        }

        final int[] breakLines(int n) {
            int n2;
            int[] nArray;
            int[] nArray2 = nArray = this.lineCache == null ? null : this.lineCache.get();
            int n3 = this.getStartOffset();
            int n4 = 0;
            if (nArray != null && (n4 = this.findLine(n - n3)) > 0) {
                --n4;
            }
            int n5 = n4 == 0 ? n3 : n3 + nArray[n4 - 1];
            int n6 = this.getEndOffset();
            while (n5 < n6) {
                n2 = WrappedPlainView.this.calculateBreakPosition(n5, n6);
                int n7 = n5 = n2 == n5 ? ++n2 : n2;
                if (n4 == 0 && n5 >= n6) {
                    this.lineCache = null;
                    nArray = null;
                    n4 = 1;
                    break;
                }
                if (nArray == null || n4 >= nArray.length) {
                    double d = (double)(n6 - n3) / (double)(n5 - n3);
                    int n8 = (int)Math.ceil((double)(n4 + 1) * d);
                    n8 = Math.max(n8, n4 + 2);
                    int[] nArray3 = new int[n8];
                    if (nArray != null) {
                        System.arraycopy(nArray, 0, nArray3, 0, n4);
                    }
                    nArray = nArray3;
                }
                nArray[n4++] = n5 - n3;
            }
            this.lineCount = n4;
            if (this.lineCount > 1 && nArray.length > (n2 = this.lineCount + this.lineCount / 3)) {
                int[] nArray4 = new int[n2];
                System.arraycopy(nArray, 0, nArray4, 0, this.lineCount);
                nArray = nArray4;
            }
            if (nArray != null && nArray != nArray2) {
                this.lineCache = new SoftReference<int[]>(nArray);
            }
            return nArray;
        }

        private int findLine(int n) {
            int[] nArray = this.lineCache.get();
            if (n < nArray[0]) {
                return 0;
            }
            if (n > nArray[this.lineCount - 1]) {
                return this.lineCount;
            }
            return this.findLine(nArray, n, 0, this.lineCount - 1);
        }

        private int findLine(int[] nArray, int n, int n2, int n3) {
            if (n3 - n2 <= 1) {
                return n3;
            }
            int n4 = (n3 + n2) / 2;
            return n < nArray[n4] ? this.findLine(nArray, n, n2, n4) : this.findLine(nArray, n, n4, n3);
        }
    }
}

