/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class GridLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -7411804673224730901L;
    int hgap;
    int vgap;
    int rows;
    int cols;

    public GridLayout() {
        this(1, 0, 0, 0);
    }

    public GridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public GridLayout(int n, int n2, int n3, int n4) {
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        if (n == 0 && this.cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = n;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int n) {
        if (n == 0 && this.rows == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.cols = n;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            int n2 = this.rows;
            int n3 = this.cols;
            if (n2 > 0) {
                n3 = (n + n2 - 1) / n2;
            } else {
                n2 = (n + n3 - 1) / n3;
            }
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Dimension dimension = component.getPreferredSize();
                if (n4 < dimension.width) {
                    n4 = dimension.width;
                }
                if (n5 >= dimension.height) continue;
                n5 = dimension.height;
            }
            return new Dimension(insets.left + insets.right + n3 * n4 + (n3 - 1) * this.hgap, insets.top + insets.bottom + n2 * n5 + (n2 - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            int n2 = this.rows;
            int n3 = this.cols;
            if (n2 > 0) {
                n3 = (n + n2 - 1) / n2;
            } else {
                n2 = (n + n3 - 1) / n3;
            }
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Dimension dimension = component.getMinimumSize();
                if (n4 < dimension.width) {
                    n4 = dimension.width;
                }
                if (n5 >= dimension.height) continue;
                n5 = dimension.height;
            }
            return new Dimension(insets.left + insets.right + n3 * n4 + (n3 - 1) * this.hgap, insets.top + insets.bottom + n2 * n5 + (n2 - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            int n2 = this.rows;
            int n3 = this.cols;
            boolean bl = container.getComponentOrientation().isLeftToRight();
            if (n == 0) {
                return;
            }
            if (n2 > 0) {
                n3 = (n + n2 - 1) / n2;
            } else {
                n2 = (n + n3 - 1) / n3;
            }
            int n4 = (n3 - 1) * this.hgap;
            int n5 = container.width - (insets.left + insets.right);
            int n6 = (n5 - n4) / n3;
            int n7 = (n5 - (n6 * n3 + n4)) / 2;
            int n8 = (n2 - 1) * this.vgap;
            int n9 = container.height - (insets.top + insets.bottom);
            int n10 = (n9 - n8) / n2;
            int n11 = (n9 - (n10 * n2 + n8)) / 2;
            if (bl) {
                int n12 = 0;
                int n13 = insets.left + n7;
                while (n12 < n3) {
                    int n14 = 0;
                    int n15 = insets.top + n11;
                    while (n14 < n2) {
                        int n16 = n14 * n3 + n12;
                        if (n16 < n) {
                            container.getComponent(n16).setBounds(n13, n15, n6, n10);
                        }
                        ++n14;
                        n15 += n10 + this.vgap;
                    }
                    ++n12;
                    n13 += n6 + this.hgap;
                }
            } else {
                int n17 = 0;
                int n18 = container.width - insets.right - n6 - n7;
                while (n17 < n3) {
                    int n19 = 0;
                    int n20 = insets.top + n11;
                    while (n19 < n2) {
                        int n21 = n19 * n3 + n17;
                        if (n21 < n) {
                            container.getComponent(n21).setBounds(n18, n20, n6, n10);
                        }
                        ++n19;
                        n20 += n10 + this.vgap;
                    }
                    ++n17;
                    n18 -= n6 + this.hgap;
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }
}

