/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.binary;

import com.sun.xml.internal.rngom.binary.Alphabet;
import com.sun.xml.internal.rngom.binary.DuplicateAttributeDetector;
import com.sun.xml.internal.rngom.binary.Pattern;
import com.sun.xml.internal.rngom.binary.RestrictionViolationException;
import com.sun.xml.internal.rngom.binary.SchemaPatternBuilder;
import com.sun.xml.internal.rngom.binary.visitor.PatternFunction;
import com.sun.xml.internal.rngom.binary.visitor.PatternVisitor;
import com.sun.xml.internal.rngom.nc.NameClass;
import com.sun.xml.internal.rngom.nc.SimpleNameClass;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class AttributePattern
extends Pattern {
    private NameClass nameClass;
    private Pattern p;
    private Locator loc;

    AttributePattern(NameClass nameClass, Pattern pattern, Locator locator) {
        super(false, 0, AttributePattern.combineHashCode(29, nameClass.hashCode(), pattern.hashCode()));
        this.nameClass = nameClass;
        this.p = pattern;
        this.loc = locator;
    }

    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern = this.p.expand(schemaPatternBuilder);
        if (pattern != this.p) {
            return schemaPatternBuilder.makeAttribute(this.nameClass, pattern, this.loc);
        }
        return this;
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_attribute");
            }
            case 1: {
                if (!this.nameClass.isOpen()) break;
                throw new RestrictionViolationException("open_name_class_not_repeated");
            }
            case 3: {
                throw new RestrictionViolationException("one_or_more_contains_group_contains_attribute");
            }
            case 4: {
                throw new RestrictionViolationException("one_or_more_contains_interleave_contains_attribute");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_attribute");
            }
            case 5: {
                throw new RestrictionViolationException("attribute_contains_attribute");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_attribute");
            }
        }
        if (!duplicateAttributeDetector.addAttribute(this.nameClass)) {
            if (this.nameClass instanceof SimpleNameClass) {
                throw new RestrictionViolationException("duplicate_attribute_detail", ((SimpleNameClass)this.nameClass).name);
            }
            throw new RestrictionViolationException("duplicate_attribute");
        }
        try {
            this.p.checkRestrictions(5, null, null);
        }
        catch (RestrictionViolationException restrictionViolationException) {
            restrictionViolationException.maybeSetLocator(this.loc);
            throw restrictionViolationException;
        }
    }

    boolean samePattern(Pattern pattern) {
        if (!(pattern instanceof AttributePattern)) {
            return false;
        }
        AttributePattern attributePattern = (AttributePattern)pattern;
        return this.nameClass.equals(attributePattern.nameClass) && this.p == attributePattern.p;
    }

    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n);
    }

    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitAttribute(this.nameClass, this.p);
    }

    public Object apply(PatternFunction patternFunction) {
        return patternFunction.caseAttribute(this);
    }

    public Pattern getContent() {
        return this.p;
    }

    public NameClass getNameClass() {
        return this.nameClass;
    }

    public Locator getLocator() {
        return this.loc;
    }
}

