/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.util.xml.XmlUtil;
import com.sun.tools.internal.ws.wsdl.document.BindingOperation;
import com.sun.tools.internal.ws.wsdl.document.Definitions;
import com.sun.tools.internal.ws.wsdl.document.Documentation;
import com.sun.tools.internal.ws.wsdl.document.Fault;
import com.sun.tools.internal.ws.wsdl.document.Operation;
import com.sun.tools.internal.ws.wsdl.document.Port;
import com.sun.tools.internal.ws.wsdl.document.PortType;
import com.sun.tools.internal.ws.wsdl.document.Service;
import com.sun.tools.internal.ws.wsdl.document.jaxws.CustomName;
import com.sun.tools.internal.ws.wsdl.document.jaxws.Exception;
import com.sun.tools.internal.ws.wsdl.document.jaxws.JAXWSBinding;
import com.sun.tools.internal.ws.wsdl.document.jaxws.JAXWSBindingsConstants;
import com.sun.tools.internal.ws.wsdl.document.jaxws.Parameter;
import com.sun.tools.internal.ws.wsdl.framework.Extensible;
import com.sun.tools.internal.ws.wsdl.framework.Extension;
import com.sun.tools.internal.ws.wsdl.framework.ParserContext;
import com.sun.tools.internal.ws.wsdl.framework.WriterContext;
import com.sun.tools.internal.ws.wsdl.parser.ExtensionHandlerBase;
import com.sun.tools.internal.ws.wsdl.parser.NamespaceContextImpl;
import com.sun.tools.internal.ws.wsdl.parser.Util;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAXWSBindingExtensionHandler
extends ExtensionHandlerBase {
    private static final XPathFactory xpf = XPathFactory.newInstance();
    private final XPath xpath = xpf.newXPath();

    public String getNamespaceURI() {
        return "http://java.sun.com/xml/ns/jaxws";
    }

    private boolean parseGlobalJAXWSBindings(ParserContext parserContext, Extensible extensible, Element element) {
        Element element2;
        String string;
        parserContext.push();
        parserContext.registerNamespaces(element);
        JAXWSBinding jAXWSBinding = JAXWSBindingExtensionHandler.getJAXWSExtension(extensible);
        if (jAXWSBinding == null) {
            jAXWSBinding = new JAXWSBinding();
        }
        if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"wsdlLocation")) != null) {
            jAXWSBinding.setWsdlLocation(string);
        }
        if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"node")) != null) {
            jAXWSBinding.setNode(string);
        }
        if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"version")) != null) {
            jAXWSBinding.setVersion(string);
        }
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.PACKAGE)) {
                this.parsePackage(parserContext, jAXWSBinding, element2);
                if (jAXWSBinding.getJaxwsPackage() == null || jAXWSBinding.getJaxwsPackage().getJavaDoc() == null) continue;
                ((Definitions)extensible).setDocumentation(new Documentation(jAXWSBinding.getJaxwsPackage().getJavaDoc()));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                this.parseWrapperStyle(parserContext, jAXWSBinding, element2);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                this.parseAsynMapping(parserContext, jAXWSBinding, element2);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                this.parseMimeContent(parserContext, jAXWSBinding, element2);
                continue;
            }
            Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
            return false;
        }
        extensible.addExtension(jAXWSBinding);
        parserContext.pop();
        parserContext.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jAXWSBinding);
        return true;
    }

    private static JAXWSBinding getJAXWSExtension(Extensible extensible) {
        Iterator iterator = extensible.extensions();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.getClass().equals(JAXWSBinding.class)) continue;
            return (JAXWSBinding)extension;
        }
        return null;
    }

    private void parseProvider(ParserContext parserContext, Extensible extensible, Element element) {
        String string = element.getTextContent();
        if (string == null) {
            return;
        }
        if (string.equals("false") || string.equals("0")) {
            ((JAXWSBinding)extensible).setProvider(Boolean.FALSE);
        } else if (string.equals("true") || string.equals("1")) {
            ((JAXWSBinding)extensible).setProvider(Boolean.TRUE);
        }
    }

    private void parseJAXBBindings(ParserContext parserContext, Extensible extensible, Element element) {
        JAXWSBinding jAXWSBinding = (JAXWSBinding)extensible;
        jAXWSBinding.addJaxbBindings(element);
    }

    private void parsePackage(ParserContext parserContext, Extensible extensible, Element element) {
        String string = XmlUtil.getAttributeOrNull((Element)element, (String)"name");
        JAXWSBinding jAXWSBinding = (JAXWSBinding)extensible;
        jAXWSBinding.setJaxwsPackage(new CustomName(string, this.getJavaDoc(element)));
    }

    private void parseWrapperStyle(ParserContext parserContext, Extensible extensible, Element element) {
        String string = element.getTextContent();
        if (string == null) {
            return;
        }
        if (string.equals("false") || string.equals("0")) {
            ((JAXWSBinding)extensible).setEnableWrapperStyle(Boolean.FALSE);
        } else if (string.equals("true") || string.equals("1")) {
            ((JAXWSBinding)extensible).setEnableWrapperStyle(Boolean.TRUE);
        }
    }

    private void parseAsynMapping(ParserContext parserContext, Extensible extensible, Element element) {
        String string = element.getTextContent();
        if (string == null) {
            return;
        }
        if (string.equals("false") || string.equals("0")) {
            ((JAXWSBinding)extensible).setEnableAsyncMapping(Boolean.FALSE);
        } else if (string.equals("true") || string.equals("1")) {
            ((JAXWSBinding)extensible).setEnableAsyncMapping(Boolean.TRUE);
        }
    }

    private void parseMimeContent(ParserContext parserContext, Extensible extensible, Element element) {
        String string = element.getTextContent();
        if (string == null) {
            return;
        }
        if (string.equals("false") || string.equals("0")) {
            ((JAXWSBinding)extensible).setEnableMimeContentMapping(Boolean.FALSE);
        } else if (string.equals("true") || string.equals("1")) {
            ((JAXWSBinding)extensible).setEnableMimeContentMapping(Boolean.TRUE);
        }
    }

    private void parseMethod(ParserContext parserContext, JAXWSBinding jAXWSBinding, Element element) {
        String string = XmlUtil.getAttributeOrNull((Element)element, (String)"name");
        String string2 = this.getJavaDoc(element);
        CustomName customName = new CustomName(string, string2);
        jAXWSBinding.setMethodName(customName);
    }

    private void parseParameter(ParserContext parserContext, JAXWSBinding jAXWSBinding, Element element) {
        String string = XmlUtil.getAttributeOrNull((Element)element, (String)"part");
        Element element2 = this.evaluateXPathNode(element.getOwnerDocument(), string, new NamespaceContextImpl(element));
        Node node = element2.getParentNode();
        String string2 = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
        String string3 = XmlUtil.getAttributeOrNull((Element)((Element)node), (String)"name");
        if (string2 == null || string3 == null) {
            return;
        }
        String string4 = XmlUtil.getAttributeOrNull((Element)element2, (String)"element");
        String string5 = XmlUtil.getAttributeOrNull((Element)element, (String)"childElementName");
        String string6 = XmlUtil.getAttributeOrNull((Element)element, (String)"name");
        QName qName = null;
        if (string5 != null) {
            String string7 = element.lookupNamespaceURI(XmlUtil.getPrefix((String)string5));
            qName = string7 == null ? null : new QName(string7, XmlUtil.getLocalPart((String)string5));
        }
        jAXWSBinding.addParameter(new Parameter(string3, string2, qName, string6));
    }

    private Element evaluateXPathNode(Node node, String string, NamespaceContext namespaceContext) {
        NodeList nodeList;
        try {
            this.xpath.setNamespaceContext(namespaceContext);
            nodeList = (NodeList)this.xpath.evaluate(string, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            Util.fail("internalizer.XPathEvaluationError", xPathExpressionException.getMessage());
            return null;
        }
        if (nodeList.getLength() == 0) {
            Util.fail("internalizer.XPathEvaluatesToNoTarget", new Object[]{string});
            return null;
        }
        if (nodeList.getLength() != 1) {
            Util.fail("internalizer.XPathEvaulatesToTooManyTargets", new Object[]{string, nodeList.getLength()});
            return null;
        }
        Node node2 = nodeList.item(0);
        if (!(node2 instanceof Element)) {
            Util.fail("internalizer.XPathEvaluatesToNonElement", new Object[]{string});
            return null;
        }
        return (Element)node2;
    }

    private void parseClass(ParserContext parserContext, JAXWSBinding jAXWSBinding, Element element) {
        String string = XmlUtil.getAttributeOrNull((Element)element, (String)"name");
        String string2 = this.getJavaDoc(element);
        jAXWSBinding.setClassName(new CustomName(string, string2));
    }

    private void parseException(ParserContext parserContext, JAXWSBinding jAXWSBinding, Element element) {
        Element element2;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (!XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.CLASS)) continue;
            String string = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
            String string2 = this.getJavaDoc(element2);
            jAXWSBinding.setException(new Exception(new CustomName(string, string2)));
        }
    }

    protected boolean handleDefinitionsExtension(ParserContext parserContext, Extensible extensible, Element element) {
        return this.parseGlobalJAXWSBindings(parserContext, extensible, element);
    }

    protected boolean handleTypesExtension(ParserContext parserContext, Extensible extensible, Element element) {
        return false;
    }

    protected boolean handlePortTypeExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            parserContext.push();
            parserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding();
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                    this.parseWrapperStyle(parserContext, jAXWSBinding, element2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                    this.parseAsynMapping(parserContext, jAXWSBinding, element2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(parserContext, jAXWSBinding, element2);
                    if (jAXWSBinding.getClassName() == null || jAXWSBinding.getClassName().getJavaDoc() == null) continue;
                    ((PortType)extensible).setDocumentation(new Documentation(jAXWSBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            extensible.addExtension(jAXWSBinding);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jAXWSBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleOperationExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            if (extensible instanceof Operation) {
                return this.handlePortTypeOperation(parserContext, (Operation)extensible, element);
            }
            if (extensible instanceof BindingOperation) {
                return this.handleBindingOperation(parserContext, (BindingOperation)extensible, element);
            }
        } else {
            Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
            return false;
        }
        return false;
    }

    private boolean handleBindingOperation(ParserContext parserContext, BindingOperation bindingOperation, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            parserContext.push();
            parserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding();
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                    this.parseMimeContent(parserContext, jAXWSBinding, element2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.PARAMETER)) {
                    this.parseParameter(parserContext, jAXWSBinding, element2);
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            bindingOperation.addExtension(jAXWSBinding);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jAXWSBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    private boolean handlePortTypeOperation(ParserContext parserContext, Operation operation, Element element) {
        Element element2;
        parserContext.push();
        parserContext.registerNamespaces(element);
        JAXWSBinding jAXWSBinding = new JAXWSBinding();
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE)) {
                this.parseWrapperStyle(parserContext, jAXWSBinding, element2);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_ASYNC_MAPPING)) {
                this.parseAsynMapping(parserContext, jAXWSBinding, element2);
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.METHOD)) {
                this.parseMethod(parserContext, jAXWSBinding, element2);
                if (jAXWSBinding.getMethodName() == null || jAXWSBinding.getMethodName().getJavaDoc() == null) continue;
                operation.setDocumentation(new Documentation(jAXWSBinding.getMethodName().getJavaDoc()));
                continue;
            }
            if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.PARAMETER)) {
                this.parseParameter(parserContext, jAXWSBinding, element2);
                continue;
            }
            Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
            return false;
        }
        operation.addExtension(jAXWSBinding);
        parserContext.pop();
        parserContext.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jAXWSBinding);
        return true;
    }

    protected boolean handleBindingExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            parserContext.push();
            parserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding();
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.ENABLE_MIME_CONTENT)) {
                    this.parseMimeContent(parserContext, jAXWSBinding, element2);
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            extensible.addExtension(jAXWSBinding);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jAXWSBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleInputExtension(ParserContext parserContext, Extensible extensible, Element element) {
        return false;
    }

    protected boolean handleOutputExtension(ParserContext parserContext, Extensible extensible, Element element) {
        return false;
    }

    protected boolean handleFaultExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            parserContext.push();
            parserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding();
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(parserContext, jAXWSBinding, element2);
                    if (jAXWSBinding.getClassName() == null || jAXWSBinding.getClassName().getJavaDoc() == null) continue;
                    ((Fault)extensible).setDocumentation(new Documentation(jAXWSBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            extensible.addExtension(jAXWSBinding);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jAXWSBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleServiceExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            parserContext.push();
            parserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding();
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.CLASS)) {
                    this.parseClass(parserContext, jAXWSBinding, element2);
                    if (jAXWSBinding.getClassName() == null || jAXWSBinding.getClassName().getJavaDoc() == null) continue;
                    ((Service)extensible).setDocumentation(new Documentation(jAXWSBinding.getClassName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            extensible.addExtension(jAXWSBinding);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jAXWSBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handlePortExtension(ParserContext parserContext, Extensible extensible, Element element) {
        if (XmlUtil.matchesTagNS(element, JAXWSBindingsConstants.JAXWS_BINDINGS)) {
            Element element2;
            parserContext.push();
            parserContext.registerNamespaces(element);
            JAXWSBinding jAXWSBinding = new JAXWSBinding();
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.PROVIDER)) {
                    this.parseProvider(parserContext, jAXWSBinding, element2);
                    continue;
                }
                if (XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.METHOD)) {
                    this.parseMethod(parserContext, jAXWSBinding, element2);
                    if (jAXWSBinding.getMethodName() == null || jAXWSBinding.getMethodName().getJavaDoc() == null) continue;
                    ((Port)extensible).setDocumentation(new Documentation(jAXWSBinding.getMethodName().getJavaDoc()));
                    continue;
                }
                Util.fail("parsing.invalidExtensionElement", element2.getTagName(), element2.getNamespaceURI());
                return false;
            }
            extensible.addExtension(jAXWSBinding);
            parserContext.pop();
            parserContext.fireDoneParsingEntity(JAXWSBindingsConstants.JAXWS_BINDINGS, jAXWSBinding);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected boolean handleMIMEPartExtension(ParserContext parserContext, Extensible extensible, Element element) {
        return false;
    }

    private String getJavaDoc(Element element) {
        Element element2;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
            if (!XmlUtil.matchesTagNS(element2, JAXWSBindingsConstants.JAVADOC)) continue;
            return XmlUtil.getTextForNode((Node)element2);
        }
        return null;
    }

    public void doHandleExtension(WriterContext writerContext, Extension extension) throws IOException {
        if (!(extension instanceof JAXWSBinding)) {
            throw new IllegalArgumentException();
        }
        JAXWSBinding jAXWSBinding = (JAXWSBinding)extension;
        System.out.println("binding.getElementName: " + jAXWSBinding.getElementName());
        writerContext.writeStartTag(jAXWSBinding.getElementName());
        writerContext.writeStartTag(JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE);
        writerContext.writeChars(jAXWSBinding.isEnableWrapperStyle().toString());
        writerContext.writeEndTag(JAXWSBindingsConstants.ENABLE_WRAPPER_STYLE);
        writerContext.writeEndTag(jAXWSBinding.getElementName());
    }
}

