/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.annotation;

import com.sun.istack.internal.tools.APTTypeVisitor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.Types;
import com.sun.tools.internal.ws.processor.modeler.annotation.TypeModeler;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceConstants;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeSafeTypeVisitor
extends APTTypeVisitor<TypeMirror, Types>
implements WebServiceConstants {
    TypeDeclaration collectionDecl;
    TypeDeclaration mapDecl;

    public MakeSafeTypeVisitor(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        this.collectionDecl = annotationProcessorEnvironment.getTypeDeclaration(COLLECTION_CLASSNAME);
        this.mapDecl = annotationProcessorEnvironment.getTypeDeclaration(MAP_CLASSNAME);
    }

    @Override
    protected TypeMirror onArrayType(ArrayType arrayType, Types types) {
        return types.getErasure(arrayType);
    }

    @Override
    protected TypeMirror onPrimitiveType(PrimitiveType primitiveType, Types types) {
        return types.getErasure(primitiveType);
    }

    @Override
    protected TypeMirror onClassType(ClassType classType, Types types) {
        return this.processDeclaredType(classType, types);
    }

    @Override
    protected TypeMirror onInterfaceType(InterfaceType interfaceType, Types types) {
        return this.processDeclaredType(interfaceType, types);
    }

    private TypeMirror processDeclaredType(DeclaredType declaredType, Types types) {
        if (TypeModeler.isSubtype(declaredType.getDeclaration(), this.collectionDecl) || TypeModeler.isSubtype(declaredType.getDeclaration(), this.mapDecl)) {
            Collection<TypeMirror> collection = declaredType.getActualTypeArguments();
            TypeMirror[] typeMirrorArray = new TypeMirror[collection.size()];
            int n = 0;
            for (TypeMirror typeMirror : collection) {
                typeMirrorArray[n++] = (TypeMirror)this.apply(typeMirror, types);
            }
            return types.getDeclaredType(declaredType.getDeclaration(), typeMirrorArray);
        }
        return types.getErasure(declaredType);
    }

    @Override
    protected TypeMirror onTypeVariable(TypeVariable typeVariable, Types types) {
        return types.getErasure(typeVariable);
    }

    @Override
    protected TypeMirror onVoidType(VoidType voidType, Types types) {
        return voidType;
    }

    @Override
    protected TypeMirror onWildcard(WildcardType wildcardType, Types types) {
        return types.getErasure(wildcardType);
    }
}

