/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc.gen.config;

import com.sun.tools.internal.jxc.gen.config.NGCCEventReceiver;
import com.sun.tools.internal.jxc.gen.config.NGCCEventSource;
import com.sun.tools.internal.jxc.gen.config.NGCCHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class NGCCInterleaveFilter
implements NGCCEventSource,
NGCCEventReceiver {
    protected NGCCEventReceiver[] _receivers;
    private final NGCCHandler _parent;
    private final int _cookie;
    private int lockedReceiver;
    private int lockCount = 0;
    private boolean isJoining = false;

    protected NGCCInterleaveFilter(NGCCHandler nGCCHandler, int n) {
        this._parent = nGCCHandler;
        this._cookie = n;
    }

    protected void setHandlers(NGCCEventReceiver[] nGCCEventReceiverArray) {
        this._receivers = nGCCEventReceiverArray;
    }

    public int replace(NGCCEventReceiver nGCCEventReceiver, NGCCEventReceiver nGCCEventReceiver2) {
        for (int i = 0; i < this._receivers.length; ++i) {
            if (this._receivers[i] != nGCCEventReceiver) continue;
            this._receivers[i] = nGCCEventReceiver2;
            return i;
        }
        throw new InternalError();
    }

    public void enterElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.isJoining) {
            return;
        }
        if (this.lockCount++ == 0) {
            this.lockedReceiver = this.findReceiverOfElement(string, string2);
            if (this.lockedReceiver == -1) {
                this.joinByEnterElement(null, string, string2, string3, attributes);
                return;
            }
        }
        this._receivers[this.lockedReceiver].enterElement(string, string2, string3, attributes);
    }

    public void leaveElement(String string, String string2, String string3) throws SAXException {
        if (this.isJoining) {
            return;
        }
        if (this.lockCount-- == 0) {
            this.joinByLeaveElement(null, string, string2, string3);
        } else {
            this._receivers[this.lockedReceiver].leaveElement(string, string2, string3);
        }
    }

    public void enterAttribute(String string, String string2, String string3) throws SAXException {
        if (this.isJoining) {
            return;
        }
        if (this.lockCount++ == 0) {
            this.lockedReceiver = this.findReceiverOfAttribute(string, string2);
            if (this.lockedReceiver == -1) {
                this.joinByEnterAttribute(null, string, string2, string3);
                return;
            }
        }
        this._receivers[this.lockedReceiver].enterAttribute(string, string2, string3);
    }

    public void leaveAttribute(String string, String string2, String string3) throws SAXException {
        if (this.isJoining) {
            return;
        }
        if (this.lockCount-- == 0) {
            this.joinByLeaveAttribute(null, string, string2, string3);
        } else {
            this._receivers[this.lockedReceiver].leaveAttribute(string, string2, string3);
        }
    }

    public void text(String string) throws SAXException {
        if (this.isJoining) {
            return;
        }
        if (this.lockCount != 0) {
            this._receivers[this.lockedReceiver].text(string);
        } else {
            int n = this.findReceiverOfText();
            if (n != -1) {
                this._receivers[n].text(string);
            } else {
                this.joinByText(null, string);
            }
        }
    }

    protected abstract int findReceiverOfElement(String var1, String var2);

    protected abstract int findReceiverOfAttribute(String var1, String var2);

    protected abstract int findReceiverOfText();

    public void joinByEnterElement(NGCCEventReceiver nGCCEventReceiver, String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.isJoining) {
            return;
        }
        this.isJoining = true;
        for (int i = 0; i < this._receivers.length; ++i) {
            if (this._receivers[i] == nGCCEventReceiver) continue;
            this._receivers[i].enterElement(string, string2, string3, attributes);
        }
        this._parent._source.replace(this, this._parent);
        this._parent.onChildCompleted(null, this._cookie, true);
        this._parent.enterElement(string, string2, string3, attributes);
    }

    public void joinByLeaveElement(NGCCEventReceiver nGCCEventReceiver, String string, String string2, String string3) throws SAXException {
        if (this.isJoining) {
            return;
        }
        this.isJoining = true;
        for (int i = 0; i < this._receivers.length; ++i) {
            if (this._receivers[i] == nGCCEventReceiver) continue;
            this._receivers[i].leaveElement(string, string2, string3);
        }
        this._parent._source.replace(this, this._parent);
        this._parent.onChildCompleted(null, this._cookie, true);
        this._parent.leaveElement(string, string2, string3);
    }

    public void joinByEnterAttribute(NGCCEventReceiver nGCCEventReceiver, String string, String string2, String string3) throws SAXException {
        if (this.isJoining) {
            return;
        }
        this.isJoining = true;
        for (int i = 0; i < this._receivers.length; ++i) {
            if (this._receivers[i] == nGCCEventReceiver) continue;
            this._receivers[i].enterAttribute(string, string2, string3);
        }
        this._parent._source.replace(this, this._parent);
        this._parent.onChildCompleted(null, this._cookie, true);
        this._parent.enterAttribute(string, string2, string3);
    }

    public void joinByLeaveAttribute(NGCCEventReceiver nGCCEventReceiver, String string, String string2, String string3) throws SAXException {
        if (this.isJoining) {
            return;
        }
        this.isJoining = true;
        for (int i = 0; i < this._receivers.length; ++i) {
            if (this._receivers[i] == nGCCEventReceiver) continue;
            this._receivers[i].leaveAttribute(string, string2, string3);
        }
        this._parent._source.replace(this, this._parent);
        this._parent.onChildCompleted(null, this._cookie, true);
        this._parent.leaveAttribute(string, string2, string3);
    }

    public void joinByText(NGCCEventReceiver nGCCEventReceiver, String string) throws SAXException {
        if (this.isJoining) {
            return;
        }
        this.isJoining = true;
        for (int i = 0; i < this._receivers.length; ++i) {
            if (this._receivers[i] == nGCCEventReceiver) continue;
            this._receivers[i].text(string);
        }
        this._parent._source.replace(this, this._parent);
        this._parent.onChildCompleted(null, this._cookie, true);
        this._parent.text(string);
    }

    public void sendEnterAttribute(int n, String string, String string2, String string3) throws SAXException {
        this._receivers[n].enterAttribute(string, string2, string3);
    }

    public void sendEnterElement(int n, String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._receivers[n].enterElement(string, string2, string3, attributes);
    }

    public void sendLeaveAttribute(int n, String string, String string2, String string3) throws SAXException {
        this._receivers[n].leaveAttribute(string, string2, string3);
    }

    public void sendLeaveElement(int n, String string, String string2, String string3) throws SAXException {
        this._receivers[n].leaveElement(string, string2, string3);
    }

    public void sendText(int n, String string) throws SAXException {
        this._receivers[n].text(string);
    }
}

