/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.util.Utils;
import java.io.Serializable;

public class ProdRegTreeNode
implements Serializable {
    private ComponentDescription desc = null;
    private boolean selectable = true;

    public ProdRegTreeNode(ComponentDescription desc) {
        this.desc = desc;
        String sel = desc.getData("isSelectable");
        if (sel != null && sel.equalsIgnoreCase("false")) {
            this.setSelectable(false);
        }
    }

    public boolean getAllowsChildren() {
        ComponentReference[] kids = this.getComponentDescription().getChildren();
        if (kids == null) {
            return false;
        }
        return kids.length > 0;
    }

    public int getChildCount() {
        ComponentReference[] kids = this.getComponentDescription().getChildren();
        if (kids == null) {
            return 0;
        }
        return kids.length;
    }

    public ComponentDescription getComponentDescription() {
        return this.desc;
    }

    public boolean isLeaf() {
        return this.getChildCount() <= 0;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public String toString() {
        return Utils.getDisplayName(this.desc);
    }
}

