/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.ComponentDescriptionLookup;
import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.core.ProdReg;
import com.sun.prodreg.core.Registry;
import com.sun.prodreg.core.RegistryNotAvailableException;
import com.sun.prodreg.core.RegistryQuery;
import com.sun.prodreg.event.Subprocess;
import com.sun.prodreg.event.SubprocessDoneEvent;
import com.sun.prodreg.event.SubprocessDoneListener;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.util.TypedSystemSubprocess;
import com.sun.prodreg.util.Utils;
import com.sun.prodreg.view.ViewManager;
import java.io.File;
import java.util.StringTokenizer;

public class InteractiveUninstaller
extends Subprocess
implements SubprocessDoneListener,
Runnable {
    private ComponentDescription desc;
    private ViewManager mgr;
    private ComponentDescriptionLookup cache;
    private static final int YES = 0;
    private static final int NO = 1;
    private static final int SKIP = 2;
    private boolean running = false;
    private int pkgrm_result = 1;
    private String pkgrm_message = null;
    private Registry reg;

    public InteractiveUninstaller(ComponentDescription desc, ViewManager mgr, Registry reg) {
        this.mgr = mgr;
        this.reg = reg;
        this.desc = desc;
    }

    private int ask(String question, String moreInfo, boolean skippable) {
        int response;
        String title = Localizer.resolve("<L ProdRegResources.IntUninstallTitle>");
        String ok = Localizer.resolve("<L ProdRegResources.OK>");
        String cancel = Localizer.resolve("<L ProdRegResources.Cancel>");
        String[] buttons = new String[]{ok, cancel};
        if (skippable) {
            String skip = Localizer.resolve("<L ProdRegResources.Skip>");
            buttons = new String[]{ok, cancel, skip};
        }
        if ((response = this.mgr.query(title, question, moreInfo, buttons)) == 0) {
            return 0;
        }
        if (response == 2) {
            return 2;
        }
        return 1;
    }

    private synchronized boolean getRunning() {
        return this.running;
    }

    private String listPackages(ComponentDescription desc) {
        String pkgList = Utils.listPackages(desc);
        String finalList = "";
        if (pkgList != null) {
            StringTokenizer p = new StringTokenizer(pkgList);
            String root = System.getProperty("prodreg.pkgroot");
            if (root == null) {
                root = "/";
            }
            while (p.hasMoreTokens()) {
                String pkg = p.nextToken();
                File f = new File(String.valueOf(root) + "/var/sadm/pkg/" + pkg + "/pkginfo");
                if (!f.exists()) continue;
                finalList = String.valueOf(finalList) + pkg + ' ';
            }
        }
        return finalList.trim();
    }

    private String removePackages(String pkgList) {
        String rootrun = "bin/rootrun";
        String cmd = TypedSystemSubprocess.escape(' ', "pkgrm " + pkgList);
        String prompt = TypedSystemSubprocess.escape(' ', Localizer.resolve("<L ProdRegResources.EnterRootPassword>"));
        String finalCmd = String.valueOf(rootrun) + " " + cmd + " " + prompt;
        this.setRunning(true);
        TypedSystemSubprocess p = new TypedSystemSubprocess(System.getProperty("prodreg.home"), finalCmd);
        p.addSubprocessDoneListener(this);
        new Thread(p).start();
        while (this.getRunning()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        return this.pkgrm_message;
    }

    public void run() {
        String cancelled;
        Object[] name = new Object[]{"<bold>" + Utils.getDisplayName(this.desc) + "</bold>"};
        String question = Localizer.resolve("<L ProdRegResources.UninstallConfirm>", name);
        int response = this.ask(question, null, false);
        switch (response) {
            case 1: {
                String cancelled2 = Localizer.resolve("<L ProdRegResources.UninstallCancel>", name);
                this.tell(cancelled2, null);
                this.notifyListeners(1, "interactiveuninstaller", "message");
                return;
            }
            default: {
                throw new InternalError("Invalid response during user query");
            }
            case 0: 
        }
        boolean modified = false;
        String pkgList = this.listPackages(this.desc);
        if (pkgList == null || pkgList.length() <= 0) {
            if (Utils.listPackages(this.desc) != null) {
                String nopkgs = Localizer.resolve("<L ProdRegResources.NoPackages>", new String[]{Utils.listPackages(this.desc)});
                this.tell(nopkgs, null);
            }
        } else {
            Object[] arg = new Object[]{pkgList};
            question = Localizer.resolve("<L ProdRegResources.PkgrmConfirm>", arg);
            response = this.ask(question, null, true);
            switch (response) {
                case 0: {
                    String pkg_response = this.removePackages(pkgList);
                    if (pkg_response != null) {
                        cancelled = Localizer.resolve("<L ProdRegResources.PkgrmFailed>");
                        this.tell(cancelled, pkg_response);
                        break;
                    }
                    String success = Localizer.resolve("<L ProdRegResources.PkgrmSuccess>");
                    modified = true;
                    this.tell(success, null);
                    break;
                }
                case 1: {
                    String cancelled3 = Localizer.resolve("<L ProdRegResources.PkgrmCancel>");
                    this.tell(cancelled3, null);
                    this.notifyListeners(1, "interactiveuninstaller", "message");
                    return;
                }
                default: {
                    throw new InternalError("Invalid response during pkg removal");
                }
                case 2: 
            }
        }
        boolean hasDependency = this.desc.getDependentComponents() != null && this.desc.getDependentComponents().size() > 0;
        RegistryQuery q = new RegistryQuery();
        q.setID(this.desc.getID());
        q.setUniqueName(this.desc.getUniqueName());
        q.setVersion(this.desc.getVersion());
        q.setLocation(this.desc.getLocation());
        try {
            boolean registered;
            ComponentDescription latestDesc = this.reg.getComponent(q);
            boolean bl = registered = latestDesc != null;
            if (registered) {
                if (hasDependency) {
                    Object[] disp = new String[]{Utils.getDisplayName(this.desc)};
                    String skipreg = Localizer.resolve("<L ProdRegResources.SkipUnregister>", disp);
                    this.tell(skipreg, null);
                    response = 2;
                } else {
                    question = Localizer.resolve("<L ProdRegResources.UnregisterConfirm>");
                    response = this.ask(question, null, true);
                }
            } else {
                response = 2;
                modified = true;
            }
        }
        catch (RegistryNotAvailableException registryNotAvailableException) {
            Object[] dispName = new String[]{Utils.getDisplayName(this.desc)};
            String nounreg = Localizer.resolve("<L ProdRegResources.UnregisterProblem>", dispName);
            response = 2;
        }
        switch (response) {
            case 1: {
                cancelled = Localizer.resolve("<L ProdRegResources.UnregisterCancel>");
                this.tell(cancelled, null);
                break;
            }
            case 0: {
                String unregister_response = this.unregister(this.desc);
                if (unregister_response != null) {
                    String failed = Localizer.resolve("<L ProdRegResources.UnregisterFailed>");
                    this.tell(failed, unregister_response);
                    break;
                }
                String success = Localizer.resolve("<L ProdRegResources.UnregisterSuccess>");
                this.tell(success, null);
                modified = true;
                break;
            }
            default: {
                throw new InternalError("Invalid response during unregistration");
            }
            case 2: 
        }
        int result = modified ? 0 : 1;
        this.notifyListeners(result, "interactiveuninstaller", "message");
    }

    private synchronized void setRunning(boolean running) {
        this.running = running;
    }

    public void subprocessDone(SubprocessDoneEvent ev) {
        this.pkgrm_result = ev.getReturnValue();
        if (this.pkgrm_result != 0 && this.pkgrm_result != 2 && this.pkgrm_result != 10 && this.pkgrm_result != 20) {
            this.pkgrm_message = ev.getMessage();
        }
        this.setRunning(false);
    }

    private void tell(String message, String moreInfo) {
        String title = Localizer.resolve("<L ProdRegResources.IntUninstallTitle>");
        String ok = Localizer.resolve("<L ProdRegResources.OK>");
        this.mgr.query(title, message, moreInfo, new String[]{ok});
    }

    private String unregister(ComponentDescription desc) {
        String rtn;
        block6: {
            rtn = null;
            try {
                ComponentReference[] kids;
                if (!this.reg.unregisterComponent(desc)) {
                    if (ProdReg.debug) {
                        System.out.println("unregistration of " + desc.getID() + " failed!");
                    }
                    rtn = Localizer.resolve("<L ProdRegResources.UnregisterFailed>");
                }
                if (rtn != null || (kids = desc.getChildren()) == null) break block6;
                int i = 0;
                while (i < kids.length) {
                    ComponentDescription kid = ComponentDescriptionLookup.get(kids[i].getID());
                    if (kid == null || (rtn = this.unregister(kid)) == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (RegistryNotAvailableException registryNotAvailableException) {
                rtn = Localizer.resolve("<L ProdRegResources.UnregisterFailed>");
            }
        }
        return rtn;
    }
}

