/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.RelativeLayout;
import com.sun.prodreg.awt.Separator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ExpandableDialog
extends Dialog
implements ActionListener {
    private String moreString = "More >>>";
    private String lessString = "<<< Less";
    private Component topComponent = null;
    private Component bottomComponent = null;
    private Button[] buttons = null;
    private Button expandButton = new Button(this.moreString);
    private boolean expanded = false;
    private int buttonPressed = 0;

    public ExpandableDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.expandButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.updateUI();
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.expandButton) {
            this.toggle();
        } else if (this.buttons != null) {
            int i = 0;
            while (i < this.buttons.length) {
                if (src == this.buttons[i]) {
                    this.buttonPressed = i;
                    this.dispose();
                    ((Component)this).setVisible(false);
                }
                ++i;
            }
        }
    }

    public int getButtonPressed() {
        return this.buttonPressed;
    }

    public void setBottomComponent(Component c) {
        this.bottomComponent = c;
        this.updateUI();
    }

    public void setButtons(String[] labels) {
        this.buttons = new Button[labels.length];
        int i = 0;
        while (i < labels.length) {
            this.buttons[i] = new Button(labels[i]);
            ++i;
        }
        this.updateUI();
    }

    public void setExpandLabels(String moreString, String lessString) {
        if (moreString == null || lessString == null) {
            throw new NullPointerException("ExpandableDialog: null expand strings");
        }
        this.moreString = moreString;
        this.lessString = lessString;
    }

    public void setMoreLabel(String label) {
        this.moreString = label;
    }

    public void setTopComponent(Component c) {
        this.topComponent = c;
        this.updateUI();
    }

    public void setlessLabel(String label) {
        this.lessString = label;
    }

    public void toggle() {
        this.expanded ^= true;
        if (this.expanded) {
            this.expandButton.setLabel(this.lessString);
        } else {
            this.expandButton.setLabel(this.moreString);
        }
        this.updateUI();
        this.pack();
    }

    private void updateUI() {
        this.removeAll();
        if (this.buttons != null) {
            int i = 0;
            while (i < this.buttons.length) {
                this.buttons[i].removeActionListener(this);
                ++i;
            }
        }
        Panel contentPanel = new Panel();
        contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints topC = new GridBagConstraints();
        topC.gridwidth = 0;
        topC.insets = new Insets(3, 5, 3, 5);
        topC.weightx = 1.0;
        topC.fill = 1;
        topC.weighty = 1.0;
        GridBagConstraints sepC = new GridBagConstraints();
        sepC.gridwidth = 0;
        sepC.fill = 2;
        sepC.weightx = 1.0;
        Panel topPanel = new Panel(new BorderLayout());
        if (this.topComponent != null) {
            topPanel.add(this.topComponent, "Center");
        }
        contentPanel.add((Component)topPanel, topC);
        contentPanel.add((Component)new Separator(1), sepC);
        Panel bottomPanel = new Panel(new BorderLayout());
        if (this.expanded && this.bottomComponent != null) {
            bottomPanel.add(this.bottomComponent, "Center");
        }
        contentPanel.add((Component)bottomPanel, topC);
        if (this.expanded && this.bottomComponent != null) {
            contentPanel.add((Component)new Separator(1), sepC);
        }
        Panel bottomButtonPanel = new Panel(new RelativeLayout(new double[]{0.5, 0.5}));
        Panel bp = new Panel(new FlowLayout(1));
        if (this.buttons != null) {
            int i = 0;
            while (i < this.buttons.length) {
                bp.add(this.buttons[i]);
                this.buttons[i].addActionListener(this);
                ++i;
            }
        }
        Panel expandPanel = new Panel(new FlowLayout(2));
        expandPanel.add(this.expandButton);
        bottomButtonPanel.add(bp);
        if (this.bottomComponent != null) {
            bottomButtonPanel.add(expandPanel);
        }
        contentPanel.add((Component)bottomButtonPanel, topC);
        this.add(contentPanel);
    }
}

