/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHeaderCheck
extends AbstractFileSetCheck {
    private String mFilename;
    private String mCharset = System.getProperty("file.encoding", "UTF-8");
    private final List<String> mHeaderLines = Lists.newArrayList();

    protected List<String> getHeaderLines() {
        return Collections.unmodifiableList(this.mHeaderLines);
    }

    public void setCharset(String aCharset) throws UnsupportedEncodingException {
        if (!Charset.isSupported(aCharset)) {
            String message = "unsupported charset: '" + aCharset + "'";
            throw new UnsupportedEncodingException(message);
        }
        this.mCharset = aCharset;
    }

    public void setHeaderFile(String aFileName) {
        if (aFileName == null || aFileName.trim().length() == 0) {
            return;
        }
        this.mFilename = aFileName;
    }

    private void loadHeaderFile() throws CheckstyleException {
        this.checkHeaderNotInitialized();
        InputStreamReader headerReader = null;
        try {
            headerReader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(this.mFilename)), this.mCharset);
            this.loadHeader(headerReader);
        }
        catch (IOException ex) {
            try {
                throw new CheckstyleException("unable to load header file " + this.mFilename, ex);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(headerReader);
                throw throwable;
            }
        }
        Utils.closeQuietly(headerReader);
    }

    private void checkHeaderNotInitialized() {
        if (!this.mHeaderLines.isEmpty()) {
            throw new ConversionException("header has already been set - set either header or headerFile, not both");
        }
    }

    public void setHeader(String aHeader) {
        if (aHeader == null || aHeader.trim().length() == 0) {
            return;
        }
        this.checkHeaderNotInitialized();
        String headerExpandedNewLines = aHeader.replaceAll("\\\\n", "\n");
        StringReader headerReader = new StringReader(headerExpandedNewLines);
        try {
            this.loadHeader(headerReader);
        }
        catch (IOException ex) {
            throw new ConversionException("unable to load header", (Throwable)ex);
        }
        finally {
            Utils.closeQuietly(headerReader);
        }
    }

    private void loadHeader(Reader aHeaderReader) throws IOException {
        String l;
        LineNumberReader lnr = new LineNumberReader(aHeaderReader);
        this.mHeaderLines.clear();
        while ((l = lnr.readLine()) != null) {
            this.mHeaderLines.add(l);
        }
        this.postprocessHeaderLines();
    }

    protected void postprocessHeaderLines() {
    }

    @Override
    protected final void finishLocalSetup() throws CheckstyleException {
        if (this.mFilename != null) {
            this.loadHeaderFile();
        }
        if (this.mHeaderLines.isEmpty()) {
            throw new CheckstyleException("property 'headerFile' is missing or invalid in module " + this.getConfiguration().getName());
        }
    }
}

