/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;

public class ExplicitInitializationCheck
extends Check {
    @Override
    public final int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    public final int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public void visitToken(DetailAST aAST) {
        int primitiveType;
        if (ScopeUtils.isLocalVariableDef(aAST) || ScopeUtils.inInterfaceOrAnnotationBlock(aAST)) {
            return;
        }
        DetailAST assign = aAST.findFirstToken(81);
        if (assign == null) {
            return;
        }
        DetailAST modifiers = aAST.findFirstToken(5);
        if (modifiers != null && modifiers.branchContains(40)) {
            return;
        }
        DetailAST type = aAST.findFirstToken(13);
        DetailAST ident = aAST.findFirstToken(59);
        DetailAST exprStart = assign.getFirstChild().getFirstChild();
        if (this.isObjectType(type) && exprStart.getType() == 137) {
            this.log(ident, "explicit.init", ident.getText(), "null");
        }
        if ((primitiveType = type.getFirstChild().getType()) == 51 && exprStart.getType() == 136) {
            this.log(ident, "explicit.init", ident.getText(), "false");
        }
        if (this.isNumericType(primitiveType) && this.isZero(exprStart)) {
            this.log(ident, "explicit.init", ident.getText(), "0");
        }
        if (primitiveType == 53 && (this.isZero(exprStart) || exprStart.getType() == 140 && "'\\0'".equals(exprStart.getText()))) {
            this.log(ident, "explicit.init", ident.getText(), "\\0");
        }
    }

    private boolean isObjectType(DetailAST aType) {
        int type = aType.getFirstChild().getType();
        return type == 59 || type == 60 || type == 17;
    }

    private boolean isNumericType(int aType) {
        return aType == 52 || aType == 54 || aType == 55 || aType == 56 || aType == 57 || aType == 58;
    }

    private boolean isZero(DetailAST aExpr) {
        int type = aExpr.getType();
        switch (type) {
            case 139: 
            case 142: 
            case 143: 
            case 144: {
                String text = aExpr.getText();
                return 0.0 == CheckUtils.parseFloat(text, type);
            }
        }
        return false;
    }
}

