/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.extended.CertGenerationRequest;
import org.apache.directory.api.ldap.extras.extended.CertGenerationRequestImpl;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationRequestDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationStatesEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertGenerationGrammar
extends AbstractGrammar<CertGenerationContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(CertGenerationGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<CertGenerationContainer> instance = new CertGenerationGrammar();

    public CertGenerationGrammar() {
        this.setName(CertGenerationGrammar.class.getName());
        this.transitions = new GrammarTransition[CertGenerationStatesEnum.LAST_CERT_GENERATION_STATE.ordinal()][256];
        this.transitions[CertGenerationStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)CertGenerationStatesEnum.START_STATE, (Enum)CertGenerationStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<CertGenerationContainer>("Init CertGenerationObject"){

            public void action(CertGenerationContainer container) {
                CertGenerationRequestDecorator certGenerationObject = new CertGenerationRequestDecorator(LdapApiServiceFactory.getSingleton(), (CertGenerationRequest)new CertGenerationRequestImpl());
                container.setCertGenerationObject(certGenerationObject);
            }
        });
        this.transitions[CertGenerationStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)CertGenerationStatesEnum.CERT_GENERATION_REQUEST_SEQUENCE_STATE, (Enum)CertGenerationStatesEnum.TARGETDN_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<CertGenerationContainer>("Set Cert Generation target Dn value"){

            public void action(CertGenerationContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String targetDN = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("Target Dn = " + targetDN);
                }
                if (targetDN != null && targetDN.trim().length() > 0) {
                    if (!Dn.isValid((String)targetDN)) {
                        String msg = I18n.err((I18n)I18n.ERR_04032, (Object[])new Object[]{targetDN});
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                } else {
                    String msg = I18n.err((I18n)I18n.ERR_04033, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.getCertGenerationObject().setTargetDN(targetDN);
            }
        });
        this.transitions[CertGenerationStatesEnum.TARGETDN_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)CertGenerationStatesEnum.TARGETDN_STATE, (Enum)CertGenerationStatesEnum.ISSUER_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<CertGenerationContainer>("Set Cert Generation issuer Dn value"){

            public void action(CertGenerationContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String issuerDN = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("Issuer Dn = " + issuerDN);
                }
                if (issuerDN != null && issuerDN.trim().length() > 0) {
                    if (!Dn.isValid((String)issuerDN)) {
                        String msg = I18n.err((I18n)I18n.ERR_04034, (Object[])new Object[]{issuerDN});
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                    container.getCertGenerationObject().setIssuerDN(issuerDN);
                }
            }
        });
        this.transitions[CertGenerationStatesEnum.ISSUER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)CertGenerationStatesEnum.ISSUER_STATE, (Enum)CertGenerationStatesEnum.SUBJECT_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<CertGenerationContainer>("Set Cert Generation subject Dn value"){

            public void action(CertGenerationContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String subjectDN = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("subject Dn = " + subjectDN);
                }
                if (subjectDN != null && subjectDN.trim().length() > 0) {
                    if (!Dn.isValid((String)subjectDN)) {
                        String msg = I18n.err((I18n)I18n.ERR_04035, (Object[])new Object[]{subjectDN});
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                } else {
                    String msg = I18n.err((I18n)I18n.ERR_04033, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.getCertGenerationObject().setSubjectDN(subjectDN);
            }
        });
        this.transitions[CertGenerationStatesEnum.SUBJECT_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)CertGenerationStatesEnum.SUBJECT_STATE, (Enum)CertGenerationStatesEnum.KEY_ALGORITHM_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<CertGenerationContainer>("Set Cert Generation key algorithm value"){

            public void action(CertGenerationContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                String keyAlgorithm = Strings.utf8ToString((byte[])value.getData());
                if (IS_DEBUG) {
                    LOG.debug("key algorithm = " + keyAlgorithm);
                }
                if (keyAlgorithm != null && keyAlgorithm.trim().length() > 0) {
                    container.getCertGenerationObject().setKeyAlgorithm(keyAlgorithm);
                }
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<CertGenerationContainer> getInstance() {
        return instance;
    }
}

