/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.text.ParseException;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecificationChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubtreeSpecificationSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SubtreeSpecificationSyntaxChecker.class);
    private SubtreeSpecificationChecker subtreeSpecificationChecker;

    public SubtreeSpecificationSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.45");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        try {
            SubtreeSpecificationChecker subtreeSpecificationChecker = this.subtreeSpecificationChecker;
            synchronized (subtreeSpecificationChecker) {
                this.subtreeSpecificationChecker.parse(strValue);
            }
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        catch (ParseException pe) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.subtreeSpecificationChecker = new SubtreeSpecificationChecker(schemaManager);
    }
}

