/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.exception;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

public class LdapServiceUnavailableException
extends LdapOperationException {
    static final long serialVersionUID = 1L;

    public LdapServiceUnavailableException(ResultCodeEnum resultCode, String message) {
        super(message);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    public LdapServiceUnavailableException(ResultCodeEnum resultCode) {
        super((String)null);
        this.checkResultCode(resultCode);
        this.resultCode = resultCode;
    }

    private void checkResultCode(ResultCodeEnum resultCode) {
        switch (resultCode) {
            case BUSY: 
            case UNAVAILABLE: {
                return;
            }
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04140_UNACCEPTABLE_RESUT_CODE, (Object[])new Object[]{resultCode}));
    }
}

