#
# Global variables:
#	g_debug:	debuggin on?
#	g_filename:	Filename to output.
#	g_entries:	# of entries in the table.
#	g_max_common_entries:	# of entries without a special table.
#	g_emitted_nc	boolean, have we emitted a non-comment line yet?
#	g_orig_is_enabled: boolean, is the original template line enabled?
#
#	line_emit:	boolean, emit the current line?
#	line_parsed:	boolean, has the current line been modified?
#	line_isenabled:	boolean, is it enabled?
#	line_line:	The actual line.
#
#	a_*:	Table of all line statuses.
#	  a_type:	What type is the entry.
#	  a_enable:	Is the entry enabled?
#	  a_wline:	Source config line for the entry.
#	  a_arg{1,2,3}:	arguments 1, 2 and 3
#
#	<foo> is one of dev, pdev, opts, fs.
#	t_<foo>_entries		# of entries in the <foo>_arg# tables.
#	t_<foo>_arg{1,2,3}	Argument tables.
#	t_<foo>_index		
#
#

function emit_init() {
    printf("# Config file autogenerated.\n") >g_filename
    line_emit = 1;
}

function emit_line(is_enabled, theline) {
    # Actually emit a line

    if (is_enabled == 0)
	printf("#%s\n", theline) >>g_filename;
    else
	printf("%s\n", theline) >>g_filename;
}

function emit_source_build_lines(j, found) {
    for (j = 0 ; j < g_entries ; j++) {
	if (a_type[j] == T_SOURCE) {
	    emit_line(a_enable[j], sprintf("source %s", a_arg1[j]));
	    a_used[j] = 1;
	    found = 1;
	}
	if (a_type[j] == T_BUILD) {
	    emit_line(a_enable[j], sprintf("build %s", a_arg1[j]));
	    a_used[j] = 1;
	    found = 1;
	}
    }
    if (found == 1)
	emit_line(1, "");
}

function output_line(theline, is_enabled, is_parsed) {

    # Figure
    if (is_parsed == 0) {
	# We didn't change this line.
	# Use the original from the template file.
	if (g_emitted_nc == 0) {
	    if (g_orig_is_enabled == 1) {
		g_emitted_nc = 1;
		emit_source_build_lines();
	    }
	}
        printf("%s\n", g_origline) >>g_filename;
    } else {
	# Spit out the modified line.
	if (is_enabled == 1) {
	    # If this is the first enabled line, emit source and build.
	    if (g_emitted_nc == 0) {
		g_emitted_nc = 1;
		emit_source_build_lines();
	    }
	    printf("%s\n", theline) >>g_filename;
	} else {
	    printf("#%s\n", theline) >>g_filename;
	}
    }
}

#
# File starts with # of entries.
# Each entry is 6 lines:
#	wline:		Line from the source file.  Uncommented.
#	type:		Type of line
#	enable:		Is it enabled?
#	arg1:		arguments.
#	arg2
#	arg3
function read_table(table_name, 
			temp_type, temp_j, j) {

	getline g_entries <table_name;

	t_dev_entries = 0;
	t_opts_entries = 0;
	t_pdev_entries = 0;
	t_fs_entries = 0;

	lowindex = 0;
	highindex = g_entries - 1;
	for (j = 0 ; j < g_entries ; j++) {
	    getline temp_type <table_name;

	    uselow = 0;

	    if (temp_type == T_DEV) {
		getline t_dev_arg1[t_dev_entries] <table_name;
		getline t_dev_arg2[t_dev_entries] <table_name;
		getline <table_name;
		t_dev_index[t_dev_entries] = highindex;
		t_dev_entries++;
	    } else if (temp_type == T_OPTIONS) {
		getline t_opts_arg1[t_opts_entries] <table_name;
		getline <table_name;
		getline <table_name;
		t_opts_index[t_opts_entries] = highindex;
		t_opts_entries++;
	    } else if (temp_type == T_PDEV) {
		getline t_pdev_arg1[t_pdev_entries] <table_name;
		getline t_pdev_arg2[t_pdev_entries] <table_name;
		getline <table_name;
		t_pdev_index[t_pdev_entries] = highindex;
		t_pdev_entries++;
	    } else if (temp_type == T_FS) {
		getline t_fs_arg1[t_fs_entries] <table_name;
		getline <table_name;
		getline <table_name;
		t_fs_index[t_fs_entries] = highindex;
		t_fs_entries++;
	    } else {
		uselow = 1;
		getline a_arg1[lowindex] <table_name;
		getline a_arg2[lowindex] <table_name;
		getline a_arg3[lowindex] <table_name;
	    }

	    if (uselow == 1) {
		temp_j = lowindex;
		lowindex++;
	    } else {
		temp_j = highindex;
		highindex--;
	    }

	    a_type[temp_j] = temp_type;
	    getline a_wline[temp_j] <table_name;
	    getline a_enable[temp_j] <table_name;

	}
	g_max_common_entries = lowindex;
	close(table_name);
}


BEGIN {
	T_SOURCE = "source";
	T_BUILD = "build";
	T_INCLUDE = "include";
	T_IDENT = "ident";
	T_MAXUSERS = "maxusers";
	T_OPTIONS = "options";
	T_MAKEOPT = "makeoptions";
	T_FS = "file-system";
	T_CONFIG = "config";
	T_PDEV = "pseudo-device";
	T_DEV = "device";


	g_entries = 0;
	a_type[0] = "";
	a_enable[0] = 0;
	a_wline[0] = "";
	a_arg1[0] = "";
	a_arg2[0] = "";
	a_arg3[0] = "";
	a_used[0] = 0;

	g_debug = 0;

	g_filename="CONFIG";
	g_emitted_nc = 0;

	# Array to keep track of new lines added.
	g_newlines = 0;
	g_newline[0] = "";

	# Read in the table generated by setconf.awk
	read_table("setconf.db");

	emit_init();
}

#
# Check for the line in the table.
#	theline should be the uncommented line.
#	thetype should be the type of line.
#	is_enabled: Enabled status in the template file.
#	arg1..3: args to check.
#
#	Sets line_line, line_emit, line_parsed, line_isenabled
#	uses g_entries
#
function lookup_in_table(theline, thetype, is_enabled, arg1, arg2, arg3,
								found, j) {

	if (thetype == T_SOURCE || thetype == T_BUILD) {
	    # Shouldn't be there.  Just ignore.
	    line_emit = 0;
	    return;
	}

	found = 0;

	# Assume we're going to emit the line.
	line_emit = 1;
	line_parsed = 1;
	if (thetype == T_DEV) {
	    for (j = 0; j < t_dev_entries ; j++) {
		# Make sure it matches.
		if (arg1 == t_dev_arg1[j] && arg2 == t_dev_arg2[j]) {
		    line_line = theline;
		    j = t_dev_index[j];
		    found = 1;
		    break;
		}
	    }
	} else if (thetype == T_OPTIONS) {
	    for (j = 0; j < t_opts_entries ; j++) {
		# Make sure it matches.
		if (arg1 == t_opts_arg1[j]) {
		    line_line = theline;
		    j = t_opts_index[j];
		    found = 1;
		    break;
		}
	    }
	} else if (thetype == T_PDEV) {
	    for (j = 0; j < t_pdev_entries ; j++) {
		if (arg1 == t_pdev_arg1[j]) {
		    if (arg2 ~ /^[[:digit:]]/) {
			if (arg2 != t_pdev_arg2[j])
			    printf("WARNING: Modifying pseudo-device %s %d to %d\n",
						arg1, arg2, t_pdev_arg2[j]);
			line_line = sprintf("pseudo-device\t%s\t%d",
							arg1, t_pdev_arg2[j]);
		    } else
			line_line = sprintf("pseudo-device\t%s", arg1);
		    j = t_pdev_index[j];
		    found = 1;
		    break;
		}
	    }
	} else if (thetype == T_FS) {
	    for (j = 0; j < t_fs_entries ; j++) {
		if (arg1 == t_fs_arg1[j]) {
		    line_line = theline;
		    j = t_fs_index[j];
		    found = 1;
		    break;
		}
	    }
# ---- Rest of these use common table.
	} else if (thetype == T_INCLUDE || thetype == T_MAKEOPT) {
	    for (j = 0; j < g_max_common_entries ; j++) {
		if (a_type[j] == thetype) {
		    # Make sure it matches.
		    if (arg1 == a_arg1[j]) {
			line_line = theline;
			found = 1;
			break;
		    }
		}
	    }
	} else if (thetype == T_CONFIG) {
	    for (j = 0; j < g_max_common_entries ; j++) {
		if (a_type[j] == T_CONFIG) {
		    # Make sure it matches.
		    if (arg1 == a_arg1[j] && arg2 == a_arg2[j] &&
							arg3 == a_arg3[j]) {
			line_line = theline;
			found = 1
			break;
		    }
		}
	    }
	} else if (thetype == T_IDENT) {
	    for (j = 0; j < g_max_common_entries ; j++) {
		if (a_type[j] == T_IDENT) {
		    if (arg1 != a_arg1[j])
			printf("WARNING: Modifying ident. old=%s\nnew=%s\n",
							arg1, a_arg1[j]);
		    line_line = sprintf("ident %s", a_arg1[j]);
		    found = 1;
		    break;
		}
	    }
	} else if (thetype == T_MAXUSERS) {
	    for (j = 0; j < g_max_common_entries ; j++) {
		if (a_type[j] == T_MAXUSERS) {
		    if (arg1 != a_arg1[j])
			printf("WARNING: Modifying maxusers. old=%d new=%d\n",
							arg1, a_arg1[j]);
		    line_line = sprintf("maxusers %d", a_arg1[j]);
		    found = 1;
		    break;
		}
	    }
	}
	
	if (found == 1) {
	    if (a_used[j] != 0)
		printf("WARNING: entry %d already used\n%s: %s\n",
		    j, a_type[j], a_wline[j]);
	    a_used[j] = 1;
	    line_isenabled = a_enable[j];
	    return;
	}
	# Not found.  pass through original.
	line_parsed = 0;

	# But remember it as something new.
	g_newline[g_newlines] = g_origline;
	g_newlines++;

}

function process_line(theline, thetype, index1, index2, index3, split_regexp,
			t1, t2, t3, is_enabled, pline, part_array, nparts, j) {
	if (g_debug >= 1) {
	    print "Processing ", thetype, " line.";
	}

	# XXX blah.  Assume this line is the original template line
	# XXX and use the enable status.
	is_enabled = g_orig_is_enabled;

	# Also assume leading spaces and #s have been stripped.
	pline = theline;

	# Split the line into parts.
	if (split_regexp != "") {
	    # Allow a splitting pattern to be passed in.
	    # This is to aproximate quotation of arguments. XXX
	    nparts = split(pline, part_array, split_regexp);
	    for (j = 1 ; j <= nparts ; j++) {
		gsub(/^[[:space:]]+/, "", part_array[j]);
		gsub(/[[:space:]]+$/, "", part_array[j]);
	    }
	} else {
	    nparts = split(pline, part_array);
	}

	# Figure out which part(s) of the line to use.
	if (index1 > 0) {
	    t1 = part_array[index1];
	} else {
	    t1 = "";
	}
	if (index2 > 0) {
	    t2 = part_array[index2];
	} else {
	    t2 = "";
	}
	if (index3 > 0) {
	    t3 = part_array[index3];
	} else {
	    t3 = "";
	}

	# Check it against the table.
	if (g_debug >= 2)
	    printf("T> %s\nTemplate: type:%s  On:%d  Arg1:%s  Arg2:%s  Arg3:%s\n", 
			theline, thetype, is_enabled, t1, t2, t3);

	lookup_in_table(theline, thetype, is_enabled, t1, t2, t3);

}

# Need to figure out if the template line is enabled.
{
	g_origline = $0;

	# See if this line is on.
	if (/^[[:space:]]*#/)
	    g_orig_is_enabled = 0;
	else
	    g_orig_is_enabled = 1;

	# Strip leading spaces and #s
	gsub(/^[[:space:]]*(#+[[:space:]]*)+/, "");
}

# ---- snip ----
# XXX XXX This should go in a common file.
#

#    "foo"        "  "      "at"  "  "  "bar"
/^[^[:space:]]+[[:space:]]+at[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_DEV, 1, 3, -1);
}

#"pseudo-device"   "  "     "foo"
/^pseudo-device[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_PDEV, 2, 3, -1);
}

# XXX: This needs some work to handle options set to a value.
# XXX: This needs some work to handle multiple options to a line.
#"options"   "   "     "FOO"
/^options[[:space:]]+[^[:space:]]+/ { 
	process_line($0, T_OPTIONS, 2, -1, -1);
}

#"file-system"   "  "     "FOO"
/^file-system[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_FS, 2, -1, -1);
}

#"makeoptions"   "  "     "FOO"
/^makeoptions[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_MAKEOPT, 2, -1, -1);
}

#"config"  "  "     "netbsd"      "   "     "root" "  "     "on"   "  " 
# "sd0a"        "  "    "type"  "   " "ffs"
/^config[[:space:]]+[^[:space:]]+[[:space:]]+root[[:space:]]+on[[:space:]]+\
[^[:space:]]+[[:space:]]+type[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_CONFIG, 2, 5, 7);
}

#"source"  "  "      "/foo/bar"
/^source[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_SOURCE, 2, -1, -1);
}

#"build"   "  "      "/foo/bar"
/^build[[:space:]]+[^[:space:]]+/ {
	process_line($0, T_BUILD, 2, -1, -1);
}

#"maxusers"   "  "      "123"
/^maxusers[[:space:]]+[[:digit:]]+/ {
	process_line($0, T_MAXUSERS, 2, -1, -1);
}

#"ident"   "  "   \"foo\"
/^ident[[:space:]]+"[^"]*"/ {
	# XXX not quite right action wrt quoted info.
	process_line($0, T_IDENT, 2, -1, -1, "\[\"\]\+");
}

# ---- snip ----


# After matching the line and potentially rewriting it, output it.
# any rewriting should have set line_line.
{
    if (line_emit == 1)
	output_line(line_line, line_isenabled, line_parsed);
    line_emit = 1;
    line_parsed = 0;
    line_isenabled = 0;
    line_line = "DEADBEEF";
}

END {
    if (g_newlines > 0) {
	print "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-"
	print "New lines in the config:"
	for (j = 0 ; j < g_newlines ; j++) {
	    print g_newline[j];
	}
    }
    found_old = 0;
    for (j = 0 ; j < g_entries ; j++) {
	if (a_used[j] == 0) {
	    if (found_old == 0) {
		print "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-"
		print "Unused lines from old config:"
		found_old = 1;
	    }
	    print a_wline[j]
	}
    }
}
	
