/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.namespace;

import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class ObjectNameRouter {
    private static final int NAMESPACE_SEPARATOR_LENGTH = "//".length();
    final String targetPrefix;
    final String sourcePrefix;
    final int slen;
    final int tlen;
    final boolean identity;

    public ObjectNameRouter(String string, String string2) {
        this.targetPrefix = string == null ? "" : string;
        this.sourcePrefix = string2 == null ? "" : string2;
        this.tlen = this.targetPrefix.length();
        this.slen = this.sourcePrefix.length();
        this.identity = this.targetPrefix.equals(this.sourcePrefix);
    }

    public final ObjectName toTargetContext(ObjectName objectName, boolean bl) {
        if (objectName == null) {
            return null;
        }
        if (this.identity) {
            return objectName;
        }
        String string = objectName.getDomain();
        if (string.startsWith("//")) {
            if (!bl) {
                return objectName;
            }
            string = ObjectNameRouter.normalizeDomain(string, true);
        }
        if (this.slen != 0) {
            if (!string.startsWith(this.sourcePrefix) || !string.startsWith("//", this.slen)) {
                throw new IllegalArgumentException("ObjectName does not start with expected prefix " + this.sourcePrefix + ": " + String.valueOf(objectName));
            }
            string = string.substring(this.slen + NAMESPACE_SEPARATOR_LENGTH);
        }
        String string2 = this.tlen > 0 ? this.targetPrefix + "//" + string : string;
        return objectName.withDomain(string2);
    }

    public final ObjectName toSourceContext(ObjectName objectName, boolean bl) {
        if (objectName == null) {
            return null;
        }
        if (this.identity) {
            return objectName;
        }
        String string = objectName.getDomain();
        if (string.startsWith("//")) {
            if (!bl) {
                return objectName;
            }
            string = ObjectNameRouter.normalizeDomain(string, true);
        }
        if (this.tlen != 0) {
            if (!string.startsWith(this.targetPrefix) || !string.startsWith("//", this.tlen)) {
                throw new IllegalArgumentException("ObjectName does not start with expected prefix " + this.targetPrefix + ": " + String.valueOf(objectName));
            }
            string = string.substring(this.tlen + NAMESPACE_SEPARATOR_LENGTH);
        }
        String string2 = this.slen > 0 ? this.sourcePrefix + "//" + string : string;
        return objectName.withDomain(string2);
    }

    public final ObjectInstance toTargetContext(ObjectInstance objectInstance, boolean bl) {
        if (objectInstance == null) {
            return null;
        }
        if (this.identity) {
            return objectInstance;
        }
        return new ObjectInstance(this.toTargetContext(objectInstance.getObjectName(), bl), objectInstance.getClassName());
    }

    public static String normalizeDomain(String string, boolean bl) {
        return ObjectNameRouter.normalizeNamespacePath(string, bl, false, true);
    }

    public static String normalizeNamespacePath(String string, boolean bl, boolean bl2, boolean bl3) {
        if (string.equals("")) {
            return "";
        }
        String[] stringArray = string.split("//");
        StringBuilder stringBuilder = new StringBuilder(string.length() + NAMESPACE_SEPARATOR_LENGTH);
        String string2 = null;
        if (!bl && string.startsWith("//")) {
            stringBuilder.append("//");
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3.equals("")) continue;
            if (string3.startsWith("/") || string3.endsWith("/")) {
                if (!bl3 || i != stringArray.length - 1) {
                    throw new IllegalArgumentException(string3 + " is not a valid name space identifier");
                }
                boolean bl4 = bl2 = bl2 || string3.equals("/");
            }
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(string3);
            string2 = "//";
            ++n;
        }
        if (!bl2 && string.endsWith("//") && n > 0) {
            stringBuilder.append("//");
        }
        return stringBuilder.toString();
    }
}

