/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESConstants;
import com.sun.crypto.provider.DESCrypt;
import java.security.InvalidKeyException;

final class DESedeCrypt
extends DESCrypt
implements DESConstants {
    private byte[] key1 = null;
    private byte[] key2 = null;
    private byte[] key3 = null;
    private byte[] buf1 = new byte[8];
    private byte[] buf2 = new byte[8];

    DESedeCrypt() {
    }

    void init(boolean bl, String string, byte[] byArray) throws InvalidKeyException {
        if (!string.equalsIgnoreCase("DESede") && !string.equalsIgnoreCase("TripleDES")) {
            throw new InvalidKeyException("Wrong algorithm: DESede or TripleDES required");
        }
        if (byArray.length != 24) {
            throw new InvalidKeyException("Wrong key size");
        }
        byte[] byArray2 = new byte[8];
        this.key1 = new byte[128];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        this.expandKey(byArray2);
        System.arraycopy(this.expandedKey, 0, this.key1, 0, 128);
        if (this.keyEquals(byArray2, 0, byArray, 16, 8)) {
            this.key3 = this.key1;
        } else {
            this.key3 = new byte[128];
            System.arraycopy(byArray, 16, byArray2, 0, 8);
            this.expandKey(byArray2);
            System.arraycopy(this.expandedKey, 0, this.key3, 0, 128);
        }
        this.key2 = new byte[128];
        System.arraycopy(byArray, 8, byArray2, 0, 8);
        this.expandKey(byArray2);
        System.arraycopy(this.expandedKey, 0, this.key2, 0, 128);
    }

    void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.expandedKey = this.key1;
        this.decrypting = false;
        this.cipherBlock(byArray, n, this.buf1, 0);
        this.expandedKey = this.key2;
        this.decrypting = true;
        this.cipherBlock(this.buf1, 0, this.buf2, 0);
        this.expandedKey = this.key3;
        this.decrypting = false;
        this.cipherBlock(this.buf2, 0, byArray2, n2);
    }

    void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.expandedKey = this.key3;
        this.decrypting = true;
        this.cipherBlock(byArray, n, this.buf1, 0);
        this.expandedKey = this.key2;
        this.decrypting = false;
        this.cipherBlock(this.buf1, 0, this.buf2, 0);
        this.expandedKey = this.key1;
        this.decrypting = true;
        this.cipherBlock(this.buf2, 0, byArray2, n2);
    }

    private boolean keyEquals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (byArray[i + n] == byArray2[i + n2]) continue;
            return false;
        }
        return true;
    }
}

