/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XmbTextItem
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 24;
    }

    public int getDataSize() {
        return XmbTextItem.getSize();
    }

    public long getPData() {
        return this.pData;
    }

    XmbTextItem(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    XmbTextItem() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XmbTextItem.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public byte get_chars(int n) {
        log.finest("");
        return Native.getByte(Native.getLong(this.pData + 0L) + (long)(n * 1));
    }

    public long get_chars() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_chars(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public int get_nchars() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_nchars(int n) {
        log.finest("");
        Native.putInt(this.pData + 8L, n);
    }

    public int get_delta() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_delta(int n) {
        log.finest("");
        Native.putInt(this.pData + 12L, n);
    }

    public long get_font_set(int n) {
        log.finest("");
        return Native.getLong(this.pData + 16L) + (long)(n * Native.getLongSize());
    }

    public long get_font_set() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_font_set(long l) {
        log.finest("");
        Native.putLong(this.pData + 16L, l);
    }

    String getName() {
        return "XmbTextItem";
    }

    String getFieldsAsString() {
        String string = "";
        string = string + "chars = " + this.get_chars() + ", ";
        string = string + "nchars = " + this.get_nchars() + ", ";
        string = string + "delta = " + this.get_delta() + ", ";
        string = string + "font_set = " + this.get_font_set() + ", ";
        return string;
    }
}

