/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.ClassReader;
import com.sun.tools.classfile.ConstantPoolException;
import java.io.IOException;

public class ConstantPool {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    private CPInfo[] pool;

    ConstantPool(ClassReader classReader) throws IOException, InvalidEntry {
        int n = classReader.readUnsignedShort();
        this.pool = new CPInfo[n];
        block13: for (int i = 1; i < n; ++i) {
            int n2 = classReader.readUnsignedByte();
            switch (n2) {
                case 7: {
                    this.pool[i] = new CONSTANT_Class_info(this, classReader);
                    continue block13;
                }
                case 6: {
                    this.pool[i] = new CONSTANT_Double_info(classReader);
                    ++i;
                    continue block13;
                }
                case 9: {
                    this.pool[i] = new CONSTANT_Fieldref_info(this, classReader);
                    continue block13;
                }
                case 4: {
                    this.pool[i] = new CONSTANT_Float_info(classReader);
                    continue block13;
                }
                case 3: {
                    this.pool[i] = new CONSTANT_Integer_info(classReader);
                    continue block13;
                }
                case 11: {
                    this.pool[i] = new CONSTANT_InterfaceMethodref_info(this, classReader);
                    continue block13;
                }
                case 5: {
                    this.pool[i] = new CONSTANT_Long_info(classReader);
                    ++i;
                    continue block13;
                }
                case 10: {
                    this.pool[i] = new CONSTANT_Methodref_info(this, classReader);
                    continue block13;
                }
                case 12: {
                    this.pool[i] = new CONSTANT_NameAndType_info(this, classReader);
                    continue block13;
                }
                case 8: {
                    this.pool[i] = new CONSTANT_String_info(this, classReader);
                    continue block13;
                }
                case 1: {
                    this.pool[i] = new CONSTANT_Utf8_info(classReader);
                    continue block13;
                }
                default: {
                    throw new InvalidEntry(i, n2);
                }
            }
        }
    }

    public ConstantPool(CPInfo[] cPInfoArray) {
        this.pool = cPInfoArray;
    }

    public int size() {
        return this.pool.length;
    }

    public CPInfo get(int n) throws InvalidIndex {
        if (n <= 0 || n >= this.pool.length) {
            throw new InvalidIndex(n);
        }
        CPInfo cPInfo = this.pool[n];
        if (cPInfo == null) {
            throw new InvalidIndex(n);
        }
        return this.pool[n];
    }

    private CPInfo get(int n, int n2) throws InvalidIndex, UnexpectedEntry {
        CPInfo cPInfo = this.get(n);
        if (cPInfo.getTag() != n2) {
            throw new UnexpectedEntry(n, n2, cPInfo.getTag());
        }
        return cPInfo;
    }

    public CONSTANT_Utf8_info getUTF8Info(int n) throws InvalidIndex, UnexpectedEntry {
        return (CONSTANT_Utf8_info)this.get(n, 1);
    }

    public CONSTANT_Class_info getClassInfo(int n) throws InvalidIndex, UnexpectedEntry {
        return (CONSTANT_Class_info)this.get(n, 7);
    }

    public CONSTANT_NameAndType_info getNameAndTypeInfo(int n) throws InvalidIndex, UnexpectedEntry {
        return (CONSTANT_NameAndType_info)this.get(n, 12);
    }

    public String getUTF8Value(int n) throws InvalidIndex, UnexpectedEntry {
        return this.getUTF8Info((int)n).value;
    }

    public int getUTF8Index(String string) throws EntryNotFound {
        for (int i = 1; i < this.pool.length; ++i) {
            CPInfo cPInfo = this.pool[i];
            if (!(cPInfo instanceof CONSTANT_Utf8_info) || !((CONSTANT_Utf8_info)cPInfo).value.equals(string)) continue;
            return i;
        }
        throw new EntryNotFound(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONSTANT_Utf8_info
    extends CPInfo {
        public final String value;

        CONSTANT_Utf8_info(ClassReader classReader) throws IOException {
            this.value = classReader.readUTF();
        }

        public CONSTANT_Utf8_info(String string) {
            this.value = string;
        }

        @Override
        public int getTag() {
            return 1;
        }

        public String toString() {
            return "CONSTANT_Utf8_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitUtf8(this, d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONSTANT_String_info
    extends CPInfo {
        public final int string_index;

        CONSTANT_String_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool);
            this.string_index = classReader.readUnsignedShort();
        }

        public CONSTANT_String_info(ConstantPool constantPool, int n) {
            super(constantPool);
            this.string_index = n;
        }

        @Override
        public int getTag() {
            return 8;
        }

        public String getString() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.string_index);
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitString(this, d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONSTANT_NameAndType_info
    extends CPInfo {
        public final int name_index;
        public final int type_index;

        CONSTANT_NameAndType_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool);
            this.name_index = classReader.readUnsignedShort();
            this.type_index = classReader.readUnsignedShort();
        }

        public CONSTANT_NameAndType_info(ConstantPool constantPool, int n, int n2) {
            super(constantPool);
            this.name_index = n;
            this.type_index = n2;
        }

        @Override
        public int getTag() {
            return 12;
        }

        public String getName() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.name_index);
        }

        public String getType() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.type_index);
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitNameAndType(this, d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONSTANT_Methodref_info
    extends CPRefInfo {
        CONSTANT_Methodref_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool, classReader, 10);
        }

        public CONSTANT_Methodref_info(ConstantPool constantPool, int n, int n2) {
            super(constantPool, 10, n, n2);
        }

        public String toString() {
            return "CONSTANT_Methodref_info[class_index: " + this.class_index + ", name_and_type_index: " + this.name_and_type_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitMethodref(this, d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONSTANT_Long_info
    extends CPInfo {
        public final long value;

        CONSTANT_Long_info(ClassReader classReader) throws IOException {
            this.value = classReader.readLong();
        }

        public CONSTANT_Long_info(long l) {
            this.value = l;
        }

        @Override
        public int getTag() {
            return 5;
        }

        public String toString() {
            return "CONSTANT_Long_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitLong(this, d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONSTANT_InterfaceMethodref_info
    extends CPRefInfo {
        CONSTANT_InterfaceMethodref_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool, classReader, 11);
        }

        public CONSTANT_InterfaceMethodref_info(ConstantPool constantPool, int n, int n2) {
            super(constantPool, 11, n, n2);
        }

        public String toString() {
            return "CONSTANT_InterfaceMethodref_info[class_index: " + this.class_index + ", name_and_type_index: " + this.name_and_type_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitInterfaceMethodref(this, d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONSTANT_Integer_info
    extends CPInfo {
        public final int value;

        CONSTANT_Integer_info(ClassReader classReader) throws IOException {
            this.value = classReader.readInt();
        }

        public CONSTANT_Integer_info(int n) {
            this.value = n;
        }

        @Override
        public int getTag() {
            return 3;
        }

        public String toString() {
            return "CONSTANT_Integer_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitInteger(this, d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONSTANT_Float_info
    extends CPInfo {
        public final float value;

        CONSTANT_Float_info(ClassReader classReader) throws IOException {
            this.value = classReader.readFloat();
        }

        public CONSTANT_Float_info(float f) {
            this.value = f;
        }

        @Override
        public int getTag() {
            return 4;
        }

        public String toString() {
            return "CONSTANT_Float_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitFloat(this, d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONSTANT_Fieldref_info
    extends CPRefInfo {
        CONSTANT_Fieldref_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool, classReader, 9);
        }

        public CONSTANT_Fieldref_info(ConstantPool constantPool, int n, int n2) {
            super(constantPool, 9, n, n2);
        }

        public String toString() {
            return "CONSTANT_Fieldref_info[class_index: " + this.class_index + ", name_and_type_index: " + this.name_and_type_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitFieldref(this, d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONSTANT_Double_info
    extends CPInfo {
        public final double value;

        CONSTANT_Double_info(ClassReader classReader) throws IOException {
            this.value = classReader.readDouble();
        }

        public CONSTANT_Double_info(double d) {
            this.value = d;
        }

        @Override
        public int getTag() {
            return 6;
        }

        public String toString() {
            return "CONSTANT_Double_info[value: " + this.value + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitDouble(this, d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONSTANT_Class_info
    extends CPInfo {
        public final int name_index;

        CONSTANT_Class_info(ConstantPool constantPool, ClassReader classReader) throws IOException {
            super(constantPool);
            this.name_index = classReader.readUnsignedShort();
        }

        public CONSTANT_Class_info(ConstantPool constantPool, int n) {
            super(constantPool);
            this.name_index = n;
        }

        @Override
        public int getTag() {
            return 7;
        }

        public String getName() throws ConstantPoolException {
            return this.cp.getUTF8Value(this.name_index);
        }

        public String toString() {
            return "CONSTANT_Class_info[name_index: " + this.name_index + "]";
        }

        @Override
        public <R, D> R accept(Visitor<R, D> visitor, D d) {
            return visitor.visitClass(this, d);
        }
    }

    public static abstract class CPRefInfo
    extends CPInfo {
        public final int tag;
        public final int class_index;
        public final int name_and_type_index;

        protected CPRefInfo(ConstantPool constantPool, ClassReader classReader, int n) throws IOException {
            super(constantPool);
            this.tag = n;
            this.class_index = classReader.readUnsignedShort();
            this.name_and_type_index = classReader.readUnsignedShort();
        }

        protected CPRefInfo(ConstantPool constantPool, int n, int n2, int n3) {
            super(constantPool);
            this.tag = n;
            this.class_index = n2;
            this.name_and_type_index = n3;
        }

        public int getTag() {
            return this.tag;
        }

        public CONSTANT_Class_info getClassInfo() throws ConstantPoolException {
            return this.cp.getClassInfo(this.class_index);
        }

        public String getClassName() throws ConstantPoolException {
            return this.cp.getClassInfo(this.class_index).getName();
        }

        public CONSTANT_NameAndType_info getNameAndTypeInfo() throws ConstantPoolException {
            return this.cp.getNameAndTypeInfo(this.name_and_type_index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CPInfo {
        protected final ConstantPool cp;

        CPInfo() {
            this.cp = null;
        }

        CPInfo(ConstantPool constantPool) {
            this.cp = constantPool;
        }

        public abstract int getTag();

        public abstract <R, D> R accept(Visitor<R, D> var1, D var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Visitor<R, P> {
        public R visitClass(CONSTANT_Class_info var1, P var2);

        public R visitDouble(CONSTANT_Double_info var1, P var2);

        public R visitFieldref(CONSTANT_Fieldref_info var1, P var2);

        public R visitFloat(CONSTANT_Float_info var1, P var2);

        public R visitInteger(CONSTANT_Integer_info var1, P var2);

        public R visitInterfaceMethodref(CONSTANT_InterfaceMethodref_info var1, P var2);

        public R visitLong(CONSTANT_Long_info var1, P var2);

        public R visitNameAndType(CONSTANT_NameAndType_info var1, P var2);

        public R visitMethodref(CONSTANT_Methodref_info var1, P var2);

        public R visitString(CONSTANT_String_info var1, P var2);

        public R visitUtf8(CONSTANT_Utf8_info var1, P var2);
    }

    public class EntryNotFound
    extends ConstantPoolException {
        public final Object value;

        EntryNotFound(Object object) {
            super(-1);
            this.value = object;
        }

        public String getMessage() {
            return "value not found: " + this.value;
        }
    }

    public class InvalidEntry
    extends ConstantPoolException {
        public final int tag;

        InvalidEntry(int n, int n2) {
            super(n);
            this.tag = n2;
        }

        public String getMessage() {
            return "unexpected tag at #" + this.index + ": " + this.tag;
        }
    }

    public class UnexpectedEntry
    extends ConstantPoolException {
        public final int expected_tag;
        public final int found_tag;

        UnexpectedEntry(int n, int n2, int n3) {
            super(n);
            this.expected_tag = n2;
            this.found_tag = n3;
        }

        public String getMessage() {
            return "unexpected entry at #" + this.index + " -- expected tag " + this.expected_tag + ", found " + this.found_tag;
        }
    }

    public class InvalidIndex
    extends ConstantPoolException {
        InvalidIndex(int n) {
            super(n);
        }

        public String getMessage() {
            return "invalid index #" + this.index;
        }
    }
}

