/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.FrameIndexOutOfBoundsException;
import com.sun.tools.example.debug.bdi.SessionListener;
import com.sun.tools.example.debug.bdi.ThreadInfo;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;
import com.sun.tools.example.debug.event.ExceptionEventSet;
import com.sun.tools.example.debug.event.JDIAdapter;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.LocationTriggerEventSet;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.ContextListener;
import com.sun.tools.example.debug.gui.CurrentFrameChangedEvent;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import java.io.File;
import java.util.EventObject;
import java.util.Vector;

public class ContextManager {
    private ClassManager classManager;
    private ExecutionManager runtime;
    private String mainClassName;
    private String vmArguments;
    private String commandArguments;
    private String remotePort;
    private ThreadReference currentThread;
    private boolean verbose;
    private Vector<ContextListener> contextListeners = new Vector();

    public ContextManager(Environment environment) {
        this.classManager = environment.getClassManager();
        this.runtime = environment.getExecutionManager();
        this.mainClassName = "";
        this.vmArguments = "";
        this.commandArguments = "";
        this.currentThread = null;
        ContextManagerListener contextManagerListener = new ContextManagerListener();
        this.runtime.addJDIListener(contextManagerListener);
        this.runtime.addSessionListener(contextManagerListener);
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setMainClassName(String string) {
        this.mainClassName = string;
    }

    public String getVmArguments() {
        return this.processClasspathDefaults(this.vmArguments);
    }

    public void setVmArguments(String string) {
        this.vmArguments = string;
    }

    public String getProgramArguments() {
        return this.commandArguments;
    }

    public void setProgramArguments(String string) {
        this.commandArguments = string;
    }

    public String getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(String string) {
        this.remotePort = string;
    }

    public boolean getVerboseFlag() {
        return this.verbose;
    }

    public void setVerboseFlag(boolean bl) {
        this.verbose = bl;
    }

    public ThreadReference getCurrentThread() {
        return this.currentThread;
    }

    public void setCurrentThread(ThreadReference threadReference) {
        if (threadReference != this.currentThread) {
            this.currentThread = threadReference;
            this.notifyCurrentThreadChanged(threadReference);
        }
    }

    public void setCurrentThreadInvalidate(ThreadReference threadReference) {
        this.currentThread = threadReference;
        this.notifyCurrentFrameChanged(this.runtime.threadInfo(threadReference), 0, true);
    }

    public void invalidateCurrentThread() {
        this.notifyCurrentFrameChanged(null, 0, true);
    }

    public int getCurrentFrameIndex(ThreadReference threadReference) {
        return this.getCurrentFrameIndex(this.runtime.threadInfo(threadReference));
    }

    public int getCurrentFrameIndex(ThreadInfo threadInfo) {
        if (threadInfo == null) {
            return 0;
        }
        Integer n = (Integer)threadInfo.getUserObject();
        if (n == null) {
            return 0;
        }
        return n;
    }

    public int moveCurrentFrameIndex(ThreadReference threadReference, int n) throws VMNotInterruptedException {
        return this.setCurrentFrameIndex(threadReference, n, true);
    }

    public int setCurrentFrameIndex(ThreadReference threadReference, int n) throws VMNotInterruptedException {
        return this.setCurrentFrameIndex(threadReference, n, false);
    }

    public int setCurrentFrameIndex(int n) throws VMNotInterruptedException {
        if (this.currentThread == null) {
            return 0;
        }
        return this.setCurrentFrameIndex(this.currentThread, n, false);
    }

    private int setCurrentFrameIndex(ThreadReference threadReference, int n, boolean bl) throws VMNotInterruptedException {
        int n2;
        boolean bl2 = threadReference.equals(this.currentThread);
        ThreadInfo threadInfo = this.runtime.threadInfo(threadReference);
        if (threadInfo == null) {
            return 0;
        }
        int n3 = threadInfo.getFrameCount() - 1;
        int n4 = this.getCurrentFrameIndex(threadInfo);
        int n5 = n2 = bl ? n4 + n : n;
        if (n2 > n3) {
            n2 = n3;
        } else if (n2 < 0) {
            n2 = 0;
        }
        if (!bl2 || n2 != n4) {
            this.setCurrentFrameIndex(threadInfo, n2);
        }
        return n2 - n4;
    }

    private void setCurrentFrameIndex(ThreadInfo threadInfo, int n) {
        threadInfo.setUserObject(new Integer(n));
        this.notifyCurrentFrameChanged(threadInfo.thread(), n);
    }

    public StackFrame getCurrentFrame() throws VMNotInterruptedException {
        return this.getCurrentFrame(this.runtime.threadInfo(this.currentThread));
    }

    public StackFrame getCurrentFrame(ThreadReference threadReference) throws VMNotInterruptedException {
        return this.getCurrentFrame(this.runtime.threadInfo(threadReference));
    }

    public StackFrame getCurrentFrame(ThreadInfo threadInfo) throws VMNotInterruptedException {
        int n = this.getCurrentFrameIndex(threadInfo);
        try {
            return threadInfo.getFrame(n);
        }
        catch (FrameIndexOutOfBoundsException frameIndexOutOfBoundsException) {
            return null;
        }
    }

    public void addContextListener(ContextListener contextListener) {
        this.contextListeners.add(contextListener);
    }

    public void removeContextListener(ContextListener contextListener) {
        this.contextListeners.remove(contextListener);
    }

    private void notifyCurrentThreadChanged(ThreadReference threadReference) {
        ThreadInfo threadInfo = null;
        int n = 0;
        if (threadReference != null) {
            threadInfo = this.runtime.threadInfo(threadReference);
            n = this.getCurrentFrameIndex(threadInfo);
        }
        this.notifyCurrentFrameChanged(threadInfo, n, false);
    }

    private void notifyCurrentFrameChanged(ThreadReference threadReference, int n) {
        this.notifyCurrentFrameChanged(this.runtime.threadInfo(threadReference), n, false);
    }

    private void notifyCurrentFrameChanged(ThreadInfo threadInfo, int n, boolean bl) {
        Vector vector = (Vector)this.contextListeners.clone();
        CurrentFrameChangedEvent currentFrameChangedEvent = new CurrentFrameChangedEvent(this, threadInfo, n, bl);
        for (int i = 0; i < vector.size(); ++i) {
            ((ContextListener)vector.elementAt(i)).currentFrameChanged(currentFrameChangedEvent);
        }
    }

    private String processClasspathDefaults(String string) {
        if (string.indexOf("-classpath ") == -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            SearchPath searchPath = this.classManager.getClassPath();
            if (searchPath.isEmpty()) {
                String string2 = System.getProperty("env.class.path");
                if (string2 != null && string2.length() > 0) {
                    stringBuffer.append(" -classpath " + string2);
                }
            } else {
                stringBuffer.append(" -classpath " + searchPath.asString());
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private String appendPath(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2 == null ? "." : string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string + File.pathSeparator + string2;
    }

    private class ContextManagerListener
    extends JDIAdapter
    implements SessionListener,
    JDIListener {
        private ContextManagerListener() {
        }

        public void sessionStart(EventObject eventObject) {
            ContextManager.this.invalidateCurrentThread();
        }

        public void sessionInterrupt(EventObject eventObject) {
            ContextManager.this.setCurrentThreadInvalidate(ContextManager.this.currentThread);
        }

        public void sessionContinue(EventObject eventObject) {
            ContextManager.this.invalidateCurrentThread();
        }

        public void locationTrigger(LocationTriggerEventSet locationTriggerEventSet) {
            ContextManager.this.setCurrentThreadInvalidate(locationTriggerEventSet.getThread());
        }

        public void exception(ExceptionEventSet exceptionEventSet) {
            ContextManager.this.setCurrentThreadInvalidate(exceptionEventSet.getThread());
        }

        public void vmDisconnect(VMDisconnectEventSet vMDisconnectEventSet) {
            ContextManager.this.invalidateCurrentThread();
        }
    }
}

