/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ArrayPersistenceDelegate;
import java.beans.ConstructorProperties;
import java.beans.DefaultPersistenceDelegate;
import java.beans.EnumPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.NullPersistenceDelegate;
import java.beans.PersistenceDelegate;
import java.beans.PrimitivePersistenceDelegate;
import java.beans.ProxyPersistenceDelegate;
import java.beans.ReflectionUtils;
import java.beans.java_awt_AWTKeyStroke_PersistenceDelegate;
import java.beans.java_awt_Font_PersistenceDelegate;
import java.beans.java_util_Date_PersistenceDelegate;
import java.beans.java_util_EnumSet_PersistenceDelegate;
import java.beans.javax_swing_border_MatteBorder_PersistenceDelegate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetaData {
    private static Hashtable internalPersistenceDelegates = new Hashtable();
    private static PersistenceDelegate nullPersistenceDelegate = new NullPersistenceDelegate();
    private static PersistenceDelegate enumPersistenceDelegate = new EnumPersistenceDelegate();
    private static PersistenceDelegate primitivePersistenceDelegate = new PrimitivePersistenceDelegate();
    private static PersistenceDelegate defaultPersistenceDelegate = new DefaultPersistenceDelegate();
    private static PersistenceDelegate arrayPersistenceDelegate;
    private static PersistenceDelegate proxyPersistenceDelegate;

    MetaData() {
    }

    static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static synchronized PersistenceDelegate getPersistenceDelegate(Class clazz) {
        if (clazz == null) {
            return nullPersistenceDelegate;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return enumPersistenceDelegate;
        }
        if (ReflectionUtils.isPrimitive(clazz)) {
            return primitivePersistenceDelegate;
        }
        if (clazz.isArray()) {
            if (arrayPersistenceDelegate == null) {
                arrayPersistenceDelegate = new ArrayPersistenceDelegate();
            }
            return arrayPersistenceDelegate;
        }
        try {
            if (Proxy.isProxyClass(clazz)) {
                if (proxyPersistenceDelegate == null) {
                    proxyPersistenceDelegate = new ProxyPersistenceDelegate();
                }
                return proxyPersistenceDelegate;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = clazz.getName();
        PersistenceDelegate persistenceDelegate = (PersistenceDelegate)MetaData.getBeanAttribute(clazz, "persistenceDelegate");
        if (persistenceDelegate == null) {
            persistenceDelegate = (PersistenceDelegate)internalPersistenceDelegates.get(string);
            if (persistenceDelegate != null) {
                return persistenceDelegate;
            }
            internalPersistenceDelegates.put(string, defaultPersistenceDelegate);
            try {
                String string2 = clazz.getName();
                Class<?> clazz2 = Class.forName("java.beans." + string2.replace('.', '_') + "_PersistenceDelegate");
                persistenceDelegate = (PersistenceDelegate)clazz2.newInstance();
                internalPersistenceDelegates.put(string, persistenceDelegate);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String[] stringArray = MetaData.getConstructorProperties(clazz);
                if (stringArray != null) {
                    persistenceDelegate = new DefaultPersistenceDelegate(stringArray);
                    internalPersistenceDelegates.put(string, persistenceDelegate);
                }
            }
            catch (Exception exception) {
                System.err.println("Internal error: " + exception);
            }
        }
        return persistenceDelegate != null ? persistenceDelegate : defaultPersistenceDelegate;
    }

    private static String[] getConstructorProperties(Class clazz) {
        String[] stringArray = null;
        int n = 0;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            String[] stringArray2 = MetaData.getAnnotationValue(constructor);
            if (stringArray2 == null || n >= stringArray2.length || !MetaData.isValid(constructor, stringArray2)) continue;
            stringArray = stringArray2;
            n = stringArray2.length;
        }
        return stringArray;
    }

    private static String[] getAnnotationValue(Constructor<?> constructor) {
        ConstructorProperties constructorProperties = constructor.getAnnotation(ConstructorProperties.class);
        return constructorProperties != null ? constructorProperties.value() : null;
    }

    private static boolean isValid(Constructor<?> constructor, String[] stringArray) {
        Class<?>[] classArray = constructor.getParameterTypes();
        if (stringArray.length != classArray.length) {
            return false;
        }
        for (String string : stringArray) {
            if (string != null) continue;
            return false;
        }
        return true;
    }

    private static Object getBeanAttribute(Class clazz, String string) {
        try {
            return Introspector.getBeanInfo(clazz).getBeanDescriptor().getValue(string);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    static {
        internalPersistenceDelegates.put("java.net.URI", new PrimitivePersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.plaf.BorderUIResource$MatteBorderUIResource", new javax_swing_border_MatteBorder_PersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.plaf.FontUIResource", new java_awt_Font_PersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.KeyStroke", new java_awt_AWTKeyStroke_PersistenceDelegate());
        internalPersistenceDelegates.put("java.sql.Date", new java_util_Date_PersistenceDelegate());
        internalPersistenceDelegates.put("java.sql.Time", new java_util_Date_PersistenceDelegate());
        internalPersistenceDelegates.put("java.util.JumboEnumSet", new java_util_EnumSet_PersistenceDelegate());
        internalPersistenceDelegates.put("java.util.RegularEnumSet", new java_util_EnumSet_PersistenceDelegate());
    }
}

