/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.xsom.impl.parser.state;

import com.sun.xml.internal.xsom.impl.parser.state.AttributesImpl;
import com.sun.xml.internal.xsom.impl.parser.state.NGCCEventReceiver;
import com.sun.xml.internal.xsom.impl.parser.state.NGCCEventSource;
import com.sun.xml.internal.xsom.impl.parser.state.NGCCHandler;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NGCCRuntime
implements ContentHandler,
NGCCEventSource {
    private Locator locator;
    private final Stack attStack = new Stack();
    private AttributesImpl currentAtts;
    private StringBuffer text = new StringBuffer();
    private NGCCEventReceiver currentHandler;
    static final String IMPOSSIBLE = "\u0000";
    private ContentHandler redirect = null;
    private int redirectionDepth = 0;
    private final ArrayList namespaces = new ArrayList();
    private int nsEffectivePtr = 0;
    private final Stack nsEffectiveStack = new Stack();
    private int indent = 0;
    private boolean needIndent = true;

    public NGCCRuntime() {
        this.reset();
    }

    public void setRootHandler(NGCCHandler nGCCHandler) {
        if (this.currentHandler != null) {
            throw new IllegalStateException();
        }
        this.currentHandler = nGCCHandler;
    }

    public void reset() {
        this.attStack.clear();
        this.currentAtts = null;
        this.currentHandler = null;
        this.indent = 0;
        this.locator = null;
        this.namespaces.clear();
        this.needIndent = true;
        this.redirect = null;
        this.redirectionDepth = 0;
        this.text = new StringBuffer();
        this.attStack.push(new AttributesImpl());
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public Attributes getCurrentAttributes() {
        return this.currentAtts;
    }

    public int replace(NGCCEventReceiver nGCCEventReceiver, NGCCEventReceiver nGCCEventReceiver2) {
        if (nGCCEventReceiver != this.currentHandler) {
            throw new IllegalStateException();
        }
        this.currentHandler = nGCCEventReceiver2;
        return 0;
    }

    private void processPendingText(boolean bl) throws SAXException {
        if (!bl || this.text.toString().trim().length() != 0) {
            this.currentHandler.text(this.text.toString());
        }
        if (this.text.length() > 1024) {
            this.text = new StringBuffer();
        } else {
            this.text.setLength(0);
        }
    }

    public void processList(String string) throws SAXException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.currentHandler.text(stringTokenizer.nextToken());
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.redirect != null) {
            this.redirect.startElement(string, string2, string3, attributes);
            ++this.redirectionDepth;
        } else {
            this.processPendingText(true);
            this.currentHandler.enterElement(string, string2, string3, attributes);
        }
    }

    public void onEnterElementConsumed(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.currentAtts = new AttributesImpl(attributes);
        this.attStack.push(this.currentAtts);
        this.nsEffectiveStack.push(new Integer(this.nsEffectivePtr));
        this.nsEffectivePtr = this.namespaces.size();
    }

    public void onLeaveElementConsumed(String string, String string2, String string3) throws SAXException {
        this.attStack.pop();
        this.currentAtts = this.attStack.isEmpty() ? null : (AttributesImpl)this.attStack.peek();
        this.nsEffectivePtr = (Integer)this.nsEffectiveStack.pop();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.redirect != null) {
            this.redirect.endElement(string, string2, string3);
            --this.redirectionDepth;
            if (this.redirectionDepth != 0) {
                return;
            }
            for (int i = 0; i < this.namespaces.size(); i += 2) {
                this.redirect.endPrefixMapping((String)this.namespaces.get(i));
            }
            this.redirect.endDocument();
            this.redirect = null;
        }
        this.processPendingText(false);
        this.currentHandler.leaveElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.redirect != null) {
            this.redirect.characters(cArray, n, n2);
        } else {
            this.text.append(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.redirect != null) {
            this.redirect.ignorableWhitespace(cArray, n, n2);
        } else {
            this.text.append(cArray, n, n2);
        }
    }

    public int getAttributeIndex(String string, String string2) {
        return this.currentAtts.getIndex(string, string2);
    }

    public void consumeAttribute(int n) throws SAXException {
        String string = this.currentAtts.getURI(n);
        String string2 = this.currentAtts.getLocalName(n);
        String string3 = this.currentAtts.getQName(n);
        String string4 = this.currentAtts.getValue(n);
        this.currentAtts.removeAttribute(n);
        this.currentHandler.enterAttribute(string, string2, string3);
        this.currentHandler.text(string4);
        this.currentHandler.leaveAttribute(string, string2, string3);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.redirect != null) {
            this.redirect.startPrefixMapping(string, string2);
        } else {
            this.namespaces.add(string);
            this.namespaces.add(string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        if (this.redirect != null) {
            this.redirect.endPrefixMapping(string);
        } else {
            this.namespaces.remove(this.namespaces.size() - 1);
            this.namespaces.remove(this.namespaces.size() - 1);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.redirect != null) {
            this.redirect.skippedEntity(string);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.redirect != null) {
            this.redirect.processingInstruction(string, string2);
        }
    }

    public void endDocument() throws SAXException {
        this.currentHandler.leaveElement(IMPOSSIBLE, IMPOSSIBLE, IMPOSSIBLE);
        this.reset();
    }

    public void startDocument() {
    }

    public void sendEnterAttribute(int n, String string, String string2, String string3) throws SAXException {
        this.currentHandler.enterAttribute(string, string2, string3);
    }

    public void sendEnterElement(int n, String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.currentHandler.enterElement(string, string2, string3, attributes);
    }

    public void sendLeaveAttribute(int n, String string, String string2, String string3) throws SAXException {
        this.currentHandler.leaveAttribute(string, string2, string3);
    }

    public void sendLeaveElement(int n, String string, String string2, String string3) throws SAXException {
        this.currentHandler.leaveElement(string, string2, string3);
    }

    public void sendText(int n, String string) throws SAXException {
        this.currentHandler.text(string);
    }

    public void redirectSubtree(ContentHandler contentHandler, String string, String string2, String string3) throws SAXException {
        this.redirect = contentHandler;
        this.redirect.setDocumentLocator(this.locator);
        this.redirect.startDocument();
        for (int i = 0; i < this.namespaces.size(); i += 2) {
            this.redirect.startPrefixMapping((String)this.namespaces.get(i), (String)this.namespaces.get(i + 1));
        }
        this.redirect.startElement(string, string2, string3, this.currentAtts);
        this.redirectionDepth = 1;
    }

    public String resolveNamespacePrefix(String string) {
        for (int i = this.nsEffectivePtr - 2; i >= 0; i -= 2) {
            if (!this.namespaces.get(i).equals(string)) continue;
            return (String)this.namespaces.get(i + 1);
        }
        if (string.equals("")) {
            return "";
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return null;
    }

    protected void unexpectedX(String string) throws SAXException {
        throw new SAXParseException(MessageFormat.format("Unexpected {0} appears at line {1} column {2}", string, new Integer(this.getLocator().getLineNumber()), new Integer(this.getLocator().getColumnNumber())), this.getLocator());
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            System.out.print("  ");
        }
    }

    public void trace(String string) {
        if (this.needIndent) {
            this.needIndent = false;
            this.printIndent();
        }
        System.out.print(string);
    }

    public void traceln(String string) {
        this.trace(string);
        this.trace("\n");
        this.needIndent = true;
    }
}

