/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

abstract class SingleByteEncoder
extends CharsetEncoder {
    private final short[] index1;
    private final String index2;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected SingleByteEncoder(Charset charset, short[] sArray, String string, int n, int n2, int n3) {
        super(charset, 1.0f, 1.0f);
        this.index1 = sArray;
        this.index2 = string;
        this.mask1 = n;
        this.mask2 = n2;
        this.shift = n3;
    }

    public boolean canEncode(char c) {
        char c2 = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
        return c2 != '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
        n2 = n2 <= n3 ? n2 : n3;
        try {
            int n4;
            for (n = (n = charBuffer.arrayOffset() + charBuffer.position()) <= (n4 = charBuffer.arrayOffset() + charBuffer.limit()) ? n : n4; n < n4; ++n) {
                char c = cArray[n];
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, cArray, n, n4) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (n3 - n2 < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                char c2 = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
                if (c2 == '\u0000' && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                byArray[n2++] = (byte)c2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n2 - byteBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!byteBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                char c2 = this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
                if (c2 == '\u0000' && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                ++n;
                byteBuffer.put((byte)c2);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }

    public byte encode(char c) {
        return (byte)this.index2.charAt(this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2));
    }
}

