/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Adjustable;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.event.MouseWheelEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ScrollPaneWheelScroller {
    private static final Logger log = Logger.getLogger("sun.awt.ScrollPaneWheelScroller");

    private ScrollPaneWheelScroller() {
    }

    public static void handleWheelScrolling(ScrollPane scrollPane, MouseWheelEvent mouseWheelEvent) {
        Adjustable adjustable;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "x = " + mouseWheelEvent.getX() + ", y = " + mouseWheelEvent.getY() + ", src is " + mouseWheelEvent.getSource());
        }
        int n = 0;
        if (scrollPane != null && mouseWheelEvent.getScrollAmount() != 0 && (adjustable = ScrollPaneWheelScroller.getAdjustableToScroll(scrollPane)) != null) {
            n = ScrollPaneWheelScroller.getIncrementFromAdjustable(adjustable, mouseWheelEvent);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "increment from adjustable(" + adjustable.getClass() + ") : " + n);
            }
            ScrollPaneWheelScroller.scrollAdjustable(adjustable, n);
        }
    }

    public static Adjustable getAdjustableToScroll(ScrollPane scrollPane) {
        int n = scrollPane.getScrollbarDisplayPolicy();
        if (n == 1 || n == 2) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "using vertical scrolling due to scrollbar policy");
            }
            return scrollPane.getVAdjustable();
        }
        Insets insets = scrollPane.getInsets();
        int n2 = scrollPane.getVScrollbarWidth();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "insets: l = " + insets.left + ", r = " + insets.right + ", t = " + insets.top + ", b = " + insets.bottom);
            log.log(Level.FINER, "vertScrollWidth = " + n2);
        }
        if (insets.right >= n2) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "using vertical scrolling because scrollbar is present");
            }
            return scrollPane.getVAdjustable();
        }
        int n3 = scrollPane.getHScrollbarHeight();
        if (insets.bottom >= n3) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "using horiz scrolling because scrollbar is present");
            }
            return scrollPane.getHAdjustable();
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "using NO scrollbar becsause neither is present");
        }
        return null;
    }

    public static int getIncrementFromAdjustable(Adjustable adjustable, MouseWheelEvent mouseWheelEvent) {
        if (log.isLoggable(Level.FINE) && adjustable == null) {
            log.log(Level.FINE, "Assertion (adj != null) failed");
        }
        int n = 0;
        if (mouseWheelEvent.getScrollType() == 0) {
            n = mouseWheelEvent.getUnitsToScroll() * adjustable.getUnitIncrement();
        } else if (mouseWheelEvent.getScrollType() == 1) {
            n = adjustable.getBlockIncrement() * mouseWheelEvent.getWheelRotation();
        }
        return n;
    }

    public static void scrollAdjustable(Adjustable adjustable, int n) {
        if (log.isLoggable(Level.FINE)) {
            if (adjustable == null) {
                log.log(Level.FINE, "Assertion (adj != null) failed");
            }
            if (n == 0) {
                log.log(Level.FINE, "Assertion (amount != 0) failed");
            }
        }
        int n2 = adjustable.getValue();
        int n3 = adjustable.getMaximum() - adjustable.getVisibleAmount();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "doScrolling by " + n);
        }
        if (n > 0 && n2 < n3) {
            if (n2 + n < n3) {
                adjustable.setValue(n2 + n);
                return;
            }
            adjustable.setValue(n3);
            return;
        }
        if (n < 0 && n2 > adjustable.getMinimum()) {
            if (n2 + n > adjustable.getMinimum()) {
                adjustable.setValue(n2 + n);
                return;
            }
            adjustable.setValue(adjustable.getMinimum());
            return;
        }
    }
}

