#! /bin/sh

# $NetBSD$

#
# Copyright (c) 2001 Alistair G. Crooks.  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed by Alistair G. Crooks.
# 4. The name of the author may not be used to endorse or promote
#    products derived from this software without specific prior written
#    permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
# GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

# Usage: pkg_retire <pkgname> [regexp for files to retain]

case $# in
0)	echo "Usage: pkg_retire <pkgname> [regexp for files to retain]" >&2
	exit 1 ;;
esac

# check that effective uid is 0
case `id -u` in
0)	;;
*)	echo "You need to be root to run this script" >&2; exit 1 ;;
esac

doit=""
preserve=""
while [ $# -gt 1 ]; do
	case $1 in
	-n)	doit=echo ;;
	-p)	preserve=yes ;;
	-v)	set -x ;;
	*)	break ;;
	esac
	shift
done

awkprog=/usr/bin/awk
envprog=/usr/bin/env
mkdirprog=/bin/mkdir
mvprog=/bin/mv
rmprog=/bin/rm
sedprog=/usr/bin/sed
tarupprog=/usr/pkg/bin/pkg_tarup
pkg_addprog=/usr/sbin/pkg_add
pkg_deleteprog=/usr/sbin/pkg_delete
pkg_tarupprog=/usr/pkg/bin/pkg_tarup
tarprog=/usr/bin/tar

case "$PKG_DBDIR" in
"")	PKG_DBDIR=/var/db/pkg ;;
esac

pkgname="`pkg_info -e $1`"
pkgbase=`echo $pkgname | $sedprog -e 's|\(.*\)-\(.*\)|\1|'`
retired=`echo $pkgname | $sedprog -e 's|\(.*\)-\(.*\)|\1-\2-retired-\2|'`

keepfiles=""
shift
while [ $# -gt 0 ]; do
	keepfiles="$keepfiles $1"
	shift
done

if [ -n "$preserve" ]; then
	$doit $pkg_tarupprog $pkgname
fi

$doit $mkdirprog $PKG_DBDIR/$retired

$doit sh -c "(cd $PKG_DBDIR/$pkgname; $tarprog cf - . | (cd ../$retired; $tarprog xf - ))"

$envprog _KEEPFILES="$keepfiles" $awkprog '
BEGIN { keepc = split(ENVIRON["_KEEPFILES"], keepv); }
/^@name/ { print "@name " "'$retired'"; next }
/^@cwd/ { print $0; next }
/^@comment/ { print $0; next }
/^@src/ { print $0; next }
/^@pkgdep/ { print $0; next }
/^@ignore/ { print $0; getline; print $0; next }
/^@pkgcfl/ { next }
/^[^@].*\/lib[^\/]+\.so$/ { print "@comment " $0; getline; if (match($0, "@comment MD5:") == 1) { print $0; getline } }
/^[^@].*\/lib[^\/]+\.so\.[0-9]+$/ { print $0; getline; if (match($0, "@comment MD5:") == 1) { print $0; getline } }
/^[^@].*\/lib[^\/]+\.so\.[0-9]+\.[0-9]+$/ { print $0; getline; if (match($0, "@comment MD5:") == 1) { print $0; getline } }
/^[^@].*\/lib[^\/]+\.so\.[0-9]+\.[0-9]+\.[0-9]+$/ { print $0; getline; if (match($0, "@comment MD5:") == 1) { print $0; getline } }
{ for (keep in keepv) if (keepv[keep] == $0) { print $0; next } print "@comment " $0 }' < $PKG_DBDIR/$pkgname/+CONTENTS > $PKG_DBDIR/$retired/+CONTENTS

if [ -f $PKG_DBDIR/$pkgname/+REQUIRED_BY ]; then
	for pkg in `cat $PKG_DBDIR/$pkgname/+REQUIRED_BY`; do
		$doit $awkprog '/^@pkgdep '$pkgbase'/ { print "@pkgdep " "'$retired'"; next } { print $0 }' \
			< $PKG_DBDIR/$pkg/+CONTENTS > $PKG_DBDIR/$pkg/+CONTENTS.$$ &&
			$mvprog $PKG_DBDIR/$pkg/+CONTENTS.$$ $PKG_DBDIR/$pkg/+CONTENTS
	done
	$doit $mvprog $PKG_DBDIR/$pkgname/+REQUIRED_BY /tmp/$pkgname-$$
fi

$doit $pkg_tarupprog $retired

$doit $rmprog -rf $PKG_DBDIR/$retired

$doit $pkg_deleteprog $pkgname

$doit $pkg_addprog -v /tmp/$retired.tgz

$doit $mvprog /tmp/$pkgname-$$ $PKG_DBDIR/$retired/+REQUIRED_BY

exit 0
