/*	$NetBSD$	*/

/*
 * Copyright (c) 1997 Michael L. Hitch.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed for the NetBSD Project
 *	by Michael L. Hitch.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

struct csc_softc {
	struct ncr53c9x_softc	sc_ncr53c9x;	/* glue to MI code */

	irqhandler_t	sc_ih;			/* Interrupt chain struct */

	volatile u_char *sc_reg;		/* the registers */
	volatile u_char *sc_status;
	volatile u_char *sc_alatch;
	volatile u_short *sc_dack;
/*	volatile u_char *sc_dmabase;*/

	int		sc_active;		/* Pseudo-DMA state vars */
	int		sc_piomode;
	int		sc_datain;
	size_t		sc_dmasize;
	char		**sc_dmaaddr;
	size_t		*sc_pdmalen;
};

#define CSC_STATUS0		0x0000
#define CSC_ALATCH		0x0014
#define CSC_DACK		0x0200
#define CSC_FASOFFSET_BASE	0x0300
#define CSC_FAS_REG_SPACING	4

#define CSC_STATUS0_INT		0x01
#define CSC_STATUS0_DREQ	0x02
#define CSC_STATUS0_EDOUT	0x04
#define CSC_STATUS0_LATCHED	0x08

#define CSC_ALATCH_P7		0x01
#define CSC_ALATCH_INTEN	0x02
#define CSC_ALATCH_TERM		0x04
#define CSC_ALATCH_RSVD		0x08
#define CSC_ALATCH_PROG		0x10
#define CSC_ALATCH_DMA32	0x20
#define CSC_ALATCH_DMAEN	0x40
#define CSC_ALATCH_DMADIR	0x80

#define CSC_INTERRUPTS_OFF	(CSC_ALATCH_INTEN | 0)
#define CSC_INTERRUPTS_ON	(CSC_ALATCH_INTEN | 1)
