/* $NetBSD: linux_systrace_args.c,v 1.28 2024/09/28 19:36:19 christos Exp $ */

/*
 * System call argument to DTrace register array conversion.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * This file is part of the DTrace syscall provider.
 */

static void
systrace_args(register_t sysnum, const void *params, uintptr_t *uarg, size_t *n_args)
{
	intptr_t *iarg  = (intptr_t *)uarg;
	switch (sysnum) {
	/* sys_read */
	case 0: {
		const struct sys_read_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* void * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		*n_args = 3;
		break;
	}
	/* sys_write */
	case 1: {
		const struct sys_write_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* const void * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_open */
	case 2: {
		const struct linux_sys_open_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, flags); /* int */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 3;
		break;
	}
	/* sys_close */
	case 3: {
		const struct sys_close_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_stat64 */
	case 4: {
		const struct linux_sys_stat64_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_stat64 * */
		*n_args = 2;
		break;
	}
	/* linux_sys_fstat64 */
	case 5: {
		const struct linux_sys_fstat64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_stat64 * */
		*n_args = 2;
		break;
	}
	/* linux_sys_lstat64 */
	case 6: {
		const struct linux_sys_lstat64_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_stat64 * */
		*n_args = 2;
		break;
	}
	/* sys_poll */
	case 7: {
		const struct sys_poll_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds); /* struct pollfd * */
		uarg[1] = SCARG(p, nfds); /* u_int */
		iarg[2] = SCARG(p, timeout); /* int */
		*n_args = 3;
		break;
	}
	/* compat_43_sys_lseek */
	case 8: {
		const struct compat_43_sys_lseek_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, offset); /* long */
		iarg[2] = SCARG(p, whence); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_mmap */
	case 9: {
		const struct linux_sys_mmap_args *p = params;
		uarg[0] = SCARG(p, addr); /* unsigned long */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, prot); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		iarg[4] = SCARG(p, fd); /* int */
		iarg[5] = SCARG(p, offset); /* linux_off_t */
		*n_args = 6;
		break;
	}
	/* linux_sys_mprotect */
	case 10: {
		const struct linux_sys_mprotect_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, start); /* const void * */
		uarg[1] = SCARG(p, len); /* unsigned long */
		iarg[2] = SCARG(p, prot); /* int */
		*n_args = 3;
		break;
	}
	/* sys_munmap */
	case 11: {
		const struct sys_munmap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_brk */
	case 12: {
		const struct linux_sys_brk_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, nsize); /* char * */
		*n_args = 1;
		break;
	}
	/* linux_sys_rt_sigaction */
	case 13: {
		const struct linux_sys_rt_sigaction_args *p = params;
		iarg[0] = SCARG(p, signum); /* int */
		uarg[1] = (intptr_t) SCARG(p, nsa); /* const struct linux_sigaction * */
		uarg[2] = (intptr_t) SCARG(p, osa); /* struct linux_sigaction * */
		uarg[3] = SCARG(p, sigsetsize); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_rt_sigprocmask */
	case 14: {
		const struct linux_sys_rt_sigprocmask_args *p = params;
		iarg[0] = SCARG(p, how); /* int */
		uarg[1] = (intptr_t) SCARG(p, set); /* const linux_sigset_t * */
		uarg[2] = (intptr_t) SCARG(p, oset); /* linux_sigset_t * */
		uarg[3] = SCARG(p, sigsetsize); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_rt_sigreturn */
	case 15: {
		*n_args = 0;
		break;
	}
	/* linux_sys_ioctl */
	case 16: {
		const struct linux_sys_ioctl_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, com); /* u_long */
		uarg[2] = (intptr_t) SCARG(p, data); /* void * */
		*n_args = 3;
		break;
	}
	/* linux_sys_pread */
	case 17: {
		const struct linux_sys_pread_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		iarg[3] = SCARG(p, offset); /* off_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_pwrite */
	case 18: {
		const struct linux_sys_pwrite_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[2] = SCARG(p, nbyte); /* size_t */
		iarg[3] = SCARG(p, offset); /* off_t */
		*n_args = 4;
		break;
	}
	/* sys_readv */
	case 19: {
		const struct sys_readv_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp); /* const struct iovec * */
		iarg[2] = SCARG(p, iovcnt); /* int */
		*n_args = 3;
		break;
	}
	/* sys_writev */
	case 20: {
		const struct sys_writev_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp); /* const struct iovec * */
		iarg[2] = SCARG(p, iovcnt); /* int */
		*n_args = 3;
		break;
	}
	/* sys_access */
	case 21: {
		const struct sys_access_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_pipe */
	case 22: {
		const struct linux_sys_pipe_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, pfds); /* int * */
		*n_args = 1;
		break;
	}
	/* linux_sys_select */
	case 23: {
		const struct linux_sys_select_args *p = params;
		iarg[0] = SCARG(p, nfds); /* int */
		uarg[1] = (intptr_t) SCARG(p, readfds); /* fd_set * */
		uarg[2] = (intptr_t) SCARG(p, writefds); /* fd_set * */
		uarg[3] = (intptr_t) SCARG(p, exceptfds); /* fd_set * */
		uarg[4] = (intptr_t) SCARG(p, timeout); /* struct timeval50 * */
		*n_args = 5;
		break;
	}
	/* linux_sys_sched_yield */
	case 24: {
		*n_args = 0;
		break;
	}
	/* linux_sys_mremap */
	case 25: {
		const struct linux_sys_mremap_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, old_address); /* void * */
		uarg[1] = SCARG(p, old_size); /* size_t */
		uarg[2] = SCARG(p, new_size); /* size_t */
		uarg[3] = SCARG(p, flags); /* u_long */
		*n_args = 4;
		break;
	}
	/* sys___msync13 */
	case 26: {
		const struct sys___msync13_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_mincore */
	case 27: {
		const struct sys_mincore_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		uarg[2] = (intptr_t) SCARG(p, vec); /* char * */
		*n_args = 3;
		break;
	}
	/* sys_madvise */
	case 28: {
		const struct sys_madvise_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		iarg[2] = SCARG(p, behav); /* int */
		*n_args = 3;
		break;
	}
#ifdef SYSVSHM
	/* linux_sys_shmget */
	case 29: {
		const struct linux_sys_shmget_args *p = params;
		iarg[0] = SCARG(p, key); /* key_t */
		uarg[1] = SCARG(p, size); /* size_t */
		iarg[2] = SCARG(p, shmflg); /* int */
		*n_args = 3;
		break;
	}
	/* sys_shmat */
	case 30: {
		const struct sys_shmat_args *p = params;
		iarg[0] = SCARG(p, shmid); /* int */
		uarg[1] = (intptr_t) SCARG(p, shmaddr); /* void * */
		iarg[2] = SCARG(p, shmflg); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_shmctl */
	case 31: {
		const struct linux_sys_shmctl_args *p = params;
		iarg[0] = SCARG(p, shmid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf); /* struct linux_shmid_ds * */
		*n_args = 3;
		break;
	}
#else
#endif
	/* sys_dup */
	case 32: {
		const struct sys_dup_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* sys_dup2 */
	case 33: {
		const struct sys_dup2_args *p = params;
		iarg[0] = SCARG(p, from); /* int */
		iarg[1] = SCARG(p, to); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_pause */
	case 34: {
		*n_args = 0;
		break;
	}
	/* linux_sys_nanosleep */
	case 35: {
		const struct linux_sys_nanosleep_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rqtp); /* const struct linux_timespec * */
		uarg[1] = (intptr_t) SCARG(p, rmtp); /* struct linux_timespec * */
		*n_args = 2;
		break;
	}
	/* compat_50_sys_getitimer */
	case 36: {
		const struct compat_50_sys_getitimer_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv); /* struct itimerval50 * */
		*n_args = 2;
		break;
	}
	/* linux_sys_alarm */
	case 37: {
		const struct linux_sys_alarm_args *p = params;
		uarg[0] = SCARG(p, secs); /* unsigned int */
		*n_args = 1;
		break;
	}
	/* compat_50_sys_setitimer */
	case 38: {
		const struct compat_50_sys_setitimer_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, itv); /* struct itimerval50 * */
		uarg[2] = (intptr_t) SCARG(p, oitv); /* struct itimerval50 * */
		*n_args = 3;
		break;
	}
	/* sys_getpid */
	case 39: {
		*n_args = 0;
		break;
	}
	/* linux_sys_socket */
	case 41: {
		const struct linux_sys_socket_args *p = params;
		iarg[0] = SCARG(p, domain); /* int */
		iarg[1] = SCARG(p, type); /* int */
		iarg[2] = SCARG(p, protocol); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_connect */
	case 42: {
		const struct linux_sys_connect_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* const struct osockaddr * */
		uarg[2] = SCARG(p, namelen); /* unsigned int */
		*n_args = 3;
		break;
	}
	/* linux_sys_accept */
	case 43: {
		const struct linux_sys_accept_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* struct osockaddr * */
		uarg[2] = (intptr_t) SCARG(p, anamelen); /* int * */
		*n_args = 3;
		break;
	}
	/* linux_sys_sendto */
	case 44: {
		const struct linux_sys_sendto_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msg); /* void * */
		iarg[2] = SCARG(p, len); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		uarg[4] = (intptr_t) SCARG(p, to); /* struct osockaddr * */
		iarg[5] = SCARG(p, tolen); /* int */
		*n_args = 6;
		break;
	}
	/* linux_sys_recvfrom */
	case 45: {
		const struct linux_sys_recvfrom_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, buf); /* void * */
		uarg[2] = SCARG(p, len); /* size_t */
		iarg[3] = SCARG(p, flags); /* int */
		uarg[4] = (intptr_t) SCARG(p, from); /* struct osockaddr * */
		uarg[5] = (intptr_t) SCARG(p, fromlenaddr); /* unsigned int * */
		*n_args = 6;
		break;
	}
	/* linux_sys_sendmsg */
	case 46: {
		const struct linux_sys_sendmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msg); /* const struct linux_msghdr * */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_recvmsg */
	case 47: {
		const struct linux_sys_recvmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msg); /* struct linux_msghdr * */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* sys_shutdown */
	case 48: {
		const struct sys_shutdown_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, how); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_bind */
	case 49: {
		const struct linux_sys_bind_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* const struct osockaddr * */
		uarg[2] = SCARG(p, namelen); /* unsigned int */
		*n_args = 3;
		break;
	}
	/* sys_listen */
	case 50: {
		const struct sys_listen_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, backlog); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_getsockname */
	case 51: {
		const struct linux_sys_getsockname_args *p = params;
		iarg[0] = SCARG(p, fdec); /* int */
		uarg[1] = (intptr_t) SCARG(p, asa); /* void * */
		uarg[2] = (intptr_t) SCARG(p, alen); /* int * */
		*n_args = 3;
		break;
	}
	/* linux_sys_getpeername */
	case 52: {
		const struct linux_sys_getpeername_args *p = params;
		iarg[0] = SCARG(p, fdes); /* int */
		uarg[1] = (intptr_t) SCARG(p, asa); /* struct sockaddr * */
		uarg[2] = (intptr_t) SCARG(p, alen); /* unsigned int * */
		*n_args = 3;
		break;
	}
	/* linux_sys_socketpair */
	case 53: {
		const struct linux_sys_socketpair_args *p = params;
		iarg[0] = SCARG(p, domain); /* int */
		iarg[1] = SCARG(p, type); /* int */
		iarg[2] = SCARG(p, protocol); /* int */
		uarg[3] = (intptr_t) SCARG(p, rsv); /* int * */
		*n_args = 4;
		break;
	}
	/* linux_sys_setsockopt */
	case 54: {
		const struct linux_sys_setsockopt_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, level); /* int */
		iarg[2] = SCARG(p, optname); /* int */
		uarg[3] = (intptr_t) SCARG(p, optval); /* void * */
		iarg[4] = SCARG(p, optlen); /* int */
		*n_args = 5;
		break;
	}
	/* linux_sys_getsockopt */
	case 55: {
		const struct linux_sys_getsockopt_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		iarg[1] = SCARG(p, level); /* int */
		iarg[2] = SCARG(p, optname); /* int */
		uarg[3] = (intptr_t) SCARG(p, optval); /* void * */
		uarg[4] = (intptr_t) SCARG(p, optlen); /* int * */
		*n_args = 5;
		break;
	}
	/* linux_sys_clone */
	case 56: {
		const struct linux_sys_clone_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		uarg[1] = (intptr_t) SCARG(p, stack); /* void * */
		uarg[2] = (intptr_t) SCARG(p, parent_tidptr); /* void * */
		uarg[3] = (intptr_t) SCARG(p, child_tidptr); /* void * */
		uarg[4] = (intptr_t) SCARG(p, tls); /* void * */
		*n_args = 5;
		break;
	}
	/* sys_fork */
	case 57: {
		*n_args = 0;
		break;
	}
	/* sys___vfork14 */
	case 58: {
		*n_args = 0;
		break;
	}
	/* sys_execve */
	case 59: {
		const struct sys_execve_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, argp); /* char ** */
		uarg[2] = (intptr_t) SCARG(p, envp); /* char ** */
		*n_args = 3;
		break;
	}
	/* linux_sys_exit */
	case 60: {
		const struct linux_sys_exit_args *p = params;
		iarg[0] = SCARG(p, rval); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_wait4 */
	case 61: {
		const struct linux_sys_wait4_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		uarg[1] = (intptr_t) SCARG(p, status); /* int * */
		iarg[2] = SCARG(p, options); /* int */
		uarg[3] = (intptr_t) SCARG(p, rusage); /* struct rusage50 * */
		*n_args = 4;
		break;
	}
	/* linux_sys_kill */
	case 62: {
		const struct linux_sys_kill_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		iarg[1] = SCARG(p, signum); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_uname */
	case 63: {
		const struct linux_sys_uname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, up); /* struct linux_utsname * */
		*n_args = 1;
		break;
	}
#ifdef SYSVSEM
	/* sys_semget */
	case 64: {
		const struct sys_semget_args *p = params;
		iarg[0] = SCARG(p, key); /* key_t */
		iarg[1] = SCARG(p, nsems); /* int */
		iarg[2] = SCARG(p, semflg); /* int */
		*n_args = 3;
		break;
	}
	/* sys_semop */
	case 65: {
		const struct sys_semop_args *p = params;
		iarg[0] = SCARG(p, semid); /* int */
		uarg[1] = (intptr_t) SCARG(p, sops); /* struct sembuf * */
		uarg[2] = SCARG(p, nsops); /* size_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_semctl */
	case 66: {
		const struct linux_sys_semctl_args *p = params;
		iarg[0] = SCARG(p, semid); /* int */
		iarg[1] = SCARG(p, semnum); /* int */
		iarg[2] = SCARG(p, cmd); /* int */
		uarg[3] = SCARG(p, arg); /* union linux_semun */
		*n_args = 4;
		break;
	}
#else
#endif
#ifdef SYSVSHM
	/* sys_shmdt */
	case 67: {
		const struct sys_shmdt_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, shmaddr); /* const void * */
		*n_args = 1;
		break;
	}
#else
#endif
#ifdef SYSVMSG
	/* sys_msgget */
	case 68: {
		const struct sys_msgget_args *p = params;
		iarg[0] = SCARG(p, key); /* key_t */
		iarg[1] = SCARG(p, msgflg); /* int */
		*n_args = 2;
		break;
	}
	/* sys_msgsnd */
	case 69: {
		const struct sys_msgsnd_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		uarg[1] = (intptr_t) SCARG(p, msgp); /* void * */
		uarg[2] = SCARG(p, msgsz); /* size_t */
		iarg[3] = SCARG(p, msgflg); /* int */
		*n_args = 4;
		break;
	}
	/* sys_msgrcv */
	case 70: {
		const struct sys_msgrcv_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		uarg[1] = (intptr_t) SCARG(p, msgp); /* void * */
		uarg[2] = SCARG(p, msgsz); /* size_t */
		iarg[3] = SCARG(p, msgtyp); /* long */
		iarg[4] = SCARG(p, msgflg); /* int */
		*n_args = 5;
		break;
	}
	/* linux_sys_msgctl */
	case 71: {
		const struct linux_sys_msgctl_args *p = params;
		iarg[0] = SCARG(p, msqid); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, buf); /* struct linux_msqid_ds * */
		*n_args = 3;
		break;
	}
#else
#endif
	/* linux_sys_fcntl */
	case 72: {
		const struct linux_sys_fcntl_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, cmd); /* int */
		uarg[2] = (intptr_t) SCARG(p, arg); /* void * */
		*n_args = 3;
		break;
	}
	/* sys_flock */
	case 73: {
		const struct sys_flock_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, how); /* int */
		*n_args = 2;
		break;
	}
	/* sys_fsync */
	case 74: {
		const struct sys_fsync_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_fdatasync */
	case 75: {
		const struct linux_sys_fdatasync_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_truncate64 */
	case 76: {
		const struct linux_sys_truncate64_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, length); /* off_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_ftruncate64 */
	case 77: {
		const struct linux_sys_ftruncate64_args *p = params;
		uarg[0] = SCARG(p, fd); /* unsigned int */
		iarg[1] = SCARG(p, length); /* off_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_getdents */
	case 78: {
		const struct linux_sys_getdents_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, dent); /* struct linux_dirent * */
		uarg[2] = SCARG(p, count); /* unsigned int */
		*n_args = 3;
		break;
	}
	/* sys___getcwd */
	case 79: {
		const struct sys___getcwd_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, bufp); /* char * */
		uarg[1] = SCARG(p, length); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys_chdir */
	case 80: {
		const struct sys_chdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_fchdir */
	case 81: {
		const struct sys_fchdir_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* sys___posix_rename */
	case 82: {
		const struct sys___posix_rename_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, from); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, to); /* const char * */
		*n_args = 2;
		break;
	}
	/* sys_mkdir */
	case 83: {
		const struct sys_mkdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 2;
		break;
	}
	/* sys_rmdir */
	case 84: {
		const struct sys_rmdir_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* linux_sys_creat */
	case 85: {
		const struct linux_sys_creat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 2;
		break;
	}
	/* sys_link */
	case 86: {
		const struct sys_link_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, link); /* const char * */
		*n_args = 2;
		break;
	}
	/* linux_sys_unlink */
	case 87: {
		const struct linux_sys_unlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* sys_symlink */
	case 88: {
		const struct sys_symlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, link); /* const char * */
		*n_args = 2;
		break;
	}
	/* sys_readlink */
	case 89: {
		const struct sys_readlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, buf); /* char * */
		iarg[2] = SCARG(p, count); /* int */
		*n_args = 3;
		break;
	}
	/* sys_chmod */
	case 90: {
		const struct sys_chmod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 2;
		break;
	}
	/* sys_fchmod */
	case 91: {
		const struct sys_fchmod_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 2;
		break;
	}
	/* sys___posix_chown */
	case 92: {
		const struct sys___posix_chown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys___posix_fchown */
	case 93: {
		const struct sys___posix_fchown_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys___posix_lchown */
	case 94: {
		const struct sys___posix_lchown_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = SCARG(p, uid); /* uid_t */
		iarg[2] = SCARG(p, gid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* sys_umask */
	case 95: {
		const struct sys_umask_args *p = params;
		iarg[0] = SCARG(p, newmask); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_gettimeofday */
	case 96: {
		const struct linux_sys_gettimeofday_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp); /* struct timeval50 * */
		uarg[1] = (intptr_t) SCARG(p, tzp); /* struct timezone * */
		*n_args = 2;
		break;
	}
	/* linux_sys_getrlimit */
	case 97: {
		const struct linux_sys_getrlimit_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		uarg[1] = (intptr_t) SCARG(p, rlp); /* struct rlimit * */
		*n_args = 2;
		break;
	}
	/* compat_50_sys_getrusage */
	case 98: {
		const struct compat_50_sys_getrusage_args *p = params;
		iarg[0] = SCARG(p, who); /* int */
		uarg[1] = (intptr_t) SCARG(p, rusage); /* struct rusage50 * */
		*n_args = 2;
		break;
	}
	/* linux_sys_sysinfo */
	case 99: {
		const struct linux_sys_sysinfo_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, arg); /* struct linux_sysinfo * */
		*n_args = 1;
		break;
	}
	/* linux_sys_times */
	case 100: {
		const struct linux_sys_times_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tms); /* struct times * */
		*n_args = 1;
		break;
	}
	/* linux_sys_ptrace */
	case 101: {
		const struct linux_sys_ptrace_args *p = params;
		iarg[0] = SCARG(p, request); /* long */
		iarg[1] = SCARG(p, pid); /* long */
		iarg[2] = SCARG(p, addr); /* long */
		iarg[3] = SCARG(p, data); /* long */
		*n_args = 4;
		break;
	}
	/* sys_getuid */
	case 102: {
		*n_args = 0;
		break;
	}
	/* sys_getgid */
	case 104: {
		*n_args = 0;
		break;
	}
	/* sys_setuid */
	case 105: {
		const struct sys_setuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* sys_setgid */
	case 106: {
		const struct sys_setgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* sys_geteuid */
	case 107: {
		*n_args = 0;
		break;
	}
	/* sys_getegid */
	case 108: {
		*n_args = 0;
		break;
	}
	/* sys_setpgid */
	case 109: {
		const struct sys_setpgid_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		iarg[1] = SCARG(p, pgid); /* int */
		*n_args = 2;
		break;
	}
	/* sys_getppid */
	case 110: {
		*n_args = 0;
		break;
	}
	/* sys_getpgrp */
	case 111: {
		*n_args = 0;
		break;
	}
	/* sys_setsid */
	case 112: {
		*n_args = 0;
		break;
	}
	/* sys_setreuid */
	case 113: {
		const struct sys_setreuid_args *p = params;
		uarg[0] = SCARG(p, ruid); /* uid_t */
		uarg[1] = SCARG(p, euid); /* uid_t */
		*n_args = 2;
		break;
	}
	/* sys_setregid */
	case 114: {
		const struct sys_setregid_args *p = params;
		iarg[0] = SCARG(p, rgid); /* gid_t */
		iarg[1] = SCARG(p, egid); /* gid_t */
		*n_args = 2;
		break;
	}
	/* sys_getgroups */
	case 115: {
		const struct sys_getgroups_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset); /* gid_t * */
		*n_args = 2;
		break;
	}
	/* sys_setgroups */
	case 116: {
		const struct sys_setgroups_args *p = params;
		iarg[0] = SCARG(p, gidsetsize); /* int */
		uarg[1] = (intptr_t) SCARG(p, gidset); /* gid_t * */
		*n_args = 2;
		break;
	}
	/* linux_sys_setresuid */
	case 117: {
		const struct linux_sys_setresuid_args *p = params;
		uarg[0] = SCARG(p, ruid); /* uid_t */
		uarg[1] = SCARG(p, euid); /* uid_t */
		uarg[2] = SCARG(p, suid); /* uid_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_getresuid */
	case 118: {
		const struct linux_sys_getresuid_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ruid); /* uid_t * */
		uarg[1] = (intptr_t) SCARG(p, euid); /* uid_t * */
		uarg[2] = (intptr_t) SCARG(p, suid); /* uid_t * */
		*n_args = 3;
		break;
	}
	/* linux_sys_setresgid */
	case 119: {
		const struct linux_sys_setresgid_args *p = params;
		iarg[0] = SCARG(p, rgid); /* gid_t */
		iarg[1] = SCARG(p, egid); /* gid_t */
		iarg[2] = SCARG(p, sgid); /* gid_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_getresgid */
	case 120: {
		const struct linux_sys_getresgid_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, rgid); /* gid_t * */
		uarg[1] = (intptr_t) SCARG(p, egid); /* gid_t * */
		uarg[2] = (intptr_t) SCARG(p, sgid); /* gid_t * */
		*n_args = 3;
		break;
	}
	/* sys_getpgid */
	case 121: {
		const struct sys_getpgid_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_setfsuid */
	case 122: {
		const struct linux_sys_setfsuid_args *p = params;
		uarg[0] = SCARG(p, uid); /* uid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_setfsgid */
	case 123: {
		const struct linux_sys_setfsgid_args *p = params;
		iarg[0] = SCARG(p, gid); /* gid_t */
		*n_args = 1;
		break;
	}
	/* sys_getsid */
	case 124: {
		const struct sys_getsid_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_rt_sigpending */
	case 127: {
		const struct linux_sys_rt_sigpending_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set); /* linux_sigset_t * */
		uarg[1] = SCARG(p, sigsetsize); /* size_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_rt_sigtimedwait */
	case 128: {
		const struct linux_sys_rt_sigtimedwait_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, set); /* const linux_sigset_t * */
		uarg[1] = (intptr_t) SCARG(p, info); /* linux_siginfo_t * */
		uarg[2] = (intptr_t) SCARG(p, timeout); /* const struct linux_timespec * */
		*n_args = 3;
		break;
	}
	/* linux_sys_rt_queueinfo */
	case 129: {
		const struct linux_sys_rt_queueinfo_args *p = params;
		iarg[0] = SCARG(p, pid); /* int */
		iarg[1] = SCARG(p, signum); /* int */
		uarg[2] = (intptr_t) SCARG(p, uinfo); /* linux_siginfo_t * */
		*n_args = 3;
		break;
	}
	/* linux_sys_rt_sigsuspend */
	case 130: {
		const struct linux_sys_rt_sigsuspend_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, unewset); /* linux_sigset_t * */
		uarg[1] = SCARG(p, sigsetsize); /* size_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_sigaltstack */
	case 131: {
		const struct linux_sys_sigaltstack_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, ss); /* const struct linux_sigaltstack * */
		uarg[1] = (intptr_t) SCARG(p, oss); /* struct linux_sigaltstack * */
		*n_args = 2;
		break;
	}
	/* linux_sys_utime */
	case 132: {
		const struct linux_sys_utime_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, times); /* struct linux_utimbuf * */
		*n_args = 2;
		break;
	}
	/* linux_sys_mknod */
	case 133: {
		const struct linux_sys_mknod_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[1] = SCARG(p, mode); /* linux_umode_t */
		uarg[2] = SCARG(p, dev); /* unsigned */
		*n_args = 3;
		break;
	}
#ifdef EXEC_AOUT
	/* linux_sys_uselib */
	case 134: {
		const struct linux_sys_uselib_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
#else
#endif
	/* linux_sys_personality */
	case 135: {
		const struct linux_sys_personality_args *p = params;
		uarg[0] = SCARG(p, per); /* unsigned long */
		*n_args = 1;
		break;
	}
	/* linux_sys_statfs */
	case 137: {
		const struct linux_sys_statfs_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_statfs * */
		*n_args = 2;
		break;
	}
	/* linux_sys_fstatfs */
	case 138: {
		const struct linux_sys_fstatfs_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_statfs * */
		*n_args = 2;
		break;
	}
	/* linux_sys_getpriority */
	case 140: {
		const struct linux_sys_getpriority_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, who); /* int */
		*n_args = 2;
		break;
	}
	/* sys_setpriority */
	case 141: {
		const struct sys_setpriority_args *p = params;
		iarg[0] = SCARG(p, which); /* int */
		iarg[1] = SCARG(p, who); /* int */
		iarg[2] = SCARG(p, prio); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_sched_setparam */
	case 142: {
		const struct linux_sys_sched_setparam_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = (intptr_t) SCARG(p, sp); /* const struct linux_sched_param * */
		*n_args = 2;
		break;
	}
	/* linux_sys_sched_getparam */
	case 143: {
		const struct linux_sys_sched_getparam_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = (intptr_t) SCARG(p, sp); /* struct linux_sched_param * */
		*n_args = 2;
		break;
	}
	/* linux_sys_sched_setscheduler */
	case 144: {
		const struct linux_sys_sched_setscheduler_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, policy); /* int */
		uarg[2] = (intptr_t) SCARG(p, sp); /* const struct linux_sched_param * */
		*n_args = 3;
		break;
	}
	/* linux_sys_sched_getscheduler */
	case 145: {
		const struct linux_sys_sched_getscheduler_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_sched_get_priority_max */
	case 146: {
		const struct linux_sys_sched_get_priority_max_args *p = params;
		iarg[0] = SCARG(p, policy); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_sched_get_priority_min */
	case 147: {
		const struct linux_sys_sched_get_priority_min_args *p = params;
		iarg[0] = SCARG(p, policy); /* int */
		*n_args = 1;
		break;
	}
	/* sys_mlock */
	case 149: {
		const struct sys_mlock_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys_munlock */
	case 150: {
		const struct sys_munlock_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, addr); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys_mlockall */
	case 151: {
		const struct sys_mlockall_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		*n_args = 1;
		break;
	}
	/* sys_munlockall */
	case 152: {
		*n_args = 0;
		break;
	}
	/* linux_sys_modify_ldt */
	case 154: {
		const struct linux_sys_modify_ldt_args *p = params;
		iarg[0] = SCARG(p, func); /* int */
		uarg[1] = (intptr_t) SCARG(p, ptr); /* void * */
		uarg[2] = SCARG(p, bytecount); /* size_t */
		*n_args = 3;
		break;
	}
	/* linux_sys___sysctl */
	case 156: {
		const struct linux_sys___sysctl_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, lsp); /* struct linux___sysctl * */
		*n_args = 1;
		break;
	}
	/* linux_sys_arch_prctl */
	case 158: {
		const struct linux_sys_arch_prctl_args *p = params;
		iarg[0] = SCARG(p, code); /* int */
		uarg[1] = SCARG(p, addr); /* unsigned long */
		*n_args = 2;
		break;
	}
	/* linux_sys_setrlimit */
	case 160: {
		const struct linux_sys_setrlimit_args *p = params;
		uarg[0] = SCARG(p, which); /* u_int */
		uarg[1] = (intptr_t) SCARG(p, rlp); /* struct rlimit * */
		*n_args = 2;
		break;
	}
	/* sys_chroot */
	case 161: {
		const struct sys_chroot_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		*n_args = 1;
		break;
	}
	/* sys_sync */
	case 162: {
		*n_args = 0;
		break;
	}
	/* sys_acct */
	case 163: {
		const struct sys_acct_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		*n_args = 1;
		break;
	}
	/* linux_sys_settimeofday */
	case 164: {
		const struct linux_sys_settimeofday_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tp); /* struct timeval50 * */
		uarg[1] = (intptr_t) SCARG(p, tzp); /* struct timezone * */
		*n_args = 2;
		break;
	}
	/* linux_sys_swapon */
	case 167: {
		const struct linux_sys_swapon_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* char * */
		*n_args = 1;
		break;
	}
	/* linux_sys_swapoff */
	case 168: {
		const struct linux_sys_swapoff_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		*n_args = 1;
		break;
	}
	/* linux_sys_reboot */
	case 169: {
		const struct linux_sys_reboot_args *p = params;
		iarg[0] = SCARG(p, magic1); /* int */
		iarg[1] = SCARG(p, magic2); /* int */
		iarg[2] = SCARG(p, cmd); /* int */
		uarg[3] = (intptr_t) SCARG(p, arg); /* void * */
		*n_args = 4;
		break;
	}
	/* compat_43_sys_sethostname */
	case 170: {
		const struct compat_43_sys_sethostname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, hostname); /* char * */
		uarg[1] = SCARG(p, len); /* u_int */
		*n_args = 2;
		break;
	}
	/* linux_sys_setdomainname */
	case 171: {
		const struct linux_sys_setdomainname_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, domainname); /* char * */
		iarg[1] = SCARG(p, len); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_iopl */
	case 172: {
		const struct linux_sys_iopl_args *p = params;
		iarg[0] = SCARG(p, level); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_ioperm */
	case 173: {
		const struct linux_sys_ioperm_args *p = params;
		uarg[0] = SCARG(p, lo); /* unsigned int */
		uarg[1] = SCARG(p, hi); /* unsigned int */
		iarg[2] = SCARG(p, val); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_gettid */
	case 186: {
		*n_args = 0;
		break;
	}
	/* linux_sys_readahead */
	case 187: {
		const struct linux_sys_readahead_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, offset); /* off_t */
		uarg[2] = SCARG(p, count); /* size_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_setxattr */
	case 188: {
		const struct linux_sys_setxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* linux_sys_lsetxattr */
	case 189: {
		const struct linux_sys_lsetxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* linux_sys_fsetxattr */
	case 190: {
		const struct linux_sys_fsetxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* linux_sys_getxattr */
	case 191: {
		const struct linux_sys_getxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_lgetxattr */
	case 192: {
		const struct linux_sys_lgetxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_fgetxattr */
	case 193: {
		const struct linux_sys_fgetxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		uarg[2] = (intptr_t) SCARG(p, value); /* void * */
		uarg[3] = SCARG(p, size); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_listxattr */
	case 194: {
		const struct linux_sys_listxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, list); /* char * */
		uarg[2] = SCARG(p, size); /* size_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_llistxattr */
	case 195: {
		const struct linux_sys_llistxattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, list); /* char * */
		uarg[2] = SCARG(p, size); /* size_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_flistxattr */
	case 196: {
		const struct linux_sys_flistxattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, list); /* char * */
		uarg[2] = SCARG(p, size); /* size_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_removexattr */
	case 197: {
		const struct linux_sys_removexattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		*n_args = 2;
		break;
	}
	/* linux_sys_lremovexattr */
	case 198: {
		const struct linux_sys_lremovexattr_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* char * */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		*n_args = 2;
		break;
	}
	/* linux_sys_fremovexattr */
	case 199: {
		const struct linux_sys_fremovexattr_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* char * */
		*n_args = 2;
		break;
	}
	/* linux_sys_tkill */
	case 200: {
		const struct linux_sys_tkill_args *p = params;
		iarg[0] = SCARG(p, tid); /* int */
		iarg[1] = SCARG(p, sig); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_time */
	case 201: {
		const struct linux_sys_time_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, t); /* linux_time_t * */
		*n_args = 1;
		break;
	}
	/* linux_sys_futex */
	case 202: {
		const struct linux_sys_futex_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, uaddr); /* int * */
		iarg[1] = SCARG(p, op); /* int */
		iarg[2] = SCARG(p, val); /* int */
		uarg[3] = (intptr_t) SCARG(p, timeout); /* const struct linux_timespec * */
		uarg[4] = (intptr_t) SCARG(p, uaddr2); /* int * */
		iarg[5] = SCARG(p, val3); /* int */
		*n_args = 6;
		break;
	}
	/* linux_sys_sched_setaffinity */
	case 203: {
		const struct linux_sys_sched_setaffinity_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = SCARG(p, len); /* unsigned int */
		uarg[2] = (intptr_t) SCARG(p, mask); /* unsigned long * */
		*n_args = 3;
		break;
	}
	/* linux_sys_sched_getaffinity */
	case 204: {
		const struct linux_sys_sched_getaffinity_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		uarg[1] = SCARG(p, len); /* unsigned int */
		uarg[2] = (intptr_t) SCARG(p, mask); /* unsigned long * */
		*n_args = 3;
		break;
	}
	/* linux_sys_epoll_create */
	case 213: {
		const struct linux_sys_epoll_create_args *p = params;
		iarg[0] = SCARG(p, size); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_getdents64 */
	case 217: {
		const struct linux_sys_getdents64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, dent); /* struct linux_dirent64 * */
		uarg[2] = SCARG(p, count); /* unsigned int */
		*n_args = 3;
		break;
	}
	/* linux_sys_set_tid_address */
	case 218: {
		const struct linux_sys_set_tid_address_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, tid); /* int * */
		*n_args = 1;
		break;
	}
	/* linux_sys_fadvise64 */
	case 221: {
		const struct linux_sys_fadvise64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, offset); /* off_t */
		uarg[2] = SCARG(p, len); /* size_t */
		iarg[3] = SCARG(p, advice); /* int */
		*n_args = 4;
		break;
	}
	/* linux_sys_timer_create */
	case 222: {
		const struct linux_sys_timer_create_args *p = params;
		iarg[0] = SCARG(p, clockid); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, evp); /* struct linux_sigevent * */
		uarg[2] = (intptr_t) SCARG(p, timerid); /* timer_t * */
		*n_args = 3;
		break;
	}
	/* linux_sys_timer_settime */
	case 223: {
		const struct linux_sys_timer_settime_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, tim); /* const struct linux_itimerspec * */
		uarg[3] = (intptr_t) SCARG(p, otim); /* struct linux_itimerspec * */
		*n_args = 4;
		break;
	}
	/* linux_sys_timer_gettime */
	case 224: {
		const struct linux_sys_timer_gettime_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		uarg[1] = (intptr_t) SCARG(p, tim); /* struct linux_itimerspec * */
		*n_args = 2;
		break;
	}
	/* sys_timer_getoverrun */
	case 225: {
		const struct sys_timer_getoverrun_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		*n_args = 1;
		break;
	}
	/* sys_timer_delete */
	case 226: {
		const struct sys_timer_delete_args *p = params;
		iarg[0] = SCARG(p, timerid); /* timer_t */
		*n_args = 1;
		break;
	}
	/* linux_sys_clock_settime */
	case 227: {
		const struct linux_sys_clock_settime_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* struct linux_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_sys_clock_gettime */
	case 228: {
		const struct linux_sys_clock_gettime_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* struct linux_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_sys_clock_getres */
	case 229: {
		const struct linux_sys_clock_getres_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		uarg[1] = (intptr_t) SCARG(p, tp); /* struct linux_timespec * */
		*n_args = 2;
		break;
	}
	/* linux_sys_clock_nanosleep */
	case 230: {
		const struct linux_sys_clock_nanosleep_args *p = params;
		iarg[0] = SCARG(p, which); /* clockid_t */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, rqtp); /* struct linux_timespec * */
		uarg[3] = (intptr_t) SCARG(p, rmtp); /* struct linux_timespec * */
		*n_args = 4;
		break;
	}
	/* linux_sys_exit_group */
	case 231: {
		const struct linux_sys_exit_group_args *p = params;
		iarg[0] = SCARG(p, error_code); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_epoll_wait */
	case 232: {
		const struct linux_sys_epoll_wait_args *p = params;
		iarg[0] = SCARG(p, epfd); /* int */
		uarg[1] = (intptr_t) SCARG(p, events); /* struct linux_epoll_event * */
		iarg[2] = SCARG(p, maxevents); /* int */
		iarg[3] = SCARG(p, timeout); /* int */
		*n_args = 4;
		break;
	}
	/* linux_sys_epoll_ctl */
	case 233: {
		const struct linux_sys_epoll_ctl_args *p = params;
		iarg[0] = SCARG(p, epfd); /* int */
		iarg[1] = SCARG(p, op); /* int */
		iarg[2] = SCARG(p, fd); /* int */
		uarg[3] = (intptr_t) SCARG(p, event); /* struct linux_epoll_event * */
		*n_args = 4;
		break;
	}
	/* linux_sys_tgkill */
	case 234: {
		const struct linux_sys_tgkill_args *p = params;
		iarg[0] = SCARG(p, tgid); /* int */
		iarg[1] = SCARG(p, tid); /* int */
		iarg[2] = SCARG(p, sig); /* int */
		*n_args = 3;
		break;
	}
	/* compat_50_sys_utimes */
	case 235: {
		const struct compat_50_sys_utimes_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[1] = (intptr_t) SCARG(p, tptr); /* const struct timeval50 * */
		*n_args = 2;
		break;
	}
	/* linux_sys_mq_open */
	case 240: {
		const struct linux_sys_mq_open_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* const char * */
		iarg[1] = SCARG(p, oflag); /* int */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		uarg[3] = (intptr_t) SCARG(p, attr); /* struct linux_mq_attr * */
		*n_args = 4;
		break;
	}
	/* linux_sys_mq_unlink */
	case 241: {
		const struct linux_sys_mq_unlink_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* const char * */
		*n_args = 1;
		break;
	}
	/* linux_sys_mq_timedsend */
	case 242: {
		const struct linux_sys_mq_timedsend_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* linux_mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr); /* const char * */
		uarg[2] = SCARG(p, msg_len); /* size_t */
		uarg[3] = SCARG(p, msg_prio); /* unsigned int */
		uarg[4] = (intptr_t) SCARG(p, abs_timeout); /* const struct linux_timespec * */
		*n_args = 5;
		break;
	}
	/* linux_sys_mq_timedreceive */
	case 243: {
		const struct linux_sys_mq_timedreceive_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* linux_mqd_t */
		uarg[1] = (intptr_t) SCARG(p, msg_ptr); /* char * */
		uarg[2] = SCARG(p, msg_len); /* size_t */
		uarg[3] = (intptr_t) SCARG(p, msg_prio); /* unsigned int * */
		uarg[4] = (intptr_t) SCARG(p, abs_timeout); /* const struct linux_timespec * */
		*n_args = 5;
		break;
	}
	/* linux_sys_mq_notify */
	case 244: {
		const struct linux_sys_mq_notify_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* linux_mqd_t */
		uarg[1] = (intptr_t) SCARG(p, sevp); /* const struct linux_sigevent * */
		*n_args = 2;
		break;
	}
	/* linux_sys_mq_getsetattr */
	case 245: {
		const struct linux_sys_mq_getsetattr_args *p = params;
		iarg[0] = SCARG(p, mqdes); /* linux_mqd_t */
		uarg[1] = (intptr_t) SCARG(p, newattr); /* const struct linux_mq_attr * */
		uarg[2] = (intptr_t) SCARG(p, oldattr); /* struct linux_mq_attr * */
		*n_args = 3;
		break;
	}
	/* linux_sys_waitid */
	case 247: {
		const struct linux_sys_waitid_args *p = params;
		iarg[0] = SCARG(p, idtype); /* int */
		iarg[1] = SCARG(p, id); /* id_t */
		uarg[2] = (intptr_t) SCARG(p, infop); /* linux_siginfo_t * */
		iarg[3] = SCARG(p, options); /* int */
		uarg[4] = (intptr_t) SCARG(p, rusage); /* struct rusage50 * */
		*n_args = 5;
		break;
	}
	/* linux_sys_inotify_init */
	case 253: {
		*n_args = 0;
		break;
	}
	/* linux_sys_inotify_add_watch */
	case 254: {
		const struct linux_sys_inotify_add_watch_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, pathname); /* const char * */
		uarg[2] = SCARG(p, mask); /* uint32_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_inotify_rm_watch */
	case 255: {
		const struct linux_sys_inotify_rm_watch_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, wd); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_openat */
	case 257: {
		const struct linux_sys_openat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, flags); /* int */
		iarg[3] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 4;
		break;
	}
	/* sys_mkdirat */
	case 258: {
		const struct sys_mkdirat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_mknodat */
	case 259: {
		const struct linux_sys_mknodat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		uarg[3] = SCARG(p, dev); /* unsigned */
		*n_args = 4;
		break;
	}
	/* linux_sys_fchownat */
	case 260: {
		const struct linux_sys_fchownat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = SCARG(p, owner); /* uid_t */
		iarg[3] = SCARG(p, group); /* gid_t */
		iarg[4] = SCARG(p, flag); /* int */
		*n_args = 5;
		break;
	}
	/* linux_sys_fstatat64 */
	case 262: {
		const struct linux_sys_fstatat64_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, sp); /* struct linux_stat * */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* linux_sys_unlinkat */
	case 263: {
		const struct linux_sys_unlinkat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, flag); /* int */
		*n_args = 3;
		break;
	}
	/* sys_renameat */
	case 264: {
		const struct sys_renameat_args *p = params;
		iarg[0] = SCARG(p, fromfd); /* int */
		uarg[1] = (intptr_t) SCARG(p, from); /* const char * */
		iarg[2] = SCARG(p, tofd); /* int */
		uarg[3] = (intptr_t) SCARG(p, to); /* const char * */
		*n_args = 4;
		break;
	}
	/* linux_sys_linkat */
	case 265: {
		const struct linux_sys_linkat_args *p = params;
		iarg[0] = SCARG(p, fd1); /* int */
		uarg[1] = (intptr_t) SCARG(p, name1); /* const char * */
		iarg[2] = SCARG(p, fd2); /* int */
		uarg[3] = (intptr_t) SCARG(p, name2); /* const char * */
		iarg[4] = SCARG(p, flags); /* int */
		*n_args = 5;
		break;
	}
	/* sys_symlinkat */
	case 266: {
		const struct sys_symlinkat_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, path1); /* const char * */
		iarg[1] = SCARG(p, fd); /* int */
		uarg[2] = (intptr_t) SCARG(p, path2); /* const char * */
		*n_args = 3;
		break;
	}
	/* sys_readlinkat */
	case 267: {
		const struct sys_readlinkat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, buf); /* char * */
		uarg[3] = SCARG(p, bufsize); /* size_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_fchmodat */
	case 268: {
		const struct linux_sys_fchmodat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, mode); /* linux_umode_t */
		*n_args = 3;
		break;
	}
	/* linux_sys_faccessat */
	case 269: {
		const struct linux_sys_faccessat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, amode); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_pselect6 */
	case 270: {
		const struct linux_sys_pselect6_args *p = params;
		iarg[0] = SCARG(p, nfds); /* int */
		uarg[1] = (intptr_t) SCARG(p, readfds); /* fd_set * */
		uarg[2] = (intptr_t) SCARG(p, writefds); /* fd_set * */
		uarg[3] = (intptr_t) SCARG(p, exceptfds); /* fd_set * */
		uarg[4] = (intptr_t) SCARG(p, timeout); /* struct linux_timespec * */
		uarg[5] = (intptr_t) SCARG(p, ss); /* linux_sized_sigset_t * */
		*n_args = 6;
		break;
	}
	/* linux_sys_ppoll */
	case 271: {
		const struct linux_sys_ppoll_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, fds); /* struct pollfd * */
		uarg[1] = SCARG(p, nfds); /* u_int */
		uarg[2] = (intptr_t) SCARG(p, timeout); /* struct linux_timespec * */
		uarg[3] = (intptr_t) SCARG(p, sigset); /* linux_sigset_t * */
		*n_args = 4;
		break;
	}
	/* sys___futex_set_robust_list */
	case 273: {
		const struct sys___futex_set_robust_list_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, head); /* void * */
		uarg[1] = SCARG(p, len); /* size_t */
		*n_args = 2;
		break;
	}
	/* sys___futex_get_robust_list */
	case 274: {
		const struct sys___futex_get_robust_list_args *p = params;
		iarg[0] = SCARG(p, lwpid); /* lwpid_t */
		uarg[1] = (intptr_t) SCARG(p, headp); /* void ** */
		uarg[2] = (intptr_t) SCARG(p, lenp); /* size_t * */
		*n_args = 3;
		break;
	}
	/* linux_sys_sync_file_range */
	case 277: {
		const struct linux_sys_sync_file_range_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, offset); /* off_t */
		iarg[2] = SCARG(p, nbytes); /* off_t */
		uarg[3] = SCARG(p, flags); /* unsigned int */
		*n_args = 4;
		break;
	}
	/* linux_sys_utimensat */
	case 280: {
		const struct linux_sys_utimensat_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		uarg[2] = (intptr_t) SCARG(p, times); /* struct linux_timespec * */
		iarg[3] = SCARG(p, flag); /* int */
		*n_args = 4;
		break;
	}
	/* linux_sys_epoll_pwait */
	case 281: {
		const struct linux_sys_epoll_pwait_args *p = params;
		iarg[0] = SCARG(p, epfd); /* int */
		uarg[1] = (intptr_t) SCARG(p, events); /* struct linux_epoll_event * */
		iarg[2] = SCARG(p, maxevents); /* int */
		iarg[3] = SCARG(p, timeout); /* int */
		uarg[4] = (intptr_t) SCARG(p, sigmask); /* const linux_sigset_t * */
		*n_args = 5;
		break;
	}
	/* linux_sys_timerfd_create */
	case 283: {
		const struct linux_sys_timerfd_create_args *p = params;
		iarg[0] = SCARG(p, clock_id); /* clockid_t */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_eventfd */
	case 284: {
		const struct linux_sys_eventfd_args *p = params;
		uarg[0] = SCARG(p, initval); /* unsigned int */
		*n_args = 1;
		break;
	}
	/* linux_sys_fallocate */
	case 285: {
		const struct linux_sys_fallocate_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, mode); /* int */
		iarg[2] = SCARG(p, offset); /* off_t */
		iarg[3] = SCARG(p, len); /* off_t */
		*n_args = 4;
		break;
	}
	/* linux_sys_timerfd_settime */
	case 286: {
		const struct linux_sys_timerfd_settime_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		iarg[1] = SCARG(p, flags); /* int */
		uarg[2] = (intptr_t) SCARG(p, tim); /* const struct linux_itimerspec * */
		uarg[3] = (intptr_t) SCARG(p, otim); /* struct linux_itimerspec * */
		*n_args = 4;
		break;
	}
	/* linux_sys_timerfd_gettime */
	case 287: {
		const struct linux_sys_timerfd_gettime_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, tim); /* struct linux_itimerspec * */
		*n_args = 2;
		break;
	}
	/* linux_sys_accept4 */
	case 288: {
		const struct linux_sys_accept4_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, name); /* struct osockaddr * */
		uarg[2] = (intptr_t) SCARG(p, anamelen); /* int * */
		iarg[3] = SCARG(p, flags); /* int */
		*n_args = 4;
		break;
	}
	/* linux_sys_eventfd2 */
	case 290: {
		const struct linux_sys_eventfd2_args *p = params;
		uarg[0] = SCARG(p, initval); /* unsigned int */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_epoll_create1 */
	case 291: {
		const struct linux_sys_epoll_create1_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_dup3 */
	case 292: {
		const struct linux_sys_dup3_args *p = params;
		iarg[0] = SCARG(p, from); /* int */
		iarg[1] = SCARG(p, to); /* int */
		iarg[2] = SCARG(p, flags); /* int */
		*n_args = 3;
		break;
	}
	/* linux_sys_pipe2 */
	case 293: {
		const struct linux_sys_pipe2_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, pfds); /* int * */
		iarg[1] = SCARG(p, flags); /* int */
		*n_args = 2;
		break;
	}
	/* linux_sys_inotify_init1 */
	case 294: {
		const struct linux_sys_inotify_init1_args *p = params;
		iarg[0] = SCARG(p, flags); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_preadv */
	case 295: {
		const struct linux_sys_preadv_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp); /* const struct iovec * */
		iarg[2] = SCARG(p, iovcnt); /* int */
		uarg[3] = SCARG(p, off_lo); /* unsigned long */
		uarg[4] = SCARG(p, off_hi); /* unsigned long */
		*n_args = 5;
		break;
	}
	/* linux_sys_pwritev */
	case 296: {
		const struct linux_sys_pwritev_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, iovp); /* const struct iovcnt * */
		iarg[2] = SCARG(p, iovcnt); /* int */
		uarg[3] = SCARG(p, off_lo); /* unsigned long */
		uarg[4] = SCARG(p, off_hi); /* unsigned long */
		*n_args = 5;
		break;
	}
	/* linux_sys_recvmmsg */
	case 299: {
		const struct linux_sys_recvmmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msgvec); /* struct linux_mmsghdr * */
		uarg[2] = SCARG(p, vlen); /* unsigned int */
		uarg[3] = SCARG(p, flags); /* unsigned int */
		uarg[4] = (intptr_t) SCARG(p, timeout); /* struct timespec * */
		*n_args = 5;
		break;
	}
	/* linux_sys_prlimit64 */
	case 302: {
		const struct linux_sys_prlimit64_args *p = params;
		iarg[0] = SCARG(p, pid); /* pid_t */
		iarg[1] = SCARG(p, which); /* int */
		uarg[2] = (intptr_t) SCARG(p, new_rlp); /* struct rlimit * */
		uarg[3] = (intptr_t) SCARG(p, old_rlp); /* struct rlimit * */
		*n_args = 4;
		break;
	}
	/* linux_sys_syncfs */
	case 306: {
		const struct linux_sys_syncfs_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		*n_args = 1;
		break;
	}
	/* linux_sys_sendmmsg */
	case 307: {
		const struct linux_sys_sendmmsg_args *p = params;
		iarg[0] = SCARG(p, s); /* int */
		uarg[1] = (intptr_t) SCARG(p, msgvec); /* struct linux_mmsghdr * */
		uarg[2] = SCARG(p, vlen); /* unsigned int */
		uarg[3] = SCARG(p, flags); /* unsigned int */
		*n_args = 4;
		break;
	}
	/* linux_sys_getcpu */
	case 309: {
		const struct linux_sys_getcpu_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, cpu); /* unsigned int * */
		uarg[1] = (intptr_t) SCARG(p, node); /* unsigned int * */
		uarg[2] = (intptr_t) SCARG(p, tcache); /* struct linux_getcpu_cache * */
		*n_args = 3;
		break;
	}
	/* linux_sys_renameat2 */
	case 316: {
		const struct linux_sys_renameat2_args *p = params;
		iarg[0] = SCARG(p, fromfd); /* int */
		uarg[1] = (intptr_t) SCARG(p, from); /* const char * */
		iarg[2] = SCARG(p, tofd); /* int */
		uarg[3] = (intptr_t) SCARG(p, to); /* const char * */
		uarg[4] = SCARG(p, flags); /* unsigned int */
		*n_args = 5;
		break;
	}
	/* sys_getrandom */
	case 318: {
		const struct sys_getrandom_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, buf); /* void * */
		uarg[1] = SCARG(p, buflen); /* size_t */
		uarg[2] = SCARG(p, flags); /* unsigned int */
		*n_args = 3;
		break;
	}
	/* linux_sys_memfd_create */
	case 319: {
		const struct linux_sys_memfd_create_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, name); /* const char * */
		uarg[1] = SCARG(p, flags); /* unsigned int */
		*n_args = 2;
		break;
	}
	/* linux_sys_copy_file_range */
	case 326: {
		const struct linux_sys_copy_file_range_args *p = params;
		iarg[0] = SCARG(p, fd_in); /* int */
		uarg[1] = (intptr_t) SCARG(p, off_in); /* off_t * */
		iarg[2] = SCARG(p, fd_out); /* int */
		uarg[3] = (intptr_t) SCARG(p, off_out); /* off_t * */
		uarg[4] = SCARG(p, len); /* size_t */
		uarg[5] = SCARG(p, flags); /* unsigned int */
		*n_args = 6;
		break;
	}
	/* linux_sys_statx */
	case 332: {
		const struct linux_sys_statx_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, flag); /* int */
		uarg[3] = SCARG(p, mask); /* unsigned int */
		uarg[4] = (intptr_t) SCARG(p, sp); /* struct linux_statx * */
		*n_args = 5;
		break;
	}
	/* linux_sys_clone3 */
	case 435: {
		const struct linux_sys_clone3_args *p = params;
		uarg[0] = (intptr_t) SCARG(p, cl_args); /* struct linux_user_clone3_args * */
		uarg[1] = SCARG(p, size); /* size_t */
		*n_args = 2;
		break;
	}
	/* linux_sys_close_range */
	case 436: {
		const struct linux_sys_close_range_args *p = params;
		uarg[0] = SCARG(p, first); /* unsigned int */
		uarg[1] = SCARG(p, last); /* unsigned int */
		uarg[2] = SCARG(p, flags); /* unsigned int */
		*n_args = 3;
		break;
	}
	/* linux_sys_faccessat2 */
	case 439: {
		const struct linux_sys_faccessat2_args *p = params;
		iarg[0] = SCARG(p, fd); /* int */
		uarg[1] = (intptr_t) SCARG(p, path); /* const char * */
		iarg[2] = SCARG(p, amode); /* int */
		iarg[3] = SCARG(p, flags); /* int */
		*n_args = 4;
		break;
	}
	/* linux_sys_epoll_pwait2 */
	case 441: {
		const struct linux_sys_epoll_pwait2_args *p = params;
		iarg[0] = SCARG(p, epfd); /* int */
		uarg[1] = (intptr_t) SCARG(p, events); /* struct linux_epoll_event * */
		iarg[2] = SCARG(p, maxevents); /* int */
		uarg[3] = (intptr_t) SCARG(p, timeout); /* const struct linux_timespec * */
		uarg[4] = (intptr_t) SCARG(p, sigmask); /* const linux_sigset_t * */
		*n_args = 5;
		break;
	}
	/* linux_sys_nosys */
	case 451: {
		*n_args = 0;
		break;
	}
	default:
		*n_args = 0;
		break;
	};
}
static void
systrace_entry_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
	/* sys_read */
	case 0:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_write */
	case 1:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const void *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_open */
	case 2:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_close */
	case 3:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_stat64 */
	case 4:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct linux_stat64 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fstat64 */
	case 5:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_stat64 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_lstat64 */
	case 6:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct linux_stat64 *";
			break;
		default:
			break;
		};
		break;
	/* sys_poll */
	case 7:
		switch(ndx) {
		case 0:
			p = "struct pollfd *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* compat_43_sys_lseek */
	case 8:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "long";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mmap */
	case 9:
		switch(ndx) {
		case 0:
			p = "unsigned long";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "int";
			break;
		case 5:
			p = "linux_off_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mprotect */
	case 10:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		case 1:
			p = "unsigned long";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_munmap */
	case 11:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_brk */
	case 12:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_sigaction */
	case 13:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct linux_sigaction *";
			break;
		case 2:
			p = "struct linux_sigaction *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_sigprocmask */
	case 14:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const linux_sigset_t *";
			break;
		case 2:
			p = "linux_sigset_t *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_sigreturn */
	case 15:
		break;
	/* linux_sys_ioctl */
	case 16:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "u_long";
			break;
		case 2:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pread */
	case 17:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pwrite */
	case 18:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* sys_readv */
	case 19:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct iovec *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_writev */
	case 20:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct iovec *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_access */
	case 21:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pipe */
	case 22:
		switch(ndx) {
		case 0:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_select */
	case 23:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "fd_set *";
			break;
		case 2:
			p = "fd_set *";
			break;
		case 3:
			p = "fd_set *";
			break;
		case 4:
			p = "struct timeval50 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_yield */
	case 24:
		break;
	/* linux_sys_mremap */
	case 25:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "u_long";
			break;
		default:
			break;
		};
		break;
	/* sys___msync13 */
	case 26:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_mincore */
	case 27:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* sys_madvise */
	case 28:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
#ifdef SYSVSHM
	/* linux_sys_shmget */
	case 29:
		switch(ndx) {
		case 0:
			p = "key_t";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_shmat */
	case 30:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_shmctl */
	case 31:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct linux_shmid_ds *";
			break;
		default:
			break;
		};
		break;
#else
#endif
	/* sys_dup */
	case 32:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_dup2 */
	case 33:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pause */
	case 34:
		break;
	/* linux_sys_nanosleep */
	case 35:
		switch(ndx) {
		case 0:
			p = "const struct linux_timespec *";
			break;
		case 1:
			p = "struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* compat_50_sys_getitimer */
	case 36:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct itimerval50 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_alarm */
	case 37:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* compat_50_sys_setitimer */
	case 38:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct itimerval50 *";
			break;
		case 2:
			p = "struct itimerval50 *";
			break;
		default:
			break;
		};
		break;
	/* sys_getpid */
	case 39:
		break;
	/* linux_sys_socket */
	case 41:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_connect */
	case 42:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct osockaddr *";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_accept */
	case 43:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct osockaddr *";
			break;
		case 2:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sendto */
	case 44:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "struct osockaddr *";
			break;
		case 5:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_recvfrom */
	case 45:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "struct osockaddr *";
			break;
		case 5:
			p = "unsigned int *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sendmsg */
	case 46:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct linux_msghdr *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_recvmsg */
	case 47:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_msghdr *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_shutdown */
	case 48:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_bind */
	case 49:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct osockaddr *";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* sys_listen */
	case 50:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getsockname */
	case 51:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getpeername */
	case 52:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct sockaddr *";
			break;
		case 2:
			p = "unsigned int *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_socketpair */
	case 53:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setsockopt */
	case 54:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getsockopt */
	case 55:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_clone */
	case 56:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "void *";
			break;
		case 4:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys_fork */
	case 57:
		break;
	/* sys___vfork14 */
	case 58:
		break;
	/* sys_execve */
	case 59:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "char **";
			break;
		case 2:
			p = "char **";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_exit */
	case 60:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_wait4 */
	case 61:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "struct rusage50 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_kill */
	case 62:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_uname */
	case 63:
		switch(ndx) {
		case 0:
			p = "struct linux_utsname *";
			break;
		default:
			break;
		};
		break;
#ifdef SYSVSEM
	/* sys_semget */
	case 64:
		switch(ndx) {
		case 0:
			p = "key_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_semop */
	case 65:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct sembuf *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_semctl */
	case 66:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "union linux_semun";
			break;
		default:
			break;
		};
		break;
#else
#endif
#ifdef SYSVSHM
	/* sys_shmdt */
	case 67:
		switch(ndx) {
		case 0:
			p = "const void *";
			break;
		default:
			break;
		};
		break;
#else
#endif
#ifdef SYSVMSG
	/* sys_msgget */
	case 68:
		switch(ndx) {
		case 0:
			p = "key_t";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_msgsnd */
	case 69:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_msgrcv */
	case 70:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "long";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_msgctl */
	case 71:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct linux_msqid_ds *";
			break;
		default:
			break;
		};
		break;
#else
#endif
	/* linux_sys_fcntl */
	case 72:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* sys_flock */
	case 73:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_fsync */
	case 74:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fdatasync */
	case 75:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_truncate64 */
	case 76:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_ftruncate64 */
	case 77:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		case 1:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getdents */
	case 78:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_dirent *";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* sys___getcwd */
	case 79:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_chdir */
	case 80:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_fchdir */
	case 81:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_rename */
	case 82:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_mkdir */
	case 83:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_rmdir */
	case 84:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_creat */
	case 85:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_link */
	case 86:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_unlink */
	case 87:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_symlink */
	case 88:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_readlink */
	case 89:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_chmod */
	case 90:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_fchmod */
	case 91:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_chown */
	case 92:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_fchown */
	case 93:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys___posix_lchown */
	case 94:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_umask */
	case 95:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_gettimeofday */
	case 96:
		switch(ndx) {
		case 0:
			p = "struct timeval50 *";
			break;
		case 1:
			p = "struct timezone *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getrlimit */
	case 97:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct rlimit *";
			break;
		default:
			break;
		};
		break;
	/* compat_50_sys_getrusage */
	case 98:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct rusage50 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sysinfo */
	case 99:
		switch(ndx) {
		case 0:
			p = "struct linux_sysinfo *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_times */
	case 100:
		switch(ndx) {
		case 0:
			p = "struct times *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_ptrace */
	case 101:
		switch(ndx) {
		case 0:
			p = "long";
			break;
		case 1:
			p = "long";
			break;
		case 2:
			p = "long";
			break;
		case 3:
			p = "long";
			break;
		default:
			break;
		};
		break;
	/* sys_getuid */
	case 102:
		break;
	/* sys_getgid */
	case 104:
		break;
	/* sys_setuid */
	case 105:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_setgid */
	case 106:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_geteuid */
	case 107:
		break;
	/* sys_getegid */
	case 108:
		break;
	/* sys_setpgid */
	case 109:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_getppid */
	case 110:
		break;
	/* sys_getpgrp */
	case 111:
		break;
	/* sys_setsid */
	case 112:
		break;
	/* sys_setreuid */
	case 113:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		case 1:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_setregid */
	case 114:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		case 1:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getgroups */
	case 115:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "gid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_setgroups */
	case 116:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "gid_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setresuid */
	case 117:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		case 1:
			p = "uid_t";
			break;
		case 2:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getresuid */
	case 118:
		switch(ndx) {
		case 0:
			p = "uid_t *";
			break;
		case 1:
			p = "uid_t *";
			break;
		case 2:
			p = "uid_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setresgid */
	case 119:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		case 1:
			p = "gid_t";
			break;
		case 2:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getresgid */
	case 120:
		switch(ndx) {
		case 0:
			p = "gid_t *";
			break;
		case 1:
			p = "gid_t *";
			break;
		case 2:
			p = "gid_t *";
			break;
		default:
			break;
		};
		break;
	/* sys_getpgid */
	case 121:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setfsuid */
	case 122:
		switch(ndx) {
		case 0:
			p = "uid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setfsgid */
	case 123:
		switch(ndx) {
		case 0:
			p = "gid_t";
			break;
		default:
			break;
		};
		break;
	/* sys_getsid */
	case 124:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_sigpending */
	case 127:
		switch(ndx) {
		case 0:
			p = "linux_sigset_t *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_sigtimedwait */
	case 128:
		switch(ndx) {
		case 0:
			p = "const linux_sigset_t *";
			break;
		case 1:
			p = "linux_siginfo_t *";
			break;
		case 2:
			p = "const struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_queueinfo */
	case 129:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "linux_siginfo_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_rt_sigsuspend */
	case 130:
		switch(ndx) {
		case 0:
			p = "linux_sigset_t *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sigaltstack */
	case 131:
		switch(ndx) {
		case 0:
			p = "const struct linux_sigaltstack *";
			break;
		case 1:
			p = "struct linux_sigaltstack *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_utime */
	case 132:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct linux_utimbuf *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mknod */
	case 133:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "linux_umode_t";
			break;
		case 2:
			p = "unsigned";
			break;
		default:
			break;
		};
		break;
#ifdef EXEC_AOUT
	/* linux_sys_uselib */
	case 134:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
#else
#endif
	/* linux_sys_personality */
	case 135:
		switch(ndx) {
		case 0:
			p = "unsigned long";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_statfs */
	case 137:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "struct linux_statfs *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fstatfs */
	case 138:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_statfs *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getpriority */
	case 140:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_setpriority */
	case 141:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_setparam */
	case 142:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "const struct linux_sched_param *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_getparam */
	case 143:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "struct linux_sched_param *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_setscheduler */
	case 144:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const struct linux_sched_param *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_getscheduler */
	case 145:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_get_priority_max */
	case 146:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_get_priority_min */
	case 147:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_mlock */
	case 149:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_munlock */
	case 150:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys_mlockall */
	case 151:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_munlockall */
	case 152:
		break;
	/* linux_sys_modify_ldt */
	case 154:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "void *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys___sysctl */
	case 156:
		switch(ndx) {
		case 0:
			p = "struct linux___sysctl *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_arch_prctl */
	case 158:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "unsigned long";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setrlimit */
	case 160:
		switch(ndx) {
		case 0:
			p = "u_int";
			break;
		case 1:
			p = "struct rlimit *";
			break;
		default:
			break;
		};
		break;
	/* sys_chroot */
	case 161:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* sys_sync */
	case 162:
		break;
	/* sys_acct */
	case 163:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_settimeofday */
	case 164:
		switch(ndx) {
		case 0:
			p = "struct timeval50 *";
			break;
		case 1:
			p = "struct timezone *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_swapon */
	case 167:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_swapoff */
	case 168:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_reboot */
	case 169:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "void *";
			break;
		default:
			break;
		};
		break;
	/* compat_43_sys_sethostname */
	case 170:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "u_int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setdomainname */
	case 171:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_iopl */
	case 172:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_ioperm */
	case 173:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_gettid */
	case 186:
		break;
	/* linux_sys_readahead */
	case 187:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "off_t";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_setxattr */
	case 188:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_lsetxattr */
	case 189:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fsetxattr */
	case 190:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getxattr */
	case 191:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_lgetxattr */
	case 192:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fgetxattr */
	case 193:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "void *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_listxattr */
	case 194:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_llistxattr */
	case 195:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_flistxattr */
	case 196:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_removexattr */
	case 197:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_lremovexattr */
	case 198:
		switch(ndx) {
		case 0:
			p = "char *";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fremovexattr */
	case 199:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_tkill */
	case 200:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_time */
	case 201:
		switch(ndx) {
		case 0:
			p = "linux_time_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_futex */
	case 202:
		switch(ndx) {
		case 0:
			p = "int *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const struct linux_timespec *";
			break;
		case 4:
			p = "int *";
			break;
		case 5:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_setaffinity */
	case 203:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "unsigned long *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sched_getaffinity */
	case 204:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "unsigned long *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_epoll_create */
	case 213:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getdents64 */
	case 217:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_dirent64 *";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_set_tid_address */
	case 218:
		switch(ndx) {
		case 0:
			p = "int *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fadvise64 */
	case 221:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "off_t";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_timer_create */
	case 222:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct linux_sigevent *";
			break;
		case 2:
			p = "timer_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_timer_settime */
	case 223:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const struct linux_itimerspec *";
			break;
		case 3:
			p = "struct linux_itimerspec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_timer_gettime */
	case 224:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		case 1:
			p = "struct linux_itimerspec *";
			break;
		default:
			break;
		};
		break;
	/* sys_timer_getoverrun */
	case 225:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		default:
			break;
		};
		break;
	/* sys_timer_delete */
	case 226:
		switch(ndx) {
		case 0:
			p = "timer_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_clock_settime */
	case 227:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_clock_gettime */
	case 228:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_clock_getres */
	case 229:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_clock_nanosleep */
	case 230:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct linux_timespec *";
			break;
		case 3:
			p = "struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_exit_group */
	case 231:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_epoll_wait */
	case 232:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_epoll_event *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_epoll_ctl */
	case 233:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "struct linux_epoll_event *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_tgkill */
	case 234:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* compat_50_sys_utimes */
	case 235:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "const struct timeval50 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mq_open */
	case 240:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		case 3:
			p = "struct linux_mq_attr *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mq_unlink */
	case 241:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mq_timedsend */
	case 242:
		switch(ndx) {
		case 0:
			p = "linux_mqd_t";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "unsigned int";
			break;
		case 4:
			p = "const struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mq_timedreceive */
	case 243:
		switch(ndx) {
		case 0:
			p = "linux_mqd_t";
			break;
		case 1:
			p = "char *";
			break;
		case 2:
			p = "size_t";
			break;
		case 3:
			p = "unsigned int *";
			break;
		case 4:
			p = "const struct linux_timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mq_notify */
	case 244:
		switch(ndx) {
		case 0:
			p = "linux_mqd_t";
			break;
		case 1:
			p = "const struct linux_sigevent *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mq_getsetattr */
	case 245:
		switch(ndx) {
		case 0:
			p = "linux_mqd_t";
			break;
		case 1:
			p = "const struct linux_mq_attr *";
			break;
		case 2:
			p = "struct linux_mq_attr *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_waitid */
	case 247:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "id_t";
			break;
		case 2:
			p = "linux_siginfo_t *";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "struct rusage50 *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_inotify_init */
	case 253:
		break;
	/* linux_sys_inotify_add_watch */
	case 254:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "uint32_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_inotify_rm_watch */
	case 255:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_openat */
	case 257:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* sys_mkdirat */
	case 258:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_mknodat */
	case 259:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		case 3:
			p = "unsigned";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fchownat */
	case 260:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "uid_t";
			break;
		case 3:
			p = "gid_t";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fstatat64 */
	case 262:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "struct linux_stat *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_unlinkat */
	case 263:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_renameat */
	case 264:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_linkat */
	case 265:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const char *";
			break;
		case 4:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* sys_symlinkat */
	case 266:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const char *";
			break;
		default:
			break;
		};
		break;
	/* sys_readlinkat */
	case 267:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "char *";
			break;
		case 3:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fchmodat */
	case 268:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "linux_umode_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_faccessat */
	case 269:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pselect6 */
	case 270:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "fd_set *";
			break;
		case 2:
			p = "fd_set *";
			break;
		case 3:
			p = "fd_set *";
			break;
		case 4:
			p = "struct linux_timespec *";
			break;
		case 5:
			p = "linux_sized_sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_ppoll */
	case 271:
		switch(ndx) {
		case 0:
			p = "struct pollfd *";
			break;
		case 1:
			p = "u_int";
			break;
		case 2:
			p = "struct linux_timespec *";
			break;
		case 3:
			p = "linux_sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* sys___futex_set_robust_list */
	case 273:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* sys___futex_get_robust_list */
	case 274:
		switch(ndx) {
		case 0:
			p = "lwpid_t";
			break;
		case 1:
			p = "void **";
			break;
		case 2:
			p = "size_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sync_file_range */
	case 277:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "off_t";
			break;
		case 2:
			p = "off_t";
			break;
		case 3:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_utimensat */
	case 280:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "struct linux_timespec *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_epoll_pwait */
	case 281:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_epoll_event *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		case 4:
			p = "const linux_sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_timerfd_create */
	case 283:
		switch(ndx) {
		case 0:
			p = "clockid_t";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_eventfd */
	case 284:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_fallocate */
	case 285:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "off_t";
			break;
		case 3:
			p = "off_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_timerfd_settime */
	case 286:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "const struct linux_itimerspec *";
			break;
		case 3:
			p = "struct linux_itimerspec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_timerfd_gettime */
	case 287:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_itimerspec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_accept4 */
	case 288:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct osockaddr *";
			break;
		case 2:
			p = "int *";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_eventfd2 */
	case 290:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_epoll_create1 */
	case 291:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_dup3 */
	case 292:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pipe2 */
	case 293:
		switch(ndx) {
		case 0:
			p = "int *";
			break;
		case 1:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_inotify_init1 */
	case 294:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_preadv */
	case 295:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct iovec *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "unsigned long";
			break;
		case 4:
			p = "unsigned long";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_pwritev */
	case 296:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const struct iovcnt *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "unsigned long";
			break;
		case 4:
			p = "unsigned long";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_recvmmsg */
	case 299:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_mmsghdr *";
			break;
		case 2:
			p = "unsigned int";
			break;
		case 3:
			p = "unsigned int";
			break;
		case 4:
			p = "struct timespec *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_prlimit64 */
	case 302:
		switch(ndx) {
		case 0:
			p = "pid_t";
			break;
		case 1:
			p = "int";
			break;
		case 2:
			p = "struct rlimit *";
			break;
		case 3:
			p = "struct rlimit *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_syncfs */
	case 306:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_sendmmsg */
	case 307:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_mmsghdr *";
			break;
		case 2:
			p = "unsigned int";
			break;
		case 3:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_getcpu */
	case 309:
		switch(ndx) {
		case 0:
			p = "unsigned int *";
			break;
		case 1:
			p = "unsigned int *";
			break;
		case 2:
			p = "struct linux_getcpu_cache *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_renameat2 */
	case 316:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const char *";
			break;
		case 4:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* sys_getrandom */
	case 318:
		switch(ndx) {
		case 0:
			p = "void *";
			break;
		case 1:
			p = "size_t";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_memfd_create */
	case 319:
		switch(ndx) {
		case 0:
			p = "const char *";
			break;
		case 1:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_copy_file_range */
	case 326:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "off_t *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "off_t *";
			break;
		case 4:
			p = "size_t";
			break;
		case 5:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_statx */
	case 332:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "unsigned int";
			break;
		case 4:
			p = "struct linux_statx *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_clone3 */
	case 435:
		switch(ndx) {
		case 0:
			p = "struct linux_user_clone3_args *";
			break;
		case 1:
			p = "size_t";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_close_range */
	case 436:
		switch(ndx) {
		case 0:
			p = "unsigned int";
			break;
		case 1:
			p = "unsigned int";
			break;
		case 2:
			p = "unsigned int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_faccessat2 */
	case 439:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "const char *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "int";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_epoll_pwait2 */
	case 441:
		switch(ndx) {
		case 0:
			p = "int";
			break;
		case 1:
			p = "struct linux_epoll_event *";
			break;
		case 2:
			p = "int";
			break;
		case 3:
			p = "const struct linux_timespec *";
			break;
		case 4:
			p = "const linux_sigset_t *";
			break;
		default:
			break;
		};
		break;
	/* linux_sys_nosys */
	case 451:
		break;
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
static void
systrace_return_setargdesc(int sysnum, int ndx, char *desc, size_t descsz)
{
	const char *p = NULL;
	switch (sysnum) {
	/* sys_read */
	case 0:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_write */
	case 1:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_open */
	case 2:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_close */
	case 3:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_stat64 */
	case 4:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fstat64 */
	case 5:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_lstat64 */
	case 6:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_poll */
	case 7:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_sys_lseek */
	case 8:
		if (ndx == 0 || ndx == 1)
			p = "long";
		break;
	/* linux_sys_mmap */
	case 9:
		if (ndx == 0 || ndx == 1)
			p = "linux_off_t";
		break;
	/* linux_sys_mprotect */
	case 10:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_munmap */
	case 11:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_brk */
	case 12:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_sigaction */
	case 13:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_sigprocmask */
	case 14:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_sigreturn */
	case 15:
	/* linux_sys_ioctl */
	case 16:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pread */
	case 17:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pwrite */
	case 18:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_readv */
	case 19:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_writev */
	case 20:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_access */
	case 21:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pipe */
	case 22:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_select */
	case 23:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_yield */
	case 24:
	/* linux_sys_mremap */
	case 25:
		if (ndx == 0 || ndx == 1)
			p = "void *";
		break;
	/* sys___msync13 */
	case 26:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mincore */
	case 27:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_madvise */
	case 28:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#ifdef SYSVSHM
	/* linux_sys_shmget */
	case 29:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_shmat */
	case 30:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_shmctl */
	case 31:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
	/* sys_dup */
	case 32:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_dup2 */
	case 33:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pause */
	case 34:
	/* linux_sys_nanosleep */
	case 35:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_sys_getitimer */
	case 36:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_alarm */
	case 37:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_sys_setitimer */
	case 38:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getpid */
	case 39:
	/* linux_sys_socket */
	case 41:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_connect */
	case 42:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_accept */
	case 43:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sendto */
	case 44:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_recvfrom */
	case 45:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_sendmsg */
	case 46:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_recvmsg */
	case 47:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_shutdown */
	case 48:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_bind */
	case 49:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_listen */
	case 50:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getsockname */
	case 51:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getpeername */
	case 52:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_socketpair */
	case 53:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setsockopt */
	case 54:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getsockopt */
	case 55:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_clone */
	case 56:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fork */
	case 57:
	/* sys___vfork14 */
	case 58:
	/* sys_execve */
	case 59:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_exit */
	case 60:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_wait4 */
	case 61:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_kill */
	case 62:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_uname */
	case 63:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#ifdef SYSVSEM
	/* sys_semget */
	case 64:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_semop */
	case 65:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_semctl */
	case 66:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
#ifdef SYSVSHM
	/* sys_shmdt */
	case 67:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
#ifdef SYSVMSG
	/* sys_msgget */
	case 68:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_msgsnd */
	case 69:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_msgrcv */
	case 70:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_msgctl */
	case 71:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
	/* linux_sys_fcntl */
	case 72:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_flock */
	case 73:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fsync */
	case 74:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fdatasync */
	case 75:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_truncate64 */
	case 76:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_ftruncate64 */
	case 77:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getdents */
	case 78:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___getcwd */
	case 79:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_chdir */
	case 80:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fchdir */
	case 81:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___posix_rename */
	case 82:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mkdir */
	case 83:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_rmdir */
	case 84:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_creat */
	case 85:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_link */
	case 86:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_unlink */
	case 87:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_symlink */
	case 88:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_readlink */
	case 89:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* sys_chmod */
	case 90:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_fchmod */
	case 91:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___posix_chown */
	case 92:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___posix_fchown */
	case 93:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___posix_lchown */
	case 94:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_umask */
	case 95:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_gettimeofday */
	case 96:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getrlimit */
	case 97:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_sys_getrusage */
	case 98:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sysinfo */
	case 99:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_times */
	case 100:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_ptrace */
	case 101:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getuid */
	case 102:
	/* sys_getgid */
	case 104:
	/* sys_setuid */
	case 105:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setgid */
	case 106:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_geteuid */
	case 107:
	/* sys_getegid */
	case 108:
	/* sys_setpgid */
	case 109:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getppid */
	case 110:
	/* sys_getpgrp */
	case 111:
	/* sys_setsid */
	case 112:
	/* sys_setreuid */
	case 113:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setregid */
	case 114:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getgroups */
	case 115:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setgroups */
	case 116:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setresuid */
	case 117:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getresuid */
	case 118:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setresgid */
	case 119:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getresgid */
	case 120:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getpgid */
	case 121:
		if (ndx == 0 || ndx == 1)
			p = "pid_t";
		break;
	/* linux_sys_setfsuid */
	case 122:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setfsgid */
	case 123:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getsid */
	case 124:
		if (ndx == 0 || ndx == 1)
			p = "pid_t";
		break;
	/* linux_sys_rt_sigpending */
	case 127:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_sigtimedwait */
	case 128:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_queueinfo */
	case 129:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_rt_sigsuspend */
	case 130:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sigaltstack */
	case 131:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_utime */
	case 132:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_mknod */
	case 133:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#ifdef EXEC_AOUT
	/* linux_sys_uselib */
	case 134:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
#else
#endif
	/* linux_sys_personality */
	case 135:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_statfs */
	case 137:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fstatfs */
	case 138:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getpriority */
	case 140:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_setpriority */
	case 141:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_setparam */
	case 142:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_getparam */
	case 143:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_setscheduler */
	case 144:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_getscheduler */
	case 145:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_get_priority_max */
	case 146:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_get_priority_min */
	case 147:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mlock */
	case 149:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_munlock */
	case 150:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mlockall */
	case 151:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_munlockall */
	case 152:
	/* linux_sys_modify_ldt */
	case 154:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys___sysctl */
	case 156:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_arch_prctl */
	case 158:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setrlimit */
	case 160:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_chroot */
	case 161:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_sync */
	case 162:
	/* sys_acct */
	case 163:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_settimeofday */
	case 164:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_swapon */
	case 167:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_swapoff */
	case 168:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_reboot */
	case 169:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_43_sys_sethostname */
	case 170:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_setdomainname */
	case 171:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_iopl */
	case 172:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_ioperm */
	case 173:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_gettid */
	case 186:
	/* linux_sys_readahead */
	case 187:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_setxattr */
	case 188:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_lsetxattr */
	case 189:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fsetxattr */
	case 190:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getxattr */
	case 191:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_lgetxattr */
	case 192:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_fgetxattr */
	case 193:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_listxattr */
	case 194:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_llistxattr */
	case 195:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_flistxattr */
	case 196:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_removexattr */
	case 197:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_lremovexattr */
	case 198:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fremovexattr */
	case 199:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_tkill */
	case 200:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_time */
	case 201:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_futex */
	case 202:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_setaffinity */
	case 203:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sched_getaffinity */
	case 204:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_epoll_create */
	case 213:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getdents64 */
	case 217:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_set_tid_address */
	case 218:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fadvise64 */
	case 221:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_timer_create */
	case 222:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_timer_settime */
	case 223:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_timer_gettime */
	case 224:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_timer_getoverrun */
	case 225:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_timer_delete */
	case 226:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_clock_settime */
	case 227:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_clock_gettime */
	case 228:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_clock_getres */
	case 229:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_clock_nanosleep */
	case 230:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_exit_group */
	case 231:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_epoll_wait */
	case 232:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_epoll_ctl */
	case 233:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_tgkill */
	case 234:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* compat_50_sys_utimes */
	case 235:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_mq_open */
	case 240:
		if (ndx == 0 || ndx == 1)
			p = "linux_mqd_t";
		break;
	/* linux_sys_mq_unlink */
	case 241:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_mq_timedsend */
	case 242:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_mq_timedreceive */
	case 243:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_mq_notify */
	case 244:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_mq_getsetattr */
	case 245:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_waitid */
	case 247:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_inotify_init */
	case 253:
	/* linux_sys_inotify_add_watch */
	case 254:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_inotify_rm_watch */
	case 255:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_openat */
	case 257:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_mkdirat */
	case 258:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_mknodat */
	case 259:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fchownat */
	case 260:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fstatat64 */
	case 262:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_unlinkat */
	case 263:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_renameat */
	case 264:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_linkat */
	case 265:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_symlinkat */
	case 266:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_readlinkat */
	case 267:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_fchmodat */
	case 268:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_faccessat */
	case 269:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pselect6 */
	case 270:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_ppoll */
	case 271:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___futex_set_robust_list */
	case 273:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys___futex_get_robust_list */
	case 274:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sync_file_range */
	case 277:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_utimensat */
	case 280:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_epoll_pwait */
	case 281:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_timerfd_create */
	case 283:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_eventfd */
	case 284:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_fallocate */
	case 285:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_timerfd_settime */
	case 286:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_timerfd_gettime */
	case 287:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_accept4 */
	case 288:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_eventfd2 */
	case 290:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_epoll_create1 */
	case 291:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_dup3 */
	case 292:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pipe2 */
	case 293:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_inotify_init1 */
	case 294:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_preadv */
	case 295:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_pwritev */
	case 296:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_recvmmsg */
	case 299:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_prlimit64 */
	case 302:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_syncfs */
	case 306:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_sendmmsg */
	case 307:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_getcpu */
	case 309:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_renameat2 */
	case 316:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* sys_getrandom */
	case 318:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_memfd_create */
	case 319:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_copy_file_range */
	case 326:
		if (ndx == 0 || ndx == 1)
			p = "ssize_t";
		break;
	/* linux_sys_statx */
	case 332:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_clone3 */
	case 435:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_close_range */
	case 436:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_faccessat2 */
	case 439:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_epoll_pwait2 */
	case 441:
		if (ndx == 0 || ndx == 1)
			p = "int";
		break;
	/* linux_sys_nosys */
	case 451:
	default:
		break;
	};
	if (p != NULL)
		strlcpy(desc, p, descsz);
}
