/*	$NetBSD: oss_2_0_sh_mask.h,v 1.2 2018/08/27 04:58:22 riastradh Exp $	*/

/*
 * OSS_2_0 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef OSS_2_0_SH_MASK_H
#define OSS_2_0_SH_MASK_H

#define IH_VMID_0_LUT__PASID_MASK 0xffff
#define IH_VMID_0_LUT__PASID__SHIFT 0x0
#define IH_VMID_1_LUT__PASID_MASK 0xffff
#define IH_VMID_1_LUT__PASID__SHIFT 0x0
#define IH_VMID_2_LUT__PASID_MASK 0xffff
#define IH_VMID_2_LUT__PASID__SHIFT 0x0
#define IH_VMID_3_LUT__PASID_MASK 0xffff
#define IH_VMID_3_LUT__PASID__SHIFT 0x0
#define IH_VMID_4_LUT__PASID_MASK 0xffff
#define IH_VMID_4_LUT__PASID__SHIFT 0x0
#define IH_VMID_5_LUT__PASID_MASK 0xffff
#define IH_VMID_5_LUT__PASID__SHIFT 0x0
#define IH_VMID_6_LUT__PASID_MASK 0xffff
#define IH_VMID_6_LUT__PASID__SHIFT 0x0
#define IH_VMID_7_LUT__PASID_MASK 0xffff
#define IH_VMID_7_LUT__PASID__SHIFT 0x0
#define IH_VMID_8_LUT__PASID_MASK 0xffff
#define IH_VMID_8_LUT__PASID__SHIFT 0x0
#define IH_VMID_9_LUT__PASID_MASK 0xffff
#define IH_VMID_9_LUT__PASID__SHIFT 0x0
#define IH_VMID_10_LUT__PASID_MASK 0xffff
#define IH_VMID_10_LUT__PASID__SHIFT 0x0
#define IH_VMID_11_LUT__PASID_MASK 0xffff
#define IH_VMID_11_LUT__PASID__SHIFT 0x0
#define IH_VMID_12_LUT__PASID_MASK 0xffff
#define IH_VMID_12_LUT__PASID__SHIFT 0x0
#define IH_VMID_13_LUT__PASID_MASK 0xffff
#define IH_VMID_13_LUT__PASID__SHIFT 0x0
#define IH_VMID_14_LUT__PASID_MASK 0xffff
#define IH_VMID_14_LUT__PASID__SHIFT 0x0
#define IH_VMID_15_LUT__PASID_MASK 0xffff
#define IH_VMID_15_LUT__PASID__SHIFT 0x0
#define IH_RB_CNTL__RB_ENABLE_MASK 0x1
#define IH_RB_CNTL__RB_ENABLE__SHIFT 0x0
#define IH_RB_CNTL__RB_SIZE_MASK 0x3e
#define IH_RB_CNTL__RB_SIZE__SHIFT 0x1
#define IH_RB_CNTL__RB_FULL_DRAIN_ENABLE_MASK 0x40
#define IH_RB_CNTL__RB_FULL_DRAIN_ENABLE__SHIFT 0x6
#define IH_RB_CNTL__RB_GPU_TS_ENABLE_MASK 0x80
#define IH_RB_CNTL__RB_GPU_TS_ENABLE__SHIFT 0x7
#define IH_RB_CNTL__WPTR_WRITEBACK_ENABLE_MASK 0x100
#define IH_RB_CNTL__WPTR_WRITEBACK_ENABLE__SHIFT 0x8
#define IH_RB_CNTL__WPTR_WRITEBACK_TIMER_MASK 0x3e00
#define IH_RB_CNTL__WPTR_WRITEBACK_TIMER__SHIFT 0x9
#define IH_RB_CNTL__WPTR_OVERFLOW_ENABLE_MASK 0x10000
#define IH_RB_CNTL__WPTR_OVERFLOW_ENABLE__SHIFT 0x10
#define IH_RB_CNTL__WPTR_OVERFLOW_CLEAR_MASK 0x80000000
#define IH_RB_CNTL__WPTR_OVERFLOW_CLEAR__SHIFT 0x1f
#define IH_RB_BASE__ADDR_MASK 0xffffffff
#define IH_RB_BASE__ADDR__SHIFT 0x0
#define IH_RB_RPTR__OFFSET_MASK 0x3fffc
#define IH_RB_RPTR__OFFSET__SHIFT 0x2
#define IH_RB_WPTR__RB_OVERFLOW_MASK 0x1
#define IH_RB_WPTR__RB_OVERFLOW__SHIFT 0x0
#define IH_RB_WPTR__OFFSET_MASK 0x3fffc
#define IH_RB_WPTR__OFFSET__SHIFT 0x2
#define IH_RB_WPTR_ADDR_HI__ADDR_MASK 0xff
#define IH_RB_WPTR_ADDR_HI__ADDR__SHIFT 0x0
#define IH_RB_WPTR_ADDR_LO__ADDR_MASK 0xfffffffc
#define IH_RB_WPTR_ADDR_LO__ADDR__SHIFT 0x2
#define IH_CNTL__ENABLE_INTR_MASK 0x1
#define IH_CNTL__ENABLE_INTR__SHIFT 0x0
#define IH_CNTL__MC_SWAP_MASK 0x6
#define IH_CNTL__MC_SWAP__SHIFT 0x1
#define IH_CNTL__MC_TRAN_MASK 0x8
#define IH_CNTL__MC_TRAN__SHIFT 0x3
#define IH_CNTL__RPTR_REARM_MASK 0x10
#define IH_CNTL__RPTR_REARM__SHIFT 0x4
#define IH_CNTL__CLIENT_FIFO_HIGHWATER_MASK 0x300
#define IH_CNTL__CLIENT_FIFO_HIGHWATER__SHIFT 0x8
#define IH_CNTL__MC_FIFO_HIGHWATER_MASK 0x7c00
#define IH_CNTL__MC_FIFO_HIGHWATER__SHIFT 0xa
#define IH_CNTL__MC_WRREQ_CREDIT_MASK 0xf8000
#define IH_CNTL__MC_WRREQ_CREDIT__SHIFT 0xf
#define IH_CNTL__MC_WR_CLEAN_CNT_MASK 0x1f00000
#define IH_CNTL__MC_WR_CLEAN_CNT__SHIFT 0x14
#define IH_CNTL__MC_VMID_MASK 0x1e000000
#define IH_CNTL__MC_VMID__SHIFT 0x19
#define IH_LEVEL_STATUS__DC_STATUS_MASK 0x1
#define IH_LEVEL_STATUS__DC_STATUS__SHIFT 0x0
#define IH_LEVEL_STATUS__ROM_STATUS_MASK 0x4
#define IH_LEVEL_STATUS__ROM_STATUS__SHIFT 0x2
#define IH_LEVEL_STATUS__SRBM_STATUS_MASK 0x8
#define IH_LEVEL_STATUS__SRBM_STATUS__SHIFT 0x3
#define IH_LEVEL_STATUS__BIF_STATUS_MASK 0x10
#define IH_LEVEL_STATUS__BIF_STATUS__SHIFT 0x4
#define IH_LEVEL_STATUS__XDMA_STATUS_MASK 0x20
#define IH_LEVEL_STATUS__XDMA_STATUS__SHIFT 0x5
#define IH_STATUS__IDLE_MASK 0x1
#define IH_STATUS__IDLE__SHIFT 0x0
#define IH_STATUS__INPUT_IDLE_MASK 0x2
#define IH_STATUS__INPUT_IDLE__SHIFT 0x1
#define IH_STATUS__RB_IDLE_MASK 0x4
#define IH_STATUS__RB_IDLE__SHIFT 0x2
#define IH_STATUS__RB_FULL_MASK 0x8
#define IH_STATUS__RB_FULL__SHIFT 0x3
#define IH_STATUS__RB_FULL_DRAIN_MASK 0x10
#define IH_STATUS__RB_FULL_DRAIN__SHIFT 0x4
#define IH_STATUS__RB_OVERFLOW_MASK 0x20
#define IH_STATUS__RB_OVERFLOW__SHIFT 0x5
#define IH_STATUS__MC_WR_IDLE_MASK 0x40
#define IH_STATUS__MC_WR_IDLE__SHIFT 0x6
#define IH_STATUS__MC_WR_STALL_MASK 0x80
#define IH_STATUS__MC_WR_STALL__SHIFT 0x7
#define IH_STATUS__MC_WR_CLEAN_PENDING_MASK 0x100
#define IH_STATUS__MC_WR_CLEAN_PENDING__SHIFT 0x8
#define IH_STATUS__MC_WR_CLEAN_STALL_MASK 0x200
#define IH_STATUS__MC_WR_CLEAN_STALL__SHIFT 0x9
#define IH_STATUS__BIF_INTERRUPT_LINE_MASK 0x400
#define IH_STATUS__BIF_INTERRUPT_LINE__SHIFT 0xa
#define IH_PERFMON_CNTL__ENABLE0_MASK 0x1
#define IH_PERFMON_CNTL__ENABLE0__SHIFT 0x0
#define IH_PERFMON_CNTL__CLEAR0_MASK 0x2
#define IH_PERFMON_CNTL__CLEAR0__SHIFT 0x1
#define IH_PERFMON_CNTL__PERF_SEL0_MASK 0xfc
#define IH_PERFMON_CNTL__PERF_SEL0__SHIFT 0x2
#define IH_PERFMON_CNTL__ENABLE1_MASK 0x100
#define IH_PERFMON_CNTL__ENABLE1__SHIFT 0x8
#define IH_PERFMON_CNTL__CLEAR1_MASK 0x200
#define IH_PERFMON_CNTL__CLEAR1__SHIFT 0x9
#define IH_PERFMON_CNTL__PERF_SEL1_MASK 0xfc00
#define IH_PERFMON_CNTL__PERF_SEL1__SHIFT 0xa
#define IH_PERFCOUNTER0_RESULT__PERF_COUNT_MASK 0xffffffff
#define IH_PERFCOUNTER0_RESULT__PERF_COUNT__SHIFT 0x0
#define IH_PERFCOUNTER1_RESULT__PERF_COUNT_MASK 0xffffffff
#define IH_PERFCOUNTER1_RESULT__PERF_COUNT__SHIFT 0x0
#define IH_ADVFAULT_CNTL__WATERMARK_MASK 0x7
#define IH_ADVFAULT_CNTL__WATERMARK__SHIFT 0x0
#define IH_ADVFAULT_CNTL__WATERMARK_ENABLE_MASK 0x8
#define IH_ADVFAULT_CNTL__WATERMARK_ENABLE__SHIFT 0x3
#define IH_ADVFAULT_CNTL__WATERMARK_REACHED_MASK 0x10
#define IH_ADVFAULT_CNTL__WATERMARK_REACHED__SHIFT 0x4
#define IH_ADVFAULT_CNTL__NUM_FAULTS_DROPPED_MASK 0xff00
#define IH_ADVFAULT_CNTL__NUM_FAULTS_DROPPED__SHIFT 0x8
#define IH_ADVFAULT_CNTL__WAIT_TIMER_MASK 0x3fff0000
#define IH_ADVFAULT_CNTL__WAIT_TIMER__SHIFT 0x10
#define SEM_MCIF_CONFIG__MC_REQ_SWAP_MASK 0x3
#define SEM_MCIF_CONFIG__MC_REQ_SWAP__SHIFT 0x0
#define SEM_MCIF_CONFIG__MC_WRREQ_CREDIT_MASK 0xfc
#define SEM_MCIF_CONFIG__MC_WRREQ_CREDIT__SHIFT 0x2
#define SEM_MCIF_CONFIG__MC_RDREQ_CREDIT_MASK 0x3f00
#define SEM_MCIF_CONFIG__MC_RDREQ_CREDIT__SHIFT 0x8
#define SDMA_CONFIG__SDMA_RDREQ_URG_MASK 0xf00
#define SDMA_CONFIG__SDMA_RDREQ_URG__SHIFT 0x8
#define SDMA_CONFIG__SDMA_REQ_TRAN_MASK 0x10000
#define SDMA_CONFIG__SDMA_REQ_TRAN__SHIFT 0x10
#define SDMA1_CONFIG__SDMA_RDREQ_URG_MASK 0xf00
#define SDMA1_CONFIG__SDMA_RDREQ_URG__SHIFT 0x8
#define SDMA1_CONFIG__SDMA_REQ_TRAN_MASK 0x10000
#define SDMA1_CONFIG__SDMA_REQ_TRAN__SHIFT 0x10
#define UVD_CONFIG__UVD_RDREQ_URG_MASK 0xf00
#define UVD_CONFIG__UVD_RDREQ_URG__SHIFT 0x8
#define UVD_CONFIG__UVD_REQ_TRAN_MASK 0x10000
#define UVD_CONFIG__UVD_REQ_TRAN__SHIFT 0x10
#define VCE_CONFIG__VCE_RDREQ_URG_MASK 0xf00
#define VCE_CONFIG__VCE_RDREQ_URG__SHIFT 0x8
#define VCE_CONFIG__VCE_REQ_TRAN_MASK 0x10000
#define VCE_CONFIG__VCE_REQ_TRAN__SHIFT 0x10
#define ACP_CONFIG__ACP_RDREQ_URG_MASK 0xf00
#define ACP_CONFIG__ACP_RDREQ_URG__SHIFT 0x8
#define ACP_CONFIG__ACP_REQ_TRAN_MASK 0x10000
#define ACP_CONFIG__ACP_REQ_TRAN__SHIFT 0x10
#define CPG_CONFIG__CPG_RDREQ_URG_MASK 0xf00
#define CPG_CONFIG__CPG_RDREQ_URG__SHIFT 0x8
#define CPG_CONFIG__CPG_REQ_TRAN_MASK 0x10000
#define CPG_CONFIG__CPG_REQ_TRAN__SHIFT 0x10
#define CPC1_CONFIG__CPC1_RDREQ_URG_MASK 0xf00
#define CPC1_CONFIG__CPC1_RDREQ_URG__SHIFT 0x8
#define CPC1_CONFIG__CPC1_REQ_TRAN_MASK 0x10000
#define CPC1_CONFIG__CPC1_REQ_TRAN__SHIFT 0x10
#define CPC2_CONFIG__CPC2_RDREQ_URG_MASK 0xf00
#define CPC2_CONFIG__CPC2_RDREQ_URG__SHIFT 0x8
#define CPC2_CONFIG__CPC2_REQ_TRAN_MASK 0x10000
#define CPC2_CONFIG__CPC2_REQ_TRAN__SHIFT 0x10
#define SEM_STATUS__SEM_IDLE_MASK 0x1
#define SEM_STATUS__SEM_IDLE__SHIFT 0x0
#define SEM_STATUS__SEM_INTERNAL_IDLE_MASK 0x2
#define SEM_STATUS__SEM_INTERNAL_IDLE__SHIFT 0x1
#define SEM_STATUS__MC_RDREQ_FIFO_FULL_MASK 0x4
#define SEM_STATUS__MC_RDREQ_FIFO_FULL__SHIFT 0x2
#define SEM_STATUS__MC_WRREQ_FIFO_FULL_MASK 0x8
#define SEM_STATUS__MC_WRREQ_FIFO_FULL__SHIFT 0x3
#define SEM_STATUS__WRITE1_FIFO_FULL_MASK 0x10
#define SEM_STATUS__WRITE1_FIFO_FULL__SHIFT 0x4
#define SEM_STATUS__CHECK0_FIFO_FULL_MASK 0x20
#define SEM_STATUS__CHECK0_FIFO_FULL__SHIFT 0x5
#define SEM_STATUS__MC_RDREQ_PENDING_MASK 0x40
#define SEM_STATUS__MC_RDREQ_PENDING__SHIFT 0x6
#define SEM_STATUS__MC_WRREQ_PENDING_MASK 0x80
#define SEM_STATUS__MC_WRREQ_PENDING__SHIFT 0x7
#define SEM_STATUS__SDMA0_MAILBOX_PENDING_MASK 0x100
#define SEM_STATUS__SDMA0_MAILBOX_PENDING__SHIFT 0x8
#define SEM_STATUS__SDMA1_MAILBOX_PENDING_MASK 0x200
#define SEM_STATUS__SDMA1_MAILBOX_PENDING__SHIFT 0x9
#define SEM_STATUS__UVD_MAILBOX_PENDING_MASK 0x400
#define SEM_STATUS__UVD_MAILBOX_PENDING__SHIFT 0xa
#define SEM_STATUS__VCE_MAILBOX_PENDING_MASK 0x800
#define SEM_STATUS__VCE_MAILBOX_PENDING__SHIFT 0xb
#define SEM_STATUS__CPG1_MAILBOX_PENDING_MASK 0x1000
#define SEM_STATUS__CPG1_MAILBOX_PENDING__SHIFT 0xc
#define SEM_STATUS__CPG2_MAILBOX_PENDING_MASK 0x2000
#define SEM_STATUS__CPG2_MAILBOX_PENDING__SHIFT 0xd
#define SEM_EDC_CONFIG__DIS_EDC_MASK 0x2
#define SEM_EDC_CONFIG__DIS_EDC__SHIFT 0x1
#define SEM_MAILBOX_CLIENTCONFIG__CP_CLIENT0_MASK 0x7
#define SEM_MAILBOX_CLIENTCONFIG__CP_CLIENT0__SHIFT 0x0
#define SEM_MAILBOX_CLIENTCONFIG__CP_CLIENT1_MASK 0x38
#define SEM_MAILBOX_CLIENTCONFIG__CP_CLIENT1__SHIFT 0x3
#define SEM_MAILBOX_CLIENTCONFIG__CP_CLIENT2_MASK 0x1c0
#define SEM_MAILBOX_CLIENTCONFIG__CP_CLIENT2__SHIFT 0x6
#define SEM_MAILBOX_CLIENTCONFIG__CP_CLIENT3_MASK 0xe00
#define SEM_MAILBOX_CLIENTCONFIG__CP_CLIENT3__SHIFT 0x9
#define SEM_MAILBOX_CLIENTCONFIG__SDMA_CLIENT0_MASK 0x7000
#define SEM_MAILBOX_CLIENTCONFIG__SDMA_CLIENT0__SHIFT 0xc
#define SEM_MAILBOX_CLIENTCONFIG__UVD_CLIENT0_MASK 0x38000
#define SEM_MAILBOX_CLIENTCONFIG__UVD_CLIENT0__SHIFT 0xf
#define SEM_MAILBOX_CLIENTCONFIG__SDMA1_CLIENT0_MASK 0x1c0000
#define SEM_MAILBOX_CLIENTCONFIG__SDMA1_CLIENT0__SHIFT 0x12
#define SEM_MAILBOX_CLIENTCONFIG__VCE_CLIENT0_MASK 0xe00000
#define SEM_MAILBOX_CLIENTCONFIG__VCE_CLIENT0__SHIFT 0x15
#define SEM_MAILBOX__SIDEPORT_MASK 0xff
#define SEM_MAILBOX__SIDEPORT__SHIFT 0x0
#define SEM_MAILBOX__HOSTPORT_MASK 0xff00
#define SEM_MAILBOX__HOSTPORT__SHIFT 0x8
#define SEM_MAILBOX_CONTROL__SIDEPORT_ENABLE_MASK 0xff
#define SEM_MAILBOX_CONTROL__SIDEPORT_ENABLE__SHIFT 0x0
#define SEM_MAILBOX_CONTROL__HOSTPORT_ENABLE_MASK 0xff00
#define SEM_MAILBOX_CONTROL__HOSTPORT_ENABLE__SHIFT 0x8
#define SEM_CHICKEN_BITS__VMID_PIPELINE_EN_MASK 0x1
#define SEM_CHICKEN_BITS__VMID_PIPELINE_EN__SHIFT 0x0
#define SEM_CHICKEN_BITS__ENTRY_PIPELINE_EN_MASK 0x2
#define SEM_CHICKEN_BITS__ENTRY_PIPELINE_EN__SHIFT 0x1
#define SRBM_CNTL__READ_TIMEOUT_MASK 0x1fff
#define SRBM_CNTL__READ_TIMEOUT__SHIFT 0x0
#define SRBM_CNTL__PWR_REQUEST_HALT_MASK 0x10000
#define SRBM_CNTL__PWR_REQUEST_HALT__SHIFT 0x10
#define SRBM_CNTL__COMBINE_SYSTEM_MC_MASK 0x20000
#define SRBM_CNTL__COMBINE_SYSTEM_MC__SHIFT 0x11
#define SRBM_GFX_CNTL__PIPEID_MASK 0x3
#define SRBM_GFX_CNTL__PIPEID__SHIFT 0x0
#define SRBM_GFX_CNTL__MEID_MASK 0xc
#define SRBM_GFX_CNTL__MEID__SHIFT 0x2
#define SRBM_GFX_CNTL__VMID_MASK 0xf0
#define SRBM_GFX_CNTL__VMID__SHIFT 0x4
#define SRBM_GFX_CNTL__QUEUEID_MASK 0x700
#define SRBM_GFX_CNTL__QUEUEID__SHIFT 0x8
#define SRBM_STATUS2__SDMA_RQ_PENDING_MASK 0x1
#define SRBM_STATUS2__SDMA_RQ_PENDING__SHIFT 0x0
#define SRBM_STATUS2__TST_RQ_PENDING_MASK 0x2
#define SRBM_STATUS2__TST_RQ_PENDING__SHIFT 0x1
#define SRBM_STATUS2__SDMA1_RQ_PENDING_MASK 0x4
#define SRBM_STATUS2__SDMA1_RQ_PENDING__SHIFT 0x2
#define SRBM_STATUS2__VCE_RQ_PENDING_MASK 0x8
#define SRBM_STATUS2__VCE_RQ_PENDING__SHIFT 0x3
#define SRBM_STATUS2__XSP_BUSY_MASK 0x10
#define SRBM_STATUS2__XSP_BUSY__SHIFT 0x4
#define SRBM_STATUS2__SDMA_BUSY_MASK 0x20
#define SRBM_STATUS2__SDMA_BUSY__SHIFT 0x5
#define SRBM_STATUS2__SDMA1_BUSY_MASK 0x40
#define SRBM_STATUS2__SDMA1_BUSY__SHIFT 0x6
#define SRBM_STATUS2__VCE_BUSY_MASK 0x80
#define SRBM_STATUS2__VCE_BUSY__SHIFT 0x7
#define SRBM_STATUS2__XDMA_BUSY_MASK 0x100
#define SRBM_STATUS2__XDMA_BUSY__SHIFT 0x8
#define SRBM_STATUS2__CHUB_BUSY_MASK 0x200
#define SRBM_STATUS2__CHUB_BUSY__SHIFT 0x9
#define SRBM_STATUS__UVD_RQ_PENDING_MASK 0x2
#define SRBM_STATUS__UVD_RQ_PENDING__SHIFT 0x1
#define SRBM_STATUS__SAM_RQ_PENDING_MASK 0x4
#define SRBM_STATUS__SAM_RQ_PENDING__SHIFT 0x2
#define SRBM_STATUS__ACP_RQ_PENDING_MASK 0x8
#define SRBM_STATUS__ACP_RQ_PENDING__SHIFT 0x3
#define SRBM_STATUS__SMU_RQ_PENDING_MASK 0x10
#define SRBM_STATUS__SMU_RQ_PENDING__SHIFT 0x4
#define SRBM_STATUS__GRBM_RQ_PENDING_MASK 0x20
#define SRBM_STATUS__GRBM_RQ_PENDING__SHIFT 0x5
#define SRBM_STATUS__HI_RQ_PENDING_MASK 0x40
#define SRBM_STATUS__HI_RQ_PENDING__SHIFT 0x6
#define SRBM_STATUS__IO_EXTERN_SIGNAL_MASK 0x80
#define SRBM_STATUS__IO_EXTERN_SIGNAL__SHIFT 0x7
#define SRBM_STATUS__VMC_BUSY_MASK 0x100
#define SRBM_STATUS__VMC_BUSY__SHIFT 0x8
#define SRBM_STATUS__MCB_BUSY_MASK 0x200
#define SRBM_STATUS__MCB_BUSY__SHIFT 0x9
#define SRBM_STATUS__MCB_NON_DISPLAY_BUSY_MASK 0x400
#define SRBM_STATUS__MCB_NON_DISPLAY_BUSY__SHIFT 0xa
#define SRBM_STATUS__MCC_BUSY_MASK 0x800
#define SRBM_STATUS__MCC_BUSY__SHIFT 0xb
#define SRBM_STATUS__MCD_BUSY_MASK 0x1000
#define SRBM_STATUS__MCD_BUSY__SHIFT 0xc
#define SRBM_STATUS__SEM_BUSY_MASK 0x4000
#define SRBM_STATUS__SEM_BUSY__SHIFT 0xe
#define SRBM_STATUS__ACP_BUSY_MASK 0x10000
#define SRBM_STATUS__ACP_BUSY__SHIFT 0x10
#define SRBM_STATUS__IH_BUSY_MASK 0x20000
#define SRBM_STATUS__IH_BUSY__SHIFT 0x11
#define SRBM_STATUS__UVD_BUSY_MASK 0x80000
#define SRBM_STATUS__UVD_BUSY__SHIFT 0x13
#define SRBM_STATUS__SAM_BUSY_MASK 0x100000
#define SRBM_STATUS__SAM_BUSY__SHIFT 0x14
#define SRBM_STATUS__BIF_BUSY_MASK 0x20000000
#define SRBM_STATUS__BIF_BUSY__SHIFT 0x1d
#define SRBM_CAM_INDEX__CAM_INDEX_MASK 0x7
#define SRBM_CAM_INDEX__CAM_INDEX__SHIFT 0x0
#define SRBM_CAM_DATA__CAM_ADDR_MASK 0xffff
#define SRBM_CAM_DATA__CAM_ADDR__SHIFT 0x0
#define SRBM_CAM_DATA__CAM_REMAPADDR_MASK 0xffff0000
#define SRBM_CAM_DATA__CAM_REMAPADDR__SHIFT 0x10
#define SRBM_SOFT_RESET__SOFT_RESET_BIF_MASK 0x2
#define SRBM_SOFT_RESET__SOFT_RESET_BIF__SHIFT 0x1
#define SRBM_SOFT_RESET__SOFT_RESET_ROPLL_MASK 0x10
#define SRBM_SOFT_RESET__SOFT_RESET_ROPLL__SHIFT 0x4
#define SRBM_SOFT_RESET__SOFT_RESET_DC_MASK 0x20
#define SRBM_SOFT_RESET__SOFT_RESET_DC__SHIFT 0x5
#define SRBM_SOFT_RESET__SOFT_RESET_SDMA1_MASK 0x40
#define SRBM_SOFT_RESET__SOFT_RESET_SDMA1__SHIFT 0x6
#define SRBM_SOFT_RESET__SOFT_RESET_GRBM_MASK 0x100
#define SRBM_SOFT_RESET__SOFT_RESET_GRBM__SHIFT 0x8
#define SRBM_SOFT_RESET__SOFT_RESET_HDP_MASK 0x200
#define SRBM_SOFT_RESET__SOFT_RESET_HDP__SHIFT 0x9
#define SRBM_SOFT_RESET__SOFT_RESET_IH_MASK 0x400
#define SRBM_SOFT_RESET__SOFT_RESET_IH__SHIFT 0xa
#define SRBM_SOFT_RESET__SOFT_RESET_MC_MASK 0x800
#define SRBM_SOFT_RESET__SOFT_RESET_MC__SHIFT 0xb
#define SRBM_SOFT_RESET__SOFT_RESET_CHUB_MASK 0x1000
#define SRBM_SOFT_RESET__SOFT_RESET_CHUB__SHIFT 0xc
#define SRBM_SOFT_RESET__SOFT_RESET_ROM_MASK 0x4000
#define SRBM_SOFT_RESET__SOFT_RESET_ROM__SHIFT 0xe
#define SRBM_SOFT_RESET__SOFT_RESET_SEM_MASK 0x8000
#define SRBM_SOFT_RESET__SOFT_RESET_SEM__SHIFT 0xf
#define SRBM_SOFT_RESET__SOFT_RESET_SMU_MASK 0x10000
#define SRBM_SOFT_RESET__SOFT_RESET_SMU__SHIFT 0x10
#define SRBM_SOFT_RESET__SOFT_RESET_VMC_MASK 0x20000
#define SRBM_SOFT_RESET__SOFT_RESET_VMC__SHIFT 0x11
#define SRBM_SOFT_RESET__SOFT_RESET_UVD_MASK 0x40000
#define SRBM_SOFT_RESET__SOFT_RESET_UVD__SHIFT 0x12
#define SRBM_SOFT_RESET__SOFT_RESET_XSP_MASK 0x80000
#define SRBM_SOFT_RESET__SOFT_RESET_XSP__SHIFT 0x13
#define SRBM_SOFT_RESET__SOFT_RESET_SDMA_MASK 0x100000
#define SRBM_SOFT_RESET__SOFT_RESET_SDMA__SHIFT 0x14
#define SRBM_SOFT_RESET__SOFT_RESET_TST_MASK 0x200000
#define SRBM_SOFT_RESET__SOFT_RESET_TST__SHIFT 0x15
#define SRBM_SOFT_RESET__SOFT_RESET_REGBB_MASK 0x400000
#define SRBM_SOFT_RESET__SOFT_RESET_REGBB__SHIFT 0x16
#define SRBM_SOFT_RESET__SOFT_RESET_ORB_MASK 0x800000
#define SRBM_SOFT_RESET__SOFT_RESET_ORB__SHIFT 0x17
#define SRBM_SOFT_RESET__SOFT_RESET_VCE_MASK 0x1000000
#define SRBM_SOFT_RESET__SOFT_RESET_VCE__SHIFT 0x18
#define SRBM_SOFT_RESET__SOFT_RESET_XDMA_MASK 0x2000000
#define SRBM_SOFT_RESET__SOFT_RESET_XDMA__SHIFT 0x19
#define SRBM_SOFT_RESET__SOFT_RESET_ACP_MASK 0x4000000
#define SRBM_SOFT_RESET__SOFT_RESET_ACP__SHIFT 0x1a
#define SRBM_SOFT_RESET__SOFT_RESET_SAM_MASK 0x8000000
#define SRBM_SOFT_RESET__SOFT_RESET_SAM__SHIFT 0x1b
#define SRBM_DEBUG_CNTL__SRBM_DEBUG_INDEX_MASK 0x3f
#define SRBM_DEBUG_CNTL__SRBM_DEBUG_INDEX__SHIFT 0x0
#define SRBM_DEBUG_DATA__DATA_MASK 0xffffffff
#define SRBM_DEBUG_DATA__DATA__SHIFT 0x0
#define SRBM_CHIP_REVISION__CHIP_REVISION_MASK 0xff
#define SRBM_CHIP_REVISION__CHIP_REVISION__SHIFT 0x0
#define CC_SYS_RB_REDUNDANCY__FAILED_RB0_MASK 0xf00
#define CC_SYS_RB_REDUNDANCY__FAILED_RB0__SHIFT 0x8
#define CC_SYS_RB_REDUNDANCY__EN_REDUNDANCY0_MASK 0x1000
#define CC_SYS_RB_REDUNDANCY__EN_REDUNDANCY0__SHIFT 0xc
#define CC_SYS_RB_REDUNDANCY__FAILED_RB1_MASK 0xf0000
#define CC_SYS_RB_REDUNDANCY__FAILED_RB1__SHIFT 0x10
#define CC_SYS_RB_REDUNDANCY__EN_REDUNDANCY1_MASK 0x100000
#define CC_SYS_RB_REDUNDANCY__EN_REDUNDANCY1__SHIFT 0x14
#define CC_SYS_RB_BACKEND_DISABLE__BACKEND_DISABLE_MASK 0xff0000
#define CC_SYS_RB_BACKEND_DISABLE__BACKEND_DISABLE__SHIFT 0x10
#define GC_USER_SYS_RB_BACKEND_DISABLE__BACKEND_DISABLE_MASK 0xff0000
#define GC_USER_SYS_RB_BACKEND_DISABLE__BACKEND_DISABLE__SHIFT 0x10
#define SRBM_MC_CLKEN_CNTL__PREFIX_DELAY_CNT_MASK 0xf
#define SRBM_MC_CLKEN_CNTL__PREFIX_DELAY_CNT__SHIFT 0x0
#define SRBM_MC_CLKEN_CNTL__POST_DELAY_CNT_MASK 0x1f00
#define SRBM_MC_CLKEN_CNTL__POST_DELAY_CNT__SHIFT 0x8
#define SRBM_SYS_CLKEN_CNTL__PREFIX_DELAY_CNT_MASK 0xf
#define SRBM_SYS_CLKEN_CNTL__PREFIX_DELAY_CNT__SHIFT 0x0
#define SRBM_SYS_CLKEN_CNTL__POST_DELAY_CNT_MASK 0x1f00
#define SRBM_SYS_CLKEN_CNTL__POST_DELAY_CNT__SHIFT 0x8
#define SRBM_VCE_CLKEN_CNTL__PREFIX_DELAY_CNT_MASK 0xf
#define SRBM_VCE_CLKEN_CNTL__PREFIX_DELAY_CNT__SHIFT 0x0
#define SRBM_VCE_CLKEN_CNTL__POST_DELAY_CNT_MASK 0x1f00
#define SRBM_VCE_CLKEN_CNTL__POST_DELAY_CNT__SHIFT 0x8
#define SRBM_UVD_CLKEN_CNTL__PREFIX_DELAY_CNT_MASK 0xf
#define SRBM_UVD_CLKEN_CNTL__PREFIX_DELAY_CNT__SHIFT 0x0
#define SRBM_UVD_CLKEN_CNTL__POST_DELAY_CNT_MASK 0x1f00
#define SRBM_UVD_CLKEN_CNTL__POST_DELAY_CNT__SHIFT 0x8
#define SRBM_SDMA_CLKEN_CNTL__PREFIX_DELAY_CNT_MASK 0xf
#define SRBM_SDMA_CLKEN_CNTL__PREFIX_DELAY_CNT__SHIFT 0x0
#define SRBM_SDMA_CLKEN_CNTL__POST_DELAY_CNT_MASK 0x1f00
#define SRBM_SDMA_CLKEN_CNTL__POST_DELAY_CNT__SHIFT 0x8
#define SRBM_SAM_CLKEN_CNTL__PREFIX_DELAY_CNT_MASK 0xf
#define SRBM_SAM_CLKEN_CNTL__PREFIX_DELAY_CNT__SHIFT 0x0
#define SRBM_SAM_CLKEN_CNTL__POST_DELAY_CNT_MASK 0x1f00
#define SRBM_SAM_CLKEN_CNTL__POST_DELAY_CNT__SHIFT 0x8
#define SRBM_DEBUG__IGNORE_RDY_MASK 0x1
#define SRBM_DEBUG__IGNORE_RDY__SHIFT 0x0
#define SRBM_DEBUG__DISABLE_READ_TIMEOUT_MASK 0x2
#define SRBM_DEBUG__DISABLE_READ_TIMEOUT__SHIFT 0x1
#define SRBM_DEBUG__SNAPSHOT_FREE_CNTRS_MASK 0x4
#define SRBM_DEBUG__SNAPSHOT_FREE_CNTRS__SHIFT 0x2
#define SRBM_DEBUG__SYS_CLOCK_DOMAIN_OVERRIDE_MASK 0x10
#define SRBM_DEBUG__SYS_CLOCK_DOMAIN_OVERRIDE__SHIFT 0x4
#define SRBM_DEBUG__VCE_CLOCK_DOMAIN_OVERRIDE_MASK 0x20
#define SRBM_DEBUG__VCE_CLOCK_DOMAIN_OVERRIDE__SHIFT 0x5
#define SRBM_DEBUG__UVD_CLOCK_DOMAIN_OVERRIDE_MASK 0x40
#define SRBM_DEBUG__UVD_CLOCK_DOMAIN_OVERRIDE__SHIFT 0x6
#define SRBM_DEBUG__SDMA_CLOCK_DOMAIN_OVERRIDE_MASK 0x80
#define SRBM_DEBUG__SDMA_CLOCK_DOMAIN_OVERRIDE__SHIFT 0x7
#define SRBM_DEBUG__MC_CLOCK_DOMAIN_OVERRIDE_MASK 0x100
#define SRBM_DEBUG__MC_CLOCK_DOMAIN_OVERRIDE__SHIFT 0x8
#define SRBM_DEBUG__SAM_CLOCK_DOMAIN_OVERRIDE_MASK 0x200
#define SRBM_DEBUG__SAM_CLOCK_DOMAIN_OVERRIDE__SHIFT 0x9
#define SRBM_DEBUG_SNAPSHOT__MCB_RDY_MASK 0x1
#define SRBM_DEBUG_SNAPSHOT__MCB_RDY__SHIFT 0x0
#define SRBM_DEBUG_SNAPSHOT__ROPLL_RDY_MASK 0x2
#define SRBM_DEBUG_SNAPSHOT__ROPLL_RDY__SHIFT 0x1
#define SRBM_DEBUG_SNAPSHOT__SMU_RDY_MASK 0x4
#define SRBM_DEBUG_SNAPSHOT__SMU_RDY__SHIFT 0x2
#define SRBM_DEBUG_SNAPSHOT__SAM_RDY_MASK 0x8
#define SRBM_DEBUG_SNAPSHOT__SAM_RDY__SHIFT 0x3
#define SRBM_DEBUG_SNAPSHOT__ACP_RDY_MASK 0x10
#define SRBM_DEBUG_SNAPSHOT__ACP_RDY__SHIFT 0x4
#define SRBM_DEBUG_SNAPSHOT__GRBM_RDY_MASK 0x20
#define SRBM_DEBUG_SNAPSHOT__GRBM_RDY__SHIFT 0x5
#define SRBM_DEBUG_SNAPSHOT__DC_RDY_MASK 0x40
#define SRBM_DEBUG_SNAPSHOT__DC_RDY__SHIFT 0x6
#define SRBM_DEBUG_SNAPSHOT__BIF_RDY_MASK 0x80
#define SRBM_DEBUG_SNAPSHOT__BIF_RDY__SHIFT 0x7
#define SRBM_DEBUG_SNAPSHOT__XDMA_RDY_MASK 0x100
#define SRBM_DEBUG_SNAPSHOT__XDMA_RDY__SHIFT 0x8
#define SRBM_DEBUG_SNAPSHOT__UVD_RDY_MASK 0x200
#define SRBM_DEBUG_SNAPSHOT__UVD_RDY__SHIFT 0x9
#define SRBM_DEBUG_SNAPSHOT__XSP_RDY_MASK 0x400
#define SRBM_DEBUG_SNAPSHOT__XSP_RDY__SHIFT 0xa
#define SRBM_DEBUG_SNAPSHOT__REGBB_RDY_MASK 0x800
#define SRBM_DEBUG_SNAPSHOT__REGBB_RDY__SHIFT 0xb
#define SRBM_DEBUG_SNAPSHOT__ORB_RDY_MASK 0x1000
#define SRBM_DEBUG_SNAPSHOT__ORB_RDY__SHIFT 0xc
#define SRBM_DEBUG_SNAPSHOT__MCD7_RDY_MASK 0x2000
#define SRBM_DEBUG_SNAPSHOT__MCD7_RDY__SHIFT 0xd
#define SRBM_DEBUG_SNAPSHOT__MCD6_RDY_MASK 0x4000
#define SRBM_DEBUG_SNAPSHOT__MCD6_RDY__SHIFT 0xe
#define SRBM_DEBUG_SNAPSHOT__MCD5_RDY_MASK 0x8000
#define SRBM_DEBUG_SNAPSHOT__MCD5_RDY__SHIFT 0xf
#define SRBM_DEBUG_SNAPSHOT__MCD4_RDY_MASK 0x10000
#define SRBM_DEBUG_SNAPSHOT__MCD4_RDY__SHIFT 0x10
#define SRBM_DEBUG_SNAPSHOT__MCD3_RDY_MASK 0x20000
#define SRBM_DEBUG_SNAPSHOT__MCD3_RDY__SHIFT 0x11
#define SRBM_DEBUG_SNAPSHOT__MCD2_RDY_MASK 0x40000
#define SRBM_DEBUG_SNAPSHOT__MCD2_RDY__SHIFT 0x12
#define SRBM_DEBUG_SNAPSHOT__MCD1_RDY_MASK 0x80000
#define SRBM_DEBUG_SNAPSHOT__MCD1_RDY__SHIFT 0x13
#define SRBM_DEBUG_SNAPSHOT__MCD0_RDY_MASK 0x100000
#define SRBM_DEBUG_SNAPSHOT__MCD0_RDY__SHIFT 0x14
#define SRBM_DEBUG_SNAPSHOT__MCC7_RDY_MASK 0x200000
#define SRBM_DEBUG_SNAPSHOT__MCC7_RDY__SHIFT 0x15
#define SRBM_DEBUG_SNAPSHOT__MCC6_RDY_MASK 0x400000
#define SRBM_DEBUG_SNAPSHOT__MCC6_RDY__SHIFT 0x16
#define SRBM_DEBUG_SNAPSHOT__MCC5_RDY_MASK 0x800000
#define SRBM_DEBUG_SNAPSHOT__MCC5_RDY__SHIFT 0x17
#define SRBM_DEBUG_SNAPSHOT__MCC4_RDY_MASK 0x1000000
#define SRBM_DEBUG_SNAPSHOT__MCC4_RDY__SHIFT 0x18
#define SRBM_DEBUG_SNAPSHOT__MCC3_RDY_MASK 0x2000000
#define SRBM_DEBUG_SNAPSHOT__MCC3_RDY__SHIFT 0x19
#define SRBM_DEBUG_SNAPSHOT__MCC2_RDY_MASK 0x4000000
#define SRBM_DEBUG_SNAPSHOT__MCC2_RDY__SHIFT 0x1a
#define SRBM_DEBUG_SNAPSHOT__MCC1_RDY_MASK 0x8000000
#define SRBM_DEBUG_SNAPSHOT__MCC1_RDY__SHIFT 0x1b
#define SRBM_DEBUG_SNAPSHOT__MCC0_RDY_MASK 0x10000000
#define SRBM_DEBUG_SNAPSHOT__MCC0_RDY__SHIFT 0x1c
#define SRBM_DEBUG_SNAPSHOT__VCE_RDY_MASK 0x20000000
#define SRBM_DEBUG_SNAPSHOT__VCE_RDY__SHIFT 0x1d
#define SRBM_READ_ERROR__READ_ADDRESS_MASK 0x3fffc
#define SRBM_READ_ERROR__READ_ADDRESS__SHIFT 0x2
#define SRBM_READ_ERROR__READ_REQUESTER_VCE_MASK 0x100000
#define SRBM_READ_ERROR__READ_REQUESTER_VCE__SHIFT 0x14
#define SRBM_READ_ERROR__READ_REQUESTER_SDMA1_MASK 0x200000
#define SRBM_READ_ERROR__READ_REQUESTER_SDMA1__SHIFT 0x15
#define SRBM_READ_ERROR__READ_REQUESTER_TST_MASK 0x400000
#define SRBM_READ_ERROR__READ_REQUESTER_TST__SHIFT 0x16
#define SRBM_READ_ERROR__READ_REQUESTER_SAM_MASK 0x800000
#define SRBM_READ_ERROR__READ_REQUESTER_SAM__SHIFT 0x17
#define SRBM_READ_ERROR__READ_REQUESTER_HI_MASK 0x1000000
#define SRBM_READ_ERROR__READ_REQUESTER_HI__SHIFT 0x18
#define SRBM_READ_ERROR__READ_REQUESTER_GRBM_MASK 0x2000000
#define SRBM_READ_ERROR__READ_REQUESTER_GRBM__SHIFT 0x19
#define SRBM_READ_ERROR__READ_REQUESTER_SMU_MASK 0x4000000
#define SRBM_READ_ERROR__READ_REQUESTER_SMU__SHIFT 0x1a
#define SRBM_READ_ERROR__READ_REQUESTER_ACP_MASK 0x8000000
#define SRBM_READ_ERROR__READ_REQUESTER_ACP__SHIFT 0x1b
#define SRBM_READ_ERROR__READ_REQUESTER_SDMA_MASK 0x10000000
#define SRBM_READ_ERROR__READ_REQUESTER_SDMA__SHIFT 0x1c
#define SRBM_READ_ERROR__READ_REQUESTER_UVD_MASK 0x20000000
#define SRBM_READ_ERROR__READ_REQUESTER_UVD__SHIFT 0x1d
#define SRBM_READ_ERROR__READ_ERROR_MASK 0x80000000
#define SRBM_READ_ERROR__READ_ERROR__SHIFT 0x1f
#define SRBM_INT_CNTL__RDERR_INT_MASK_MASK 0x1
#define SRBM_INT_CNTL__RDERR_INT_MASK__SHIFT 0x0
#define SRBM_INT_STATUS__RDERR_INT_STAT_MASK 0x1
#define SRBM_INT_STATUS__RDERR_INT_STAT__SHIFT 0x0
#define SRBM_INT_ACK__RDERR_INT_ACK_MASK 0x1
#define SRBM_INT_ACK__RDERR_INT_ACK__SHIFT 0x0
#define SRBM_PERFMON_CNTL__PERFMON_STATE_MASK 0xf
#define SRBM_PERFMON_CNTL__PERFMON_STATE__SHIFT 0x0
#define SRBM_PERFMON_CNTL__PERFMON_ENABLE_MODE_MASK 0x300
#define SRBM_PERFMON_CNTL__PERFMON_ENABLE_MODE__SHIFT 0x8
#define SRBM_PERFMON_CNTL__PERFMON_SAMPLE_ENABLE_MASK 0x400
#define SRBM_PERFMON_CNTL__PERFMON_SAMPLE_ENABLE__SHIFT 0xa
#define SRBM_PERFCOUNTER0_SELECT__PERF_SEL_MASK 0x3f
#define SRBM_PERFCOUNTER0_SELECT__PERF_SEL__SHIFT 0x0
#define SRBM_PERFCOUNTER1_SELECT__PERF_SEL_MASK 0x3f
#define SRBM_PERFCOUNTER1_SELECT__PERF_SEL__SHIFT 0x0
#define SRBM_PERFCOUNTER0_LO__PERF_COUNT0_LO_MASK 0xffffffff
#define SRBM_PERFCOUNTER0_LO__PERF_COUNT0_LO__SHIFT 0x0
#define SRBM_PERFCOUNTER0_HI__PERF_COUNT0_HI_MASK 0xffffffff
#define SRBM_PERFCOUNTER0_HI__PERF_COUNT0_HI__SHIFT 0x0
#define SRBM_PERFCOUNTER1_LO__PERF_COUNT1_LO_MASK 0xffffffff
#define SRBM_PERFCOUNTER1_LO__PERF_COUNT1_LO__SHIFT 0x0
#define SRBM_PERFCOUNTER1_HI__PERF_COUNT1_HI_MASK 0xffffffff
#define SRBM_PERFCOUNTER1_HI__PERF_COUNT1_HI__SHIFT 0x0
#define CC_DRM_ID_STRAPS__DEVICE_ID_MASK 0xffff0
#define CC_DRM_ID_STRAPS__DEVICE_ID__SHIFT 0x4
#define CC_DRM_ID_STRAPS__MAJOR_REV_ID_MASK 0xf00000
#define CC_DRM_ID_STRAPS__MAJOR_REV_ID__SHIFT 0x14
#define CC_DRM_ID_STRAPS__MINOR_REV_ID_MASK 0xf000000
#define CC_DRM_ID_STRAPS__MINOR_REV_ID__SHIFT 0x18
#define CC_DRM_ID_STRAPS__ATI_REV_ID_MASK 0xf0000000
#define CC_DRM_ID_STRAPS__ATI_REV_ID__SHIFT 0x1c
#define DH_TEST__DH_TEST_MASK 0x1
#define DH_TEST__DH_TEST__SHIFT 0x0
#define KHFS0__RESERVED_MASK 0xffffffff
#define KHFS0__RESERVED__SHIFT 0x0
#define KHFS1__RESERVED_MASK 0xffffffff
#define KHFS1__RESERVED__SHIFT 0x0
#define KHFS2__RESERVED_MASK 0xffffffff
#define KHFS2__RESERVED__SHIFT 0x0
#define KHFS3__RESERVED_MASK 0xffffffff
#define KHFS3__RESERVED__SHIFT 0x0
#define KSESSION0__RESERVED_MASK 0xffffffff
#define KSESSION0__RESERVED__SHIFT 0x0
#define KSESSION1__RESERVED_MASK 0xffffffff
#define KSESSION1__RESERVED__SHIFT 0x0
#define KSESSION2__RESERVED_MASK 0xffffffff
#define KSESSION2__RESERVED__SHIFT 0x0
#define KSESSION3__RESERVED_MASK 0xffffffff
#define KSESSION3__RESERVED__SHIFT 0x0
#define KSIG0__RESERVED_MASK 0xffffffff
#define KSIG0__RESERVED__SHIFT 0x0
#define KSIG1__RESERVED_MASK 0xffffffff
#define KSIG1__RESERVED__SHIFT 0x0
#define KSIG2__RESERVED_MASK 0xffffffff
#define KSIG2__RESERVED__SHIFT 0x0
#define KSIG3__RESERVED_MASK 0xffffffff
#define KSIG3__RESERVED__SHIFT 0x0
#define EXP0__RESERVED_MASK 0xffffffff
#define EXP0__RESERVED__SHIFT 0x0
#define EXP1__RESERVED_MASK 0xffffffff
#define EXP1__RESERVED__SHIFT 0x0
#define EXP2__RESERVED_MASK 0xffffffff
#define EXP2__RESERVED__SHIFT 0x0
#define EXP3__RESERVED_MASK 0xffffffff
#define EXP3__RESERVED__SHIFT 0x0
#define EXP4__RESERVED_MASK 0xffffffff
#define EXP4__RESERVED__SHIFT 0x0
#define EXP5__RESERVED_MASK 0xffffffff
#define EXP5__RESERVED__SHIFT 0x0
#define EXP6__RESERVED_MASK 0xffffffff
#define EXP6__RESERVED__SHIFT 0x0
#define EXP7__RESERVED_MASK 0xffffffff
#define EXP7__RESERVED__SHIFT 0x0
#define LX0__RESERVED_MASK 0xffffffff
#define LX0__RESERVED__SHIFT 0x0
#define LX1__RESERVED_MASK 0xffffffff
#define LX1__RESERVED__SHIFT 0x0
#define LX2__RESERVED_MASK 0xffffffff
#define LX2__RESERVED__SHIFT 0x0
#define LX3__RESERVED_MASK 0xffffffff
#define LX3__RESERVED__SHIFT 0x0
#define CLIENT2_K0__RESERVED_MASK 0xffffffff
#define CLIENT2_K0__RESERVED__SHIFT 0x0
#define CLIENT2_K1__RESERVED_MASK 0xffffffff
#define CLIENT2_K1__RESERVED__SHIFT 0x0
#define CLIENT2_K2__RESERVED_MASK 0xffffffff
#define CLIENT2_K2__RESERVED__SHIFT 0x0
#define CLIENT2_K3__RESERVED_MASK 0xffffffff
#define CLIENT2_K3__RESERVED__SHIFT 0x0
#define CLIENT2_CK0__RESERVED_MASK 0xffffffff
#define CLIENT2_CK0__RESERVED__SHIFT 0x0
#define CLIENT2_CK1__RESERVED_MASK 0xffffffff
#define CLIENT2_CK1__RESERVED__SHIFT 0x0
#define CLIENT2_CK2__RESERVED_MASK 0xffffffff
#define CLIENT2_CK2__RESERVED__SHIFT 0x0
#define CLIENT2_CK3__RESERVED_MASK 0xffffffff
#define CLIENT2_CK3__RESERVED__SHIFT 0x0
#define CLIENT2_CD0__RESERVED_MASK 0xffffffff
#define CLIENT2_CD0__RESERVED__SHIFT 0x0
#define CLIENT2_CD1__RESERVED_MASK 0xffffffff
#define CLIENT2_CD1__RESERVED__SHIFT 0x0
#define CLIENT2_CD2__RESERVED_MASK 0xffffffff
#define CLIENT2_CD2__RESERVED__SHIFT 0x0
#define CLIENT2_CD3__RESERVED_MASK 0xffffffff
#define CLIENT2_CD3__RESERVED__SHIFT 0x0
#define CLIENT2_BM__RESERVED_MASK 0xffffffff
#define CLIENT2_BM__RESERVED__SHIFT 0x0
#define CLIENT2_OFFSET__RESERVED_MASK 0xffffffff
#define CLIENT2_OFFSET__RESERVED__SHIFT 0x0
#define CLIENT2_STATUS__RESERVED_MASK 0xffffffff
#define CLIENT2_STATUS__RESERVED__SHIFT 0x0
#define CLIENT0_K0__RESERVED_MASK 0xffffffff
#define CLIENT0_K0__RESERVED__SHIFT 0x0
#define CLIENT0_K1__RESERVED_MASK 0xffffffff
#define CLIENT0_K1__RESERVED__SHIFT 0x0
#define CLIENT0_K2__RESERVED_MASK 0xffffffff
#define CLIENT0_K2__RESERVED__SHIFT 0x0
#define CLIENT0_K3__RESERVED_MASK 0xffffffff
#define CLIENT0_K3__RESERVED__SHIFT 0x0
#define CLIENT0_CK0__RESERVED_MASK 0xffffffff
#define CLIENT0_CK0__RESERVED__SHIFT 0x0
#define CLIENT0_CK1__RESERVED_MASK 0xffffffff
#define CLIENT0_CK1__RESERVED__SHIFT 0x0
#define CLIENT0_CK2__RESERVED_MASK 0xffffffff
#define CLIENT0_CK2__RESERVED__SHIFT 0x0
#define CLIENT0_CK3__RESERVED_MASK 0xffffffff
#define CLIENT0_CK3__RESERVED__SHIFT 0x0
#define CLIENT0_CD0__RESERVED_MASK 0xffffffff
#define CLIENT0_CD0__RESERVED__SHIFT 0x0
#define CLIENT0_CD1__RESERVED_MASK 0xffffffff
#define CLIENT0_CD1__RESERVED__SHIFT 0x0
#define CLIENT0_CD2__RESERVED_MASK 0xffffffff
#define CLIENT0_CD2__RESERVED__SHIFT 0x0
#define CLIENT0_CD3__RESERVED_MASK 0xffffffff
#define CLIENT0_CD3__RESERVED__SHIFT 0x0
#define CLIENT0_BM__RESERVED_MASK 0xffffffff
#define CLIENT0_BM__RESERVED__SHIFT 0x0
#define CLIENT0_OFFSET__RESERVED_MASK 0xffffffff
#define CLIENT0_OFFSET__RESERVED__SHIFT 0x0
#define CLIENT0_STATUS__RESERVED_MASK 0xffffffff
#define CLIENT0_STATUS__RESERVED__SHIFT 0x0
#define CLIENT1_K0__RESERVED_MASK 0xffffffff
#define CLIENT1_K0__RESERVED__SHIFT 0x0
#define CLIENT1_K1__RESERVED_MASK 0xffffffff
#define CLIENT1_K1__RESERVED__SHIFT 0x0
#define CLIENT1_K2__RESERVED_MASK 0xffffffff
#define CLIENT1_K2__RESERVED__SHIFT 0x0
#define CLIENT1_K3__RESERVED_MASK 0xffffffff
#define CLIENT1_K3__RESERVED__SHIFT 0x0
#define CLIENT1_CK0__RESERVED_MASK 0xffffffff
#define CLIENT1_CK0__RESERVED__SHIFT 0x0
#define CLIENT1_CK1__RESERVED_MASK 0xffffffff
#define CLIENT1_CK1__RESERVED__SHIFT 0x0
#define CLIENT1_CK2__RESERVED_MASK 0xffffffff
#define CLIENT1_CK2__RESERVED__SHIFT 0x0
#define CLIENT1_CK3__RESERVED_MASK 0xffffffff
#define CLIENT1_CK3__RESERVED__SHIFT 0x0
#define CLIENT1_CD0__RESERVED_MASK 0xffffffff
#define CLIENT1_CD0__RESERVED__SHIFT 0x0
#define CLIENT1_CD1__RESERVED_MASK 0xffffffff
#define CLIENT1_CD1__RESERVED__SHIFT 0x0
#define CLIENT1_CD2__RESERVED_MASK 0xffffffff
#define CLIENT1_CD2__RESERVED__SHIFT 0x0
#define CLIENT1_CD3__RESERVED_MASK 0xffffffff
#define CLIENT1_CD3__RESERVED__SHIFT 0x0
#define CLIENT1_BM__RESERVED_MASK 0xffffffff
#define CLIENT1_BM__RESERVED__SHIFT 0x0
#define CLIENT1_OFFSET__RESERVED_MASK 0xffffffff
#define CLIENT1_OFFSET__RESERVED__SHIFT 0x0
#define CLIENT1_PORT_STATUS__RESERVED_MASK 0xffffffff
#define CLIENT1_PORT_STATUS__RESERVED__SHIFT 0x0
#define KEFUSE0__RESERVED_MASK 0xffffffff
#define KEFUSE0__RESERVED__SHIFT 0x0
#define KEFUSE1__RESERVED_MASK 0xffffffff
#define KEFUSE1__RESERVED__SHIFT 0x0
#define KEFUSE2__RESERVED_MASK 0xffffffff
#define KEFUSE2__RESERVED__SHIFT 0x0
#define KEFUSE3__RESERVED_MASK 0xffffffff
#define KEFUSE3__RESERVED__SHIFT 0x0
#define HFS_SEED0__RESERVED_MASK 0xffffffff
#define HFS_SEED0__RESERVED__SHIFT 0x0
#define HFS_SEED1__RESERVED_MASK 0xffffffff
#define HFS_SEED1__RESERVED__SHIFT 0x0
#define HFS_SEED2__RESERVED_MASK 0xffffffff
#define HFS_SEED2__RESERVED__SHIFT 0x0
#define HFS_SEED3__RESERVED_MASK 0xffffffff
#define HFS_SEED3__RESERVED__SHIFT 0x0
#define RINGOSC_MASK__MASK_MASK 0xffff
#define RINGOSC_MASK__MASK__SHIFT 0x0
#define CLIENT0_OFFSET_HI__RESERVED_MASK 0xffffffff
#define CLIENT0_OFFSET_HI__RESERVED__SHIFT 0x0
#define CLIENT1_OFFSET_HI__RESERVED_MASK 0xffffffff
#define CLIENT1_OFFSET_HI__RESERVED__SHIFT 0x0
#define CLIENT2_OFFSET_HI__RESERVED_MASK 0xffffffff
#define CLIENT2_OFFSET_HI__RESERVED__SHIFT 0x0
#define SPU_PORT_STATUS__RESERVED_MASK 0xffffffff
#define SPU_PORT_STATUS__RESERVED__SHIFT 0x0
#define CLIENT3_OFFSET_HI__RESERVED_MASK 0xffffffff
#define CLIENT3_OFFSET_HI__RESERVED__SHIFT 0x0
#define CLIENT3_K0__RESERVED_MASK 0xffffffff
#define CLIENT3_K0__RESERVED__SHIFT 0x0
#define CLIENT3_K1__RESERVED_MASK 0xffffffff
#define CLIENT3_K1__RESERVED__SHIFT 0x0
#define CLIENT3_K2__RESERVED_MASK 0xffffffff
#define CLIENT3_K2__RESERVED__SHIFT 0x0
#define CLIENT3_K3__RESERVED_MASK 0xffffffff
#define CLIENT3_K3__RESERVED__SHIFT 0x0
#define CLIENT3_CK0__RESERVED_MASK 0xffffffff
#define CLIENT3_CK0__RESERVED__SHIFT 0x0
#define CLIENT3_CK1__RESERVED_MASK 0xffffffff
#define CLIENT3_CK1__RESERVED__SHIFT 0x0
#define CLIENT3_CK2__RESERVED_MASK 0xffffffff
#define CLIENT3_CK2__RESERVED__SHIFT 0x0
#define CLIENT3_CK3__RESERVED_MASK 0xffffffff
#define CLIENT3_CK3__RESERVED__SHIFT 0x0
#define CLIENT3_CD0__RESERVED_MASK 0xffffffff
#define CLIENT3_CD0__RESERVED__SHIFT 0x0
#define CLIENT3_CD1__RESERVED_MASK 0xffffffff
#define CLIENT3_CD1__RESERVED__SHIFT 0x0
#define CLIENT3_CD2__RESERVED_MASK 0xffffffff
#define CLIENT3_CD2__RESERVED__SHIFT 0x0
#define CLIENT3_CD3__RESERVED_MASK 0xffffffff
#define CLIENT3_CD3__RESERVED__SHIFT 0x0
#define CLIENT3_BM__RESERVED_MASK 0xffffffff
#define CLIENT3_BM__RESERVED__SHIFT 0x0
#define CLIENT3_OFFSET__RESERVED_MASK 0xffffffff
#define CLIENT3_OFFSET__RESERVED__SHIFT 0x0
#define CLIENT3_STATUS__RESERVED_MASK 0xffffffff
#define CLIENT3_STATUS__RESERVED__SHIFT 0x0
#define DC_TEST_DEBUG_INDEX__DC_TEST_DEBUG_INDEX_MASK 0xff
#define DC_TEST_DEBUG_INDEX__DC_TEST_DEBUG_INDEX__SHIFT 0x0
#define DC_TEST_DEBUG_INDEX__DC_TEST_DEBUG_WRITE_EN_MASK 0x100
#define DC_TEST_DEBUG_INDEX__DC_TEST_DEBUG_WRITE_EN__SHIFT 0x8
#define DC_TEST_DEBUG_DATA__DC_TEST_DEBUG_DATA_MASK 0xffffffff
#define DC_TEST_DEBUG_DATA__DC_TEST_DEBUG_DATA__SHIFT 0x0
#define XDMA_SLV_CNTL__XDMA_SLV_READ_LINES_MASK 0x1
#define XDMA_SLV_CNTL__XDMA_SLV_READ_LINES__SHIFT 0x0
#define XDMA_SLV_CNTL__XDMA_SLV_MEM_READY_MASK 0x200
#define XDMA_SLV_CNTL__XDMA_SLV_MEM_READY__SHIFT 0x9
#define XDMA_SLV_CNTL__XDMA_SLV_ACTIVE_MASK 0x400
#define XDMA_SLV_CNTL__XDMA_SLV_ACTIVE__SHIFT 0xa
#define XDMA_SLV_CNTL__XDMA_SLV_ALPHA_POSITION_MASK 0x3000
#define XDMA_SLV_CNTL__XDMA_SLV_ALPHA_POSITION__SHIFT 0xc
#define XDMA_SLV_CNTL__XDMA_SLV_ENABLE_MASK 0x10000
#define XDMA_SLV_CNTL__XDMA_SLV_ENABLE__SHIFT 0x10
#define XDMA_SLV_CNTL__XDMA_SLV_READ_LAT_TEST_EN_MASK 0x80000
#define XDMA_SLV_CNTL__XDMA_SLV_READ_LAT_TEST_EN__SHIFT 0x13
#define XDMA_SLV_CNTL__XDMA_SLV_SOFT_RESET_MASK 0x100000
#define XDMA_SLV_CNTL__XDMA_SLV_SOFT_RESET__SHIFT 0x14
#define XDMA_SLV_CNTL__XDMA_SLV_REQ_MAXED_OUT_MASK 0x1000000
#define XDMA_SLV_CNTL__XDMA_SLV_REQ_MAXED_OUT__SHIFT 0x18
#define XDMA_SLV_MEM_CLIENT_CONFIG__XDMA_SLV_MEM_CLIENT_SWAP_MASK 0x300
#define XDMA_SLV_MEM_CLIENT_CONFIG__XDMA_SLV_MEM_CLIENT_SWAP__SHIFT 0x8
#define XDMA_SLV_MEM_CLIENT_CONFIG__XDMA_SLV_MEM_CLIENT_VMID_MASK 0xf000
#define XDMA_SLV_MEM_CLIENT_CONFIG__XDMA_SLV_MEM_CLIENT_VMID__SHIFT 0xc
#define XDMA_SLV_MEM_CLIENT_CONFIG__XDMA_SLV_MEM_CLIENT_PRIV_MASK 0x10000
#define XDMA_SLV_MEM_CLIENT_CONFIG__XDMA_SLV_MEM_CLIENT_PRIV__SHIFT 0x10
#define XDMA_SLV_SLS_PITCH__XDMA_SLV_SLS_PITCH_MASK 0x3fff
#define XDMA_SLV_SLS_PITCH__XDMA_SLV_SLS_PITCH__SHIFT 0x0
#define XDMA_SLV_SLS_PITCH__XDMA_SLV_SLS_WIDTH_MASK 0x3fff0000
#define XDMA_SLV_SLS_PITCH__XDMA_SLV_SLS_WIDTH__SHIFT 0x10
#define XDMA_SLV_READ_URGENT_CNTL__XDMA_SLV_READ_CLIENT_STALL_MASK 0x1
#define XDMA_SLV_READ_URGENT_CNTL__XDMA_SLV_READ_CLIENT_STALL__SHIFT 0x0
#define XDMA_SLV_READ_URGENT_CNTL__XDMA_SLV_READ_URGENT_LIMIT_MASK 0xf0
#define XDMA_SLV_READ_URGENT_CNTL__XDMA_SLV_READ_URGENT_LIMIT__SHIFT 0x4
#define XDMA_SLV_READ_URGENT_CNTL__XDMA_SLV_READ_URGENT_LEVEL_MASK 0xf00
#define XDMA_SLV_READ_URGENT_CNTL__XDMA_SLV_READ_URGENT_LEVEL__SHIFT 0x8
#define XDMA_SLV_READ_URGENT_CNTL__XDMA_SLV_READ_STALL_DELAY_MASK 0xf000
#define XDMA_SLV_READ_URGENT_CNTL__XDMA_SLV_READ_STALL_DELAY__SHIFT 0xc
#define XDMA_SLV_READ_URGENT_CNTL__XDMA_SLV_READ_URGENT_TIMER_MASK 0xffff0000
#define XDMA_SLV_READ_URGENT_CNTL__XDMA_SLV_READ_URGENT_TIMER__SHIFT 0x10
#define XDMA_SLV_WRITE_URGENT_CNTL__XDMA_SLV_WRITE_STALL_MASK 0x1
#define XDMA_SLV_WRITE_URGENT_CNTL__XDMA_SLV_WRITE_STALL__SHIFT 0x0
#define XDMA_SLV_WRITE_URGENT_CNTL__XDMA_SLV_WRITE_URGENT_LEVEL_MASK 0xf00
#define XDMA_SLV_WRITE_URGENT_CNTL__XDMA_SLV_WRITE_URGENT_LEVEL__SHIFT 0x8
#define XDMA_SLV_WRITE_URGENT_CNTL__XDMA_SLV_WRITE_STALL_DELAY_MASK 0xf000
#define XDMA_SLV_WRITE_URGENT_CNTL__XDMA_SLV_WRITE_STALL_DELAY__SHIFT 0xc
#define XDMA_SLV_WB_RATE_CNTL__XDMA_SLV_WB_BURST_SIZE_MASK 0x1ff
#define XDMA_SLV_WB_RATE_CNTL__XDMA_SLV_WB_BURST_SIZE__SHIFT 0x0
#define XDMA_SLV_WB_RATE_CNTL__XDMA_SLV_WB_BURST_PERIOD_MASK 0xffff0000
#define XDMA_SLV_WB_RATE_CNTL__XDMA_SLV_WB_BURST_PERIOD__SHIFT 0x10
#define XDMA_SLV_READ_LATENCY_MINMAX__XDMA_SLV_READ_LATENCY_MIN_MASK 0xffff
#define XDMA_SLV_READ_LATENCY_MINMAX__XDMA_SLV_READ_LATENCY_MIN__SHIFT 0x0
#define XDMA_SLV_READ_LATENCY_MINMAX__XDMA_SLV_READ_LATENCY_MAX_MASK 0xffff0000
#define XDMA_SLV_READ_LATENCY_MINMAX__XDMA_SLV_READ_LATENCY_MAX__SHIFT 0x10
#define XDMA_SLV_READ_LATENCY_AVE__XDMA_SLV_READ_LATENCY_ACC_MASK 0xfffff
#define XDMA_SLV_READ_LATENCY_AVE__XDMA_SLV_READ_LATENCY_ACC__SHIFT 0x0
#define XDMA_SLV_READ_LATENCY_AVE__XDMA_SLV_READ_LATENCY_COUNT_MASK 0xfff00000
#define XDMA_SLV_READ_LATENCY_AVE__XDMA_SLV_READ_LATENCY_COUNT__SHIFT 0x14
#define XDMA_SLV_PCIE_NACK_STATUS__XDMA_SLV_PCIE_NACK_TAG_MASK 0x3ff
#define XDMA_SLV_PCIE_NACK_STATUS__XDMA_SLV_PCIE_NACK_TAG__SHIFT 0x0
#define XDMA_SLV_PCIE_NACK_STATUS__XDMA_SLV_PCIE_NACK_MASK 0x3000
#define XDMA_SLV_PCIE_NACK_STATUS__XDMA_SLV_PCIE_NACK__SHIFT 0xc
#define XDMA_SLV_PCIE_NACK_STATUS__XDMA_SLV_PCIE_NACK_CLR_MASK 0x10000
#define XDMA_SLV_PCIE_NACK_STATUS__XDMA_SLV_PCIE_NACK_CLR__SHIFT 0x10
#define XDMA_SLV_MEM_NACK_STATUS__XDMA_SLV_MEM_NACK_TAG_MASK 0xffff
#define XDMA_SLV_MEM_NACK_STATUS__XDMA_SLV_MEM_NACK_TAG__SHIFT 0x0
#define XDMA_SLV_MEM_NACK_STATUS__XDMA_SLV_MEM_NACK_MASK 0x30000
#define XDMA_SLV_MEM_NACK_STATUS__XDMA_SLV_MEM_NACK__SHIFT 0x10
#define XDMA_SLV_MEM_NACK_STATUS__XDMA_SLV_MEM_NACK_CLR_MASK 0x80000000
#define XDMA_SLV_MEM_NACK_STATUS__XDMA_SLV_MEM_NACK_CLR__SHIFT 0x1f
#define XDMA_SLV_RDRET_BUF_STATUS__XDMA_SLV_RDRET_FREE_ENTRIES_MASK 0x3ff
#define XDMA_SLV_RDRET_BUF_STATUS__XDMA_SLV_RDRET_FREE_ENTRIES__SHIFT 0x0
#define XDMA_SLV_RDRET_BUF_STATUS__XDMA_SLV_RDRET_BUF_SIZE_MASK 0x3ff000
#define XDMA_SLV_RDRET_BUF_STATUS__XDMA_SLV_RDRET_BUF_SIZE__SHIFT 0xc
#define XDMA_SLV_READ_LATENCY_TIMER__XDMA_SLV_READ_LATENCY_TIMER_MASK 0xffff
#define XDMA_SLV_READ_LATENCY_TIMER__XDMA_SLV_READ_LATENCY_TIMER__SHIFT 0x0
#define XDMA_SLV_FLIP_PENDING__XDMA_SLV_FLIP_PENDING_MASK 0x1
#define XDMA_SLV_FLIP_PENDING__XDMA_SLV_FLIP_PENDING__SHIFT 0x0
#define SDMA0_UCODE_ADDR__VALUE_MASK 0x7ff
#define SDMA0_UCODE_ADDR__VALUE__SHIFT 0x0
#define SDMA0_UCODE_DATA__VALUE_MASK 0xffffffff
#define SDMA0_UCODE_DATA__VALUE__SHIFT 0x0
#define SDMA0_POWER_CNTL__MEM_POWER_OVERRIDE_MASK 0x100
#define SDMA0_POWER_CNTL__MEM_POWER_OVERRIDE__SHIFT 0x8
#define SDMA0_CLK_CTRL__ON_DELAY_MASK 0xf
#define SDMA0_CLK_CTRL__ON_DELAY__SHIFT 0x0
#define SDMA0_CLK_CTRL__OFF_HYSTERESIS_MASK 0xff0
#define SDMA0_CLK_CTRL__OFF_HYSTERESIS__SHIFT 0x4
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE7_MASK 0x1000000
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE7__SHIFT 0x18
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE6_MASK 0x2000000
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE6__SHIFT 0x19
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE5_MASK 0x4000000
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE5__SHIFT 0x1a
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE4_MASK 0x8000000
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE4__SHIFT 0x1b
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE3_MASK 0x10000000
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE3__SHIFT 0x1c
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE2_MASK 0x20000000
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE2__SHIFT 0x1d
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE1_MASK 0x40000000
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE1__SHIFT 0x1e
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE0_MASK 0x80000000
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE0__SHIFT 0x1f
#define SDMA0_CNTL__TRAP_ENABLE_MASK 0x1
#define SDMA0_CNTL__TRAP_ENABLE__SHIFT 0x0
#define SDMA0_CNTL__SEM_INCOMPLETE_INT_ENABLE_MASK 0x2
#define SDMA0_CNTL__SEM_INCOMPLETE_INT_ENABLE__SHIFT 0x1
#define SDMA0_CNTL__SEM_WAIT_INT_ENABLE_MASK 0x4
#define SDMA0_CNTL__SEM_WAIT_INT_ENABLE__SHIFT 0x2
#define SDMA0_CNTL__DATA_SWAP_ENABLE_MASK 0x8
#define SDMA0_CNTL__DATA_SWAP_ENABLE__SHIFT 0x3
#define SDMA0_CNTL__FENCE_SWAP_ENABLE_MASK 0x10
#define SDMA0_CNTL__FENCE_SWAP_ENABLE__SHIFT 0x4
#define SDMA0_CNTL__MC_WRREQ_CREDIT_MASK 0x1f800
#define SDMA0_CNTL__MC_WRREQ_CREDIT__SHIFT 0xb
#define SDMA0_CNTL__AUTO_CTXSW_ENABLE_MASK 0x40000
#define SDMA0_CNTL__AUTO_CTXSW_ENABLE__SHIFT 0x12
#define SDMA0_CNTL__MC_RDREQ_CREDIT_MASK 0xfc00000
#define SDMA0_CNTL__MC_RDREQ_CREDIT__SHIFT 0x16
#define SDMA0_CNTL__CTXEMPTY_INT_ENABLE_MASK 0x10000000
#define SDMA0_CNTL__CTXEMPTY_INT_ENABLE__SHIFT 0x1c
#define SDMA0_CNTL__FROZEN_INT_ENABLE_MASK 0x20000000
#define SDMA0_CNTL__FROZEN_INT_ENABLE__SHIFT 0x1d
#define SDMA0_CHICKEN_BITS__COPY_EFFICIENCY_ENABLE_MASK 0x1
#define SDMA0_CHICKEN_BITS__COPY_EFFICIENCY_ENABLE__SHIFT 0x0
#define SDMA0_CHICKEN_BITS__COPY_OVERLAP_ENABLE_MASK 0x10000
#define SDMA0_CHICKEN_BITS__COPY_OVERLAP_ENABLE__SHIFT 0x10
#define SDMA0_CHICKEN_BITS__SRBM_POLL_RETRYING_MASK 0x100000
#define SDMA0_CHICKEN_BITS__SRBM_POLL_RETRYING__SHIFT 0x14
#define SDMA0_CHICKEN_BITS__CG_STATUS_OUTPUT_MASK 0x800000
#define SDMA0_CHICKEN_BITS__CG_STATUS_OUTPUT__SHIFT 0x17
#define SDMA0_TILING_CONFIG__PIPE_INTERLEAVE_SIZE_MASK 0x70
#define SDMA0_TILING_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT 0x4
#define SDMA0_HASH__CHANNEL_BITS_MASK 0x7
#define SDMA0_HASH__CHANNEL_BITS__SHIFT 0x0
#define SDMA0_HASH__BANK_BITS_MASK 0x70
#define SDMA0_HASH__BANK_BITS__SHIFT 0x4
#define SDMA0_HASH__CHANNEL_XOR_COUNT_MASK 0x700
#define SDMA0_HASH__CHANNEL_XOR_COUNT__SHIFT 0x8
#define SDMA0_HASH__BANK_XOR_COUNT_MASK 0x7000
#define SDMA0_HASH__BANK_XOR_COUNT__SHIFT 0xc
#define SDMA0_SEM_INCOMPLETE_TIMER_CNTL__TIMER_MASK 0xffff
#define SDMA0_SEM_INCOMPLETE_TIMER_CNTL__TIMER__SHIFT 0x0
#define SDMA0_SEM_WAIT_FAIL_TIMER_CNTL__TIMER_MASK 0xffffffff
#define SDMA0_SEM_WAIT_FAIL_TIMER_CNTL__TIMER__SHIFT 0x0
#define SDMA0_RB_RPTR_FETCH__OFFSET_MASK 0xfffffffc
#define SDMA0_RB_RPTR_FETCH__OFFSET__SHIFT 0x2
#define SDMA0_IB_OFFSET_FETCH__OFFSET_MASK 0x3ffffc
#define SDMA0_IB_OFFSET_FETCH__OFFSET__SHIFT 0x2
#define SDMA0_PROGRAM__STREAM_MASK 0xffffffff
#define SDMA0_PROGRAM__STREAM__SHIFT 0x0
#define SDMA0_STATUS_REG__IDLE_MASK 0x1
#define SDMA0_STATUS_REG__IDLE__SHIFT 0x0
#define SDMA0_STATUS_REG__REG_IDLE_MASK 0x2
#define SDMA0_STATUS_REG__REG_IDLE__SHIFT 0x1
#define SDMA0_STATUS_REG__RB_EMPTY_MASK 0x4
#define SDMA0_STATUS_REG__RB_EMPTY__SHIFT 0x2
#define SDMA0_STATUS_REG__RB_FULL_MASK 0x8
#define SDMA0_STATUS_REG__RB_FULL__SHIFT 0x3
#define SDMA0_STATUS_REG__RB_CMD_IDLE_MASK 0x10
#define SDMA0_STATUS_REG__RB_CMD_IDLE__SHIFT 0x4
#define SDMA0_STATUS_REG__RB_CMD_FULL_MASK 0x20
#define SDMA0_STATUS_REG__RB_CMD_FULL__SHIFT 0x5
#define SDMA0_STATUS_REG__IB_CMD_IDLE_MASK 0x40
#define SDMA0_STATUS_REG__IB_CMD_IDLE__SHIFT 0x6
#define SDMA0_STATUS_REG__IB_CMD_FULL_MASK 0x80
#define SDMA0_STATUS_REG__IB_CMD_FULL__SHIFT 0x7
#define SDMA0_STATUS_REG__BLOCK_IDLE_MASK 0x100
#define SDMA0_STATUS_REG__BLOCK_IDLE__SHIFT 0x8
#define SDMA0_STATUS_REG__INSIDE_IB_MASK 0x200
#define SDMA0_STATUS_REG__INSIDE_IB__SHIFT 0x9
#define SDMA0_STATUS_REG__EX_IDLE_MASK 0x400
#define SDMA0_STATUS_REG__EX_IDLE__SHIFT 0xa
#define SDMA0_STATUS_REG__EX_IDLE_POLL_TIMER_EXPIRE_MASK 0x800
#define SDMA0_STATUS_REG__EX_IDLE_POLL_TIMER_EXPIRE__SHIFT 0xb
#define SDMA0_STATUS_REG__PACKET_READY_MASK 0x1000
#define SDMA0_STATUS_REG__PACKET_READY__SHIFT 0xc
#define SDMA0_STATUS_REG__MC_WR_IDLE_MASK 0x2000
#define SDMA0_STATUS_REG__MC_WR_IDLE__SHIFT 0xd
#define SDMA0_STATUS_REG__SRBM_IDLE_MASK 0x4000
#define SDMA0_STATUS_REG__SRBM_IDLE__SHIFT 0xe
#define SDMA0_STATUS_REG__CONTEXT_EMPTY_MASK 0x8000
#define SDMA0_STATUS_REG__CONTEXT_EMPTY__SHIFT 0xf
#define SDMA0_STATUS_REG__RB_MC_RREQ_IDLE_MASK 0x20000
#define SDMA0_STATUS_REG__RB_MC_RREQ_IDLE__SHIFT 0x11
#define SDMA0_STATUS_REG__IB_MC_RREQ_IDLE_MASK 0x40000
#define SDMA0_STATUS_REG__IB_MC_RREQ_IDLE__SHIFT 0x12
#define SDMA0_STATUS_REG__MC_RD_IDLE_MASK 0x80000
#define SDMA0_STATUS_REG__MC_RD_IDLE__SHIFT 0x13
#define SDMA0_STATUS_REG__MC_RD_RET_STALL_MASK 0x200000
#define SDMA0_STATUS_REG__MC_RD_RET_STALL__SHIFT 0x15
#define SDMA0_STATUS_REG__MC_RD_NO_POLL_IDLE_MASK 0x400000
#define SDMA0_STATUS_REG__MC_RD_NO_POLL_IDLE__SHIFT 0x16
#define SDMA0_STATUS_REG__PREV_CMD_IDLE_MASK 0x2000000
#define SDMA0_STATUS_REG__PREV_CMD_IDLE__SHIFT 0x19
#define SDMA0_STATUS_REG__SEM_IDLE_MASK 0x4000000
#define SDMA0_STATUS_REG__SEM_IDLE__SHIFT 0x1a
#define SDMA0_STATUS_REG__SEM_REQ_STALL_MASK 0x8000000
#define SDMA0_STATUS_REG__SEM_REQ_STALL__SHIFT 0x1b
#define SDMA0_STATUS_REG__SEM_RESP_STATE_MASK 0x30000000
#define SDMA0_STATUS_REG__SEM_RESP_STATE__SHIFT 0x1c
#define SDMA0_STATUS_REG__INT_IDLE_MASK 0x40000000
#define SDMA0_STATUS_REG__INT_IDLE__SHIFT 0x1e
#define SDMA0_STATUS_REG__INT_REQ_STALL_MASK 0x80000000
#define SDMA0_STATUS_REG__INT_REQ_STALL__SHIFT 0x1f
#define SDMA0_STATUS1_REG__CE_WREQ_IDLE_MASK 0x1
#define SDMA0_STATUS1_REG__CE_WREQ_IDLE__SHIFT 0x0
#define SDMA0_STATUS1_REG__CE_WR_IDLE_MASK 0x2
#define SDMA0_STATUS1_REG__CE_WR_IDLE__SHIFT 0x1
#define SDMA0_STATUS1_REG__CE_SPLIT_IDLE_MASK 0x4
#define SDMA0_STATUS1_REG__CE_SPLIT_IDLE__SHIFT 0x2
#define SDMA0_STATUS1_REG__CE_RREQ_IDLE_MASK 0x8
#define SDMA0_STATUS1_REG__CE_RREQ_IDLE__SHIFT 0x3
#define SDMA0_STATUS1_REG__CE_OUT_IDLE_MASK 0x10
#define SDMA0_STATUS1_REG__CE_OUT_IDLE__SHIFT 0x4
#define SDMA0_STATUS1_REG__CE_IN_IDLE_MASK 0x20
#define SDMA0_STATUS1_REG__CE_IN_IDLE__SHIFT 0x5
#define SDMA0_STATUS1_REG__CE_DST_IDLE_MASK 0x40
#define SDMA0_STATUS1_REG__CE_DST_IDLE__SHIFT 0x6
#define SDMA0_STATUS1_REG__CE_AFIFO_FULL_MASK 0x400
#define SDMA0_STATUS1_REG__CE_AFIFO_FULL__SHIFT 0xa
#define SDMA0_STATUS1_REG__CE_INFO_FULL_MASK 0x2000
#define SDMA0_STATUS1_REG__CE_INFO_FULL__SHIFT 0xd
#define SDMA0_STATUS1_REG__CE_INFO1_FULL_MASK 0x4000
#define SDMA0_STATUS1_REG__CE_INFO1_FULL__SHIFT 0xe
#define SDMA0_STATUS1_REG__CE_RD_STALL_MASK 0x20000
#define SDMA0_STATUS1_REG__CE_RD_STALL__SHIFT 0x11
#define SDMA0_STATUS1_REG__CE_WR_STALL_MASK 0x40000
#define SDMA0_STATUS1_REG__CE_WR_STALL__SHIFT 0x12
#define SDMA0_PERFMON_CNTL__PERF_ENABLE0_MASK 0x1
#define SDMA0_PERFMON_CNTL__PERF_ENABLE0__SHIFT 0x0
#define SDMA0_PERFMON_CNTL__PERF_CLEAR0_MASK 0x2
#define SDMA0_PERFMON_CNTL__PERF_CLEAR0__SHIFT 0x1
#define SDMA0_PERFMON_CNTL__PERF_SEL0_MASK 0xfc
#define SDMA0_PERFMON_CNTL__PERF_SEL0__SHIFT 0x2
#define SDMA0_PERFMON_CNTL__PERF_ENABLE1_MASK 0x100
#define SDMA0_PERFMON_CNTL__PERF_ENABLE1__SHIFT 0x8
#define SDMA0_PERFMON_CNTL__PERF_CLEAR1_MASK 0x200
#define SDMA0_PERFMON_CNTL__PERF_CLEAR1__SHIFT 0x9
#define SDMA0_PERFMON_CNTL__PERF_SEL1_MASK 0xfc00
#define SDMA0_PERFMON_CNTL__PERF_SEL1__SHIFT 0xa
#define SDMA0_PERFCOUNTER0_RESULT__PERF_COUNT_MASK 0xffffffff
#define SDMA0_PERFCOUNTER0_RESULT__PERF_COUNT__SHIFT 0x0
#define SDMA0_PERFCOUNTER1_RESULT__PERF_COUNT_MASK 0xffffffff
#define SDMA0_PERFCOUNTER1_RESULT__PERF_COUNT__SHIFT 0x0
#define SDMA0_F32_CNTL__HALT_MASK 0x1
#define SDMA0_F32_CNTL__HALT__SHIFT 0x0
#define SDMA0_F32_CNTL__STEP_MASK 0x2
#define SDMA0_F32_CNTL__STEP__SHIFT 0x1
#define SDMA0_FREEZE__FREEZE_MASK 0x10
#define SDMA0_FREEZE__FREEZE__SHIFT 0x4
#define SDMA0_FREEZE__FROZEN_MASK 0x20
#define SDMA0_FREEZE__FROZEN__SHIFT 0x5
#define SDMA0_PHASE0_QUANTUM__UNIT_MASK 0xf
#define SDMA0_PHASE0_QUANTUM__UNIT__SHIFT 0x0
#define SDMA0_PHASE0_QUANTUM__VALUE_MASK 0xffff00
#define SDMA0_PHASE0_QUANTUM__VALUE__SHIFT 0x8
#define SDMA0_PHASE0_QUANTUM__PREFER_MASK 0x40000000
#define SDMA0_PHASE0_QUANTUM__PREFER__SHIFT 0x1e
#define SDMA0_PHASE1_QUANTUM__UNIT_MASK 0xf
#define SDMA0_PHASE1_QUANTUM__UNIT__SHIFT 0x0
#define SDMA0_PHASE1_QUANTUM__VALUE_MASK 0xffff00
#define SDMA0_PHASE1_QUANTUM__VALUE__SHIFT 0x8
#define SDMA0_PHASE1_QUANTUM__PREFER_MASK 0x40000000
#define SDMA0_PHASE1_QUANTUM__PREFER__SHIFT 0x1e
#define SDMA_POWER_GATING__PG_CNTL_ENABLE_MASK 0x1
#define SDMA_POWER_GATING__PG_CNTL_ENABLE__SHIFT 0x0
#define SDMA_POWER_GATING__AUTOMATIC_STATUS_ENABLE_MASK 0x2
#define SDMA_POWER_GATING__AUTOMATIC_STATUS_ENABLE__SHIFT 0x1
#define SDMA_POWER_GATING__PG_STATE_VALID_MASK 0x4
#define SDMA_POWER_GATING__PG_STATE_VALID__SHIFT 0x2
#define SDMA_POWER_GATING__PG_CNTL_STATUS_MASK 0x30
#define SDMA_POWER_GATING__PG_CNTL_STATUS__SHIFT 0x4
#define SDMA_POWER_GATING__SDMA0_ON_CONDITION_MASK 0x40
#define SDMA_POWER_GATING__SDMA0_ON_CONDITION__SHIFT 0x6
#define SDMA_POWER_GATING__SDMA1_ON_CONDITION_MASK 0x80
#define SDMA_POWER_GATING__SDMA1_ON_CONDITION__SHIFT 0x7
#define SDMA_POWER_GATING__POWER_OFF_DELAY_MASK 0xfff00
#define SDMA_POWER_GATING__POWER_OFF_DELAY__SHIFT 0x8
#define SDMA_POWER_GATING__POWER_ON_DELAY_MASK 0xfff00000
#define SDMA_POWER_GATING__POWER_ON_DELAY__SHIFT 0x14
#define SDMA_PGFSM_CONFIG__FSM_ADDR_MASK 0xff
#define SDMA_PGFSM_CONFIG__FSM_ADDR__SHIFT 0x0
#define SDMA_PGFSM_CONFIG__POWER_DOWN_MASK 0x100
#define SDMA_PGFSM_CONFIG__POWER_DOWN__SHIFT 0x8
#define SDMA_PGFSM_CONFIG__POWER_UP_MASK 0x200
#define SDMA_PGFSM_CONFIG__POWER_UP__SHIFT 0x9
#define SDMA_PGFSM_CONFIG__P1_SELECT_MASK 0x400
#define SDMA_PGFSM_CONFIG__P1_SELECT__SHIFT 0xa
#define SDMA_PGFSM_CONFIG__P2_SELECT_MASK 0x800
#define SDMA_PGFSM_CONFIG__P2_SELECT__SHIFT 0xb
#define SDMA_PGFSM_CONFIG__WRITE_MASK 0x1000
#define SDMA_PGFSM_CONFIG__WRITE__SHIFT 0xc
#define SDMA_PGFSM_CONFIG__READ_MASK 0x2000
#define SDMA_PGFSM_CONFIG__READ__SHIFT 0xd
#define SDMA_PGFSM_CONFIG__SRBM_OVERRIDE_MASK 0x8000000
#define SDMA_PGFSM_CONFIG__SRBM_OVERRIDE__SHIFT 0x1b
#define SDMA_PGFSM_CONFIG__REG_ADDR_MASK 0xf0000000
#define SDMA_PGFSM_CONFIG__REG_ADDR__SHIFT 0x1c
#define SDMA_PGFSM_WRITE__VALUE_MASK 0xffffffff
#define SDMA_PGFSM_WRITE__VALUE__SHIFT 0x0
#define SDMA_PGFSM_READ__VALUE_MASK 0xffffff
#define SDMA_PGFSM_READ__VALUE__SHIFT 0x0
#define SDMA0_EDC_CONFIG__DIS_EDC_MASK 0x2
#define SDMA0_EDC_CONFIG__DIS_EDC__SHIFT 0x1
#define SDMA0_EDC_CONFIG__ECC_INT_ENABLE_MASK 0x4
#define SDMA0_EDC_CONFIG__ECC_INT_ENABLE__SHIFT 0x2
#define SDMA0_GFX_RB_CNTL__RB_ENABLE_MASK 0x1
#define SDMA0_GFX_RB_CNTL__RB_ENABLE__SHIFT 0x0
#define SDMA0_GFX_RB_CNTL__RB_SIZE_MASK 0x3e
#define SDMA0_GFX_RB_CNTL__RB_SIZE__SHIFT 0x1
#define SDMA0_GFX_RB_CNTL__RB_SWAP_ENABLE_MASK 0x200
#define SDMA0_GFX_RB_CNTL__RB_SWAP_ENABLE__SHIFT 0x9
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK 0x1000
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT 0xc
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK 0x2000
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT 0xd
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK 0x1f0000
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT 0x10
#define SDMA0_GFX_RB_CNTL__RB_PRIV_MASK 0x800000
#define SDMA0_GFX_RB_CNTL__RB_PRIV__SHIFT 0x17
#define SDMA0_GFX_RB_CNTL__RB_VMID_MASK 0xf000000
#define SDMA0_GFX_RB_CNTL__RB_VMID__SHIFT 0x18
#define SDMA0_GFX_RB_BASE__ADDR_MASK 0xffffffff
#define SDMA0_GFX_RB_BASE__ADDR__SHIFT 0x0
#define SDMA0_GFX_RB_BASE_HI__ADDR_MASK 0xffffff
#define SDMA0_GFX_RB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA0_GFX_RB_RPTR__OFFSET_MASK 0xfffffffc
#define SDMA0_GFX_RB_RPTR__OFFSET__SHIFT 0x2
#define SDMA0_GFX_RB_WPTR__OFFSET_MASK 0xfffffffc
#define SDMA0_GFX_RB_WPTR__OFFSET__SHIFT 0x2
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__ENABLE_MASK 0x1
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__ENABLE__SHIFT 0x0
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK 0x2
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT 0x1
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__FREQUENCY_MASK 0xfff0
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT 0x4
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK 0xffff0000
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT 0x10
#define SDMA0_GFX_RB_WPTR_POLL_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA0_GFX_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA0_GFX_RB_WPTR_POLL_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA0_GFX_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA0_GFX_RB_RPTR_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA0_GFX_RB_RPTR_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA0_GFX_RB_RPTR_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA0_GFX_RB_RPTR_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA0_GFX_IB_CNTL__IB_ENABLE_MASK 0x1
#define SDMA0_GFX_IB_CNTL__IB_ENABLE__SHIFT 0x0
#define SDMA0_GFX_IB_CNTL__IB_SWAP_ENABLE_MASK 0x10
#define SDMA0_GFX_IB_CNTL__IB_SWAP_ENABLE__SHIFT 0x4
#define SDMA0_GFX_IB_CNTL__SWITCH_INSIDE_IB_MASK 0x100
#define SDMA0_GFX_IB_CNTL__SWITCH_INSIDE_IB__SHIFT 0x8
#define SDMA0_GFX_IB_CNTL__CMD_VMID_MASK 0xf0000
#define SDMA0_GFX_IB_CNTL__CMD_VMID__SHIFT 0x10
#define SDMA0_GFX_IB_RPTR__OFFSET_MASK 0x3ffffc
#define SDMA0_GFX_IB_RPTR__OFFSET__SHIFT 0x2
#define SDMA0_GFX_IB_OFFSET__OFFSET_MASK 0x3ffffc
#define SDMA0_GFX_IB_OFFSET__OFFSET__SHIFT 0x2
#define SDMA0_GFX_IB_BASE_LO__ADDR_MASK 0xffffffe0
#define SDMA0_GFX_IB_BASE_LO__ADDR__SHIFT 0x5
#define SDMA0_GFX_IB_BASE_HI__ADDR_MASK 0xffffffff
#define SDMA0_GFX_IB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA0_GFX_IB_SIZE__SIZE_MASK 0xfffff
#define SDMA0_GFX_IB_SIZE__SIZE__SHIFT 0x0
#define SDMA0_GFX_SKIP_CNTL__SKIP_COUNT_MASK 0x3fff
#define SDMA0_GFX_SKIP_CNTL__SKIP_COUNT__SHIFT 0x0
#define SDMA0_GFX_CONTEXT_STATUS__SELECTED_MASK 0x1
#define SDMA0_GFX_CONTEXT_STATUS__SELECTED__SHIFT 0x0
#define SDMA0_GFX_CONTEXT_STATUS__IDLE_MASK 0x4
#define SDMA0_GFX_CONTEXT_STATUS__IDLE__SHIFT 0x2
#define SDMA0_GFX_CONTEXT_STATUS__EXPIRED_MASK 0x8
#define SDMA0_GFX_CONTEXT_STATUS__EXPIRED__SHIFT 0x3
#define SDMA0_GFX_CONTEXT_STATUS__EXCEPTION_MASK 0x70
#define SDMA0_GFX_CONTEXT_STATUS__EXCEPTION__SHIFT 0x4
#define SDMA0_GFX_CONTEXT_STATUS__CTXSW_ABLE_MASK 0x80
#define SDMA0_GFX_CONTEXT_STATUS__CTXSW_ABLE__SHIFT 0x7
#define SDMA0_GFX_CONTEXT_STATUS__CTXSW_READY_MASK 0x100
#define SDMA0_GFX_CONTEXT_STATUS__CTXSW_READY__SHIFT 0x8
#define SDMA0_GFX_CONTEXT_CNTL__RESUME_CTX_MASK 0x10000
#define SDMA0_GFX_CONTEXT_CNTL__RESUME_CTX__SHIFT 0x10
#define SDMA0_GFX_CONTEXT_CNTL__SESSION_SEL_MASK 0xf000000
#define SDMA0_GFX_CONTEXT_CNTL__SESSION_SEL__SHIFT 0x18
#define SDMA0_GFX_VIRTUAL_ADDR__ATC_MASK 0x1
#define SDMA0_GFX_VIRTUAL_ADDR__ATC__SHIFT 0x0
#define SDMA0_GFX_VIRTUAL_ADDR__PTR32_MASK 0x10
#define SDMA0_GFX_VIRTUAL_ADDR__PTR32__SHIFT 0x4
#define SDMA0_GFX_VIRTUAL_ADDR__SHARED_BASE_MASK 0x700
#define SDMA0_GFX_VIRTUAL_ADDR__SHARED_BASE__SHIFT 0x8
#define SDMA0_GFX_VIRTUAL_ADDR__VM_HOLE_MASK 0x40000000
#define SDMA0_GFX_VIRTUAL_ADDR__VM_HOLE__SHIFT 0x1e
#define SDMA0_GFX_APE1_CNTL__BASE_MASK 0xffff
#define SDMA0_GFX_APE1_CNTL__BASE__SHIFT 0x0
#define SDMA0_GFX_APE1_CNTL__LIMIT_MASK 0xffff0000
#define SDMA0_GFX_APE1_CNTL__LIMIT__SHIFT 0x10
#define SDMA0_GFX_WATERMARK__RD_OUTSTANDING_MASK 0xfff
#define SDMA0_GFX_WATERMARK__RD_OUTSTANDING__SHIFT 0x0
#define SDMA0_GFX_WATERMARK__WR_OUTSTANDING_MASK 0x1ff0000
#define SDMA0_GFX_WATERMARK__WR_OUTSTANDING__SHIFT 0x10
#define SDMA0_RLC0_RB_CNTL__RB_ENABLE_MASK 0x1
#define SDMA0_RLC0_RB_CNTL__RB_ENABLE__SHIFT 0x0
#define SDMA0_RLC0_RB_CNTL__RB_SIZE_MASK 0x3e
#define SDMA0_RLC0_RB_CNTL__RB_SIZE__SHIFT 0x1
#define SDMA0_RLC0_RB_CNTL__RB_SWAP_ENABLE_MASK 0x200
#define SDMA0_RLC0_RB_CNTL__RB_SWAP_ENABLE__SHIFT 0x9
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK 0x1000
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT 0xc
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK 0x2000
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT 0xd
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK 0x1f0000
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT 0x10
#define SDMA0_RLC0_RB_CNTL__RB_PRIV_MASK 0x800000
#define SDMA0_RLC0_RB_CNTL__RB_PRIV__SHIFT 0x17
#define SDMA0_RLC0_RB_CNTL__RB_VMID_MASK 0xf000000
#define SDMA0_RLC0_RB_CNTL__RB_VMID__SHIFT 0x18
#define SDMA0_RLC0_RB_BASE__ADDR_MASK 0xffffffff
#define SDMA0_RLC0_RB_BASE__ADDR__SHIFT 0x0
#define SDMA0_RLC0_RB_BASE_HI__ADDR_MASK 0xffffff
#define SDMA0_RLC0_RB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA0_RLC0_RB_RPTR__OFFSET_MASK 0xfffffffc
#define SDMA0_RLC0_RB_RPTR__OFFSET__SHIFT 0x2
#define SDMA0_RLC0_RB_WPTR__OFFSET_MASK 0xfffffffc
#define SDMA0_RLC0_RB_WPTR__OFFSET__SHIFT 0x2
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__ENABLE_MASK 0x1
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__ENABLE__SHIFT 0x0
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK 0x2
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT 0x1
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__FREQUENCY_MASK 0xfff0
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT 0x4
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK 0xffff0000
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT 0x10
#define SDMA0_RLC0_RB_WPTR_POLL_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA0_RLC0_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA0_RLC0_RB_WPTR_POLL_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA0_RLC0_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA0_RLC0_RB_RPTR_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA0_RLC0_RB_RPTR_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA0_RLC0_RB_RPTR_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA0_RLC0_RB_RPTR_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA0_RLC0_IB_CNTL__IB_ENABLE_MASK 0x1
#define SDMA0_RLC0_IB_CNTL__IB_ENABLE__SHIFT 0x0
#define SDMA0_RLC0_IB_CNTL__IB_SWAP_ENABLE_MASK 0x10
#define SDMA0_RLC0_IB_CNTL__IB_SWAP_ENABLE__SHIFT 0x4
#define SDMA0_RLC0_IB_CNTL__SWITCH_INSIDE_IB_MASK 0x100
#define SDMA0_RLC0_IB_CNTL__SWITCH_INSIDE_IB__SHIFT 0x8
#define SDMA0_RLC0_IB_CNTL__CMD_VMID_MASK 0xf0000
#define SDMA0_RLC0_IB_CNTL__CMD_VMID__SHIFT 0x10
#define SDMA0_RLC0_IB_RPTR__OFFSET_MASK 0x3ffffc
#define SDMA0_RLC0_IB_RPTR__OFFSET__SHIFT 0x2
#define SDMA0_RLC0_IB_OFFSET__OFFSET_MASK 0x3ffffc
#define SDMA0_RLC0_IB_OFFSET__OFFSET__SHIFT 0x2
#define SDMA0_RLC0_IB_BASE_LO__ADDR_MASK 0xffffffe0
#define SDMA0_RLC0_IB_BASE_LO__ADDR__SHIFT 0x5
#define SDMA0_RLC0_IB_BASE_HI__ADDR_MASK 0xffffffff
#define SDMA0_RLC0_IB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA0_RLC0_IB_SIZE__SIZE_MASK 0xfffff
#define SDMA0_RLC0_IB_SIZE__SIZE__SHIFT 0x0
#define SDMA0_RLC0_SKIP_CNTL__SKIP_COUNT_MASK 0x3fff
#define SDMA0_RLC0_SKIP_CNTL__SKIP_COUNT__SHIFT 0x0
#define SDMA0_RLC0_CONTEXT_STATUS__SELECTED_MASK 0x1
#define SDMA0_RLC0_CONTEXT_STATUS__SELECTED__SHIFT 0x0
#define SDMA0_RLC0_CONTEXT_STATUS__IDLE_MASK 0x4
#define SDMA0_RLC0_CONTEXT_STATUS__IDLE__SHIFT 0x2
#define SDMA0_RLC0_CONTEXT_STATUS__EXPIRED_MASK 0x8
#define SDMA0_RLC0_CONTEXT_STATUS__EXPIRED__SHIFT 0x3
#define SDMA0_RLC0_CONTEXT_STATUS__EXCEPTION_MASK 0x70
#define SDMA0_RLC0_CONTEXT_STATUS__EXCEPTION__SHIFT 0x4
#define SDMA0_RLC0_CONTEXT_STATUS__CTXSW_ABLE_MASK 0x80
#define SDMA0_RLC0_CONTEXT_STATUS__CTXSW_ABLE__SHIFT 0x7
#define SDMA0_RLC0_CONTEXT_STATUS__CTXSW_READY_MASK 0x100
#define SDMA0_RLC0_CONTEXT_STATUS__CTXSW_READY__SHIFT 0x8
#define SDMA0_RLC0_DOORBELL__OFFSET_MASK 0x1fffff
#define SDMA0_RLC0_DOORBELL__OFFSET__SHIFT 0x0
#define SDMA0_RLC0_DOORBELL__ENABLE_MASK 0x10000000
#define SDMA0_RLC0_DOORBELL__ENABLE__SHIFT 0x1c
#define SDMA0_RLC0_DOORBELL__CAPTURED_MASK 0x40000000
#define SDMA0_RLC0_DOORBELL__CAPTURED__SHIFT 0x1e
#define SDMA0_RLC0_VIRTUAL_ADDR__ATC_MASK 0x1
#define SDMA0_RLC0_VIRTUAL_ADDR__ATC__SHIFT 0x0
#define SDMA0_RLC0_VIRTUAL_ADDR__PTR32_MASK 0x10
#define SDMA0_RLC0_VIRTUAL_ADDR__PTR32__SHIFT 0x4
#define SDMA0_RLC0_VIRTUAL_ADDR__SHARED_BASE_MASK 0x700
#define SDMA0_RLC0_VIRTUAL_ADDR__SHARED_BASE__SHIFT 0x8
#define SDMA0_RLC0_VIRTUAL_ADDR__VM_HOLE_MASK 0x40000000
#define SDMA0_RLC0_VIRTUAL_ADDR__VM_HOLE__SHIFT 0x1e
#define SDMA0_RLC0_APE1_CNTL__BASE_MASK 0xffff
#define SDMA0_RLC0_APE1_CNTL__BASE__SHIFT 0x0
#define SDMA0_RLC0_APE1_CNTL__LIMIT_MASK 0xffff0000
#define SDMA0_RLC0_APE1_CNTL__LIMIT__SHIFT 0x10
#define SDMA0_RLC0_DOORBELL_LOG__BE_ERROR_MASK 0x1
#define SDMA0_RLC0_DOORBELL_LOG__BE_ERROR__SHIFT 0x0
#define SDMA0_RLC0_DOORBELL_LOG__DATA_MASK 0xfffffffc
#define SDMA0_RLC0_DOORBELL_LOG__DATA__SHIFT 0x2
#define SDMA0_RLC0_WATERMARK__RD_OUTSTANDING_MASK 0xfff
#define SDMA0_RLC0_WATERMARK__RD_OUTSTANDING__SHIFT 0x0
#define SDMA0_RLC0_WATERMARK__WR_OUTSTANDING_MASK 0x1ff0000
#define SDMA0_RLC0_WATERMARK__WR_OUTSTANDING__SHIFT 0x10
#define SDMA0_RLC1_RB_CNTL__RB_ENABLE_MASK 0x1
#define SDMA0_RLC1_RB_CNTL__RB_ENABLE__SHIFT 0x0
#define SDMA0_RLC1_RB_CNTL__RB_SIZE_MASK 0x3e
#define SDMA0_RLC1_RB_CNTL__RB_SIZE__SHIFT 0x1
#define SDMA0_RLC1_RB_CNTL__RB_SWAP_ENABLE_MASK 0x200
#define SDMA0_RLC1_RB_CNTL__RB_SWAP_ENABLE__SHIFT 0x9
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK 0x1000
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT 0xc
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK 0x2000
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT 0xd
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK 0x1f0000
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT 0x10
#define SDMA0_RLC1_RB_CNTL__RB_PRIV_MASK 0x800000
#define SDMA0_RLC1_RB_CNTL__RB_PRIV__SHIFT 0x17
#define SDMA0_RLC1_RB_CNTL__RB_VMID_MASK 0xf000000
#define SDMA0_RLC1_RB_CNTL__RB_VMID__SHIFT 0x18
#define SDMA0_RLC1_RB_BASE__ADDR_MASK 0xffffffff
#define SDMA0_RLC1_RB_BASE__ADDR__SHIFT 0x0
#define SDMA0_RLC1_RB_BASE_HI__ADDR_MASK 0xffffff
#define SDMA0_RLC1_RB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA0_RLC1_RB_RPTR__OFFSET_MASK 0xfffffffc
#define SDMA0_RLC1_RB_RPTR__OFFSET__SHIFT 0x2
#define SDMA0_RLC1_RB_WPTR__OFFSET_MASK 0xfffffffc
#define SDMA0_RLC1_RB_WPTR__OFFSET__SHIFT 0x2
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__ENABLE_MASK 0x1
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__ENABLE__SHIFT 0x0
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK 0x2
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT 0x1
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__FREQUENCY_MASK 0xfff0
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT 0x4
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK 0xffff0000
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT 0x10
#define SDMA0_RLC1_RB_WPTR_POLL_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA0_RLC1_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA0_RLC1_RB_WPTR_POLL_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA0_RLC1_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA0_RLC1_RB_RPTR_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA0_RLC1_RB_RPTR_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA0_RLC1_RB_RPTR_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA0_RLC1_RB_RPTR_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA0_RLC1_IB_CNTL__IB_ENABLE_MASK 0x1
#define SDMA0_RLC1_IB_CNTL__IB_ENABLE__SHIFT 0x0
#define SDMA0_RLC1_IB_CNTL__IB_SWAP_ENABLE_MASK 0x10
#define SDMA0_RLC1_IB_CNTL__IB_SWAP_ENABLE__SHIFT 0x4
#define SDMA0_RLC1_IB_CNTL__SWITCH_INSIDE_IB_MASK 0x100
#define SDMA0_RLC1_IB_CNTL__SWITCH_INSIDE_IB__SHIFT 0x8
#define SDMA0_RLC1_IB_CNTL__CMD_VMID_MASK 0xf0000
#define SDMA0_RLC1_IB_CNTL__CMD_VMID__SHIFT 0x10
#define SDMA0_RLC1_IB_RPTR__OFFSET_MASK 0x3ffffc
#define SDMA0_RLC1_IB_RPTR__OFFSET__SHIFT 0x2
#define SDMA0_RLC1_IB_OFFSET__OFFSET_MASK 0x3ffffc
#define SDMA0_RLC1_IB_OFFSET__OFFSET__SHIFT 0x2
#define SDMA0_RLC1_IB_BASE_LO__ADDR_MASK 0xffffffe0
#define SDMA0_RLC1_IB_BASE_LO__ADDR__SHIFT 0x5
#define SDMA0_RLC1_IB_BASE_HI__ADDR_MASK 0xffffffff
#define SDMA0_RLC1_IB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA0_RLC1_IB_SIZE__SIZE_MASK 0xfffff
#define SDMA0_RLC1_IB_SIZE__SIZE__SHIFT 0x0
#define SDMA0_RLC1_SKIP_CNTL__SKIP_COUNT_MASK 0x3fff
#define SDMA0_RLC1_SKIP_CNTL__SKIP_COUNT__SHIFT 0x0
#define SDMA0_RLC1_CONTEXT_STATUS__SELECTED_MASK 0x1
#define SDMA0_RLC1_CONTEXT_STATUS__SELECTED__SHIFT 0x0
#define SDMA0_RLC1_CONTEXT_STATUS__IDLE_MASK 0x4
#define SDMA0_RLC1_CONTEXT_STATUS__IDLE__SHIFT 0x2
#define SDMA0_RLC1_CONTEXT_STATUS__EXPIRED_MASK 0x8
#define SDMA0_RLC1_CONTEXT_STATUS__EXPIRED__SHIFT 0x3
#define SDMA0_RLC1_CONTEXT_STATUS__EXCEPTION_MASK 0x70
#define SDMA0_RLC1_CONTEXT_STATUS__EXCEPTION__SHIFT 0x4
#define SDMA0_RLC1_CONTEXT_STATUS__CTXSW_ABLE_MASK 0x80
#define SDMA0_RLC1_CONTEXT_STATUS__CTXSW_ABLE__SHIFT 0x7
#define SDMA0_RLC1_CONTEXT_STATUS__CTXSW_READY_MASK 0x100
#define SDMA0_RLC1_CONTEXT_STATUS__CTXSW_READY__SHIFT 0x8
#define SDMA0_RLC1_DOORBELL__OFFSET_MASK 0x1fffff
#define SDMA0_RLC1_DOORBELL__OFFSET__SHIFT 0x0
#define SDMA0_RLC1_DOORBELL__ENABLE_MASK 0x10000000
#define SDMA0_RLC1_DOORBELL__ENABLE__SHIFT 0x1c
#define SDMA0_RLC1_DOORBELL__CAPTURED_MASK 0x40000000
#define SDMA0_RLC1_DOORBELL__CAPTURED__SHIFT 0x1e
#define SDMA0_RLC1_VIRTUAL_ADDR__ATC_MASK 0x1
#define SDMA0_RLC1_VIRTUAL_ADDR__ATC__SHIFT 0x0
#define SDMA0_RLC1_VIRTUAL_ADDR__PTR32_MASK 0x10
#define SDMA0_RLC1_VIRTUAL_ADDR__PTR32__SHIFT 0x4
#define SDMA0_RLC1_VIRTUAL_ADDR__SHARED_BASE_MASK 0x700
#define SDMA0_RLC1_VIRTUAL_ADDR__SHARED_BASE__SHIFT 0x8
#define SDMA0_RLC1_VIRTUAL_ADDR__VM_HOLE_MASK 0x40000000
#define SDMA0_RLC1_VIRTUAL_ADDR__VM_HOLE__SHIFT 0x1e
#define SDMA0_RLC1_APE1_CNTL__BASE_MASK 0xffff
#define SDMA0_RLC1_APE1_CNTL__BASE__SHIFT 0x0
#define SDMA0_RLC1_APE1_CNTL__LIMIT_MASK 0xffff0000
#define SDMA0_RLC1_APE1_CNTL__LIMIT__SHIFT 0x10
#define SDMA0_RLC1_DOORBELL_LOG__BE_ERROR_MASK 0x1
#define SDMA0_RLC1_DOORBELL_LOG__BE_ERROR__SHIFT 0x0
#define SDMA0_RLC1_DOORBELL_LOG__DATA_MASK 0xfffffffc
#define SDMA0_RLC1_DOORBELL_LOG__DATA__SHIFT 0x2
#define SDMA0_RLC1_WATERMARK__RD_OUTSTANDING_MASK 0xfff
#define SDMA0_RLC1_WATERMARK__RD_OUTSTANDING__SHIFT 0x0
#define SDMA0_RLC1_WATERMARK__WR_OUTSTANDING_MASK 0x1ff0000
#define SDMA0_RLC1_WATERMARK__WR_OUTSTANDING__SHIFT 0x10
#define SDMA1_UCODE_ADDR__VALUE_MASK 0x7ff
#define SDMA1_UCODE_ADDR__VALUE__SHIFT 0x0
#define SDMA1_UCODE_DATA__VALUE_MASK 0xffffffff
#define SDMA1_UCODE_DATA__VALUE__SHIFT 0x0
#define SDMA1_POWER_CNTL__MEM_POWER_OVERRIDE_MASK 0x100
#define SDMA1_POWER_CNTL__MEM_POWER_OVERRIDE__SHIFT 0x8
#define SDMA1_CLK_CTRL__ON_DELAY_MASK 0xf
#define SDMA1_CLK_CTRL__ON_DELAY__SHIFT 0x0
#define SDMA1_CLK_CTRL__OFF_HYSTERESIS_MASK 0xff0
#define SDMA1_CLK_CTRL__OFF_HYSTERESIS__SHIFT 0x4
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE7_MASK 0x1000000
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE7__SHIFT 0x18
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE6_MASK 0x2000000
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE6__SHIFT 0x19
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE5_MASK 0x4000000
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE5__SHIFT 0x1a
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE4_MASK 0x8000000
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE4__SHIFT 0x1b
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE3_MASK 0x10000000
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE3__SHIFT 0x1c
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE2_MASK 0x20000000
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE2__SHIFT 0x1d
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE1_MASK 0x40000000
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE1__SHIFT 0x1e
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE0_MASK 0x80000000
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE0__SHIFT 0x1f
#define SDMA1_CNTL__TRAP_ENABLE_MASK 0x1
#define SDMA1_CNTL__TRAP_ENABLE__SHIFT 0x0
#define SDMA1_CNTL__SEM_INCOMPLETE_INT_ENABLE_MASK 0x2
#define SDMA1_CNTL__SEM_INCOMPLETE_INT_ENABLE__SHIFT 0x1
#define SDMA1_CNTL__SEM_WAIT_INT_ENABLE_MASK 0x4
#define SDMA1_CNTL__SEM_WAIT_INT_ENABLE__SHIFT 0x2
#define SDMA1_CNTL__DATA_SWAP_ENABLE_MASK 0x8
#define SDMA1_CNTL__DATA_SWAP_ENABLE__SHIFT 0x3
#define SDMA1_CNTL__FENCE_SWAP_ENABLE_MASK 0x10
#define SDMA1_CNTL__FENCE_SWAP_ENABLE__SHIFT 0x4
#define SDMA1_CNTL__MC_WRREQ_CREDIT_MASK 0x1f800
#define SDMA1_CNTL__MC_WRREQ_CREDIT__SHIFT 0xb
#define SDMA1_CNTL__AUTO_CTXSW_ENABLE_MASK 0x40000
#define SDMA1_CNTL__AUTO_CTXSW_ENABLE__SHIFT 0x12
#define SDMA1_CNTL__MC_RDREQ_CREDIT_MASK 0xfc00000
#define SDMA1_CNTL__MC_RDREQ_CREDIT__SHIFT 0x16
#define SDMA1_CNTL__CTXEMPTY_INT_ENABLE_MASK 0x10000000
#define SDMA1_CNTL__CTXEMPTY_INT_ENABLE__SHIFT 0x1c
#define SDMA1_CNTL__FROZEN_INT_ENABLE_MASK 0x20000000
#define SDMA1_CNTL__FROZEN_INT_ENABLE__SHIFT 0x1d
#define SDMA1_CHICKEN_BITS__COPY_EFFICIENCY_ENABLE_MASK 0x1
#define SDMA1_CHICKEN_BITS__COPY_EFFICIENCY_ENABLE__SHIFT 0x0
#define SDMA1_CHICKEN_BITS__COPY_OVERLAP_ENABLE_MASK 0x10000
#define SDMA1_CHICKEN_BITS__COPY_OVERLAP_ENABLE__SHIFT 0x10
#define SDMA1_CHICKEN_BITS__SRBM_POLL_RETRYING_MASK 0x100000
#define SDMA1_CHICKEN_BITS__SRBM_POLL_RETRYING__SHIFT 0x14
#define SDMA1_CHICKEN_BITS__CG_STATUS_OUTPUT_MASK 0x800000
#define SDMA1_CHICKEN_BITS__CG_STATUS_OUTPUT__SHIFT 0x17
#define SDMA1_TILING_CONFIG__PIPE_INTERLEAVE_SIZE_MASK 0x70
#define SDMA1_TILING_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT 0x4
#define SDMA1_HASH__CHANNEL_BITS_MASK 0x7
#define SDMA1_HASH__CHANNEL_BITS__SHIFT 0x0
#define SDMA1_HASH__BANK_BITS_MASK 0x70
#define SDMA1_HASH__BANK_BITS__SHIFT 0x4
#define SDMA1_HASH__CHANNEL_XOR_COUNT_MASK 0x700
#define SDMA1_HASH__CHANNEL_XOR_COUNT__SHIFT 0x8
#define SDMA1_HASH__BANK_XOR_COUNT_MASK 0x7000
#define SDMA1_HASH__BANK_XOR_COUNT__SHIFT 0xc
#define SDMA1_SEM_INCOMPLETE_TIMER_CNTL__TIMER_MASK 0xffff
#define SDMA1_SEM_INCOMPLETE_TIMER_CNTL__TIMER__SHIFT 0x0
#define SDMA1_SEM_WAIT_FAIL_TIMER_CNTL__TIMER_MASK 0xffffffff
#define SDMA1_SEM_WAIT_FAIL_TIMER_CNTL__TIMER__SHIFT 0x0
#define SDMA1_RB_RPTR_FETCH__OFFSET_MASK 0xfffffffc
#define SDMA1_RB_RPTR_FETCH__OFFSET__SHIFT 0x2
#define SDMA1_IB_OFFSET_FETCH__OFFSET_MASK 0x3ffffc
#define SDMA1_IB_OFFSET_FETCH__OFFSET__SHIFT 0x2
#define SDMA1_PROGRAM__STREAM_MASK 0xffffffff
#define SDMA1_PROGRAM__STREAM__SHIFT 0x0
#define SDMA1_STATUS_REG__IDLE_MASK 0x1
#define SDMA1_STATUS_REG__IDLE__SHIFT 0x0
#define SDMA1_STATUS_REG__REG_IDLE_MASK 0x2
#define SDMA1_STATUS_REG__REG_IDLE__SHIFT 0x1
#define SDMA1_STATUS_REG__RB_EMPTY_MASK 0x4
#define SDMA1_STATUS_REG__RB_EMPTY__SHIFT 0x2
#define SDMA1_STATUS_REG__RB_FULL_MASK 0x8
#define SDMA1_STATUS_REG__RB_FULL__SHIFT 0x3
#define SDMA1_STATUS_REG__RB_CMD_IDLE_MASK 0x10
#define SDMA1_STATUS_REG__RB_CMD_IDLE__SHIFT 0x4
#define SDMA1_STATUS_REG__RB_CMD_FULL_MASK 0x20
#define SDMA1_STATUS_REG__RB_CMD_FULL__SHIFT 0x5
#define SDMA1_STATUS_REG__IB_CMD_IDLE_MASK 0x40
#define SDMA1_STATUS_REG__IB_CMD_IDLE__SHIFT 0x6
#define SDMA1_STATUS_REG__IB_CMD_FULL_MASK 0x80
#define SDMA1_STATUS_REG__IB_CMD_FULL__SHIFT 0x7
#define SDMA1_STATUS_REG__BLOCK_IDLE_MASK 0x100
#define SDMA1_STATUS_REG__BLOCK_IDLE__SHIFT 0x8
#define SDMA1_STATUS_REG__INSIDE_IB_MASK 0x200
#define SDMA1_STATUS_REG__INSIDE_IB__SHIFT 0x9
#define SDMA1_STATUS_REG__EX_IDLE_MASK 0x400
#define SDMA1_STATUS_REG__EX_IDLE__SHIFT 0xa
#define SDMA1_STATUS_REG__EX_IDLE_POLL_TIMER_EXPIRE_MASK 0x800
#define SDMA1_STATUS_REG__EX_IDLE_POLL_TIMER_EXPIRE__SHIFT 0xb
#define SDMA1_STATUS_REG__PACKET_READY_MASK 0x1000
#define SDMA1_STATUS_REG__PACKET_READY__SHIFT 0xc
#define SDMA1_STATUS_REG__MC_WR_IDLE_MASK 0x2000
#define SDMA1_STATUS_REG__MC_WR_IDLE__SHIFT 0xd
#define SDMA1_STATUS_REG__SRBM_IDLE_MASK 0x4000
#define SDMA1_STATUS_REG__SRBM_IDLE__SHIFT 0xe
#define SDMA1_STATUS_REG__CONTEXT_EMPTY_MASK 0x8000
#define SDMA1_STATUS_REG__CONTEXT_EMPTY__SHIFT 0xf
#define SDMA1_STATUS_REG__RB_MC_RREQ_IDLE_MASK 0x20000
#define SDMA1_STATUS_REG__RB_MC_RREQ_IDLE__SHIFT 0x11
#define SDMA1_STATUS_REG__IB_MC_RREQ_IDLE_MASK 0x40000
#define SDMA1_STATUS_REG__IB_MC_RREQ_IDLE__SHIFT 0x12
#define SDMA1_STATUS_REG__MC_RD_IDLE_MASK 0x80000
#define SDMA1_STATUS_REG__MC_RD_IDLE__SHIFT 0x13
#define SDMA1_STATUS_REG__MC_RD_RET_STALL_MASK 0x200000
#define SDMA1_STATUS_REG__MC_RD_RET_STALL__SHIFT 0x15
#define SDMA1_STATUS_REG__MC_RD_NO_POLL_IDLE_MASK 0x400000
#define SDMA1_STATUS_REG__MC_RD_NO_POLL_IDLE__SHIFT 0x16
#define SDMA1_STATUS_REG__PREV_CMD_IDLE_MASK 0x2000000
#define SDMA1_STATUS_REG__PREV_CMD_IDLE__SHIFT 0x19
#define SDMA1_STATUS_REG__SEM_IDLE_MASK 0x4000000
#define SDMA1_STATUS_REG__SEM_IDLE__SHIFT 0x1a
#define SDMA1_STATUS_REG__SEM_REQ_STALL_MASK 0x8000000
#define SDMA1_STATUS_REG__SEM_REQ_STALL__SHIFT 0x1b
#define SDMA1_STATUS_REG__SEM_RESP_STATE_MASK 0x30000000
#define SDMA1_STATUS_REG__SEM_RESP_STATE__SHIFT 0x1c
#define SDMA1_STATUS_REG__INT_IDLE_MASK 0x40000000
#define SDMA1_STATUS_REG__INT_IDLE__SHIFT 0x1e
#define SDMA1_STATUS_REG__INT_REQ_STALL_MASK 0x80000000
#define SDMA1_STATUS_REG__INT_REQ_STALL__SHIFT 0x1f
#define SDMA1_STATUS1_REG__CE_WREQ_IDLE_MASK 0x1
#define SDMA1_STATUS1_REG__CE_WREQ_IDLE__SHIFT 0x0
#define SDMA1_STATUS1_REG__CE_WR_IDLE_MASK 0x2
#define SDMA1_STATUS1_REG__CE_WR_IDLE__SHIFT 0x1
#define SDMA1_STATUS1_REG__CE_SPLIT_IDLE_MASK 0x4
#define SDMA1_STATUS1_REG__CE_SPLIT_IDLE__SHIFT 0x2
#define SDMA1_STATUS1_REG__CE_RREQ_IDLE_MASK 0x8
#define SDMA1_STATUS1_REG__CE_RREQ_IDLE__SHIFT 0x3
#define SDMA1_STATUS1_REG__CE_OUT_IDLE_MASK 0x10
#define SDMA1_STATUS1_REG__CE_OUT_IDLE__SHIFT 0x4
#define SDMA1_STATUS1_REG__CE_IN_IDLE_MASK 0x20
#define SDMA1_STATUS1_REG__CE_IN_IDLE__SHIFT 0x5
#define SDMA1_STATUS1_REG__CE_DST_IDLE_MASK 0x40
#define SDMA1_STATUS1_REG__CE_DST_IDLE__SHIFT 0x6
#define SDMA1_STATUS1_REG__CE_AFIFO_FULL_MASK 0x400
#define SDMA1_STATUS1_REG__CE_AFIFO_FULL__SHIFT 0xa
#define SDMA1_STATUS1_REG__CE_INFO_FULL_MASK 0x2000
#define SDMA1_STATUS1_REG__CE_INFO_FULL__SHIFT 0xd
#define SDMA1_STATUS1_REG__CE_INFO1_FULL_MASK 0x4000
#define SDMA1_STATUS1_REG__CE_INFO1_FULL__SHIFT 0xe
#define SDMA1_STATUS1_REG__CE_RD_STALL_MASK 0x20000
#define SDMA1_STATUS1_REG__CE_RD_STALL__SHIFT 0x11
#define SDMA1_STATUS1_REG__CE_WR_STALL_MASK 0x40000
#define SDMA1_STATUS1_REG__CE_WR_STALL__SHIFT 0x12
#define SDMA1_PERFMON_CNTL__PERF_ENABLE0_MASK 0x1
#define SDMA1_PERFMON_CNTL__PERF_ENABLE0__SHIFT 0x0
#define SDMA1_PERFMON_CNTL__PERF_CLEAR0_MASK 0x2
#define SDMA1_PERFMON_CNTL__PERF_CLEAR0__SHIFT 0x1
#define SDMA1_PERFMON_CNTL__PERF_SEL0_MASK 0xfc
#define SDMA1_PERFMON_CNTL__PERF_SEL0__SHIFT 0x2
#define SDMA1_PERFMON_CNTL__PERF_ENABLE1_MASK 0x100
#define SDMA1_PERFMON_CNTL__PERF_ENABLE1__SHIFT 0x8
#define SDMA1_PERFMON_CNTL__PERF_CLEAR1_MASK 0x200
#define SDMA1_PERFMON_CNTL__PERF_CLEAR1__SHIFT 0x9
#define SDMA1_PERFMON_CNTL__PERF_SEL1_MASK 0xfc00
#define SDMA1_PERFMON_CNTL__PERF_SEL1__SHIFT 0xa
#define SDMA1_PERFCOUNTER0_RESULT__PERF_COUNT_MASK 0xffffffff
#define SDMA1_PERFCOUNTER0_RESULT__PERF_COUNT__SHIFT 0x0
#define SDMA1_PERFCOUNTER1_RESULT__PERF_COUNT_MASK 0xffffffff
#define SDMA1_PERFCOUNTER1_RESULT__PERF_COUNT__SHIFT 0x0
#define SDMA1_F32_CNTL__HALT_MASK 0x1
#define SDMA1_F32_CNTL__HALT__SHIFT 0x0
#define SDMA1_F32_CNTL__STEP_MASK 0x2
#define SDMA1_F32_CNTL__STEP__SHIFT 0x1
#define SDMA1_FREEZE__FREEZE_MASK 0x10
#define SDMA1_FREEZE__FREEZE__SHIFT 0x4
#define SDMA1_FREEZE__FROZEN_MASK 0x20
#define SDMA1_FREEZE__FROZEN__SHIFT 0x5
#define SDMA1_PHASE0_QUANTUM__UNIT_MASK 0xf
#define SDMA1_PHASE0_QUANTUM__UNIT__SHIFT 0x0
#define SDMA1_PHASE0_QUANTUM__VALUE_MASK 0xffff00
#define SDMA1_PHASE0_QUANTUM__VALUE__SHIFT 0x8
#define SDMA1_PHASE0_QUANTUM__PREFER_MASK 0x40000000
#define SDMA1_PHASE0_QUANTUM__PREFER__SHIFT 0x1e
#define SDMA1_PHASE1_QUANTUM__UNIT_MASK 0xf
#define SDMA1_PHASE1_QUANTUM__UNIT__SHIFT 0x0
#define SDMA1_PHASE1_QUANTUM__VALUE_MASK 0xffff00
#define SDMA1_PHASE1_QUANTUM__VALUE__SHIFT 0x8
#define SDMA1_PHASE1_QUANTUM__PREFER_MASK 0x40000000
#define SDMA1_PHASE1_QUANTUM__PREFER__SHIFT 0x1e
#define SDMA1_EDC_CONFIG__DIS_EDC_MASK 0x2
#define SDMA1_EDC_CONFIG__DIS_EDC__SHIFT 0x1
#define SDMA1_EDC_CONFIG__ECC_INT_ENABLE_MASK 0x4
#define SDMA1_EDC_CONFIG__ECC_INT_ENABLE__SHIFT 0x2
#define SDMA1_GFX_RB_CNTL__RB_ENABLE_MASK 0x1
#define SDMA1_GFX_RB_CNTL__RB_ENABLE__SHIFT 0x0
#define SDMA1_GFX_RB_CNTL__RB_SIZE_MASK 0x3e
#define SDMA1_GFX_RB_CNTL__RB_SIZE__SHIFT 0x1
#define SDMA1_GFX_RB_CNTL__RB_SWAP_ENABLE_MASK 0x200
#define SDMA1_GFX_RB_CNTL__RB_SWAP_ENABLE__SHIFT 0x9
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK 0x1000
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT 0xc
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK 0x2000
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT 0xd
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK 0x1f0000
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT 0x10
#define SDMA1_GFX_RB_CNTL__RB_PRIV_MASK 0x800000
#define SDMA1_GFX_RB_CNTL__RB_PRIV__SHIFT 0x17
#define SDMA1_GFX_RB_CNTL__RB_VMID_MASK 0xf000000
#define SDMA1_GFX_RB_CNTL__RB_VMID__SHIFT 0x18
#define SDMA1_GFX_RB_BASE__ADDR_MASK 0xffffffff
#define SDMA1_GFX_RB_BASE__ADDR__SHIFT 0x0
#define SDMA1_GFX_RB_BASE_HI__ADDR_MASK 0xffffff
#define SDMA1_GFX_RB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA1_GFX_RB_RPTR__OFFSET_MASK 0xfffffffc
#define SDMA1_GFX_RB_RPTR__OFFSET__SHIFT 0x2
#define SDMA1_GFX_RB_WPTR__OFFSET_MASK 0xfffffffc
#define SDMA1_GFX_RB_WPTR__OFFSET__SHIFT 0x2
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__ENABLE_MASK 0x1
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__ENABLE__SHIFT 0x0
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK 0x2
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT 0x1
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__FREQUENCY_MASK 0xfff0
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT 0x4
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK 0xffff0000
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT 0x10
#define SDMA1_GFX_RB_WPTR_POLL_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA1_GFX_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA1_GFX_RB_WPTR_POLL_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA1_GFX_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA1_GFX_RB_RPTR_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA1_GFX_RB_RPTR_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA1_GFX_RB_RPTR_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA1_GFX_RB_RPTR_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA1_GFX_IB_CNTL__IB_ENABLE_MASK 0x1
#define SDMA1_GFX_IB_CNTL__IB_ENABLE__SHIFT 0x0
#define SDMA1_GFX_IB_CNTL__IB_SWAP_ENABLE_MASK 0x10
#define SDMA1_GFX_IB_CNTL__IB_SWAP_ENABLE__SHIFT 0x4
#define SDMA1_GFX_IB_CNTL__SWITCH_INSIDE_IB_MASK 0x100
#define SDMA1_GFX_IB_CNTL__SWITCH_INSIDE_IB__SHIFT 0x8
#define SDMA1_GFX_IB_CNTL__CMD_VMID_MASK 0xf0000
#define SDMA1_GFX_IB_CNTL__CMD_VMID__SHIFT 0x10
#define SDMA1_GFX_IB_RPTR__OFFSET_MASK 0x3ffffc
#define SDMA1_GFX_IB_RPTR__OFFSET__SHIFT 0x2
#define SDMA1_GFX_IB_OFFSET__OFFSET_MASK 0x3ffffc
#define SDMA1_GFX_IB_OFFSET__OFFSET__SHIFT 0x2
#define SDMA1_GFX_IB_BASE_LO__ADDR_MASK 0xffffffe0
#define SDMA1_GFX_IB_BASE_LO__ADDR__SHIFT 0x5
#define SDMA1_GFX_IB_BASE_HI__ADDR_MASK 0xffffffff
#define SDMA1_GFX_IB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA1_GFX_IB_SIZE__SIZE_MASK 0xfffff
#define SDMA1_GFX_IB_SIZE__SIZE__SHIFT 0x0
#define SDMA1_GFX_SKIP_CNTL__SKIP_COUNT_MASK 0x3fff
#define SDMA1_GFX_SKIP_CNTL__SKIP_COUNT__SHIFT 0x0
#define SDMA1_GFX_CONTEXT_STATUS__SELECTED_MASK 0x1
#define SDMA1_GFX_CONTEXT_STATUS__SELECTED__SHIFT 0x0
#define SDMA1_GFX_CONTEXT_STATUS__IDLE_MASK 0x4
#define SDMA1_GFX_CONTEXT_STATUS__IDLE__SHIFT 0x2
#define SDMA1_GFX_CONTEXT_STATUS__EXPIRED_MASK 0x8
#define SDMA1_GFX_CONTEXT_STATUS__EXPIRED__SHIFT 0x3
#define SDMA1_GFX_CONTEXT_STATUS__EXCEPTION_MASK 0x70
#define SDMA1_GFX_CONTEXT_STATUS__EXCEPTION__SHIFT 0x4
#define SDMA1_GFX_CONTEXT_STATUS__CTXSW_ABLE_MASK 0x80
#define SDMA1_GFX_CONTEXT_STATUS__CTXSW_ABLE__SHIFT 0x7
#define SDMA1_GFX_CONTEXT_STATUS__CTXSW_READY_MASK 0x100
#define SDMA1_GFX_CONTEXT_STATUS__CTXSW_READY__SHIFT 0x8
#define SDMA1_GFX_CONTEXT_CNTL__RESUME_CTX_MASK 0x10000
#define SDMA1_GFX_CONTEXT_CNTL__RESUME_CTX__SHIFT 0x10
#define SDMA1_GFX_CONTEXT_CNTL__SESSION_SEL_MASK 0xf000000
#define SDMA1_GFX_CONTEXT_CNTL__SESSION_SEL__SHIFT 0x18
#define SDMA1_GFX_VIRTUAL_ADDR__ATC_MASK 0x1
#define SDMA1_GFX_VIRTUAL_ADDR__ATC__SHIFT 0x0
#define SDMA1_GFX_VIRTUAL_ADDR__PTR32_MASK 0x10
#define SDMA1_GFX_VIRTUAL_ADDR__PTR32__SHIFT 0x4
#define SDMA1_GFX_VIRTUAL_ADDR__SHARED_BASE_MASK 0x700
#define SDMA1_GFX_VIRTUAL_ADDR__SHARED_BASE__SHIFT 0x8
#define SDMA1_GFX_VIRTUAL_ADDR__VM_HOLE_MASK 0x40000000
#define SDMA1_GFX_VIRTUAL_ADDR__VM_HOLE__SHIFT 0x1e
#define SDMA1_GFX_APE1_CNTL__BASE_MASK 0xffff
#define SDMA1_GFX_APE1_CNTL__BASE__SHIFT 0x0
#define SDMA1_GFX_APE1_CNTL__LIMIT_MASK 0xffff0000
#define SDMA1_GFX_APE1_CNTL__LIMIT__SHIFT 0x10
#define SDMA1_GFX_WATERMARK__RD_OUTSTANDING_MASK 0xfff
#define SDMA1_GFX_WATERMARK__RD_OUTSTANDING__SHIFT 0x0
#define SDMA1_GFX_WATERMARK__WR_OUTSTANDING_MASK 0x1ff0000
#define SDMA1_GFX_WATERMARK__WR_OUTSTANDING__SHIFT 0x10
#define SDMA1_RLC0_RB_CNTL__RB_ENABLE_MASK 0x1
#define SDMA1_RLC0_RB_CNTL__RB_ENABLE__SHIFT 0x0
#define SDMA1_RLC0_RB_CNTL__RB_SIZE_MASK 0x3e
#define SDMA1_RLC0_RB_CNTL__RB_SIZE__SHIFT 0x1
#define SDMA1_RLC0_RB_CNTL__RB_SWAP_ENABLE_MASK 0x200
#define SDMA1_RLC0_RB_CNTL__RB_SWAP_ENABLE__SHIFT 0x9
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK 0x1000
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT 0xc
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK 0x2000
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT 0xd
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK 0x1f0000
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT 0x10
#define SDMA1_RLC0_RB_CNTL__RB_PRIV_MASK 0x800000
#define SDMA1_RLC0_RB_CNTL__RB_PRIV__SHIFT 0x17
#define SDMA1_RLC0_RB_CNTL__RB_VMID_MASK 0xf000000
#define SDMA1_RLC0_RB_CNTL__RB_VMID__SHIFT 0x18
#define SDMA1_RLC0_RB_BASE__ADDR_MASK 0xffffffff
#define SDMA1_RLC0_RB_BASE__ADDR__SHIFT 0x0
#define SDMA1_RLC0_RB_BASE_HI__ADDR_MASK 0xffffff
#define SDMA1_RLC0_RB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA1_RLC0_RB_RPTR__OFFSET_MASK 0xfffffffc
#define SDMA1_RLC0_RB_RPTR__OFFSET__SHIFT 0x2
#define SDMA1_RLC0_RB_WPTR__OFFSET_MASK 0xfffffffc
#define SDMA1_RLC0_RB_WPTR__OFFSET__SHIFT 0x2
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__ENABLE_MASK 0x1
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__ENABLE__SHIFT 0x0
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK 0x2
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT 0x1
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__FREQUENCY_MASK 0xfff0
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT 0x4
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK 0xffff0000
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT 0x10
#define SDMA1_RLC0_RB_WPTR_POLL_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA1_RLC0_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA1_RLC0_RB_WPTR_POLL_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA1_RLC0_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA1_RLC0_RB_RPTR_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA1_RLC0_RB_RPTR_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA1_RLC0_RB_RPTR_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA1_RLC0_RB_RPTR_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA1_RLC0_IB_CNTL__IB_ENABLE_MASK 0x1
#define SDMA1_RLC0_IB_CNTL__IB_ENABLE__SHIFT 0x0
#define SDMA1_RLC0_IB_CNTL__IB_SWAP_ENABLE_MASK 0x10
#define SDMA1_RLC0_IB_CNTL__IB_SWAP_ENABLE__SHIFT 0x4
#define SDMA1_RLC0_IB_CNTL__SWITCH_INSIDE_IB_MASK 0x100
#define SDMA1_RLC0_IB_CNTL__SWITCH_INSIDE_IB__SHIFT 0x8
#define SDMA1_RLC0_IB_CNTL__CMD_VMID_MASK 0xf0000
#define SDMA1_RLC0_IB_CNTL__CMD_VMID__SHIFT 0x10
#define SDMA1_RLC0_IB_RPTR__OFFSET_MASK 0x3ffffc
#define SDMA1_RLC0_IB_RPTR__OFFSET__SHIFT 0x2
#define SDMA1_RLC0_IB_OFFSET__OFFSET_MASK 0x3ffffc
#define SDMA1_RLC0_IB_OFFSET__OFFSET__SHIFT 0x2
#define SDMA1_RLC0_IB_BASE_LO__ADDR_MASK 0xffffffe0
#define SDMA1_RLC0_IB_BASE_LO__ADDR__SHIFT 0x5
#define SDMA1_RLC0_IB_BASE_HI__ADDR_MASK 0xffffffff
#define SDMA1_RLC0_IB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA1_RLC0_IB_SIZE__SIZE_MASK 0xfffff
#define SDMA1_RLC0_IB_SIZE__SIZE__SHIFT 0x0
#define SDMA1_RLC0_SKIP_CNTL__SKIP_COUNT_MASK 0x3fff
#define SDMA1_RLC0_SKIP_CNTL__SKIP_COUNT__SHIFT 0x0
#define SDMA1_RLC0_CONTEXT_STATUS__SELECTED_MASK 0x1
#define SDMA1_RLC0_CONTEXT_STATUS__SELECTED__SHIFT 0x0
#define SDMA1_RLC0_CONTEXT_STATUS__IDLE_MASK 0x4
#define SDMA1_RLC0_CONTEXT_STATUS__IDLE__SHIFT 0x2
#define SDMA1_RLC0_CONTEXT_STATUS__EXPIRED_MASK 0x8
#define SDMA1_RLC0_CONTEXT_STATUS__EXPIRED__SHIFT 0x3
#define SDMA1_RLC0_CONTEXT_STATUS__EXCEPTION_MASK 0x70
#define SDMA1_RLC0_CONTEXT_STATUS__EXCEPTION__SHIFT 0x4
#define SDMA1_RLC0_CONTEXT_STATUS__CTXSW_ABLE_MASK 0x80
#define SDMA1_RLC0_CONTEXT_STATUS__CTXSW_ABLE__SHIFT 0x7
#define SDMA1_RLC0_CONTEXT_STATUS__CTXSW_READY_MASK 0x100
#define SDMA1_RLC0_CONTEXT_STATUS__CTXSW_READY__SHIFT 0x8
#define SDMA1_RLC0_DOORBELL__OFFSET_MASK 0x1fffff
#define SDMA1_RLC0_DOORBELL__OFFSET__SHIFT 0x0
#define SDMA1_RLC0_DOORBELL__ENABLE_MASK 0x10000000
#define SDMA1_RLC0_DOORBELL__ENABLE__SHIFT 0x1c
#define SDMA1_RLC0_DOORBELL__CAPTURED_MASK 0x40000000
#define SDMA1_RLC0_DOORBELL__CAPTURED__SHIFT 0x1e
#define SDMA1_RLC0_VIRTUAL_ADDR__ATC_MASK 0x1
#define SDMA1_RLC0_VIRTUAL_ADDR__ATC__SHIFT 0x0
#define SDMA1_RLC0_VIRTUAL_ADDR__PTR32_MASK 0x10
#define SDMA1_RLC0_VIRTUAL_ADDR__PTR32__SHIFT 0x4
#define SDMA1_RLC0_VIRTUAL_ADDR__SHARED_BASE_MASK 0x700
#define SDMA1_RLC0_VIRTUAL_ADDR__SHARED_BASE__SHIFT 0x8
#define SDMA1_RLC0_VIRTUAL_ADDR__VM_HOLE_MASK 0x40000000
#define SDMA1_RLC0_VIRTUAL_ADDR__VM_HOLE__SHIFT 0x1e
#define SDMA1_RLC0_APE1_CNTL__BASE_MASK 0xffff
#define SDMA1_RLC0_APE1_CNTL__BASE__SHIFT 0x0
#define SDMA1_RLC0_APE1_CNTL__LIMIT_MASK 0xffff0000
#define SDMA1_RLC0_APE1_CNTL__LIMIT__SHIFT 0x10
#define SDMA1_RLC0_DOORBELL_LOG__BE_ERROR_MASK 0x1
#define SDMA1_RLC0_DOORBELL_LOG__BE_ERROR__SHIFT 0x0
#define SDMA1_RLC0_DOORBELL_LOG__DATA_MASK 0xfffffffc
#define SDMA1_RLC0_DOORBELL_LOG__DATA__SHIFT 0x2
#define SDMA1_RLC0_WATERMARK__RD_OUTSTANDING_MASK 0xfff
#define SDMA1_RLC0_WATERMARK__RD_OUTSTANDING__SHIFT 0x0
#define SDMA1_RLC0_WATERMARK__WR_OUTSTANDING_MASK 0x1ff0000
#define SDMA1_RLC0_WATERMARK__WR_OUTSTANDING__SHIFT 0x10
#define SDMA1_RLC1_RB_CNTL__RB_ENABLE_MASK 0x1
#define SDMA1_RLC1_RB_CNTL__RB_ENABLE__SHIFT 0x0
#define SDMA1_RLC1_RB_CNTL__RB_SIZE_MASK 0x3e
#define SDMA1_RLC1_RB_CNTL__RB_SIZE__SHIFT 0x1
#define SDMA1_RLC1_RB_CNTL__RB_SWAP_ENABLE_MASK 0x200
#define SDMA1_RLC1_RB_CNTL__RB_SWAP_ENABLE__SHIFT 0x9
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK 0x1000
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT 0xc
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK 0x2000
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT 0xd
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK 0x1f0000
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT 0x10
#define SDMA1_RLC1_RB_CNTL__RB_PRIV_MASK 0x800000
#define SDMA1_RLC1_RB_CNTL__RB_PRIV__SHIFT 0x17
#define SDMA1_RLC1_RB_CNTL__RB_VMID_MASK 0xf000000
#define SDMA1_RLC1_RB_CNTL__RB_VMID__SHIFT 0x18
#define SDMA1_RLC1_RB_BASE__ADDR_MASK 0xffffffff
#define SDMA1_RLC1_RB_BASE__ADDR__SHIFT 0x0
#define SDMA1_RLC1_RB_BASE_HI__ADDR_MASK 0xffffff
#define SDMA1_RLC1_RB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA1_RLC1_RB_RPTR__OFFSET_MASK 0xfffffffc
#define SDMA1_RLC1_RB_RPTR__OFFSET__SHIFT 0x2
#define SDMA1_RLC1_RB_WPTR__OFFSET_MASK 0xfffffffc
#define SDMA1_RLC1_RB_WPTR__OFFSET__SHIFT 0x2
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__ENABLE_MASK 0x1
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__ENABLE__SHIFT 0x0
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK 0x2
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT 0x1
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__FREQUENCY_MASK 0xfff0
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT 0x4
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK 0xffff0000
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT 0x10
#define SDMA1_RLC1_RB_WPTR_POLL_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA1_RLC1_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA1_RLC1_RB_WPTR_POLL_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA1_RLC1_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA1_RLC1_RB_RPTR_ADDR_HI__ADDR_MASK 0xffffffff
#define SDMA1_RLC1_RB_RPTR_ADDR_HI__ADDR__SHIFT 0x0
#define SDMA1_RLC1_RB_RPTR_ADDR_LO__ADDR_MASK 0xfffffffc
#define SDMA1_RLC1_RB_RPTR_ADDR_LO__ADDR__SHIFT 0x2
#define SDMA1_RLC1_IB_CNTL__IB_ENABLE_MASK 0x1
#define SDMA1_RLC1_IB_CNTL__IB_ENABLE__SHIFT 0x0
#define SDMA1_RLC1_IB_CNTL__IB_SWAP_ENABLE_MASK 0x10
#define SDMA1_RLC1_IB_CNTL__IB_SWAP_ENABLE__SHIFT 0x4
#define SDMA1_RLC1_IB_CNTL__SWITCH_INSIDE_IB_MASK 0x100
#define SDMA1_RLC1_IB_CNTL__SWITCH_INSIDE_IB__SHIFT 0x8
#define SDMA1_RLC1_IB_CNTL__CMD_VMID_MASK 0xf0000
#define SDMA1_RLC1_IB_CNTL__CMD_VMID__SHIFT 0x10
#define SDMA1_RLC1_IB_RPTR__OFFSET_MASK 0x3ffffc
#define SDMA1_RLC1_IB_RPTR__OFFSET__SHIFT 0x2
#define SDMA1_RLC1_IB_OFFSET__OFFSET_MASK 0x3ffffc
#define SDMA1_RLC1_IB_OFFSET__OFFSET__SHIFT 0x2
#define SDMA1_RLC1_IB_BASE_LO__ADDR_MASK 0xffffffe0
#define SDMA1_RLC1_IB_BASE_LO__ADDR__SHIFT 0x5
#define SDMA1_RLC1_IB_BASE_HI__ADDR_MASK 0xffffffff
#define SDMA1_RLC1_IB_BASE_HI__ADDR__SHIFT 0x0
#define SDMA1_RLC1_IB_SIZE__SIZE_MASK 0xfffff
#define SDMA1_RLC1_IB_SIZE__SIZE__SHIFT 0x0
#define SDMA1_RLC1_SKIP_CNTL__SKIP_COUNT_MASK 0x3fff
#define SDMA1_RLC1_SKIP_CNTL__SKIP_COUNT__SHIFT 0x0
#define SDMA1_RLC1_CONTEXT_STATUS__SELECTED_MASK 0x1
#define SDMA1_RLC1_CONTEXT_STATUS__SELECTED__SHIFT 0x0
#define SDMA1_RLC1_CONTEXT_STATUS__IDLE_MASK 0x4
#define SDMA1_RLC1_CONTEXT_STATUS__IDLE__SHIFT 0x2
#define SDMA1_RLC1_CONTEXT_STATUS__EXPIRED_MASK 0x8
#define SDMA1_RLC1_CONTEXT_STATUS__EXPIRED__SHIFT 0x3
#define SDMA1_RLC1_CONTEXT_STATUS__EXCEPTION_MASK 0x70
#define SDMA1_RLC1_CONTEXT_STATUS__EXCEPTION__SHIFT 0x4
#define SDMA1_RLC1_CONTEXT_STATUS__CTXSW_ABLE_MASK 0x80
#define SDMA1_RLC1_CONTEXT_STATUS__CTXSW_ABLE__SHIFT 0x7
#define SDMA1_RLC1_CONTEXT_STATUS__CTXSW_READY_MASK 0x100
#define SDMA1_RLC1_CONTEXT_STATUS__CTXSW_READY__SHIFT 0x8
#define SDMA1_RLC1_DOORBELL__OFFSET_MASK 0x1fffff
#define SDMA1_RLC1_DOORBELL__OFFSET__SHIFT 0x0
#define SDMA1_RLC1_DOORBELL__ENABLE_MASK 0x10000000
#define SDMA1_RLC1_DOORBELL__ENABLE__SHIFT 0x1c
#define SDMA1_RLC1_DOORBELL__CAPTURED_MASK 0x40000000
#define SDMA1_RLC1_DOORBELL__CAPTURED__SHIFT 0x1e
#define SDMA1_RLC1_VIRTUAL_ADDR__ATC_MASK 0x1
#define SDMA1_RLC1_VIRTUAL_ADDR__ATC__SHIFT 0x0
#define SDMA1_RLC1_VIRTUAL_ADDR__PTR32_MASK 0x10
#define SDMA1_RLC1_VIRTUAL_ADDR__PTR32__SHIFT 0x4
#define SDMA1_RLC1_VIRTUAL_ADDR__SHARED_BASE_MASK 0x700
#define SDMA1_RLC1_VIRTUAL_ADDR__SHARED_BASE__SHIFT 0x8
#define SDMA1_RLC1_VIRTUAL_ADDR__VM_HOLE_MASK 0x40000000
#define SDMA1_RLC1_VIRTUAL_ADDR__VM_HOLE__SHIFT 0x1e
#define SDMA1_RLC1_APE1_CNTL__BASE_MASK 0xffff
#define SDMA1_RLC1_APE1_CNTL__BASE__SHIFT 0x0
#define SDMA1_RLC1_APE1_CNTL__LIMIT_MASK 0xffff0000
#define SDMA1_RLC1_APE1_CNTL__LIMIT__SHIFT 0x10
#define SDMA1_RLC1_DOORBELL_LOG__BE_ERROR_MASK 0x1
#define SDMA1_RLC1_DOORBELL_LOG__BE_ERROR__SHIFT 0x0
#define SDMA1_RLC1_DOORBELL_LOG__DATA_MASK 0xfffffffc
#define SDMA1_RLC1_DOORBELL_LOG__DATA__SHIFT 0x2
#define SDMA1_RLC1_WATERMARK__RD_OUTSTANDING_MASK 0xfff
#define SDMA1_RLC1_WATERMARK__RD_OUTSTANDING__SHIFT 0x0
#define SDMA1_RLC1_WATERMARK__WR_OUTSTANDING_MASK 0x1ff0000
#define SDMA1_RLC1_WATERMARK__WR_OUTSTANDING__SHIFT 0x10
#define XDMA_SLV_CHANNEL_CNTL__XDMA_SLV_CHANNEL_WEIGHT_MASK 0x1ff
#define XDMA_SLV_CHANNEL_CNTL__XDMA_SLV_CHANNEL_WEIGHT__SHIFT 0x0
#define XDMA_SLV_CHANNEL_CNTL__XDMA_SLV_STOP_TRANSFER_MASK 0x10000
#define XDMA_SLV_CHANNEL_CNTL__XDMA_SLV_STOP_TRANSFER__SHIFT 0x10
#define XDMA_SLV_CHANNEL_CNTL__XDMA_SLV_CHANNEL_SOFT_RESET_MASK 0x20000
#define XDMA_SLV_CHANNEL_CNTL__XDMA_SLV_CHANNEL_SOFT_RESET__SHIFT 0x11
#define XDMA_SLV_CHANNEL_CNTL__XDMA_SLV_CHANNEL_ACTIVE_MASK 0x1000000
#define XDMA_SLV_CHANNEL_CNTL__XDMA_SLV_CHANNEL_ACTIVE__SHIFT 0x18
#define XDMA_SLV_REMOTE_GPU_ADDRESS__XDMA_SLV_REMOTE_GPU_ADDRESS_MASK 0xffffffff
#define XDMA_SLV_REMOTE_GPU_ADDRESS__XDMA_SLV_REMOTE_GPU_ADDRESS__SHIFT 0x0
#define XDMA_SLV_REMOTE_GPU_ADDRESS_HIGH__XDMA_SLV_REMOTE_GPU_ADDRESS_HIGH_MASK 0xff
#define XDMA_SLV_REMOTE_GPU_ADDRESS_HIGH__XDMA_SLV_REMOTE_GPU_ADDRESS_HIGH__SHIFT 0x0
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_CACHE_LINES_MASK 0xff
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_CACHE_LINES__SHIFT 0x0
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_READ_REQUEST_MASK 0x100
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_READ_REQUEST__SHIFT 0x8
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_PIPE_FRAME_MODE_MASK 0x200
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_PIPE_FRAME_MODE__SHIFT 0x9
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_PIPE_SOFT_RESET_MASK 0x400
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_PIPE_SOFT_RESET__SHIFT 0xa
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_CACHE_INVALIDATE_MASK 0x800
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_CACHE_INVALIDATE__SHIFT 0xb
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_REQUEST_CHANNEL_ID_MASK 0x7000
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_REQUEST_CHANNEL_ID__SHIFT 0xc
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_FLIP_MODE_MASK 0x8000
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_FLIP_MODE__SHIFT 0xf
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_REQUEST_MIN_MASK 0xff0000
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_REQUEST_MIN__SHIFT 0x10
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_PIPE_ACTIVE_MASK 0x1000000
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_PIPE_ACTIVE__SHIFT 0x18
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_PIPE_FLUSHING_MASK 0x2000000
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_PIPE_FLUSHING__SHIFT 0x19
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_PIPE_FLIP_PENDING_MASK 0x4000000
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_PIPE_FLIP_PENDING__SHIFT 0x1a
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_VSYNC_GSL_ENABLE_MASK 0x8000000
#define XDMA_MSTR_PIPE_CNTL__XDMA_MSTR_VSYNC_GSL_ENABLE__SHIFT 0x1b
#define XDMA_MSTR_READ_COMMAND__XDMA_MSTR_REQUEST_SIZE_MASK 0x3fff
#define XDMA_MSTR_READ_COMMAND__XDMA_MSTR_REQUEST_SIZE__SHIFT 0x0
#define XDMA_MSTR_READ_COMMAND__XDMA_MSTR_REQUEST_PREFETCH_MASK 0x3fff0000
#define XDMA_MSTR_READ_COMMAND__XDMA_MSTR_REQUEST_PREFETCH__SHIFT 0x10
#define XDMA_MSTR_CHANNEL_DIM__XDMA_MSTR_CHANNEL_WIDTH_MASK 0x3fff
#define XDMA_MSTR_CHANNEL_DIM__XDMA_MSTR_CHANNEL_WIDTH__SHIFT 0x0
#define XDMA_MSTR_CHANNEL_DIM__XDMA_MSTR_CHANNEL_HEIGHT_MASK 0x3fff0000
#define XDMA_MSTR_CHANNEL_DIM__XDMA_MSTR_CHANNEL_HEIGHT__SHIFT 0x10
#define XDMA_MSTR_HEIGHT__XDMA_MSTR_ACTIVE_HEIGHT_MASK 0x3fff
#define XDMA_MSTR_HEIGHT__XDMA_MSTR_ACTIVE_HEIGHT__SHIFT 0x0
#define XDMA_MSTR_HEIGHT__XDMA_MSTR_FRAME_HEIGHT_MASK 0x3fff0000
#define XDMA_MSTR_HEIGHT__XDMA_MSTR_FRAME_HEIGHT__SHIFT 0x10
#define XDMA_MSTR_REMOTE_SURFACE_BASE__XDMA_MSTR_REMOTE_SURFACE_BASE_MASK 0xffffffff
#define XDMA_MSTR_REMOTE_SURFACE_BASE__XDMA_MSTR_REMOTE_SURFACE_BASE__SHIFT 0x0
#define XDMA_MSTR_REMOTE_SURFACE_BASE_HIGH__XDMA_MSTR_REMOTE_SURFACE_BASE_HIGH_MASK 0xff
#define XDMA_MSTR_REMOTE_SURFACE_BASE_HIGH__XDMA_MSTR_REMOTE_SURFACE_BASE_HIGH__SHIFT 0x0
#define XDMA_MSTR_REMOTE_GPU_ADDRESS__XDMA_MSTR_REMOTE_GPU_ADDRESS_MASK 0xffffffff
#define XDMA_MSTR_REMOTE_GPU_ADDRESS__XDMA_MSTR_REMOTE_GPU_ADDRESS__SHIFT 0x0
#define XDMA_MSTR_REMOTE_GPU_ADDRESS_HIGH__XDMA_MSTR_REMOTE_GPU_ADDRESS_HIGH_MASK 0xff
#define XDMA_MSTR_REMOTE_GPU_ADDRESS_HIGH__XDMA_MSTR_REMOTE_GPU_ADDRESS_HIGH__SHIFT 0x0
#define XDMA_MSTR_CACHE_BASE_ADDR__XDMA_MSTR_CACHE_BASE_ADDR_MASK 0xffffffff
#define XDMA_MSTR_CACHE_BASE_ADDR__XDMA_MSTR_CACHE_BASE_ADDR__SHIFT 0x0
#define XDMA_MSTR_CACHE_BASE_ADDR_HIGH__XDMA_MSTR_CACHE_BASE_ADDR_HIGH_MASK 0xff
#define XDMA_MSTR_CACHE_BASE_ADDR_HIGH__XDMA_MSTR_CACHE_BASE_ADDR_HIGH__SHIFT 0x0
#define XDMA_MSTR_CACHE_PITCH__XDMA_MSTR_CACHE_PITCH_MASK 0x3fff
#define XDMA_MSTR_CACHE_PITCH__XDMA_MSTR_CACHE_PITCH__SHIFT 0x0
#define XDMA_MSTR_CHANNEL_START__XDMA_MSTR_CHANNEL_START_X_MASK 0x3fff
#define XDMA_MSTR_CHANNEL_START__XDMA_MSTR_CHANNEL_START_X__SHIFT 0x0
#define XDMA_MSTR_CHANNEL_START__XDMA_MSTR_CHANNEL_START_Y_MASK 0x3fff0000
#define XDMA_MSTR_CHANNEL_START__XDMA_MSTR_CHANNEL_START_Y__SHIFT 0x10
#define XDMA_MSTR_MEM_OVERFLOW_CNTL__XDMA_MSTR_OVERFLOW_COUNT_MASK 0xffff
#define XDMA_MSTR_MEM_OVERFLOW_CNTL__XDMA_MSTR_OVERFLOW_COUNT__SHIFT 0x0
#define XDMA_MSTR_MEM_OVERFLOW_CNTL__XDMA_MSTR_OVERFLOW_THRESHOLD_MASK 0x3fff0000
#define XDMA_MSTR_MEM_OVERFLOW_CNTL__XDMA_MSTR_OVERFLOW_THRESHOLD__SHIFT 0x10
#define XDMA_MSTR_MEM_OVERFLOW_CNTL__XDMA_MSTR_OVERFLOW_BP_ENABLE_MASK 0x40000000
#define XDMA_MSTR_MEM_OVERFLOW_CNTL__XDMA_MSTR_OVERFLOW_BP_ENABLE__SHIFT 0x1e
#define XDMA_MSTR_MEM_OVERFLOW_CNTL__XDMA_MSTR_OVERFLOW_COUNT_ENABLE_MASK 0x80000000
#define XDMA_MSTR_MEM_OVERFLOW_CNTL__XDMA_MSTR_OVERFLOW_COUNT_ENABLE__SHIFT 0x1f
#define XDMA_MSTR_MEM_UNDERFLOW_CNTL__XDMA_MSTR_UNDERFLOW_COUNT_MASK 0xffff
#define XDMA_MSTR_MEM_UNDERFLOW_CNTL__XDMA_MSTR_UNDERFLOW_COUNT__SHIFT 0x0
#define XDMA_MSTR_MEM_UNDERFLOW_CNTL__XDMA_MSTR_UNDERFLOW_THRESHOLD_MASK 0x3fff0000
#define XDMA_MSTR_MEM_UNDERFLOW_CNTL__XDMA_MSTR_UNDERFLOW_THRESHOLD__SHIFT 0x10
#define XDMA_MSTR_MEM_UNDERFLOW_CNTL__XDMA_MSTR_UNDERFLOW_DETECT_ENABLE_MASK 0x80000000
#define XDMA_MSTR_MEM_UNDERFLOW_CNTL__XDMA_MSTR_UNDERFLOW_DETECT_ENABLE__SHIFT 0x1f
#define XDMA_MSTR_PERFMEAS_STATUS__XDMA_MSTR_PERFMEAS_DATA_MASK 0xffffff
#define XDMA_MSTR_PERFMEAS_STATUS__XDMA_MSTR_PERFMEAS_DATA__SHIFT 0x0
#define XDMA_MSTR_PERFMEAS_STATUS__XDMA_MSTR_PERFMEAS_INDEX_MASK 0x7000000
#define XDMA_MSTR_PERFMEAS_STATUS__XDMA_MSTR_PERFMEAS_INDEX__SHIFT 0x18
#define XDMA_MSTR_PERFMEAS_STATUS__XDMA_MSTR_PERFMEAS_INDEX_MODE_MASK 0xc0000000
#define XDMA_MSTR_PERFMEAS_STATUS__XDMA_MSTR_PERFMEAS_INDEX_MODE__SHIFT 0x1e
#define XDMA_MSTR_PERFMEAS_CNTL__XDMA_MSTR_CACHE_BW_MEAS_ITER_MASK 0xfff
#define XDMA_MSTR_PERFMEAS_CNTL__XDMA_MSTR_CACHE_BW_MEAS_ITER__SHIFT 0x0
#define XDMA_MSTR_PERFMEAS_CNTL__XDMA_MSTR_CACHE_BW_SEGID_SEL_MASK 0x1f000
#define XDMA_MSTR_PERFMEAS_CNTL__XDMA_MSTR_CACHE_BW_SEGID_SEL__SHIFT 0xc
#define XDMA_MSTR_PERFMEAS_CNTL__XDMA_MSTR_CACHE_BW_COUNTER_RST_MASK 0x20000
#define XDMA_MSTR_PERFMEAS_CNTL__XDMA_MSTR_CACHE_BW_COUNTER_RST__SHIFT 0x11
#define XDMA_MSTR_PERFMEAS_CNTL__XDMA_MSTR_LT_MEAS_ITER_MASK 0x7ff80000
#define XDMA_MSTR_PERFMEAS_CNTL__XDMA_MSTR_LT_MEAS_ITER__SHIFT 0x13
#define XDMA_MSTR_PERFMEAS_CNTL__XDMA_MSTR_LT_COUNTER_RST_MASK 0x80000000
#define XDMA_MSTR_PERFMEAS_CNTL__XDMA_MSTR_LT_COUNTER_RST__SHIFT 0x1f
#define XDMA_MSTR_CNTL__XDMA_MSTR_ALPHA_POSITION_MASK 0x3000
#define XDMA_MSTR_CNTL__XDMA_MSTR_ALPHA_POSITION__SHIFT 0xc
#define XDMA_MSTR_CNTL__XDMA_MSTR_MEM_READY_MASK 0x4000
#define XDMA_MSTR_CNTL__XDMA_MSTR_MEM_READY__SHIFT 0xe
#define XDMA_MSTR_CNTL__XDMA_MSTR_ENABLE_MASK 0x10000
#define XDMA_MSTR_CNTL__XDMA_MSTR_ENABLE__SHIFT 0x10
#define XDMA_MSTR_CNTL__XDMA_MSTR_DEBUG_MODE_MASK 0x40000
#define XDMA_MSTR_CNTL__XDMA_MSTR_DEBUG_MODE__SHIFT 0x12
#define XDMA_MSTR_CNTL__XDMA_MSTR_LAT_TEST_EN_MASK 0x80000
#define XDMA_MSTR_CNTL__XDMA_MSTR_LAT_TEST_EN__SHIFT 0x13
#define XDMA_MSTR_CNTL__XDMA_MSTR_SOFT_RESET_MASK 0x100000
#define XDMA_MSTR_CNTL__XDMA_MSTR_SOFT_RESET__SHIFT 0x14
#define XDMA_MSTR_CNTL__XDMA_MSTR_BIF_STALL_EN_MASK 0x200000
#define XDMA_MSTR_CNTL__XDMA_MSTR_BIF_STALL_EN__SHIFT 0x15
#define XDMA_MSTR_STATUS__XDMA_MSTR_VCOUNT_CURRENT_MASK 0x3fff
#define XDMA_MSTR_STATUS__XDMA_MSTR_VCOUNT_CURRENT__SHIFT 0x0
#define XDMA_MSTR_STATUS__XDMA_MSTR_WRITE_LINE_CURRENT_MASK 0xfff0000
#define XDMA_MSTR_STATUS__XDMA_MSTR_WRITE_LINE_CURRENT__SHIFT 0x10
#define XDMA_MSTR_STATUS__XDMA_MSTR_STATUS_SELECT_MASK 0x70000000
#define XDMA_MSTR_STATUS__XDMA_MSTR_STATUS_SELECT__SHIFT 0x1c
#define XDMA_MSTR_MEM_CLIENT_CONFIG__XDMA_MSTR_MEM_CLIENT_SWAP_MASK 0x300
#define XDMA_MSTR_MEM_CLIENT_CONFIG__XDMA_MSTR_MEM_CLIENT_SWAP__SHIFT 0x8
#define XDMA_MSTR_MEM_CLIENT_CONFIG__XDMA_MSTR_MEM_CLIENT_VMID_MASK 0xf000
#define XDMA_MSTR_MEM_CLIENT_CONFIG__XDMA_MSTR_MEM_CLIENT_VMID__SHIFT 0xc
#define XDMA_MSTR_MEM_CLIENT_CONFIG__XDMA_MSTR_MEM_CLIENT_PRIV_MASK 0x10000
#define XDMA_MSTR_MEM_CLIENT_CONFIG__XDMA_MSTR_MEM_CLIENT_PRIV__SHIFT 0x10
#define XDMA_MSTR_LOCAL_SURFACE_BASE_ADDR__XDMA_MSTR_LOCAL_SURFACE_BASE_ADDR_MASK 0xffffffff
#define XDMA_MSTR_LOCAL_SURFACE_BASE_ADDR__XDMA_MSTR_LOCAL_SURFACE_BASE_ADDR__SHIFT 0x0
#define XDMA_MSTR_LOCAL_SURFACE_BASE_ADDR_HIGH__XDMA_MSTR_LOCAL_SURFACE_BASE_ADDR_HIGH_MASK 0xff
#define XDMA_MSTR_LOCAL_SURFACE_BASE_ADDR_HIGH__XDMA_MSTR_LOCAL_SURFACE_BASE_ADDR_HIGH__SHIFT 0x0
#define XDMA_MSTR_LOCAL_SURFACE_PITCH__XDMA_MSTR_LOCAL_SURFACE_PITCH_MASK 0x3fff
#define XDMA_MSTR_LOCAL_SURFACE_PITCH__XDMA_MSTR_LOCAL_SURFACE_PITCH__SHIFT 0x0
#define XDMA_MSTR_CMD_URGENT_CNTL__XDMA_MSTR_CMD_CLIENT_STALL_MASK 0x1
#define XDMA_MSTR_CMD_URGENT_CNTL__XDMA_MSTR_CMD_CLIENT_STALL__SHIFT 0x0
#define XDMA_MSTR_CMD_URGENT_CNTL__XDMA_MSTR_CMD_URGENT_LEVEL_MASK 0xf00
#define XDMA_MSTR_CMD_URGENT_CNTL__XDMA_MSTR_CMD_URGENT_LEVEL__SHIFT 0x8
#define XDMA_MSTR_CMD_URGENT_CNTL__XDMA_MSTR_CMD_STALL_DELAY_MASK 0xf000
#define XDMA_MSTR_CMD_URGENT_CNTL__XDMA_MSTR_CMD_STALL_DELAY__SHIFT 0xc
#define XDMA_MSTR_MEM_URGENT_CNTL__XDMA_MSTR_MEM_CLIENT_STALL_MASK 0x1
#define XDMA_MSTR_MEM_URGENT_CNTL__XDMA_MSTR_MEM_CLIENT_STALL__SHIFT 0x0
#define XDMA_MSTR_MEM_URGENT_CNTL__XDMA_MSTR_MEM_URGENT_LIMIT_MASK 0xf0
#define XDMA_MSTR_MEM_URGENT_CNTL__XDMA_MSTR_MEM_URGENT_LIMIT__SHIFT 0x4
#define XDMA_MSTR_MEM_URGENT_CNTL__XDMA_MSTR_MEM_URGENT_LEVEL_MASK 0xf00
#define XDMA_MSTR_MEM_URGENT_CNTL__XDMA_MSTR_MEM_URGENT_LEVEL__SHIFT 0x8
#define XDMA_MSTR_MEM_URGENT_CNTL__XDMA_MSTR_MEM_STALL_DELAY_MASK 0xf000
#define XDMA_MSTR_MEM_URGENT_CNTL__XDMA_MSTR_MEM_STALL_DELAY__SHIFT 0xc
#define XDMA_MSTR_MEM_URGENT_CNTL__XDMA_MSTR_MEM_URGENT_TIMER_MASK 0xffff0000
#define XDMA_MSTR_MEM_URGENT_CNTL__XDMA_MSTR_MEM_URGENT_TIMER__SHIFT 0x10
#define XDMA_MSTR_MEM_UNDERFLOW_CONFIG__XDMA_MSTR_UNDERFLOW_LIMIT_MASK 0xffff
#define XDMA_MSTR_MEM_UNDERFLOW_CONFIG__XDMA_MSTR_UNDERFLOW_LIMIT__SHIFT 0x0
#define XDMA_MSTR_MEM_UNDERFLOW_CONFIG__XDMA_MSTR_UNDERFLOW_TIMER_MASK 0xffff0000
#define XDMA_MSTR_MEM_UNDERFLOW_CONFIG__XDMA_MSTR_UNDERFLOW_TIMER__SHIFT 0x10
#define XDMA_MSTR_PCIE_NACK_STATUS__XDMA_MSTR_PCIE_NACK_TAG_MASK 0x3ff
#define XDMA_MSTR_PCIE_NACK_STATUS__XDMA_MSTR_PCIE_NACK_TAG__SHIFT 0x0
#define XDMA_MSTR_PCIE_NACK_STATUS__XDMA_MSTR_PCIE_NACK_MASK 0x3000
#define XDMA_MSTR_PCIE_NACK_STATUS__XDMA_MSTR_PCIE_NACK__SHIFT 0xc
#define XDMA_MSTR_PCIE_NACK_STATUS__XDMA_MSTR_PCIE_NACK_CLR_MASK 0x10000
#define XDMA_MSTR_PCIE_NACK_STATUS__XDMA_MSTR_PCIE_NACK_CLR__SHIFT 0x10
#define XDMA_MSTR_MEM_NACK_STATUS__XDMA_MSTR_MEM_NACK_TAG_MASK 0x3ff
#define XDMA_MSTR_MEM_NACK_STATUS__XDMA_MSTR_MEM_NACK_TAG__SHIFT 0x0
#define XDMA_MSTR_MEM_NACK_STATUS__XDMA_MSTR_MEM_NACK_MASK 0x3000
#define XDMA_MSTR_MEM_NACK_STATUS__XDMA_MSTR_MEM_NACK__SHIFT 0xc
#define XDMA_MSTR_MEM_NACK_STATUS__XDMA_MSTR_MEM_NACK_CLR_MASK 0x10000
#define XDMA_MSTR_MEM_NACK_STATUS__XDMA_MSTR_MEM_NACK_CLR__SHIFT 0x10
#define XDMA_MSTR_VSYNC_GSL_CHECK__XDMA_MSTR_VSYNC_GSL_CHECK_SEL_MASK 0x7
#define XDMA_MSTR_VSYNC_GSL_CHECK__XDMA_MSTR_VSYNC_GSL_CHECK_SEL__SHIFT 0x0
#define XDMA_MSTR_VSYNC_GSL_CHECK__XDMA_MSTR_VSYNC_GSL_CHECK_V_COUNT_MASK 0x3fff00
#define XDMA_MSTR_VSYNC_GSL_CHECK__XDMA_MSTR_VSYNC_GSL_CHECK_V_COUNT__SHIFT 0x8
#define HDP_HOST_PATH_CNTL__BIF_RDRET_CREDIT_MASK 0x7
#define HDP_HOST_PATH_CNTL__BIF_RDRET_CREDIT__SHIFT 0x0
#define HDP_HOST_PATH_CNTL__MC_WRREQ_CREDIT_MASK 0x1f8
#define HDP_HOST_PATH_CNTL__MC_WRREQ_CREDIT__SHIFT 0x3
#define HDP_HOST_PATH_CNTL__WR_STALL_TIMER_MASK 0x600
#define HDP_HOST_PATH_CNTL__WR_STALL_TIMER__SHIFT 0x9
#define HDP_HOST_PATH_CNTL__RD_STALL_TIMER_MASK 0x1800
#define HDP_HOST_PATH_CNTL__RD_STALL_TIMER__SHIFT 0xb
#define HDP_HOST_PATH_CNTL__WRITE_COMBINE_TIMER_MASK 0x180000
#define HDP_HOST_PATH_CNTL__WRITE_COMBINE_TIMER__SHIFT 0x13
#define HDP_HOST_PATH_CNTL__WRITE_COMBINE_EN_MASK 0x200000
#define HDP_HOST_PATH_CNTL__WRITE_COMBINE_EN__SHIFT 0x15
#define HDP_HOST_PATH_CNTL__CACHE_INVALIDATE_MASK 0x400000
#define HDP_HOST_PATH_CNTL__CACHE_INVALIDATE__SHIFT 0x16
#define HDP_HOST_PATH_CNTL__CLOCK_GATING_DIS_MASK 0x800000
#define HDP_HOST_PATH_CNTL__CLOCK_GATING_DIS__SHIFT 0x17
#define HDP_HOST_PATH_CNTL__REG_CLK_ENABLE_COUNT_MASK 0xf000000
#define HDP_HOST_PATH_CNTL__REG_CLK_ENABLE_COUNT__SHIFT 0x18
#define HDP_HOST_PATH_CNTL__ALL_SURFACES_DIS_MASK 0x20000000
#define HDP_HOST_PATH_CNTL__ALL_SURFACES_DIS__SHIFT 0x1d
#define HDP_HOST_PATH_CNTL__WRITE_THROUGH_CACHE_DIS_MASK 0x40000000
#define HDP_HOST_PATH_CNTL__WRITE_THROUGH_CACHE_DIS__SHIFT 0x1e
#define HDP_HOST_PATH_CNTL__LIN_RD_CACHE_DIS_MASK 0x80000000
#define HDP_HOST_PATH_CNTL__LIN_RD_CACHE_DIS__SHIFT 0x1f
#define HDP_NONSURFACE_BASE__NONSURF_BASE_MASK 0xffffffff
#define HDP_NONSURFACE_BASE__NONSURF_BASE__SHIFT 0x0
#define HDP_NONSURFACE_INFO__NONSURF_ADDR_TYPE_MASK 0x1
#define HDP_NONSURFACE_INFO__NONSURF_ADDR_TYPE__SHIFT 0x0
#define HDP_NONSURFACE_INFO__NONSURF_ARRAY_MODE_MASK 0x1e
#define HDP_NONSURFACE_INFO__NONSURF_ARRAY_MODE__SHIFT 0x1
#define HDP_NONSURFACE_INFO__NONSURF_ENDIAN_MASK 0x60
#define HDP_NONSURFACE_INFO__NONSURF_ENDIAN__SHIFT 0x5
#define HDP_NONSURFACE_INFO__NONSURF_PIXEL_SIZE_MASK 0x380
#define HDP_NONSURFACE_INFO__NONSURF_PIXEL_SIZE__SHIFT 0x7
#define HDP_NONSURFACE_INFO__NONSURF_SAMPLE_NUM_MASK 0x1c00
#define HDP_NONSURFACE_INFO__NONSURF_SAMPLE_NUM__SHIFT 0xa
#define HDP_NONSURFACE_INFO__NONSURF_SAMPLE_SIZE_MASK 0x6000
#define HDP_NONSURFACE_INFO__NONSURF_SAMPLE_SIZE__SHIFT 0xd
#define HDP_NONSURFACE_INFO__NONSURF_PRIV_MASK 0x8000
#define HDP_NONSURFACE_INFO__NONSURF_PRIV__SHIFT 0xf
#define HDP_NONSURFACE_INFO__NONSURF_TILE_COMPACT_MASK 0x10000
#define HDP_NONSURFACE_INFO__NONSURF_TILE_COMPACT__SHIFT 0x10
#define HDP_NONSURFACE_INFO__NONSURF_TILE_SPLIT_MASK 0xe0000
#define HDP_NONSURFACE_INFO__NONSURF_TILE_SPLIT__SHIFT 0x11
#define HDP_NONSURFACE_INFO__NONSURF_NUM_BANKS_MASK 0x300000
#define HDP_NONSURFACE_INFO__NONSURF_NUM_BANKS__SHIFT 0x14
#define HDP_NONSURFACE_INFO__NONSURF_BANK_WIDTH_MASK 0xc00000
#define HDP_NONSURFACE_INFO__NONSURF_BANK_WIDTH__SHIFT 0x16
#define HDP_NONSURFACE_INFO__NONSURF_BANK_HEIGHT_MASK 0x3000000
#define HDP_NONSURFACE_INFO__NONSURF_BANK_HEIGHT__SHIFT 0x18
#define HDP_NONSURFACE_INFO__NONSURF_MACRO_TILE_ASPECT_MASK 0xc000000
#define HDP_NONSURFACE_INFO__NONSURF_MACRO_TILE_ASPECT__SHIFT 0x1a
#define HDP_NONSURFACE_INFO__NONSURF_MICRO_TILE_MODE_MASK 0x70000000
#define HDP_NONSURFACE_INFO__NONSURF_MICRO_TILE_MODE__SHIFT 0x1c
#define HDP_NONSURFACE_INFO__NONSURF_SLICE_TILE_MAX_MSB_MASK 0x80000000
#define HDP_NONSURFACE_INFO__NONSURF_SLICE_TILE_MAX_MSB__SHIFT 0x1f
#define HDP_NONSURFACE_SIZE__NONSURF_PITCH_TILE_MAX_MASK 0x7ff
#define HDP_NONSURFACE_SIZE__NONSURF_PITCH_TILE_MAX__SHIFT 0x0
#define HDP_NONSURFACE_SIZE__NONSURF_SLICE_TILE_MAX_MASK 0xfffff800
#define HDP_NONSURFACE_SIZE__NONSURF_SLICE_TILE_MAX__SHIFT 0xb
#define HDP_NONSURF_FLAGS__NONSURF_WRITE_FLAG_MASK 0x1
#define HDP_NONSURF_FLAGS__NONSURF_WRITE_FLAG__SHIFT 0x0
#define HDP_NONSURF_FLAGS__NONSURF_READ_FLAG_MASK 0x2
#define HDP_NONSURF_FLAGS__NONSURF_READ_FLAG__SHIFT 0x1
#define HDP_NONSURF_FLAGS_CLR__NONSURF_WRITE_FLAG_CLR_MASK 0x1
#define HDP_NONSURF_FLAGS_CLR__NONSURF_WRITE_FLAG_CLR__SHIFT 0x0
#define HDP_NONSURF_FLAGS_CLR__NONSURF_READ_FLAG_CLR_MASK 0x2
#define HDP_NONSURF_FLAGS_CLR__NONSURF_READ_FLAG_CLR__SHIFT 0x1
#define HDP_SW_SEMAPHORE__SW_SEMAPHORE_MASK 0xffffffff
#define HDP_SW_SEMAPHORE__SW_SEMAPHORE__SHIFT 0x0
#define HDP_DEBUG0__HDP_DEBUG__SHIFT 0x0
#define HDP_DEBUG1__HDP_DEBUG__SHIFT 0x0
#define HDP_LAST_SURFACE_HIT__LAST_SURFACE_HIT_MASK 0x3f
#define HDP_LAST_SURFACE_HIT__LAST_SURFACE_HIT__SHIFT 0x0
#define HDP_TILING_CONFIG__PIPE_TILING_MASK 0xe
#define HDP_TILING_CONFIG__PIPE_TILING__SHIFT 0x1
#define HDP_TILING_CONFIG__BANK_TILING_MASK 0x30
#define HDP_TILING_CONFIG__BANK_TILING__SHIFT 0x4
#define HDP_TILING_CONFIG__GROUP_SIZE_MASK 0xc0
#define HDP_TILING_CONFIG__GROUP_SIZE__SHIFT 0x6
#define HDP_TILING_CONFIG__ROW_TILING_MASK 0x700
#define HDP_TILING_CONFIG__ROW_TILING__SHIFT 0x8
#define HDP_TILING_CONFIG__BANK_SWAPS_MASK 0x3800
#define HDP_TILING_CONFIG__BANK_SWAPS__SHIFT 0xb
#define HDP_TILING_CONFIG__SAMPLE_SPLIT_MASK 0xc000
#define HDP_TILING_CONFIG__SAMPLE_SPLIT__SHIFT 0xe
#define HDP_SC_MULTI_CHIP_CNTL__LOG2_NUM_CHIPS_MASK 0x7
#define HDP_SC_MULTI_CHIP_CNTL__LOG2_NUM_CHIPS__SHIFT 0x0
#define HDP_SC_MULTI_CHIP_CNTL__MULTI_CHIP_TILE_SIZE_MASK 0x18
#define HDP_SC_MULTI_CHIP_CNTL__MULTI_CHIP_TILE_SIZE__SHIFT 0x3
#define HDP_OUTSTANDING_REQ__WRITE_REQ_MASK 0xff
#define HDP_OUTSTANDING_REQ__WRITE_REQ__SHIFT 0x0
#define HDP_OUTSTANDING_REQ__READ_REQ_MASK 0xff00
#define HDP_OUTSTANDING_REQ__READ_REQ__SHIFT 0x8
#define HDP_ADDR_CONFIG__NUM_PIPES_MASK 0x7
#define HDP_ADDR_CONFIG__NUM_PIPES__SHIFT 0x0
#define HDP_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK 0x70
#define HDP_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT 0x4
#define HDP_ADDR_CONFIG__BANK_INTERLEAVE_SIZE_MASK 0x700
#define HDP_ADDR_CONFIG__BANK_INTERLEAVE_SIZE__SHIFT 0x8
#define HDP_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK 0x3000
#define HDP_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT 0xc
#define HDP_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE_MASK 0x70000
#define HDP_ADDR_CONFIG__SHADER_ENGINE_TILE_SIZE__SHIFT 0x10
#define HDP_ADDR_CONFIG__NUM_GPUS_MASK 0x700000
#define HDP_ADDR_CONFIG__NUM_GPUS__SHIFT 0x14
#define HDP_ADDR_CONFIG__MULTI_GPU_TILE_SIZE_MASK 0x3000000
#define HDP_ADDR_CONFIG__MULTI_GPU_TILE_SIZE__SHIFT 0x18
#define HDP_ADDR_CONFIG__ROW_SIZE_MASK 0x30000000
#define HDP_ADDR_CONFIG__ROW_SIZE__SHIFT 0x1c
#define HDP_ADDR_CONFIG__NUM_LOWER_PIPES_MASK 0x40000000
#define HDP_ADDR_CONFIG__NUM_LOWER_PIPES__SHIFT 0x1e
#define HDP_MISC_CNTL__FLUSH_INVALIDATE_CACHE_MASK 0x1
#define HDP_MISC_CNTL__FLUSH_INVALIDATE_CACHE__SHIFT 0x0
#define HDP_MISC_CNTL__VM_ID_MASK 0x1e
#define HDP_MISC_CNTL__VM_ID__SHIFT 0x1
#define HDP_MISC_CNTL__OUTSTANDING_WRITE_COUNT_1024_MASK 0x20
#define HDP_MISC_CNTL__OUTSTANDING_WRITE_COUNT_1024__SHIFT 0x5
#define HDP_MISC_CNTL__MULTIPLE_READS_MASK 0x40
#define HDP_MISC_CNTL__MULTIPLE_READS__SHIFT 0x6
#define HDP_MISC_CNTL__HDP_BIF_RDRET_CREDIT_MASK 0x780
#define HDP_MISC_CNTL__HDP_BIF_RDRET_CREDIT__SHIFT 0x7
#define HDP_MISC_CNTL__SIMULTANEOUS_READS_WRITES_MASK 0x800
#define HDP_MISC_CNTL__SIMULTANEOUS_READS_WRITES__SHIFT 0xb
#define HDP_MISC_CNTL__NO_SPLIT_ARRAY_LINEAR_MASK 0x1000
#define HDP_MISC_CNTL__NO_SPLIT_ARRAY_LINEAR__SHIFT 0xc
#define HDP_MISC_CNTL__MC_RDREQ_CREDIT_MASK 0x7e000
#define HDP_MISC_CNTL__MC_RDREQ_CREDIT__SHIFT 0xd
#define HDP_MISC_CNTL__READ_CACHE_INVALIDATE_MASK 0x80000
#define HDP_MISC_CNTL__READ_CACHE_INVALIDATE__SHIFT 0x13
#define HDP_MISC_CNTL__ADDRLIB_LINEAR_BYPASS_MASK 0x100000
#define HDP_MISC_CNTL__ADDRLIB_LINEAR_BYPASS__SHIFT 0x14
#define HDP_MISC_CNTL__FED_ENABLE_MASK 0x200000
#define HDP_MISC_CNTL__FED_ENABLE__SHIFT 0x15
#define HDP_MEM_POWER_LS__LS_ENABLE_MASK 0x1
#define HDP_MEM_POWER_LS__LS_ENABLE__SHIFT 0x0
#define HDP_MEM_POWER_LS__LS_SETUP_MASK 0x7e
#define HDP_MEM_POWER_LS__LS_SETUP__SHIFT 0x1
#define HDP_MEM_POWER_LS__LS_HOLD_MASK 0x1f80
#define HDP_MEM_POWER_LS__LS_HOLD__SHIFT 0x7
#define HDP_NONSURFACE_PREFETCH__NONSURF_PREFETCH_PRI_MASK 0x7
#define HDP_NONSURFACE_PREFETCH__NONSURF_PREFETCH_PRI__SHIFT 0x0
#define HDP_NONSURFACE_PREFETCH__NONSURF_PREFETCH_DIR_MASK 0x38
#define HDP_NONSURFACE_PREFETCH__NONSURF_PREFETCH_DIR__SHIFT 0x3
#define HDP_NONSURFACE_PREFETCH__NONSURF_PREFETCH_NUM_MASK 0x1c0
#define HDP_NONSURFACE_PREFETCH__NONSURF_PREFETCH_NUM__SHIFT 0x6
#define HDP_NONSURFACE_PREFETCH__NONSURF_PREFETCH_MAX_Z_MASK 0xffe00
#define HDP_NONSURFACE_PREFETCH__NONSURF_PREFETCH_MAX_Z__SHIFT 0x9
#define HDP_NONSURFACE_PREFETCH__NONSURF_PIPE_CONFIG_MASK 0xf8000000
#define HDP_NONSURFACE_PREFETCH__NONSURF_PIPE_CONFIG__SHIFT 0x1b
#define HDP_MEMIO_CNTL__MEMIO_SEND_MASK 0x1
#define HDP_MEMIO_CNTL__MEMIO_SEND__SHIFT 0x0
#define HDP_MEMIO_CNTL__MEMIO_OP_MASK 0x2
#define HDP_MEMIO_CNTL__MEMIO_OP__SHIFT 0x1
#define HDP_MEMIO_CNTL__MEMIO_BE_MASK 0x3c
#define HDP_MEMIO_CNTL__MEMIO_BE__SHIFT 0x2
#define HDP_MEMIO_CNTL__MEMIO_WR_STROBE_MASK 0x40
#define HDP_MEMIO_CNTL__MEMIO_WR_STROBE__SHIFT 0x6
#define HDP_MEMIO_CNTL__MEMIO_RD_STROBE_MASK 0x80
#define HDP_MEMIO_CNTL__MEMIO_RD_STROBE__SHIFT 0x7
#define HDP_MEMIO_CNTL__MEMIO_ADDR_UPPER_MASK 0x3f00
#define HDP_MEMIO_CNTL__MEMIO_ADDR_UPPER__SHIFT 0x8
#define HDP_MEMIO_CNTL__MEMIO_CLR_WR_ERROR_MASK 0x4000
#define HDP_MEMIO_CNTL__MEMIO_CLR_WR_ERROR__SHIFT 0xe
#define HDP_MEMIO_CNTL__MEMIO_CLR_RD_ERROR_MASK 0x8000
#define HDP_MEMIO_CNTL__MEMIO_CLR_RD_ERROR__SHIFT 0xf
#define HDP_MEMIO_ADDR__MEMIO_ADDR_LOWER_MASK 0xffffffff
#define HDP_MEMIO_ADDR__MEMIO_ADDR_LOWER__SHIFT 0x0
#define HDP_MEMIO_STATUS__MEMIO_WR_STATUS_MASK 0x1
#define HDP_MEMIO_STATUS__MEMIO_WR_STATUS__SHIFT 0x0
#define HDP_MEMIO_STATUS__MEMIO_RD_STATUS_MASK 0x2
#define HDP_MEMIO_STATUS__MEMIO_RD_STATUS__SHIFT 0x1
#define HDP_MEMIO_STATUS__MEMIO_WR_ERROR_MASK 0x4
#define HDP_MEMIO_STATUS__MEMIO_WR_ERROR__SHIFT 0x2
#define HDP_MEMIO_STATUS__MEMIO_RD_ERROR_MASK 0x8
#define HDP_MEMIO_STATUS__MEMIO_RD_ERROR__SHIFT 0x3
#define HDP_MEMIO_WR_DATA__MEMIO_WR_DATA_MASK 0xffffffff
#define HDP_MEMIO_WR_DATA__MEMIO_WR_DATA__SHIFT 0x0
#define HDP_MEMIO_RD_DATA__MEMIO_RD_DATA_MASK 0xffffffff
#define HDP_MEMIO_RD_DATA__MEMIO_RD_DATA__SHIFT 0x0
#define HDP_XDP_DIRECT2HDP_FIRST__RESERVED_MASK 0xffffffff
#define HDP_XDP_DIRECT2HDP_FIRST__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_FLUSH_NUM_MASK 0xf
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_FLUSH_NUM__SHIFT 0x0
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_MBX_ENC_DATA_MASK 0xf0
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_MBX_ENC_DATA__SHIFT 0x4
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_MBX_ADDR_SEL_MASK 0x700
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_MBX_ADDR_SEL__SHIFT 0x8
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_XPB_CLG_MASK 0xf800
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_XPB_CLG__SHIFT 0xb
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_SEND_HOST_MASK 0x10000
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_SEND_HOST__SHIFT 0x10
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_SEND_SIDE_MASK 0x20000
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_SEND_SIDE__SHIFT 0x11
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_ALTER_FLUSH_NUM_MASK 0x40000
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_ALTER_FLUSH_NUM__SHIFT 0x12
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_RSVD_0_MASK 0x80000
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_RSVD_0__SHIFT 0x13
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_RSVD_1_MASK 0x100000
#define HDP_XDP_D2H_FLUSH__D2H_FLUSH_RSVD_1__SHIFT 0x14
#define HDP_XDP_D2H_BAR_UPDATE__D2H_BAR_UPDATE_ADDR_MASK 0xffff
#define HDP_XDP_D2H_BAR_UPDATE__D2H_BAR_UPDATE_ADDR__SHIFT 0x0
#define HDP_XDP_D2H_BAR_UPDATE__D2H_BAR_UPDATE_FLUSH_NUM_MASK 0xf0000
#define HDP_XDP_D2H_BAR_UPDATE__D2H_BAR_UPDATE_FLUSH_NUM__SHIFT 0x10
#define HDP_XDP_D2H_BAR_UPDATE__D2H_BAR_UPDATE_BAR_NUM_MASK 0x700000
#define HDP_XDP_D2H_BAR_UPDATE__D2H_BAR_UPDATE_BAR_NUM__SHIFT 0x14
#define HDP_XDP_D2H_RSVD_3__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_3__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_4__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_4__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_5__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_5__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_6__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_6__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_7__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_7__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_8__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_8__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_9__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_9__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_10__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_10__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_11__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_11__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_12__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_12__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_13__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_13__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_14__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_14__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_15__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_15__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_16__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_16__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_17__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_17__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_18__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_18__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_19__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_19__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_20__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_20__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_21__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_21__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_22__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_22__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_23__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_23__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_24__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_24__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_25__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_25__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_26__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_26__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_27__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_27__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_28__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_28__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_29__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_29__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_30__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_30__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_31__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_31__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_32__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_32__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_33__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_33__RESERVED__SHIFT 0x0
#define HDP_XDP_D2H_RSVD_34__RESERVED_MASK 0xffffffff
#define HDP_XDP_D2H_RSVD_34__RESERVED__SHIFT 0x0
#define HDP_XDP_DIRECT2HDP_LAST__RESERVED_MASK 0xffffffff
#define HDP_XDP_DIRECT2HDP_LAST__RESERVED__SHIFT 0x0
#define HDP_XDP_P2P_BAR_CFG__P2P_BAR_CFG_ADDR_SIZE_MASK 0xf
#define HDP_XDP_P2P_BAR_CFG__P2P_BAR_CFG_ADDR_SIZE__SHIFT 0x0
#define HDP_XDP_P2P_BAR_CFG__P2P_BAR_CFG_BAR_FROM_MASK 0x30
#define HDP_XDP_P2P_BAR_CFG__P2P_BAR_CFG_BAR_FROM__SHIFT 0x4
#define HDP_XDP_P2P_MBX_OFFSET__P2P_MBX_OFFSET_MASK 0x3fff
#define HDP_XDP_P2P_MBX_OFFSET__P2P_MBX_OFFSET__SHIFT 0x0
#define HDP_XDP_P2P_MBX_ADDR0__VALID_MASK 0x1
#define HDP_XDP_P2P_MBX_ADDR0__VALID__SHIFT 0x0
#define HDP_XDP_P2P_MBX_ADDR0__ADDR_MASK 0x1ffffe
#define HDP_XDP_P2P_MBX_ADDR0__ADDR__SHIFT 0x1
#define HDP_XDP_P2P_MBX_ADDR0__ADDR_39_36_MASK 0x1e00000
#define HDP_XDP_P2P_MBX_ADDR0__ADDR_39_36__SHIFT 0x15
#define HDP_XDP_P2P_MBX_ADDR1__VALID_MASK 0x1
#define HDP_XDP_P2P_MBX_ADDR1__VALID__SHIFT 0x0
#define HDP_XDP_P2P_MBX_ADDR1__ADDR_MASK 0x1ffffe
#define HDP_XDP_P2P_MBX_ADDR1__ADDR__SHIFT 0x1
#define HDP_XDP_P2P_MBX_ADDR1__ADDR_39_36_MASK 0x1e00000
#define HDP_XDP_P2P_MBX_ADDR1__ADDR_39_36__SHIFT 0x15
#define HDP_XDP_P2P_MBX_ADDR2__VALID_MASK 0x1
#define HDP_XDP_P2P_MBX_ADDR2__VALID__SHIFT 0x0
#define HDP_XDP_P2P_MBX_ADDR2__ADDR_MASK 0x1ffffe
#define HDP_XDP_P2P_MBX_ADDR2__ADDR__SHIFT 0x1
#define HDP_XDP_P2P_MBX_ADDR2__ADDR_39_36_MASK 0x1e00000
#define HDP_XDP_P2P_MBX_ADDR2__ADDR_39_36__SHIFT 0x15
#define HDP_XDP_P2P_MBX_ADDR3__VALID_MASK 0x1
#define HDP_XDP_P2P_MBX_ADDR3__VALID__SHIFT 0x0
#define HDP_XDP_P2P_MBX_ADDR3__ADDR_MASK 0x1ffffe
#define HDP_XDP_P2P_MBX_ADDR3__ADDR__SHIFT 0x1
#define HDP_XDP_P2P_MBX_ADDR3__ADDR_39_36_MASK 0x1e00000
#define HDP_XDP_P2P_MBX_ADDR3__ADDR_39_36__SHIFT 0x15
#define HDP_XDP_P2P_MBX_ADDR4__VALID_MASK 0x1
#define HDP_XDP_P2P_MBX_ADDR4__VALID__SHIFT 0x0
#define HDP_XDP_P2P_MBX_ADDR4__ADDR_MASK 0x1ffffe
#define HDP_XDP_P2P_MBX_ADDR4__ADDR__SHIFT 0x1
#define HDP_XDP_P2P_MBX_ADDR4__ADDR_39_36_MASK 0x1e00000
#define HDP_XDP_P2P_MBX_ADDR4__ADDR_39_36__SHIFT 0x15
#define HDP_XDP_P2P_MBX_ADDR5__VALID_MASK 0x1
#define HDP_XDP_P2P_MBX_ADDR5__VALID__SHIFT 0x0
#define HDP_XDP_P2P_MBX_ADDR5__ADDR_MASK 0x1ffffe
#define HDP_XDP_P2P_MBX_ADDR5__ADDR__SHIFT 0x1
#define HDP_XDP_P2P_MBX_ADDR5__ADDR_39_36_MASK 0x1e00000
#define HDP_XDP_P2P_MBX_ADDR5__ADDR_39_36__SHIFT 0x15
#define HDP_XDP_P2P_MBX_ADDR6__VALID_MASK 0x1
#define HDP_XDP_P2P_MBX_ADDR6__VALID__SHIFT 0x0
#define HDP_XDP_P2P_MBX_ADDR6__ADDR_MASK 0x1ffffe
#define HDP_XDP_P2P_MBX_ADDR6__ADDR__SHIFT 0x1
#define HDP_XDP_P2P_MBX_ADDR6__ADDR_39_36_MASK 0x1e00000
#define HDP_XDP_P2P_MBX_ADDR6__ADDR_39_36__SHIFT 0x15
#define HDP_XDP_HDP_MBX_MC_CFG__HDP_MBX_MC_CFG_TAP_WRREQ_PRIV_MASK 0x1
#define HDP_XDP_HDP_MBX_MC_CFG__HDP_MBX_MC_CFG_TAP_WRREQ_PRIV__SHIFT 0x0
#define HDP_XDP_HDP_MBX_MC_CFG__HDP_MBX_MC_CFG_TAP_WRREQ_SWAP_MASK 0x6
#define HDP_XDP_HDP_MBX_MC_CFG__HDP_MBX_MC_CFG_TAP_WRREQ_SWAP__SHIFT 0x1
#define HDP_XDP_HDP_MBX_MC_CFG__HDP_MBX_MC_CFG_TAP_WRREQ_TRAN_MASK 0x8
#define HDP_XDP_HDP_MBX_MC_CFG__HDP_MBX_MC_CFG_TAP_WRREQ_TRAN__SHIFT 0x3
#define HDP_XDP_HDP_MBX_MC_CFG__HDP_MBX_MC_CFG_TAP_WRREQ_VMID_MASK 0xf0
#define HDP_XDP_HDP_MBX_MC_CFG__HDP_MBX_MC_CFG_TAP_WRREQ_VMID__SHIFT 0x4
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_HST_TAP_WRREQ_PRIV_MASK 0x1
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_HST_TAP_WRREQ_PRIV__SHIFT 0x0
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_HST_TAP_WRREQ_SWAP_MASK 0x6
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_HST_TAP_WRREQ_SWAP__SHIFT 0x1
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_HST_TAP_WRREQ_TRAN_MASK 0x8
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_HST_TAP_WRREQ_TRAN__SHIFT 0x3
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_SID_TAP_WRREQ_PRIV_MASK 0x10
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_SID_TAP_WRREQ_PRIV__SHIFT 0x4
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_SID_TAP_WRREQ_SWAP_MASK 0x60
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_SID_TAP_WRREQ_SWAP__SHIFT 0x5
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_SID_TAP_WRREQ_TRAN_MASK 0x80
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_SID_TAP_WRREQ_TRAN__SHIFT 0x7
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_XL8R_WRREQ_CRD_OVERRIDE_MASK 0x3f00
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_XL8R_WRREQ_CRD_OVERRIDE__SHIFT 0x8
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_XDP_HIGHER_PRI_THRESH_MASK 0xfc000
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_XDP_HIGHER_PRI_THRESH__SHIFT 0xe
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_MC_STALL_ON_BUF_FULL_MASK_MASK 0x700000
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_MC_STALL_ON_BUF_FULL_MASK__SHIFT 0x14
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_HST_TAP_WRREQ_VMID_MASK 0x7800000
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_HST_TAP_WRREQ_VMID__SHIFT 0x17
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_SID_TAP_WRREQ_VMID_MASK 0x78000000
#define HDP_XDP_HDP_MC_CFG__HDP_MC_CFG_SID_TAP_WRREQ_VMID__SHIFT 0x1b
#define HDP_XDP_HST_CFG__HST_CFG_WR_COMBINE_EN_MASK 0x1
#define HDP_XDP_HST_CFG__HST_CFG_WR_COMBINE_EN__SHIFT 0x0
#define HDP_XDP_HST_CFG__HST_CFG_WR_COMBINE_TIMER_MASK 0x6
#define HDP_XDP_HST_CFG__HST_CFG_WR_COMBINE_TIMER__SHIFT 0x1
#define HDP_XDP_SID_CFG__SID_CFG_WR_COMBINE_EN_MASK 0x1
#define HDP_XDP_SID_CFG__SID_CFG_WR_COMBINE_EN__SHIFT 0x0
#define HDP_XDP_SID_CFG__SID_CFG_WR_COMBINE_TIMER_MASK 0x6
#define HDP_XDP_SID_CFG__SID_CFG_WR_COMBINE_TIMER__SHIFT 0x1
#define HDP_XDP_SID_CFG__SID_CFG_FLNUM_MSB_SEL_MASK 0x18
#define HDP_XDP_SID_CFG__SID_CFG_FLNUM_MSB_SEL__SHIFT 0x3
#define HDP_XDP_HDP_IPH_CFG__HDP_IPH_CFG_SYS_FIFO_DEPTH_OVERRIDE_MASK 0x3f
#define HDP_XDP_HDP_IPH_CFG__HDP_IPH_CFG_SYS_FIFO_DEPTH_OVERRIDE__SHIFT 0x0
#define HDP_XDP_HDP_IPH_CFG__HDP_IPH_CFG_XDP_FIFO_DEPTH_OVERRIDE_MASK 0xfc0
#define HDP_XDP_HDP_IPH_CFG__HDP_IPH_CFG_XDP_FIFO_DEPTH_OVERRIDE__SHIFT 0x6
#define HDP_XDP_HDP_IPH_CFG__HDP_IPH_CFG_INVERSE_PEER_TAG_MATCHING_MASK 0x1000
#define HDP_XDP_HDP_IPH_CFG__HDP_IPH_CFG_INVERSE_PEER_TAG_MATCHING__SHIFT 0xc
#define HDP_XDP_HDP_IPH_CFG__HDP_IPH_CFG_P2P_RD_EN_MASK 0x2000
#define HDP_XDP_HDP_IPH_CFG__HDP_IPH_CFG_P2P_RD_EN__SHIFT 0xd
#define HDP_XDP_SRBM_CFG__SRBM_CFG_REG_CLK_ENABLE_COUNT_MASK 0x3f
#define HDP_XDP_SRBM_CFG__SRBM_CFG_REG_CLK_ENABLE_COUNT__SHIFT 0x0
#define HDP_XDP_SRBM_CFG__SRBM_CFG_REG_CLK_GATING_DIS_MASK 0x40
#define HDP_XDP_SRBM_CFG__SRBM_CFG_REG_CLK_GATING_DIS__SHIFT 0x6
#define HDP_XDP_SRBM_CFG__SRBM_CFG_WAKE_DYN_CLK_MASK 0x80
#define HDP_XDP_SRBM_CFG__SRBM_CFG_WAKE_DYN_CLK__SHIFT 0x7
#define HDP_XDP_CGTT_BLK_CTRL__CGTT_BLK_CTRL_0_ON_DELAY_MASK 0xf
#define HDP_XDP_CGTT_BLK_CTRL__CGTT_BLK_CTRL_0_ON_DELAY__SHIFT 0x0
#define HDP_XDP_CGTT_BLK_CTRL__CGTT_BLK_CTRL_1_OFF_DELAY_MASK 0xff0
#define HDP_XDP_CGTT_BLK_CTRL__CGTT_BLK_CTRL_1_OFF_DELAY__SHIFT 0x4
#define HDP_XDP_CGTT_BLK_CTRL__CGTT_BLK_CTRL_2_RSVD_MASK 0x3ffff000
#define HDP_XDP_CGTT_BLK_CTRL__CGTT_BLK_CTRL_2_RSVD__SHIFT 0xc
#define HDP_XDP_CGTT_BLK_CTRL__CGTT_BLK_CTRL_3_SOFT_CORE_OVERRIDE_MASK 0x40000000
#define HDP_XDP_CGTT_BLK_CTRL__CGTT_BLK_CTRL_3_SOFT_CORE_OVERRIDE__SHIFT 0x1e
#define HDP_XDP_CGTT_BLK_CTRL__CGTT_BLK_CTRL_4_SOFT_REG_OVERRIDE_MASK 0x80000000
#define HDP_XDP_CGTT_BLK_CTRL__CGTT_BLK_CTRL_4_SOFT_REG_OVERRIDE__SHIFT 0x1f
#define HDP_XDP_P2P_BAR0__ADDR_MASK 0xffff
#define HDP_XDP_P2P_BAR0__ADDR__SHIFT 0x0
#define HDP_XDP_P2P_BAR0__FLUSH_MASK 0xf0000
#define HDP_XDP_P2P_BAR0__FLUSH__SHIFT 0x10
#define HDP_XDP_P2P_BAR0__VALID_MASK 0x100000
#define HDP_XDP_P2P_BAR0__VALID__SHIFT 0x14
#define HDP_XDP_P2P_BAR1__ADDR_MASK 0xffff
#define HDP_XDP_P2P_BAR1__ADDR__SHIFT 0x0
#define HDP_XDP_P2P_BAR1__FLUSH_MASK 0xf0000
#define HDP_XDP_P2P_BAR1__FLUSH__SHIFT 0x10
#define HDP_XDP_P2P_BAR1__VALID_MASK 0x100000
#define HDP_XDP_P2P_BAR1__VALID__SHIFT 0x14
#define HDP_XDP_P2P_BAR2__ADDR_MASK 0xffff
#define HDP_XDP_P2P_BAR2__ADDR__SHIFT 0x0
#define HDP_XDP_P2P_BAR2__FLUSH_MASK 0xf0000
#define HDP_XDP_P2P_BAR2__FLUSH__SHIFT 0x10
#define HDP_XDP_P2P_BAR2__VALID_MASK 0x100000
#define HDP_XDP_P2P_BAR2__VALID__SHIFT 0x14
#define HDP_XDP_P2P_BAR3__ADDR_MASK 0xffff
#define HDP_XDP_P2P_BAR3__ADDR__SHIFT 0x0
#define HDP_XDP_P2P_BAR3__FLUSH_MASK 0xf0000
#define HDP_XDP_P2P_BAR3__FLUSH__SHIFT 0x10
#define HDP_XDP_P2P_BAR3__VALID_MASK 0x100000
#define HDP_XDP_P2P_BAR3__VALID__SHIFT 0x14
#define HDP_XDP_P2P_BAR4__ADDR_MASK 0xffff
#define HDP_XDP_P2P_BAR4__ADDR__SHIFT 0x0
#define HDP_XDP_P2P_BAR4__FLUSH_MASK 0xf0000
#define HDP_XDP_P2P_BAR4__FLUSH__SHIFT 0x10
#define HDP_XDP_P2P_BAR4__VALID_MASK 0x100000
#define HDP_XDP_P2P_BAR4__VALID__SHIFT 0x14
#define HDP_XDP_P2P_BAR5__ADDR_MASK 0xffff
#define HDP_XDP_P2P_BAR5__ADDR__SHIFT 0x0
#define HDP_XDP_P2P_BAR5__FLUSH_MASK 0xf0000
#define HDP_XDP_P2P_BAR5__FLUSH__SHIFT 0x10
#define HDP_XDP_P2P_BAR5__VALID_MASK 0x100000
#define HDP_XDP_P2P_BAR5__VALID__SHIFT 0x14
#define HDP_XDP_P2P_BAR6__ADDR_MASK 0xffff
#define HDP_XDP_P2P_BAR6__ADDR__SHIFT 0x0
#define HDP_XDP_P2P_BAR6__FLUSH_MASK 0xf0000
#define HDP_XDP_P2P_BAR6__FLUSH__SHIFT 0x10
#define HDP_XDP_P2P_BAR6__VALID_MASK 0x100000
#define HDP_XDP_P2P_BAR6__VALID__SHIFT 0x14
#define HDP_XDP_P2P_BAR7__ADDR_MASK 0xffff
#define HDP_XDP_P2P_BAR7__ADDR__SHIFT 0x0
#define HDP_XDP_P2P_BAR7__FLUSH_MASK 0xf0000
#define HDP_XDP_P2P_BAR7__FLUSH__SHIFT 0x10
#define HDP_XDP_P2P_BAR7__VALID_MASK 0x100000
#define HDP_XDP_P2P_BAR7__VALID__SHIFT 0x14
#define HDP_XDP_FLUSH_ARMED_STS__FLUSH_ARMED_STS_MASK 0xffffffff
#define HDP_XDP_FLUSH_ARMED_STS__FLUSH_ARMED_STS__SHIFT 0x0
#define HDP_XDP_FLUSH_CNTR0_STS__FLUSH_CNTR0_STS_MASK 0x3ffffff
#define HDP_XDP_FLUSH_CNTR0_STS__FLUSH_CNTR0_STS__SHIFT 0x0
#define HDP_XDP_BUSY_STS__BUSY_BITS_MASK 0x3ffff
#define HDP_XDP_BUSY_STS__BUSY_BITS__SHIFT 0x0
#define HDP_XDP_STICKY__STICKY_STS_MASK 0xffff
#define HDP_XDP_STICKY__STICKY_STS__SHIFT 0x0
#define HDP_XDP_STICKY__STICKY_W1C_MASK 0xffff0000
#define HDP_XDP_STICKY__STICKY_W1C__SHIFT 0x10
#define HDP_XDP_CHKN__CHKN_0_RSVD_MASK 0xff
#define HDP_XDP_CHKN__CHKN_0_RSVD__SHIFT 0x0
#define HDP_XDP_CHKN__CHKN_1_RSVD_MASK 0xff00
#define HDP_XDP_CHKN__CHKN_1_RSVD__SHIFT 0x8
#define HDP_XDP_CHKN__CHKN_2_RSVD_MASK 0xff0000
#define HDP_XDP_CHKN__CHKN_2_RSVD__SHIFT 0x10
#define HDP_XDP_CHKN__CHKN_3_RSVD_MASK 0xff000000
#define HDP_XDP_CHKN__CHKN_3_RSVD__SHIFT 0x18
#define HDP_XDP_DBG_ADDR__STS_MASK 0xffff
#define HDP_XDP_DBG_ADDR__STS__SHIFT 0x0
#define HDP_XDP_DBG_ADDR__CTRL_MASK 0xffff0000
#define HDP_XDP_DBG_ADDR__CTRL__SHIFT 0x10
#define HDP_XDP_DBG_DATA__STS_MASK 0xffff
#define HDP_XDP_DBG_DATA__STS__SHIFT 0x0
#define HDP_XDP_DBG_DATA__CTRL_MASK 0xffff0000
#define HDP_XDP_DBG_DATA__CTRL__SHIFT 0x10
#define HDP_XDP_DBG_MASK__STS_MASK 0xffff
#define HDP_XDP_DBG_MASK__STS__SHIFT 0x0
#define HDP_XDP_DBG_MASK__CTRL_MASK 0xffff0000
#define HDP_XDP_DBG_MASK__CTRL__SHIFT 0x10
#define HDP_XDP_BARS_ADDR_39_36__BAR0_ADDR_39_36_MASK 0xf
#define HDP_XDP_BARS_ADDR_39_36__BAR0_ADDR_39_36__SHIFT 0x0
#define HDP_XDP_BARS_ADDR_39_36__BAR1_ADDR_39_36_MASK 0xf0
#define HDP_XDP_BARS_ADDR_39_36__BAR1_ADDR_39_36__SHIFT 0x4
#define HDP_XDP_BARS_ADDR_39_36__BAR2_ADDR_39_36_MASK 0xf00
#define HDP_XDP_BARS_ADDR_39_36__BAR2_ADDR_39_36__SHIFT 0x8
#define HDP_XDP_BARS_ADDR_39_36__BAR3_ADDR_39_36_MASK 0xf000
#define HDP_XDP_BARS_ADDR_39_36__BAR3_ADDR_39_36__SHIFT 0xc
#define HDP_XDP_BARS_ADDR_39_36__BAR4_ADDR_39_36_MASK 0xf0000
#define HDP_XDP_BARS_ADDR_39_36__BAR4_ADDR_39_36__SHIFT 0x10
#define HDP_XDP_BARS_ADDR_39_36__BAR5_ADDR_39_36_MASK 0xf00000
#define HDP_XDP_BARS_ADDR_39_36__BAR5_ADDR_39_36__SHIFT 0x14
#define HDP_XDP_BARS_ADDR_39_36__BAR6_ADDR_39_36_MASK 0xf000000
#define HDP_XDP_BARS_ADDR_39_36__BAR6_ADDR_39_36__SHIFT 0x18
#define HDP_XDP_BARS_ADDR_39_36__BAR7_ADDR_39_36_MASK 0xf0000000
#define HDP_XDP_BARS_ADDR_39_36__BAR7_ADDR_39_36__SHIFT 0x1c

#endif /* OSS_2_0_SH_MASK_H */
